/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.remoting;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.optionfactory.keycloak.remoting.FormDataPart;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;

public class MultipartFormDataEntity
implements HttpEntity {
    private final String boundary;
    private final List<FormDataPart> parts;

    public MultipartFormDataEntity(String boundary, List<FormDataPart> parts) {
        this.boundary = boundary;
        this.parts = parts;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isStreaming() {
        return true;
    }

    public long getContentLength() {
        return -1L;
    }

    public Header getContentType() {
        return new BasicHeader("Content-Type", "multipart/form-data; boundary=%s".formatted(this.boundary));
    }

    public Header getContentEncoding() {
        return null;
    }

    public void consumeContent() throws IOException {
    }

    public InputStream getContent() throws IOException {
        List streams = this.parts.stream().map(FormDataPart::marshalled).collect(Collectors.toList());
        ArrayList<InputStream> withBoundaries = new ArrayList<InputStream>();
        for (InputStream stream : streams) {
            withBoundaries.add(new ByteArrayInputStream("--%s\r\n".formatted(this.boundary).getBytes(StandardCharsets.US_ASCII)));
            withBoundaries.add(stream);
        }
        withBoundaries.add(new ByteArrayInputStream("--%s--\r\n".formatted(this.boundary).getBytes(StandardCharsets.US_ASCII)));
        return new SequenceInputStream(Collections.enumeration(withBoundaries));
    }

    public void writeTo(OutputStream os) throws IOException {
        this.getContent().transferTo(os);
    }
}

