/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.remoting;

import java.util.List;
import java.util.Set;

public class BasicHeaderParameterEncoder {
    public static final Set<Character> SEPARATORS = Set.of(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('@'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf('\\'), Character.valueOf('\"'), Character.valueOf('/'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('?'), Character.valueOf('='), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\r'));
    public static final List<String[]> TRANSLATIONS = List.of(new String[]{"\\", "\\\\"}, new String[]{"\n", "\\n"}, new String[]{"\r", "\\r"}, new String[]{"\t", "\\t"}, new String[]{"\"", "\\\""});

    public static String encode(String source) {
        if (SEPARATORS.stream().noneMatch(k -> source.contains("" + k))) {
            return source;
        }
        String translated = source;
        for (String[] translation : TRANSLATIONS) {
            translated = translated.replace(translation[0], translation[1]);
        }
        return "\"%s\"".formatted(translated);
    }
}

