/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.provisioning.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.optionfactory.keycloak.providers.ResourceAuthenticator;
import net.optionfactory.keycloak.provisioning.api.ProvisioningEndpoints;
import net.optionfactory.keycloak.validation.RequestValidator;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resource.RealmResourceProviderFactory;

public class ProvisioningEndpointsFactory
implements RealmResourceProviderFactory {
    private ObjectMapper om;
    private String requiredScopeName;

    public RealmResourceProvider create(final KeycloakSession session) {
        ResourceAuthenticator.enforceScope((KeycloakSession)session, (String)this.requiredScopeName);
        final RequestValidator validator = (RequestValidator)session.getProvider(RequestValidator.class);
        return new RealmResourceProvider(){

            public Object getResource() {
                return new ProvisioningEndpoints(ProvisioningEndpointsFactory.this.om, validator, session);
            }

            public void close() {
            }
        };
    }

    public void init(Config.Scope config) {
        this.om = new ObjectMapper();
        this.requiredScopeName = config.get("scope", "provisioning");
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "provisioning";
    }
}

