/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers.validation.validators;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.EnumSet;
import java.util.List;
import net.optionfactory.keycloak.providers.validation.validators.PhoneNumbers;

@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE, ElementType.TYPE_USE})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={Validator.class})
@Documented
public @interface PhoneNumber {
    public PhoneNumberUtil.PhoneNumberType[] types() default {PhoneNumberUtil.PhoneNumberType.FIXED_LINE_OR_MOBILE, PhoneNumberUtil.PhoneNumberType.MOBILE};

    public String defaultRegion() default "IT";

    public String message() default "{net.optionfactory.keycloak.providers.validation.validators.PhoneNumber.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class Validator
    implements ConstraintValidator<PhoneNumber, String> {
        private PhoneNumbers phones = new PhoneNumbers();
        private EnumSet<PhoneNumberUtil.PhoneNumberType> types;
        private String defaultRegion;

        public void initialize(PhoneNumber annotation) {
            this.types = EnumSet.copyOf(List.of(annotation.types()));
            this.defaultRegion = annotation.defaultRegion();
        }

        public boolean isValid(String value, ConstraintValidatorContext ctx) {
            return this.phones.validate("phoneNumber", value, this.defaultRegion.isBlank() ? null : this.defaultRegion, this.types).isEmpty();
        }
    }
}

