/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers.filtering;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.optionfactory.keycloak.providers.filtering.AllowedFilter;
import net.optionfactory.keycloak.providers.filtering.Parsers;

public record GroupFilter(String name, String alias) implements AllowedFilter
{
    @Override
    public AllowedFilter.ConfiguredFilter configure(String[] values) {
        Parsers.ensure(values.length >= 2, this.name(), "Expected at least 2 values: [OP,...VALUES], got %s", Arrays.toString(values));
        Operator operator = Parsers.enumeration(Operator.class, values[0], this.name());
        Object[] params = Arrays.copyOfRange(values, 1, values.length);
        return new AllowedFilter.ConfiguredFilter(String.format("%s(%s, array[%s])", operator.fn, this.alias, GroupFilter.arrayPlaceholders(params)), params);
    }

    private static String arrayPlaceholders(Object[] params) {
        return Stream.of(params).map(p -> "?").collect(Collectors.joining(","));
    }

    public static enum Operator {
        ANY("jsonb_exists_any"),
        ALL("jsonb_exists_all"),
        NONE("not jsonb_exists_any");

        public final String fn;

        private Operator(String fn) {
            this.fn = fn;
        }
    }
}

