/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers.validation.validators;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;

@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={Validator.class})
@Documented
public @interface TaxCode {
    public Mode mode() default Mode.ANY;

    public String message() default "{net.optionfactory.keycloak.providers.validation.validators.TaxCode.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class Validator
    implements ConstraintValidator<TaxCode, String> {
        private Mode mode;
        public static final int PARTITA_IVA_LENGTH = 11;
        public static final int CODICE_FISCALE_LENGTH = 16;
        private static final Map<Character, Integer> ODD_CODES = new ConcurrentHashMap<Character, Integer>();
        private static final Map<Character, Integer> EVEN_CODES = new ConcurrentHashMap<Character, Integer>();

        public void initialize(TaxCode annotation) {
            this.mode = annotation.mode();
        }

        public static String sanitize(String taxcode) {
            if (taxcode == null) {
                return null;
            }
            return taxcode.trim().toUpperCase().replaceAll("[^A-Z0-9]", "");
        }

        public static boolean isValid(String value, Mode mode) {
            if (value == null) {
                return true;
            }
            String clean = Validator.sanitize(value);
            int len = clean.length();
            if (len == 0) {
                return true;
            }
            char lastCharacter = clean.charAt(len - 1);
            if ((mode == Mode.PARTITA_IVA || mode == Mode.ANY) && len == 11) {
                Optional<Character> maybeControlCode = Validator.controlCodePartitaIva(clean);
                return !maybeControlCode.isPresent() ? false : maybeControlCode.get().charValue() == lastCharacter;
            }
            if ((mode == Mode.CODICE_FISCALE || mode == Mode.ANY) && len == 16) {
                Optional<Character> maybeControlCode = Validator.controlCodeCodiceFiscale(clean);
                return !maybeControlCode.isPresent() ? false : maybeControlCode.get().charValue() == lastCharacter;
            }
            return false;
        }

        public boolean isValid(String value, ConstraintValidatorContext constraintContext) {
            return Validator.isValid(value, this.mode);
        }

        public static Optional<Character> controlCodePartitaIva(String possiblePartitaIva) {
            int x = IntStream.of(0, 2, 4, 6, 8).map(possiblePartitaIva::charAt).map(c -> Character.digit(c, 10)).reduce(0, Integer::sum);
            int[] ys = IntStream.of(1, 3, 5, 7, 9).map(possiblePartitaIva::charAt).map(c -> Character.digit(c, 10)).toArray();
            int y = IntStream.of(ys).map(v -> v * 2).reduce(0, Integer::sum);
            long z = IntStream.of(ys).filter(v -> v >= 5).count();
            long t = ((long)(x + y) + z) % 10L;
            long c2 = (10L - t) % 10L;
            return Optional.of(Character.valueOf(Character.forDigit((int)c2, 10)));
        }

        public static Optional<Character> controlCodeCodiceFiscale(String fiscalCode) {
            boolean oddsAreValid = IntStream.of(0, 2, 4, 6, 8, 10, 12, 14).mapToObj(fiscalCode::charAt).allMatch(ODD_CODES::containsKey);
            if (!oddsAreValid) {
                return Optional.empty();
            }
            int oddsSum = IntStream.of(0, 2, 4, 6, 8, 10, 12, 14).mapToObj(fiscalCode::charAt).map(ODD_CODES::get).reduce(0, Integer::sum);
            boolean evenAreValid = IntStream.of(1, 3, 5, 7, 9, 11, 13).mapToObj(fiscalCode::charAt).allMatch(EVEN_CODES::containsKey);
            if (!evenAreValid) {
                return Optional.empty();
            }
            int evenSum = IntStream.of(1, 3, 5, 7, 9, 11, 13).mapToObj(fiscalCode::charAt).map(EVEN_CODES::get).reduce(0, Integer::sum);
            int code = (oddsSum + evenSum) % 26;
            return Optional.of(Character.valueOf((char)(code + 65)));
        }

        static {
            ODD_CODES.put(Character.valueOf('0'), 1);
            ODD_CODES.put(Character.valueOf('1'), 0);
            ODD_CODES.put(Character.valueOf('2'), 5);
            ODD_CODES.put(Character.valueOf('3'), 7);
            ODD_CODES.put(Character.valueOf('4'), 9);
            ODD_CODES.put(Character.valueOf('5'), 13);
            ODD_CODES.put(Character.valueOf('6'), 15);
            ODD_CODES.put(Character.valueOf('7'), 17);
            ODD_CODES.put(Character.valueOf('8'), 19);
            ODD_CODES.put(Character.valueOf('9'), 21);
            ODD_CODES.put(Character.valueOf('A'), 1);
            ODD_CODES.put(Character.valueOf('B'), 0);
            ODD_CODES.put(Character.valueOf('C'), 5);
            ODD_CODES.put(Character.valueOf('D'), 7);
            ODD_CODES.put(Character.valueOf('E'), 9);
            ODD_CODES.put(Character.valueOf('F'), 13);
            ODD_CODES.put(Character.valueOf('G'), 15);
            ODD_CODES.put(Character.valueOf('H'), 17);
            ODD_CODES.put(Character.valueOf('I'), 19);
            ODD_CODES.put(Character.valueOf('J'), 21);
            ODD_CODES.put(Character.valueOf('K'), 2);
            ODD_CODES.put(Character.valueOf('L'), 4);
            ODD_CODES.put(Character.valueOf('M'), 18);
            ODD_CODES.put(Character.valueOf('N'), 20);
            ODD_CODES.put(Character.valueOf('O'), 11);
            ODD_CODES.put(Character.valueOf('P'), 3);
            ODD_CODES.put(Character.valueOf('Q'), 6);
            ODD_CODES.put(Character.valueOf('R'), 8);
            ODD_CODES.put(Character.valueOf('S'), 12);
            ODD_CODES.put(Character.valueOf('T'), 14);
            ODD_CODES.put(Character.valueOf('U'), 16);
            ODD_CODES.put(Character.valueOf('V'), 10);
            ODD_CODES.put(Character.valueOf('W'), 22);
            ODD_CODES.put(Character.valueOf('X'), 25);
            ODD_CODES.put(Character.valueOf('Y'), 24);
            ODD_CODES.put(Character.valueOf('Z'), 23);
            EVEN_CODES.put(Character.valueOf('0'), 0);
            EVEN_CODES.put(Character.valueOf('1'), 1);
            EVEN_CODES.put(Character.valueOf('2'), 2);
            EVEN_CODES.put(Character.valueOf('3'), 3);
            EVEN_CODES.put(Character.valueOf('4'), 4);
            EVEN_CODES.put(Character.valueOf('5'), 5);
            EVEN_CODES.put(Character.valueOf('6'), 6);
            EVEN_CODES.put(Character.valueOf('7'), 7);
            EVEN_CODES.put(Character.valueOf('8'), 8);
            EVEN_CODES.put(Character.valueOf('9'), 9);
            EVEN_CODES.put(Character.valueOf('A'), 0);
            EVEN_CODES.put(Character.valueOf('B'), 1);
            EVEN_CODES.put(Character.valueOf('C'), 2);
            EVEN_CODES.put(Character.valueOf('D'), 3);
            EVEN_CODES.put(Character.valueOf('E'), 4);
            EVEN_CODES.put(Character.valueOf('F'), 5);
            EVEN_CODES.put(Character.valueOf('G'), 6);
            EVEN_CODES.put(Character.valueOf('H'), 7);
            EVEN_CODES.put(Character.valueOf('I'), 8);
            EVEN_CODES.put(Character.valueOf('J'), 9);
            EVEN_CODES.put(Character.valueOf('K'), 10);
            EVEN_CODES.put(Character.valueOf('L'), 11);
            EVEN_CODES.put(Character.valueOf('M'), 12);
            EVEN_CODES.put(Character.valueOf('N'), 13);
            EVEN_CODES.put(Character.valueOf('O'), 14);
            EVEN_CODES.put(Character.valueOf('P'), 15);
            EVEN_CODES.put(Character.valueOf('Q'), 16);
            EVEN_CODES.put(Character.valueOf('R'), 17);
            EVEN_CODES.put(Character.valueOf('S'), 18);
            EVEN_CODES.put(Character.valueOf('T'), 19);
            EVEN_CODES.put(Character.valueOf('U'), 20);
            EVEN_CODES.put(Character.valueOf('V'), 21);
            EVEN_CODES.put(Character.valueOf('W'), 22);
            EVEN_CODES.put(Character.valueOf('X'), 23);
            EVEN_CODES.put(Character.valueOf('Y'), 24);
            EVEN_CODES.put(Character.valueOf('Z'), 25);
        }
    }

    public static enum Mode {
        CODICE_FISCALE,
        PARTITA_IVA,
        ANY;

    }
}

