/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers.validation.hibernate;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.optionfactory.keycloak.providers.validation.Problem;
import net.optionfactory.keycloak.providers.validation.RequestValidator;
import net.optionfactory.keycloak.providers.validation.RequestValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolverContext;
import org.keycloak.Config;
import org.keycloak.common.util.Resteasy;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class HibernateRequestValidator
implements RequestValidator {
    private final Validator validator;

    public HibernateRequestValidator(Locale defaultLocale, Set<Locale> supportedLocales) {
        this.validator = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).locales(supportedLocales)).defaultLocale(defaultLocale)).localeResolver(HibernateRequestValidator::resolveLocaleUsingAcceptLanguageHeader)).messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator(supportedLocales, defaultLocale, HibernateRequestValidator::resolveLocaleUsingAcceptLanguageHeader, true))).buildValidatorFactory().getValidator();
    }

    public static Locale resolveLocaleUsingAcceptLanguageHeader(LocaleResolverContext lrc) {
        Set supported;
        HttpHeaders headers = (HttpHeaders)Resteasy.getContextData(HttpHeaders.class);
        if (headers == null) {
            return lrc.getDefaultLocale();
        }
        String header = (String)headers.getRequestHeaders().getFirst((Object)"Accept-Language");
        if (header == null) {
            return lrc.getDefaultLocale();
        }
        List<Locale.LanguageRange> requested = Locale.LanguageRange.parse(header);
        List<Locale> filtered = Locale.filter(requested, supported = lrc.getSupportedLocales());
        return filtered.isEmpty() ? lrc.getDefaultLocale() : filtered.get(0);
    }

    @Override
    public <T> T unwrap(Class<T> k) {
        return (T)this.validator;
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validate(T request, Class<?> ... groups) {
        return this.validator.validate(request, (Class[])groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validate(T request, Method m, Object[] parameterValues, Class<?> ... groups) {
        return this.validator.forExecutables().validateParameters(request, m, parameterValues, (Class[])groups);
    }

    @Override
    public <T> void enforce(T request, Class<?> ... groups) {
        Set violations = this.validator.validate(request, (Class[])groups);
        if (violations.isEmpty()) {
            return;
        }
        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/failures+json").entity(violations.stream().map(v -> {
            String path = StreamSupport.stream(v.getPropertyPath().spliterator(), false).skip(1L).map(node -> node.getIndex() != null ? String.valueOf(node.getIndex()) : node.getName()).collect(Collectors.joining("."));
            return new Problem("FIELD_ERROR", path, v.getMessage());
        })).build();
        throw new BadRequestException(response);
    }

    @Override
    public <T> void enforce(T request, Function<Set<ConstraintViolation<T>>, RuntimeException> exFactory, Class<?> ... groups) {
        Set violations = this.validator.validate(request, (Class[])groups);
        if (violations.isEmpty()) {
            return;
        }
        throw exFactory.apply(violations);
    }

    @Override
    public <T> void enforce(T o, Method m, Object[] parameterValues, Function<Set<ConstraintViolation<T>>, RuntimeException> exFactory, Class<?> ... groups) {
        Set violations = this.validator.forExecutables().validateParameters(o, m, parameterValues, (Class[])groups);
        if (violations.isEmpty()) {
            return;
        }
        throw exFactory.apply(violations);
    }

    public static class Factory
    implements RequestValidatorFactory {
        private HibernateRequestValidator validator;

        public HibernateRequestValidator create(KeycloakSession session) {
            return this.validator;
        }

        public void init(Config.Scope config) {
            Locale defaultLocale = Locale.forLanguageTag(config.get("defaultLocale", "it"));
            Set<Locale> supportedLocales = Stream.of(config.get("supportedLocales", "ar,ca,cs,da,de,en,es,fr,fi,hu,it,ja,lt,nl,no,pl,pt-BR,ru,sk,sv,tr,zh-CN").split(",")).map(String::trim).filter(ls -> !ls.isEmpty()).map(Locale::forLanguageTag).collect(Collectors.toSet());
            this.validator = new HibernateRequestValidator(defaultLocale, supportedLocales);
        }

        public void postInit(KeycloakSessionFactory factory) {
        }

        public void close() {
            this.validator.close();
        }

        public String getId() {
            return "opfa-hibernate-request-validator";
        }
    }
}

