/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers.filtering;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.Response;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.optionfactory.keycloak.providers.filtering.ConfiguredSorter;
import net.optionfactory.keycloak.providers.validation.Problem;

public class Parsers {
    private static final ConcurrentMap<Class<? extends Enum>, Set<String>> CACHE = new ConcurrentHashMap<Class<? extends Enum>, Set<String>>();

    public static <T extends Enum<T>> T enumeration(Class<T> k, String value, String path) {
        Set names = CACHE.computeIfAbsent(k, ek -> Stream.of((Enum[])ek.getEnumConstants()).map(e -> e.name()).collect(Collectors.toSet()));
        if (!names.contains(value)) {
            String message = String.format("expected one of %s, got: '%s'", names, value);
            throw new BadRequestException(Parsers.badRequest(path, message));
        }
        return Enum.valueOf(k, value);
    }

    public static Long instant(String value, String path) {
        if (value == null) {
            return null;
        }
        try {
            return Instant.parse(value).toEpochMilli();
        }
        catch (DateTimeParseException ex) {
            String message = String.format("expected an iso instant, got: '%s'", value);
            throw new BadRequestException(Parsers.badRequest(path, message));
        }
    }

    /*
     * Exception decompiling
     */
    public static List<ConfiguredSorter> sorters(Map<String, String> allowed, List<String> requested) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void ensure(boolean test, String path, String format, Object ... args) {
        if (test) {
            return;
        }
        throw new BadRequestException(Parsers.badRequest(path, String.format(format, args)));
    }

    private static Response badRequest(String path, String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/failures+json").entity(List.of(new Problem("FIELD_ERROR", path, message))).build();
    }

    private static /* synthetic */ ConfiguredSorter lambda$sorters$5(Map allowed, String[] nad) {
        return new ConfiguredSorter((String)allowed.get(nad[0]), "DESC".equals(nad[1]) ? ConfiguredSorter.Direction.DESC : ConfiguredSorter.Direction.ASC);
    }

    private static /* synthetic */ boolean lambda$sorters$4(Map allowed, String[] nad) {
        return allowed.containsKey(nad[0]);
    }
}

