/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers;

import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAuthorizedException;
import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;

public interface ResourceAuthenticator {
    public static void enforceScope(KeycloakSession session, String scope) {
        AuthenticationManager.AuthResult auth = new AppAuthManager.BearerTokenAuthenticator(session).authenticate();
        ResourceAuthenticator.authenticated(auth != null, "Bearer", new Object[0]);
        boolean hasScope = Stream.of(auth.getToken().getScope().split(" ")).anyMatch(scope::equals);
        ResourceAuthenticator.authorized(hasScope, "Client does not have required scope '%s'", scope);
    }

    public static void enforceServiceAccountHasClientRole(KeycloakSession session, String clientName, String roleName) {
        AuthenticationManager.AuthResult auth = new AppAuthManager.BearerTokenAuthenticator(session).authenticate();
        ResourceAuthenticator.authenticated(auth != null, "Bearer", new Object[0]);
        ClientModel client = auth.getClient();
        ResourceAuthenticator.authorized(client != null, "Session context has no associated client", new Object[0]);
        UserModel sa = session.users().getServiceAccount(client);
        ResourceAuthenticator.authorized(sa != null, "Client does not have an associated service account", new Object[0]);
        ClientModel roleClient = session.clients().getClientByClientId(session.getContext().getRealm(), clientName);
        ResourceAuthenticator.authorized(roleClient != null, "Required client '%s' does not exist", clientName);
        RoleModel role = session.roles().getClientRole(roleClient, roleName);
        ResourceAuthenticator.authorized(role != null, "Required realm role '%s' does not exist", roleName);
        boolean hasRole = RoleUtils.hasRole((Stream)sa.getClientRoleMappingsStream(roleClient), (RoleModel)role);
        ResourceAuthenticator.authorized(hasRole, "Service account does not have required realm role '%s'", roleName);
    }

    public static void authenticated(boolean test, String message, Object ... args) {
        if (test) {
            return;
        }
        throw new NotAuthorizedException((Object)String.format(message, args), new Object[0]);
    }

    public static void authorized(boolean test, String message, Object ... args) {
        if (test) {
            return;
        }
        throw new ForbiddenException(String.format(message, args));
    }
}

