/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers.validation.validators;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.util.EnumSet;
import java.util.Optional;
import org.keycloak.models.utils.FormMessage;

public class PhoneNumbers {
    private final PhoneNumberUtil phoneNumbers = PhoneNumberUtil.getInstance();

    public Optional<FormMessage> validate(String fieldName, String phoneNumber, String defaultRegion, EnumSet<PhoneNumberUtil.PhoneNumberType> whitelistedTypes) {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            return Optional.of(new FormMessage(fieldName, "mandatoryField"));
        }
        try {
            Phonenumber.PhoneNumber parsed = this.phoneNumbers.parse((CharSequence)phoneNumber, defaultRegion);
            if (!this.phoneNumbers.isValidNumber(parsed)) {
                return Optional.of(new FormMessage(fieldName, "invalidField"));
            }
            PhoneNumberUtil.PhoneNumberType type = this.phoneNumbers.getNumberType(parsed);
            if (!whitelistedTypes.contains(type)) {
                return Optional.of(new FormMessage(fieldName, "invalidPhoneNumberType", new Object[]{type.name()}));
            }
            return Optional.empty();
        }
        catch (NumberParseException ex) {
            return Optional.of(new FormMessage(fieldName, "invalidField"));
        }
    }

    public String e164Format(String phoneNumber, String defaultRegion) {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            return "";
        }
        try {
            Phonenumber.PhoneNumber parsed = this.phoneNumbers.parse((CharSequence)phoneNumber, defaultRegion);
            return this.phoneNumbers.format(parsed, PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        catch (NumberParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

