/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers.filtering;

import java.util.Arrays;
import net.optionfactory.keycloak.providers.filtering.AllowedFilter;
import net.optionfactory.keycloak.providers.filtering.Parsers;

public record TimestampFilter(String name, String alias) implements AllowedFilter
{
    @Override
    public AllowedFilter.ConfiguredFilter configure(String[] values) {
        Parsers.ensure(values.length == 2, this.name(), "Expected 3 values: [OP,VALUE], got %s", Arrays.toString(values));
        Operator operator = Parsers.enumeration(Operator.class, values[0], this.name());
        Long value = Parsers.instant(values[1], this.name());
        if (value == null) {
            Parsers.ensure(operator == Operator.EQ || operator == Operator.NEQ, this.name(), "Operator %s expects a non-null value", new Object[]{operator});
            return new AllowedFilter.ConfiguredFilter(String.format("%s %s null", this.alias, operator == Operator.EQ ? "is" : "is not"), new Object[0]);
        }
        return new AllowedFilter.ConfiguredFilter(String.format("%s %s ?", this.alias, operator.op), value);
    }

    public static enum Operator {
        EQ("="),
        NEQ("<>"),
        LT("<"),
        GT(">"),
        LTE("<="),
        GTE(">=");

        public final String op;

        private Operator(String op) {
            this.op = op;
        }
    }
}

