/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers.validation.validators;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.resteasy.reactive.multipart.FileUpload;

@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={Validator.class})
@Documented
public @interface FileUploadExtensions {
    public String message() default "{net.optionfactory.keycloak.validation.providers.validators.FileUploadExtensions.message}";

    public Class<?>[] groups() default {};

    public String[] value() default {"pdf", "png", "bmp", "jpg", "jpeg"};

    public Class<? extends Payload>[] payload() default {};

    public static class Validator
    implements ConstraintValidator<FileUploadExtensions, FileUpload> {
        private Set<String> supported;

        public void initialize(FileUploadExtensions annotation) {
            this.supported = Stream.of(annotation.value()).collect(Collectors.toSet());
        }

        public boolean isValid(FileUpload value, ConstraintValidatorContext constraintContext) {
            if (value == null) {
                return false;
            }
            String filename = value.fileName();
            if (filename == null) {
                return false;
            }
            String[] parts = filename.toLowerCase().split("\\.");
            String extension = parts[parts.length - 1];
            return this.supported.contains(extension);
        }
    }
}

