/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers.filtering;

import java.util.Arrays;
import net.optionfactory.keycloak.providers.filtering.AllowedFilter;
import net.optionfactory.keycloak.providers.filtering.Parsers;

public record TextFilter(String name, String alias) implements AllowedFilter
{
    @Override
    public AllowedFilter.ConfiguredFilter configure(String[] values) {
        Parsers.ensure(values.length == 3, this.name(), "Expected 3 values: [OP,CASE,VALUE], got %s", Arrays.toString(values));
        Operator operator = Parsers.enumeration(Operator.class, values[0], this.name());
        CaseSensitivity sensitivity = Parsers.enumeration(CaseSensitivity.class, values[1], this.name());
        String value = values[2];
        return switch (operator.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 2, 3, 4, 5 -> {
                if (value == null) {
                    Parsers.ensure(operator == Operator.EQ || operator == Operator.NEQ, this.name(), "Operator %s expects a non-null value", new Object[]{operator});
                    yield new AllowedFilter.ConfiguredFilter(String.format("%s %s null", this.alias, operator == Operator.EQ ? "is" : "is not"), new Object[0]);
                }
                yield new AllowedFilter.ConfiguredFilter(String.format(sensitivity == CaseSensitivity.CASE_SENSITIVE ? "%s %s ?" : "lower(%s) %s ?", this.alias, operator.op), sensitivity == CaseSensitivity.CASE_SENSITIVE ? value : value.toLowerCase());
            }
            case 6, 7, 8 -> {
                Parsers.ensure(value != null, this.name(), "Operator %s expects a non-null value", new Object[]{operator});
                yield new AllowedFilter.ConfiguredFilter(String.format("%s %s ?", this.alias, sensitivity == CaseSensitivity.CASE_SENSITIVE ? "like" : "ilike"), TextFilter.likePattern(operator, value));
            }
        };
    }

    public static String likePattern(Operator op, String value) {
        String esc = value.replace("%", "\\%").replace("_", "\\_");
        if (op == Operator.STARTS_WITH) {
            return "%" + esc;
        }
        if (op == Operator.ENDS_WITH) {
            return esc + "%";
        }
        return "%" + esc + "%";
    }

    public static enum Operator {
        EQ("="),
        NEQ("<>"),
        LT("<"),
        GT(">"),
        LTE("<="),
        GTE(">="),
        CONTAINS("%%"),
        STARTS_WITH("%"),
        ENDS_WITH("%");

        public final String op;

        private Operator(String op) {
            this.op = op;
        }
    }

    public static enum CaseSensitivity {
        CASE_SENSITIVE,
        IGNORE_CASE;

    }
}

