/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers.filtering;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.optionfactory.keycloak.providers.filtering.AllowedFilter;
import net.optionfactory.keycloak.providers.filtering.ConfiguredSorter;
import net.optionfactory.keycloak.providers.filtering.Parsers;

public class QueryBuilder {
    private final Map<String, AllowedFilter> allowedFilters = new HashMap<String, AllowedFilter>();
    private final Map<String, String> allowedSorters = new HashMap<String, String>();
    private final String template;

    public QueryBuilder(String template) {
        this.template = template;
    }

    public QueryBuilder filter(AllowedFilter allowedFilter) {
        this.allowedFilters.put(allowedFilter.name(), allowedFilter);
        return this;
    }

    public QueryBuilder sorter(String name, String alias) {
        this.allowedSorters.put(name, alias);
        return this;
    }

    public Query create(EntityManager em, Map<String, String[]> requestedFilters, List<String> requestedSorters, int offset, int limit, Object ... params) {
        List<AllowedFilter.ConfiguredFilter> filters = requestedFilters.entrySet().stream().filter((? super T e) -> this.allowedFilters.containsKey(e.getKey())).map(e -> this.allowedFilters.get(e.getKey()).configure((String[])e.getValue())).toList();
        String conditions = (filters.isEmpty() ? "" : "and ") + filters.stream().map(AllowedFilter.ConfiguredFilter::expression).collect(Collectors.joining(" and "));
        List<ConfiguredSorter> sorters = Parsers.sorters(this.allowedSorters, requestedSorters);
        String orderClause = sorters.isEmpty() ? "" : String.format("order by %s", sorters.stream().map(s -> String.format("%s %s", new Object[]{s.alias(), s.dir()})).collect(Collectors.joining(",")));
        String qs = this.template.replace("{CONDITIONS}", conditions).replace("{ORDER_CLAUSE}", orderClause);
        Query query = em.createNativeQuery(qs);
        int pi = 0;
        for (Object param : params) {
            query.setParameter(++pi, param);
        }
        for (AllowedFilter.ConfiguredFilter filter : filters) {
            for (Object parameter : filter.parameters()) {
                query.setParameter(++pi, parameter);
            }
        }
        if (offset != 0) {
            query.setFirstResult(offset);
        }
        if (limit != 0) {
            query.setMaxResults(limit);
        }
        return query;
    }
}

