/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers.filtering;

import java.util.Arrays;
import net.optionfactory.keycloak.providers.filtering.AllowedFilter;
import net.optionfactory.keycloak.providers.filtering.Parsers;

public record BooleanFilter(String name, String alias) implements AllowedFilter
{
    @Override
    public AllowedFilter.ConfiguredFilter configure(String[] values) {
        Parsers.ensure(values.length == 2, this.name(), "Expected 2 values: [OP,VALUE], got %s", Arrays.toString(values));
        Operator operator = Parsers.enumeration(Operator.class, values[0], this.name());
        String value = values[1];
        if (value == null) {
            return new AllowedFilter.ConfiguredFilter(String.format("%s %s null", this.alias, operator == Operator.EQ ? "is" : "is not"), new Object[0]);
        }
        return new AllowedFilter.ConfiguredFilter(String.format("%s %s ?", this.alias, operator.op), value);
    }

    public static enum Operator {
        EQ("="),
        NEQ("<>");

        public final String op;

        private Operator(String op) {
            this.op = op;
        }
    }
}

