/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers.filtering;

import java.util.Arrays;
import net.optionfactory.keycloak.providers.filtering.AllowedFilter;
import net.optionfactory.keycloak.providers.filtering.Parsers;
import net.optionfactory.keycloak.providers.filtering.TextFilter;

public record AttributeFilter(String name, String alias) implements AllowedFilter
{
    @Override
    public AllowedFilter.ConfiguredFilter configure(String[] values) {
        Parsers.ensure(values.length == 4, this.name(), "Expected 4 values: [OP,CASE,FIELD,VALUE], got %s", Arrays.toString(values));
        TextFilter.Operator operator = Parsers.enumeration(TextFilter.Operator.class, values[0], this.name());
        TextFilter.CaseSensitivity sensitivity = Parsers.enumeration(TextFilter.CaseSensitivity.class, values[1], this.name());
        String field = values[2];
        String value = values[3];
        return switch (operator) {
            default -> throw new MatchException(null, null);
            case TextFilter.Operator.EQ, TextFilter.Operator.NEQ, TextFilter.Operator.LT, TextFilter.Operator.GT, TextFilter.Operator.LTE, TextFilter.Operator.GTE -> {
                if (value == null) {
                    Parsers.ensure(operator == TextFilter.Operator.EQ || operator == TextFilter.Operator.NEQ, this.name(), "Operator %s expects a non-null value", new Object[]{operator});
                    yield new AllowedFilter.ConfiguredFilter(String.format("jsonb_object_field_text(%s, ?) %s null", this.alias, operator == TextFilter.Operator.EQ ? "is" : "is not"), field);
                }
                yield new AllowedFilter.ConfiguredFilter(String.format(sensitivity == TextFilter.CaseSensitivity.CASE_SENSITIVE ? "jsonb_object_field_text(%s, ?) %s ?" : "lower(jsonb_object_field_text(%s, ?)) %s ?", this.alias, operator.op), field, sensitivity == TextFilter.CaseSensitivity.CASE_SENSITIVE ? value : value.toLowerCase());
            }
            case TextFilter.Operator.CONTAINS, TextFilter.Operator.STARTS_WITH, TextFilter.Operator.ENDS_WITH -> {
                Parsers.ensure(value != null, this.name(), "Operator %s expects a non-null value", new Object[]{operator});
                yield new AllowedFilter.ConfiguredFilter(String.format("jsonb_object_field_text(%s, ?) %s ?", this.alias, sensitivity == TextFilter.CaseSensitivity.CASE_SENSITIVE ? "like" : "ilike"), field, TextFilter.likePattern(operator, value));
            }
        };
    }
}

