/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers;

import java.util.stream.Stream;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;

public interface ResourceAuthenticator {
    public static void enforceScope(KeycloakSession session, String scope) {
        AuthenticationManager.AuthResult auth = new AppAuthManager.BearerTokenAuthenticator(session).authenticate();
        if (auth == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        if (Stream.of(auth.getToken().getScope().split(" ")).noneMatch(scope::equals)) {
            throw new ForbiddenException(String.format("Client does not have required scope '%s'", scope));
        }
    }
}

