/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.providers;

import java.net.URI;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.Config;

public class Conf {
    private final Logger logger = Logger.getLogger(Conf.class);
    private final Config.Scope scope;
    private final String name;

    public Conf(String name, Config.Scope scope) {
        this.name = name;
        this.scope = scope;
    }

    public String anyOf(String key, String ... values) {
        String value = this.string(key);
        Set<String> domain = Set.of(values);
        this.ensure(domain.contains(key), "'%s' must be one of %s", key, domain);
        return value;
    }

    public URI uri(String key) {
        String value = this.scope.get(key);
        this.ensure(value != null, "'%s' must be configured", key);
        try {
            return URI.create(value);
        }
        catch (IllegalArgumentException ex) {
            throw this.failure("'%s' must be a valid uri", key);
        }
    }

    public URI uri(String key, String defaultValue) {
        String value = this.scope.get(key, defaultValue);
        if (value == null) {
            return null;
        }
        try {
            return URI.create(value);
        }
        catch (IllegalArgumentException ex) {
            throw this.failure("'%s' must be a valid uri", key);
        }
    }

    public String string(String key) {
        String value = this.scope.get(key);
        this.ensure(value != null, "'%s' must be configured", key);
        return value;
    }

    public String string(String key, String defaultValue) {
        return this.scope.get(key, defaultValue);
    }

    public boolean bool(String key) {
        Boolean value = this.scope.getBoolean(key);
        this.ensure(value != null, "'%s' must be configured", key);
        return value;
    }

    public boolean bool(String key, boolean defaultValue) {
        return this.scope.getBoolean(key, Boolean.valueOf(defaultValue));
    }

    public long number(String key) {
        Long value = this.scope.getLong(key);
        this.ensure(value != null, "'%s' must be configured", key);
        return value;
    }

    public long number(String key, long defaultValue) {
        return this.scope.getLong(key, Long.valueOf(defaultValue));
    }

    public String[] array(String key) {
        String[] value = this.scope.getArray(key);
        this.ensure(value != null, "'%s' must be configured", key);
        return value;
    }

    public String[] array(String key, String[] defaultValue) {
        String[] v = this.scope.getArray(key);
        return v == null ? defaultValue : v;
    }

    public void ensure(boolean test, String format, Object ... args) {
        if (test) {
            return;
        }
        throw this.failure(format, args);
    }

    public ConfigurationException failure(String format, Object ... args) {
        String prefix = String.format("misconfigured %s", this.name);
        String suffix = String.format(format, args);
        String message = String.format("%s: %s", prefix, suffix);
        this.logger.warn((Object)message);
        return new ConfigurationException(message);
    }

    public static class ConfigurationException
    extends IllegalArgumentException {
        public ConfigurationException(String message) {
            super(message);
        }
    }
}

