/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.onlineaccess;

import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.optionfactory.keycloak.onlineaccess.OnlineAccessActionToken;
import net.optionfactory.keycloak.providers.Conf;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.TokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.Urls;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ext.AdminRealmResourceProvider;
import org.keycloak.services.resources.admin.ext.AdminRealmResourceProviderFactory;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;

public class OnlineAccessEndpoints {
    private final KeycloakSession session;
    private final int tokenDurationInSeconds;
    public static final String REQUIRED_ROLE = "online-access";

    public OnlineAccessEndpoints(KeycloakSession session, int tokenDurationInSeconds) {
        this.session = session;
        this.tokenDurationInSeconds = tokenDurationInSeconds;
    }

    @POST
    @Path(value="/action-token")
    @Produces(value={"application/json"})
    public OnlineSessionResponse create(@HeaderParam(value="at") String at, @QueryParam(value="redirect_uri") String redirectUri) throws Exception {
        KeycloakUriInfo uriInfo = this.session.getContext().getUri();
        RealmModel realm = this.session.getContext().getRealm();
        ClientModel client = this.session.getContext().getClient();
        TokenVerifier verifier = TokenVerifier.create((String)at, AccessToken.class);
        try {
            AccessToken token = (AccessToken)verifier.withChecks(new TokenVerifier.Predicate[]{new TokenVerifier.RealmUrlCheck(Urls.realmIssuer((URI)uriInfo.getBaseUri(), (String)realm.getName())), new TokenVerifier.TokenTypeCheck(List.of("Bearer")), new IssuedForContainsAuthorizedClient(client), new HasOfflineAccessScope(), TokenVerifier.IS_ACTIVE, TokenVerifier.SUBJECT_EXISTS_CHECK}).verifierContext(((SignatureProvider)this.session.getProvider(SignatureProvider.class, verifier.getHeader().getAlgorithm().name())).verifier(verifier.getHeader().getKeyId())).verify().getToken();
            String subject = token.getSubject();
            UserModel user = this.session.users().getUserById(realm, subject);
            if (user == null) {
                throw new NotFoundException("user not found");
            }
            if (!user.isEnabled()) {
                throw new NotFoundException("user is disabled");
            }
            ClientModel otherClient = this.session.clients().getClientByClientId(realm, token.getIssuedFor());
            if (otherClient == null) {
                throw new ForbiddenException("invalid at client");
            }
            Set validRedirectsFromClient = otherClient.getRedirectUris();
            List<String> validRedirectsFromRole = Stream.concat(Stream.of(client.getClientId()), Optional.ofNullable(client.getRole(REQUIRED_ROLE)).map(r -> r.getAttributeStream("redirect_uri")).orElse(Stream.of(new String[0]))).toList();
            Set validRedirects = Stream.concat(validRedirectsFromClient.stream(), validRedirectsFromRole.stream()).collect(Collectors.toSet());
            String verifiedRedirectUri = RedirectUtils.verifyRedirectUri((KeycloakSession)this.session, (String)otherClient.getRootUrl(), (String)redirectUri, validRedirects, (boolean)true);
            if (verifiedRedirectUri == null) {
                throw new ForbiddenException("invalid redirect_uri");
            }
            OnlineAccessActionToken actionToken = new OnlineAccessActionToken(user.getId(), Time.currentTime() + this.tokenDurationInSeconds, token.getIssuedFor(), verifiedRedirectUri);
            String link = Urls.realmBase((URI)uriInfo.getBaseUri()).path(RealmsResource.class, "getLoginActionsService").path(LoginActionsService.class, "executeActionToken").queryParam("key", new Object[]{actionToken.serialize(this.session, realm, (UriInfo)uriInfo)}).queryParam("client_id", new Object[]{actionToken.getIssuedFor()}).build(new Object[]{realm.getName()}).toString();
            return new OnlineSessionResponse(link);
        }
        catch (VerificationException ex) {
            throw new ForbiddenException(ex.getMessage());
        }
    }

    public static class IssuedForContainsAuthorizedClient
    implements TokenVerifier.Predicate<JsonWebToken> {
        private final Set<String> authorizedClients;

        public IssuedForContainsAuthorizedClient(ClientModel client) {
            this.authorizedClients = Stream.concat(Stream.of(client.getClientId()), Optional.ofNullable(client.getRole(OnlineAccessEndpoints.REQUIRED_ROLE)).map(r -> r.getAttributeStream("clients")).orElse(Stream.of(new String[0]))).collect(Collectors.toSet());
        }

        public boolean test(JsonWebToken t) throws VerificationException {
            if (!this.authorizedClients.contains(t.getIssuedFor())) {
                throw new VerificationException(String.format("%s is not an authorized client", t.getIssuedFor()));
            }
            return true;
        }
    }

    public static class HasOfflineAccessScope
    implements TokenVerifier.Predicate<AccessToken> {
        public boolean test(AccessToken t) throws VerificationException {
            Set scopes = Stream.of(t.getScope() == null ? "" : t.getScope()).flatMap(s -> Stream.of(s.split(" "))).filter(s -> !s.isBlank()).collect(Collectors.toSet());
            if (!scopes.contains("offline_access")) {
                throw new VerificationException("must have offline_access scope");
            }
            return true;
        }
    }

    public record OnlineSessionResponse(String link) {
    }

    public static class Factory
    implements AdminRealmResourceProviderFactory {
        private boolean enabled;
        private int tokenDurationInSeconds;
        private static final Logger logger = Logger.getLogger(Factory.class);

        public AdminRealmResourceProvider create(KeycloakSession session) {
            return !this.enabled ? null : new AdminRealmResourceProvider(){

                public Object getResource(KeycloakSession ks, RealmModel rm, AdminPermissionEvaluator ape, AdminEventBuilder aeb) {
                    if (ape.adminAuth().getClient().getRole(OnlineAccessEndpoints.REQUIRED_ROLE) == null) {
                        throw new ForbiddenException(String.format("client must have %s role", OnlineAccessEndpoints.REQUIRED_ROLE));
                    }
                    return new OnlineAccessEndpoints(ks, tokenDurationInSeconds);
                }

                public void close() {
                }
            };
        }

        public void init(Config.Scope scope) {
            Conf config = Conf.fromPrefix((String)"online-access-endpoins", (String)OnlineAccessEndpoints.REQUIRED_ROLE);
            this.enabled = config.bool("enabled", false);
            this.tokenDurationInSeconds = (int)config.number("token-duration", 60L);
            logger.infof("online-access(endpoints) initialized: %s", (Object)(this.enabled ? "enabled" : "disabled"));
        }

        public void postInit(KeycloakSessionFactory ksf) {
        }

        public void close() {
        }

        public String getId() {
            return OnlineAccessEndpoints.REQUIRED_ROLE;
        }
    }
}

