/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.onlineaccess;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import net.optionfactory.keycloak.onlineaccess.OnlineAccessActionToken;
import net.optionfactory.keycloak.providers.Conf;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.ActionTokenHandler;
import org.keycloak.authentication.actiontoken.ActionTokenHandlerFactory;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.sessions.AuthenticationSessionModel;

public class OnlineAccessActionTokenHandler
implements ActionTokenHandler<OnlineAccessActionToken> {
    public AuthenticationSessionModel startFreshAuthenticationSession(OnlineAccessActionToken token, ActionTokenContext<OnlineAccessActionToken> context) {
        return context.createAuthenticationSessionForClient(token.getIssuedFor());
    }

    public String getAuthenticationSessionIdFromToken(OnlineAccessActionToken token, ActionTokenContext<OnlineAccessActionToken> tokenContext, AuthenticationSessionModel currentAuthSession) {
        return token.getCompoundAuthenticationSessionId();
    }

    public boolean canUseTokenRepeatedly(OnlineAccessActionToken token, ActionTokenContext<OnlineAccessActionToken> context) {
        return false;
    }

    public Response handleToken(OnlineAccessActionToken token, ActionTokenContext<OnlineAccessActionToken> context) {
        UriInfo uriInfo = context.getUriInfo();
        RealmModel realm = context.getRealm();
        KeycloakSession session = context.getSession();
        EventBuilder eventBuilder = new EventBuilder(realm, session);
        ClientConnection connection = session.getContext().getConnection();
        UserSessionModel userSession = session.getContext().getUserSession();
        HttpRequest httpRequest = context.getSession().getContext().getHttpRequest();
        AuthenticationSessionModel authenticationSession = context.getAuthenticationSession();
        authenticationSession.setRedirectUri(token.getRedirectUri());
        ClientSessionContext clientSessionContext = AuthenticationProcessor.attachSession((AuthenticationSessionModel)authenticationSession, (UserSessionModel)userSession, (KeycloakSession)context.getSession(), (RealmModel)context.getRealm(), (ClientConnection)connection, (EventBuilder)eventBuilder);
        UserSessionModel maybeNewUserSession = clientSessionContext.getClientSession().getUserSession();
        Response response = AuthenticationManager.redirectAfterSuccessfulFlow((KeycloakSession)session, (RealmModel)realm, (UserSessionModel)maybeNewUserSession, (ClientSessionContext)clientSessionContext, (HttpRequest)httpRequest, (UriInfo)uriInfo, (ClientConnection)connection, (EventBuilder)eventBuilder, (AuthenticationSessionModel)authenticationSession);
        session.singleUseObjects().put(token.serializeKey(), token.getExp() - (long)Time.currentTime(), null);
        return response;
    }

    public Class<OnlineAccessActionToken> getTokenClass() {
        return OnlineAccessActionToken.class;
    }

    public EventType eventType() {
        return EventType.EXECUTE_ACTION_TOKEN;
    }

    public String getDefaultEventError() {
        return "not_allowed";
    }

    public String getDefaultErrorMessage() {
        return "invalidCodeMessage";
    }

    public void close() {
    }

    public static class Factory
    implements ActionTokenHandlerFactory<OnlineAccessActionToken> {
        private boolean enabled;
        private static final Logger logger = Logger.getLogger(Factory.class);

        public ActionTokenHandler<OnlineAccessActionToken> create(KeycloakSession session) {
            return this.enabled ? new OnlineAccessActionTokenHandler() : null;
        }

        public void init(Config.Scope ignored) {
            Conf config = Conf.fromPrefix((String)"online-access-action-token-handler", (String)"online-access");
            this.enabled = config.bool("enabled", false);
            logger.infof("online-access(action-token-handler) initialized: %s", (Object)(this.enabled ? "enabled" : "disabled"));
        }

        public void postInit(KeycloakSessionFactory factory) {
        }

        public void close() {
        }

        public String getId() {
            return "online-access-action-token";
        }
    }
}

