/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.email;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.optionfactory.keycloak.email.CidEmbeddingEmailSenderProvider;
import org.keycloak.Config;
import org.keycloak.email.DefaultEmailAuthenticator;
import org.keycloak.email.EmailAuthenticator;
import org.keycloak.email.EmailSenderProvider;
import org.keycloak.email.EmailSenderProviderFactory;
import org.keycloak.email.PasswordAuthEmailAuthenticator;
import org.keycloak.email.TokenAuthEmailAuthenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class CidEmbeddingEmailSenderProviderFactory
implements EmailSenderProviderFactory {
    private final Map<EmailAuthenticator.AuthenticatorType, EmailAuthenticator> emailAuthenticators = new ConcurrentHashMap<EmailAuthenticator.AuthenticatorType, EmailAuthenticator>();

    public EmailSenderProvider create(KeycloakSession session) {
        return new CidEmbeddingEmailSenderProvider(session, this.emailAuthenticators);
    }

    public void init(Config.Scope config) {
        this.emailAuthenticators.put(EmailAuthenticator.AuthenticatorType.NONE, (EmailAuthenticator)new DefaultEmailAuthenticator());
        this.emailAuthenticators.put(EmailAuthenticator.AuthenticatorType.BASIC, (EmailAuthenticator)new PasswordAuthEmailAuthenticator());
        this.emailAuthenticators.put(EmailAuthenticator.AuthenticatorType.TOKEN, (EmailAuthenticator)new TokenAuthEmailAuthenticator());
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        this.emailAuthenticators.clear();
    }

    public String getId() {
        return "opfa-cid-embedding";
    }
}

