/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.cookies;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.UriInfo;
import java.net.Inet4Address;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cookie.CookieProvider;
import org.keycloak.cookie.CookieProviderFactory;
import org.keycloak.cookie.CookieType;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.utils.SecureContextResolver;

public class SiteLocalAsSecureCookieProvider
implements CookieProvider {
    private static final Logger logger = Logger.getLogger(SiteLocalAsSecureCookieProvider.class);
    private final KeycloakSession session;
    private final CookiePathResolver pathResolver;
    private final boolean secure;
    private final Map<String, Cookie> cookies;

    public SiteLocalAsSecureCookieProvider(KeycloakSession session) {
        KeycloakContext context = session.getContext();
        this.session = session;
        this.cookies = context.getRequestHeaders().getCookies();
        this.pathResolver = new CookiePathResolver(context);
        boolean bl = this.secure = SecureContextResolver.isSecureContext((KeycloakSession)session) || this.isAllowed(context.getUri().getRequestUri());
        if (logger.isTraceEnabled()) {
            logger.tracef("Received cookies: %s, path: %s", (Object)String.join((CharSequence)", ", this.cookies.keySet()), (Object)context.getUri().getRequestUri().getRawPath());
        }
        if (!this.secure) {
            logger.warnf("Non-secure context detected; cookies are not secured, and will not be available in cross-origin POST requests", new Object[0]);
        }
        this.expireOldUnusedCookies();
    }

    public void set(CookieType cookieType, String value) {
        if (cookieType.getDefaultMaxAge() == null) {
            throw new IllegalArgumentException(String.valueOf(cookieType) + " has no default max-age");
        }
        this.set(cookieType, value, cookieType.getDefaultMaxAge());
    }

    public void set(CookieType cookieType, String value, int maxAge) {
        String name = cookieType.getName();
        NewCookie.SameSite sameSite = cookieType.getScope().getSameSite();
        if (NewCookie.SameSite.NONE.equals((Object)sameSite) && !this.secure) {
            sameSite = NewCookie.SameSite.LAX;
        }
        String path = this.pathResolver.resolvePath(cookieType);
        boolean httpOnly = cookieType.getScope().isHttpOnly();
        NewCookie newCookie = ((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(name).version(1)).value(value)).path(path)).maxAge(maxAge)).secure(this.secure)).httpOnly(httpOnly)).sameSite(sameSite)).build();
        this.session.getContext().getHttpResponse().setCookieIfAbsent(newCookie);
        logger.tracef("Setting cookie: name: %s, path: %s, same-site: %s, secure: %s, http-only: %s, max-age: %d", new Object[]{name, path, sameSite, this.secure, httpOnly, maxAge});
    }

    public String get(CookieType cookieType) {
        Cookie cookie = this.cookies.get(cookieType.getName());
        return cookie != null ? cookie.getValue() : null;
    }

    public void expire(CookieType cookieType) {
        String cookieName = cookieType.getName();
        Cookie cookie = this.cookies.get(cookieName);
        if (cookie != null) {
            String path = this.pathResolver.resolvePath(cookieType);
            NewCookie newCookie = ((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(cookieName).version(1)).path(path)).maxAge(0)).build();
            this.session.getContext().getHttpResponse().setCookieIfAbsent(newCookie);
            logger.tracef("Expiring cookie: name: %s, path: %s", (Object)cookie.getName(), (Object)path);
        }
    }

    private void expireOldUnusedCookies() {
        for (CookieType cookieType : CookieType.OLD_UNUSED_COOKIES) {
            this.expire(cookieType);
        }
    }

    public void close() {
    }

    private boolean isAllowed(URI uri) {
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        try {
            return Inet4Address.getByName(host).isSiteLocalAddress();
        }
        catch (UnknownHostException ex) {
            return false;
        }
    }

    public static class CookiePathResolver {
        private final KeycloakContext context;
        private String realmPath;
        private String requestPath;

        CookiePathResolver(KeycloakContext context) {
            this.context = context;
        }

        String resolvePath(CookieType cookieType) {
            switch (cookieType.getPath()) {
                case REALM: {
                    if (this.realmPath == null) {
                        this.realmPath = RealmsResource.realmBaseUrl((UriInfo)this.context.getUri()).path("/").build(new Object[]{this.context.getRealm().getName()}).getRawPath();
                    }
                    return this.realmPath;
                }
                case REQUEST: {
                    if (this.requestPath == null) {
                        this.requestPath = this.context.getUri().getRequestUri().getRawPath();
                    }
                    return this.requestPath;
                }
            }
            throw new IllegalArgumentException("Unsupported enum value " + cookieType.getPath().name());
        }
    }

    public static class Factory
    implements CookieProviderFactory {
        public CookieProvider create(KeycloakSession session) {
            return new SiteLocalAsSecureCookieProvider(session);
        }

        public void init(Config.Scope config) {
        }

        public void postInit(KeycloakSessionFactory factory) {
        }

        public void close() {
        }

        public String getId() {
            return "site-local-as-secure";
        }
    }
}

