/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.cie;

import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.UriUtils;
import org.keycloak.dom.saml.v2.protocol.AuthnContextComparisonType;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.saml.SamlPrincipalType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.util.XmlKeyInfoKeyNameTransformer;

public class CieIdIdentityProviderConfig
extends IdentityProviderModel {
    public static final XmlKeyInfoKeyNameTransformer DEFAULT_XML_KEY_INFO_KEY_NAME_TRANSFORMER = XmlKeyInfoKeyNameTransformer.NONE;
    public static final String ENTITY_ID = "entityId";
    public static final String ADD_EXTENSIONS_ELEMENT_WITH_KEY_INFO = "addExtensionsElementWithKeyInfo";
    public static final String BACKCHANNEL_SUPPORTED = "backchannelSupported";
    public static final String ENCRYPTION_PUBLIC_KEY = "encryptionPublicKey";
    public static final String FORCE_AUTHN = "forceAuthn";
    public static final String NAME_ID_POLICY_FORMAT = "nameIDPolicyFormat";
    public static final String POST_BINDING_AUTHN_REQUEST = "postBindingAuthnRequest";
    public static final String POST_BINDING_LOGOUT = "postBindingLogout";
    public static final String POST_BINDING_RESPONSE = "postBindingResponse";
    public static final String SIGNATURE_ALGORITHM = "signatureAlgorithm";
    public static final String SIGNING_CERTIFICATE_KEY = "signingCertificate";
    public static final String SINGLE_LOGOUT_SERVICE_URL = "singleLogoutServiceUrl";
    public static final String SINGLE_SIGN_ON_SERVICE_URL = "singleSignOnServiceUrl";
    public static final String VALIDATE_SIGNATURE = "validateSignature";
    public static final String PRINCIPAL_TYPE = "principalType";
    public static final String PRINCIPAL_ATTRIBUTE = "principalAttribute";
    public static final String WANT_ASSERTIONS_ENCRYPTED = "wantAssertionsEncrypted";
    public static final String WANT_ASSERTIONS_SIGNED = "wantAssertionsSigned";
    public static final String WANT_AUTHN_REQUESTS_SIGNED = "wantAuthnRequestsSigned";
    public static final String XML_SIG_KEY_INFO_KEY_NAME_TRANSFORMER = "xmlSigKeyInfoKeyNameTransformer";
    public static final String ENABLED_FROM_METADATA = "enabledFromMetadata";
    public static final String AUTHN_CONTEXT_COMPARISON_TYPE = "authnContextComparisonType";
    public static final String AUTHN_CONTEXT_CLASS_REFS = "authnContextClassRefs";
    public static final String AUTHN_CONTEXT_DECL_REFS = "authnContextDeclRefs";
    public static final String SIGN_SP_METADATA = "signSpMetadata";
    public static final String ALLOW_CREATE = "allowCreate";
    public static final String ATTRIBUTE_CONSUMING_SERVICE_INDEX = "attributeConsumingServiceIndex";
    public static final String ATTRIBUTE_CONSUMING_SERVICE_NAME = "attributeConsumingServiceName";
    public static final String ORGANIZATION_NAMES = "organizationNames";
    public static final String ORGANIZATION_DISPLAY_NAMES = "organizationDisplayNames";
    public static final String ORGANIZATION_URLS = "organizationUrls";
    public static final String ADMINISTRATIVE_CONTACT_SP_PRIVATE = "administrativeContactIsSpPrivate";
    public static final String ADMINISTRATIVE_CONTACT_COMPANY = "administrativeContactCompany";
    public static final String ADMINISTRATIVE_CONTACT_IPA_CATEGORY = "administrativeContactIpaCategory";
    public static final String ADMINISTRATIVE_CONTACT_IPA_CODE = "administrativeContactIpaCode";
    public static final String ADMINISTRATIVE_CONTACT_VAT_NUMBER = "administrativeContactVatNumber";
    public static final String ADMINISTRATIVE_CONTACT_FISCAL_CODE = "administrativeContactFiscalCode";
    public static final String ADMINISTRATIVE_CONTACT_NACE2_CODES = "administrativeContactNace2Codes";
    public static final String ADMINISTRATIVE_CONTACT_MUNICIPALITY = "administrativeContactMunicipality";
    public static final String ADMINISTRATIVE_CONTACT_PROVINCE = "administrativeContactProvince";
    public static final String ADMINISTRATIVE_CONTACT_COUNTRY = "administrativeContactCountry";
    public static final String ADMINISTRATIVE_CONTACT_PHONE = "administrativeContactPhone";
    public static final String ADMINISTRATIVE_CONTACT_EMAIL = "administrativeContactEmail";
    public static final String TECHNICAL_CONTACT_COMPANY = "technicalContactCompany";
    public static final String TECHNICAL_CONTACT_VAT_NUMBER = "technicalContactVatNumber";
    public static final String TECHNICAL_CONTACT_FISCAL_CODE = "technicalContactFiscalCode";
    public static final String TECHNICAL_CONTACT_NACE2_CODES = "technicalContactNace2Codes";
    public static final String TECHNICAL_CONTACT_MUNICIPALITY = "technicalContactMunicipality";
    public static final String TECHNICAL_CONTACT_PROVINCE = "technicalContactProvince";
    public static final String TECHNICAL_CONTACT_COUNTRY = "technicalContactCountry";
    public static final String TECHNICAL_CONTACT_PHONE = "technicalContactPhone";
    public static final String TECHNICAL_CONTACT_EMAIL = "technicalContactEmail";

    public CieIdIdentityProviderConfig() {
    }

    public CieIdIdentityProviderConfig(IdentityProviderModel identityProviderModel) {
        super(identityProviderModel);
    }

    public String getEntityId() {
        return (String)this.getConfig().get(ENTITY_ID);
    }

    public void setEntityId(String entityId) {
        this.getConfig().put(ENTITY_ID, entityId);
    }

    public String getSingleSignOnServiceUrl() {
        return (String)this.getConfig().get(SINGLE_SIGN_ON_SERVICE_URL);
    }

    public void setSingleSignOnServiceUrl(String singleSignOnServiceUrl) {
        this.getConfig().put(SINGLE_SIGN_ON_SERVICE_URL, singleSignOnServiceUrl);
    }

    public String getSingleLogoutServiceUrl() {
        return (String)this.getConfig().get(SINGLE_LOGOUT_SERVICE_URL);
    }

    public void setSingleLogoutServiceUrl(String singleLogoutServiceUrl) {
        this.getConfig().put(SINGLE_LOGOUT_SERVICE_URL, singleLogoutServiceUrl);
    }

    public boolean isValidateSignature() {
        return Boolean.valueOf((String)this.getConfig().get(VALIDATE_SIGNATURE));
    }

    public void setValidateSignature(boolean validateSignature) {
        this.getConfig().put(VALIDATE_SIGNATURE, String.valueOf(validateSignature));
    }

    public boolean isForceAuthn() {
        return Boolean.valueOf((String)this.getConfig().get(FORCE_AUTHN));
    }

    public void setForceAuthn(boolean forceAuthn) {
        this.getConfig().put(FORCE_AUTHN, String.valueOf(forceAuthn));
    }

    public String getSigningCertificate() {
        return (String)this.getConfig().get(SIGNING_CERTIFICATE_KEY);
    }

    public void setSigningCertificate(String signingCertificate) {
        this.getConfig().put(SIGNING_CERTIFICATE_KEY, signingCertificate);
    }

    public void addSigningCertificate(String signingCertificate) {
        String crt = (String)this.getConfig().get(SIGNING_CERTIFICATE_KEY);
        if (crt == null || crt.isEmpty()) {
            this.getConfig().put(SIGNING_CERTIFICATE_KEY, signingCertificate);
        } else {
            this.getConfig().put(SIGNING_CERTIFICATE_KEY, crt + "," + signingCertificate);
        }
    }

    public String[] getSigningCertificates() {
        String crt = (String)this.getConfig().get(SIGNING_CERTIFICATE_KEY);
        if (crt == null || crt.isEmpty()) {
            return new String[0];
        }
        return crt.split(",");
    }

    public String getNameIDPolicyFormat() {
        return (String)this.getConfig().get(NAME_ID_POLICY_FORMAT);
    }

    public void setNameIDPolicyFormat(String nameIDPolicyFormat) {
        this.getConfig().put(NAME_ID_POLICY_FORMAT, nameIDPolicyFormat);
    }

    public boolean isWantAuthnRequestsSigned() {
        return Boolean.valueOf((String)this.getConfig().get(WANT_AUTHN_REQUESTS_SIGNED));
    }

    public void setWantAuthnRequestsSigned(boolean wantAuthnRequestsSigned) {
        this.getConfig().put(WANT_AUTHN_REQUESTS_SIGNED, String.valueOf(wantAuthnRequestsSigned));
    }

    public boolean isWantAssertionsSigned() {
        return Boolean.valueOf((String)this.getConfig().get(WANT_ASSERTIONS_SIGNED));
    }

    public void setWantAssertionsSigned(boolean wantAssertionsSigned) {
        this.getConfig().put(WANT_ASSERTIONS_SIGNED, String.valueOf(wantAssertionsSigned));
    }

    public boolean isWantAssertionsEncrypted() {
        return Boolean.valueOf((String)this.getConfig().get(WANT_ASSERTIONS_ENCRYPTED));
    }

    public void setWantAssertionsEncrypted(boolean wantAssertionsEncrypted) {
        this.getConfig().put(WANT_ASSERTIONS_ENCRYPTED, String.valueOf(wantAssertionsEncrypted));
    }

    public boolean isAddExtensionsElementWithKeyInfo() {
        return Boolean.valueOf((String)this.getConfig().get(ADD_EXTENSIONS_ELEMENT_WITH_KEY_INFO));
    }

    public void setAddExtensionsElementWithKeyInfo(boolean addExtensionsElementWithKeyInfo) {
        this.getConfig().put(ADD_EXTENSIONS_ELEMENT_WITH_KEY_INFO, String.valueOf(addExtensionsElementWithKeyInfo));
    }

    public String getSignatureAlgorithm() {
        return (String)this.getConfig().get(SIGNATURE_ALGORITHM);
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.getConfig().put(SIGNATURE_ALGORITHM, signatureAlgorithm);
    }

    public String getEncryptionPublicKey() {
        return (String)this.getConfig().get(ENCRYPTION_PUBLIC_KEY);
    }

    public void setEncryptionPublicKey(String encryptionPublicKey) {
        this.getConfig().put(ENCRYPTION_PUBLIC_KEY, encryptionPublicKey);
    }

    public boolean isPostBindingAuthnRequest() {
        return Boolean.valueOf((String)this.getConfig().get(POST_BINDING_AUTHN_REQUEST));
    }

    public void setPostBindingAuthnRequest(boolean postBindingAuthnRequest) {
        this.getConfig().put(POST_BINDING_AUTHN_REQUEST, String.valueOf(postBindingAuthnRequest));
    }

    public boolean isPostBindingResponse() {
        return Boolean.valueOf((String)this.getConfig().get(POST_BINDING_RESPONSE));
    }

    public void setPostBindingResponse(boolean postBindingResponse) {
        this.getConfig().put(POST_BINDING_RESPONSE, String.valueOf(postBindingResponse));
    }

    public boolean isPostBindingLogout() {
        String postBindingLogout = (String)this.getConfig().get(POST_BINDING_LOGOUT);
        if (postBindingLogout == null) {
            return this.isPostBindingResponse();
        }
        return Boolean.valueOf(postBindingLogout);
    }

    public void setPostBindingLogout(boolean postBindingLogout) {
        this.getConfig().put(POST_BINDING_LOGOUT, String.valueOf(postBindingLogout));
    }

    public boolean isBackchannelSupported() {
        return Boolean.valueOf((String)this.getConfig().get(BACKCHANNEL_SUPPORTED));
    }

    public void setBackchannelSupported(boolean backchannel) {
        this.getConfig().put(BACKCHANNEL_SUPPORTED, String.valueOf(backchannel));
    }

    public XmlKeyInfoKeyNameTransformer getXmlSigKeyInfoKeyNameTransformer() {
        return XmlKeyInfoKeyNameTransformer.from((String)((String)this.getConfig().get(XML_SIG_KEY_INFO_KEY_NAME_TRANSFORMER)), (XmlKeyInfoKeyNameTransformer)DEFAULT_XML_KEY_INFO_KEY_NAME_TRANSFORMER);
    }

    public void setXmlSigKeyInfoKeyNameTransformer(XmlKeyInfoKeyNameTransformer xmlSigKeyInfoKeyNameTransformer) {
        this.getConfig().put(XML_SIG_KEY_INFO_KEY_NAME_TRANSFORMER, xmlSigKeyInfoKeyNameTransformer == null ? null : xmlSigKeyInfoKeyNameTransformer.name());
    }

    public int getAllowedClockSkew() {
        int result = 0;
        String allowedClockSkew = (String)this.getConfig().get("allowedClockSkew");
        if (allowedClockSkew != null && !allowedClockSkew.isEmpty()) {
            try {
                result = Integer.parseInt(allowedClockSkew);
                if (result < 0) {
                    result = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public void setAllowedClockSkew(int allowedClockSkew) {
        if (allowedClockSkew < 0) {
            this.getConfig().remove("allowedClockSkew");
        } else {
            this.getConfig().put("allowedClockSkew", String.valueOf(allowedClockSkew));
        }
    }

    public SamlPrincipalType getPrincipalType() {
        return SamlPrincipalType.from((String)((String)this.getConfig().get(PRINCIPAL_TYPE)), (SamlPrincipalType)SamlPrincipalType.SUBJECT);
    }

    public void setPrincipalType(SamlPrincipalType principalType) {
        this.getConfig().put(PRINCIPAL_TYPE, principalType == null ? null : principalType.name());
    }

    public String getPrincipalAttribute() {
        return (String)this.getConfig().get(PRINCIPAL_ATTRIBUTE);
    }

    public void setPrincipalAttribute(String principalAttribute) {
        this.getConfig().put(PRINCIPAL_ATTRIBUTE, principalAttribute);
    }

    public boolean isEnabledFromMetadata() {
        return Boolean.valueOf((String)this.getConfig().get(ENABLED_FROM_METADATA));
    }

    public void setEnabledFromMetadata(boolean enabled) {
        this.getConfig().put(ENABLED_FROM_METADATA, String.valueOf(enabled));
    }

    public AuthnContextComparisonType getAuthnContextComparisonType() {
        return AuthnContextComparisonType.fromValue((String)this.getConfig().getOrDefault(AUTHN_CONTEXT_COMPARISON_TYPE, AuthnContextComparisonType.EXACT.value()));
    }

    public void setAuthnContextComparisonType(AuthnContextComparisonType authnContextComparisonType) {
        this.getConfig().put(AUTHN_CONTEXT_COMPARISON_TYPE, authnContextComparisonType.value());
    }

    public String getAuthnContextClassRefs() {
        return (String)this.getConfig().get(AUTHN_CONTEXT_CLASS_REFS);
    }

    public void setAuthnContextClassRefs(String authnContextClassRefs) {
        this.getConfig().put(AUTHN_CONTEXT_CLASS_REFS, authnContextClassRefs);
    }

    public String getAuthnContextDeclRefs() {
        return (String)this.getConfig().get(AUTHN_CONTEXT_DECL_REFS);
    }

    public void setAuthnContextDeclRefs(String authnContextDeclRefs) {
        this.getConfig().put(AUTHN_CONTEXT_DECL_REFS, authnContextDeclRefs);
    }

    public boolean isSignSpMetadata() {
        return Boolean.valueOf((String)this.getConfig().get(SIGN_SP_METADATA));
    }

    public void setSignSpMetadata(boolean signSpMetadata) {
        this.getConfig().put(SIGN_SP_METADATA, String.valueOf(signSpMetadata));
    }

    public boolean isAllowCreate() {
        return Boolean.valueOf((String)this.getConfig().get(ALLOW_CREATE));
    }

    public void setAllowCreated(boolean allowCreate) {
        this.getConfig().put(ALLOW_CREATE, String.valueOf(allowCreate));
    }

    public Integer getAttributeConsumingServiceIndex() {
        Integer result = null;
        String strAttributeConsumingServiceIndex = (String)this.getConfig().get(ATTRIBUTE_CONSUMING_SERVICE_INDEX);
        if (strAttributeConsumingServiceIndex != null && !strAttributeConsumingServiceIndex.isEmpty()) {
            try {
                result = Integer.parseInt(strAttributeConsumingServiceIndex);
                if (result < 0) {
                    result = null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public void setAttributeConsumingServiceIndex(Integer attributeConsumingServiceIndex) {
        if (attributeConsumingServiceIndex == null || attributeConsumingServiceIndex < 0) {
            this.getConfig().remove(ATTRIBUTE_CONSUMING_SERVICE_INDEX);
        } else {
            this.getConfig().put(ATTRIBUTE_CONSUMING_SERVICE_INDEX, String.valueOf(attributeConsumingServiceIndex));
        }
    }

    public void setAttributeConsumingServiceName(String attributeConsumingServiceName) {
        this.getConfig().put(ATTRIBUTE_CONSUMING_SERVICE_NAME, attributeConsumingServiceName);
    }

    public String getAttributeConsumingServiceName() {
        return (String)this.getConfig().get(ATTRIBUTE_CONSUMING_SERVICE_NAME);
    }

    public String getOrganizationNames() {
        return (String)this.getConfig().get(ORGANIZATION_NAMES);
    }

    public void setOrganizationNames(String organizationNames) {
        this.getConfig().put(ORGANIZATION_NAMES, organizationNames);
    }

    public String getOrganizationDisplayNames() {
        return (String)this.getConfig().get(ORGANIZATION_DISPLAY_NAMES);
    }

    public void setOrganizationDisplayNames(String organizationDisplayNames) {
        this.getConfig().put(ORGANIZATION_DISPLAY_NAMES, organizationDisplayNames);
    }

    public String getOrganizationUrls() {
        return (String)this.getConfig().get(ORGANIZATION_URLS);
    }

    public void setOrganizationUrls(String organizationUrls) {
        this.getConfig().put(ORGANIZATION_URLS, organizationUrls);
    }

    public void validate(RealmModel realm) {
        SslRequired sslRequired = realm.getSslRequired();
        UriUtils.checkUrl((SslRequired)sslRequired, (String)this.getSingleLogoutServiceUrl(), (String)SINGLE_LOGOUT_SERVICE_URL);
        UriUtils.checkUrl((SslRequired)sslRequired, (String)this.getSingleSignOnServiceUrl(), (String)SINGLE_SIGN_ON_SERVICE_URL);
        if (JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get().equals(this.getNameIDPolicyFormat()) && SamlPrincipalType.SUBJECT == this.getPrincipalType()) {
            throw new IllegalArgumentException("Can not have Transient NameID Policy Format together with SUBJECT Principal Type");
        }
    }

    public boolean isSpPrivate() {
        return Boolean.valueOf((String)this.getConfig().get(ADMINISTRATIVE_CONTACT_SP_PRIVATE));
    }

    public void setSpPrivate(boolean isPrivate) {
        this.getConfig().put(ADMINISTRATIVE_CONTACT_SP_PRIVATE, String.valueOf(isPrivate));
    }

    public String getIpaCode() {
        return (String)this.getConfig().get(ADMINISTRATIVE_CONTACT_IPA_CODE);
    }

    public void setIpaCode(String ipaCode) {
        this.getConfig().put(ADMINISTRATIVE_CONTACT_IPA_CODE, ipaCode);
    }

    public String getIpaCategory() {
        return (String)this.getConfig().get(ADMINISTRATIVE_CONTACT_IPA_CATEGORY);
    }

    public void setIpaCategory(String ipaCategory) {
        this.getConfig().put(ADMINISTRATIVE_CONTACT_IPA_CATEGORY, ipaCategory);
    }

    public String getAdministrativeContactVatNumber() {
        return (String)this.getConfig().get(ADMINISTRATIVE_CONTACT_VAT_NUMBER);
    }

    public void setAdministrativeContactVatNumber(String vatNumber) {
        this.getConfig().put(ADMINISTRATIVE_CONTACT_VAT_NUMBER, vatNumber);
    }

    public String getAdministrativeContactFiscalCode() {
        return (String)this.getConfig().get(ADMINISTRATIVE_CONTACT_FISCAL_CODE);
    }

    public void setAdministrativeContactFiscalCode(String fiscalCode) {
        this.getConfig().put(ADMINISTRATIVE_CONTACT_FISCAL_CODE, fiscalCode);
    }

    public String getAdministrativeContactNace2Codes() {
        return (String)this.getConfig().get(ADMINISTRATIVE_CONTACT_NACE2_CODES);
    }

    public void setAdministrativeContactNace2Codes(String nace2Codes) {
        this.getConfig().put(ADMINISTRATIVE_CONTACT_NACE2_CODES, nace2Codes);
    }

    public String getAdministrativeContactMunicipality() {
        return (String)this.getConfig().get(ADMINISTRATIVE_CONTACT_MUNICIPALITY);
    }

    public void setAdministrativeContactMunicipality(String municipality) {
        this.getConfig().put(ADMINISTRATIVE_CONTACT_MUNICIPALITY, municipality);
    }

    public String getAdministrativeContactProvince() {
        return (String)this.getConfig().get(ADMINISTRATIVE_CONTACT_PROVINCE);
    }

    public void setAdministrativeContactProvince(String province) {
        this.getConfig().put(ADMINISTRATIVE_CONTACT_PROVINCE, province);
    }

    public String getAdministrativeContactCountry() {
        return (String)this.getConfig().get(ADMINISTRATIVE_CONTACT_COUNTRY);
    }

    public void setAdministrativeContactCountry(String country) {
        this.getConfig().put(ADMINISTRATIVE_CONTACT_COUNTRY, country);
    }

    public String getAdministrativeContactEmail() {
        return (String)this.getConfig().get(ADMINISTRATIVE_CONTACT_EMAIL);
    }

    public void setAdministrativeContactEmail(String contactEmail) {
        this.getConfig().put(ADMINISTRATIVE_CONTACT_EMAIL, contactEmail);
    }

    public String getAdministrativeContactCompany() {
        return (String)this.getConfig().get(ADMINISTRATIVE_CONTACT_COMPANY);
    }

    public void setAdministrativeContactCompany(String contactCompany) {
        this.getConfig().put(ADMINISTRATIVE_CONTACT_COMPANY, contactCompany);
    }

    public String getAdministrativeContactPhone() {
        return (String)this.getConfig().get(ADMINISTRATIVE_CONTACT_PHONE);
    }

    public void setAdministrativeContactPhone(String contactPhone) {
        this.getConfig().put(ADMINISTRATIVE_CONTACT_PHONE, contactPhone);
    }

    public String getTechnicalContactVatNumber() {
        return (String)this.getConfig().get(TECHNICAL_CONTACT_VAT_NUMBER);
    }

    public void setTechnicalContactVatNumber(String vatNumber) {
        this.getConfig().put(TECHNICAL_CONTACT_VAT_NUMBER, vatNumber);
    }

    public String getTechnicalContactFiscalCode() {
        return (String)this.getConfig().get(TECHNICAL_CONTACT_FISCAL_CODE);
    }

    public void setTechnicalContactFiscalCode(String fiscalCode) {
        this.getConfig().put(TECHNICAL_CONTACT_FISCAL_CODE, fiscalCode);
    }

    public String getTechnicalContactNace2Codes() {
        return (String)this.getConfig().get(TECHNICAL_CONTACT_NACE2_CODES);
    }

    public void setTechnicalContactNace2Codes(String nace2Codes) {
        this.getConfig().put(TECHNICAL_CONTACT_NACE2_CODES, nace2Codes);
    }

    public String getTechnicalContactMunicipality() {
        return (String)this.getConfig().get(TECHNICAL_CONTACT_MUNICIPALITY);
    }

    public void setTechnicalContactMunicipality(String municipality) {
        this.getConfig().put(TECHNICAL_CONTACT_MUNICIPALITY, municipality);
    }

    public String getTechnicalContactProvince() {
        return (String)this.getConfig().get(TECHNICAL_CONTACT_PROVINCE);
    }

    public void setTechnicalContactProvince(String province) {
        this.getConfig().put(TECHNICAL_CONTACT_PROVINCE, province);
    }

    public String getTechnicalContactCountry() {
        return (String)this.getConfig().get(TECHNICAL_CONTACT_COUNTRY);
    }

    public void setTechnicalContactCountry(String country) {
        this.getConfig().put(TECHNICAL_CONTACT_COUNTRY, country);
    }

    public String getTechnicalContactEmail() {
        return (String)this.getConfig().get(TECHNICAL_CONTACT_EMAIL);
    }

    public void setTechnicalContactEmail(String contactEmail) {
        this.getConfig().put(TECHNICAL_CONTACT_EMAIL, contactEmail);
    }

    public String getTechnicalContactCompany() {
        return (String)this.getConfig().get(TECHNICAL_CONTACT_COMPANY);
    }

    public void setTechnicalContactCompany(String contactCompany) {
        this.getConfig().put(TECHNICAL_CONTACT_COMPANY, contactCompany);
    }

    public String getTechnicalContactPhone() {
        return (String)this.getConfig().get(TECHNICAL_CONTACT_PHONE);
    }

    public void setTechnicalContactPhone(String contactPhone) {
        this.getConfig().put(TECHNICAL_CONTACT_PHONE, contactPhone);
    }
}

