/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.cie;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamWriter;
import net.optionfactory.keycloak.cie.CieIdIdentityProviderConfig;
import net.optionfactory.keycloak.cie.CieIdSAMLEndpoint;
import org.jboss.logging.Logger;
import org.keycloak.broker.provider.AbstractIdentityProvider;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderDataMarshaller;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.saml.SAMLDataMarshaller;
import org.keycloak.common.util.PemUtils;
import org.keycloak.crypto.KeyStatus;
import org.keycloak.crypto.KeyUse;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.metadata.AttributeConsumingServiceType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.LocalizedNameType;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.saml.JaxrsSAML2BindingBuilder;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.protocol.saml.SamlSessionUtils;
import org.keycloak.protocol.saml.mappers.SamlMetadataDescriptorUpdater;
import org.keycloak.protocol.saml.preprocessor.SamlAuthenticationPreprocessor;
import org.keycloak.saml.SAML2AuthnRequestBuilder;
import org.keycloak.saml.SAML2LogoutRequestBuilder;
import org.keycloak.saml.SAML2NameIDBuilder;
import org.keycloak.saml.SAML2NameIDPolicyBuilder;
import org.keycloak.saml.SAML2RequestedAuthnContextBuilder;
import org.keycloak.saml.SPMetadataDescriptor;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.api.saml.v2.sig.SAML2Signature;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLMetadataWriter;
import org.keycloak.saml.processing.core.util.KeycloakKeySamlExtensionGenerator;
import org.keycloak.saml.validators.DestinationValidator;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.util.JsonSerialization;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CieIdIdentityProvider
extends AbstractIdentityProvider<CieIdIdentityProviderConfig> {
    protected static final Logger logger = Logger.getLogger(CieIdIdentityProvider.class);
    private final DestinationValidator destinationValidator;

    public CieIdIdentityProvider(KeycloakSession session, CieIdIdentityProviderConfig config, DestinationValidator destinationValidator) {
        super(session, (IdentityProviderModel)config);
        this.destinationValidator = destinationValidator;
    }

    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new CieIdSAMLEndpoint(realm, this, (CieIdIdentityProviderConfig)this.getConfig(), callback, this.destinationValidator);
    }

    public Response performLogin(AuthenticationRequest request) {
        try {
            UriInfo uriInfo = request.getUriInfo();
            RealmModel realm = request.getRealm();
            String issuerURL = this.getEntityId(uriInfo, realm);
            String destinationUrl = ((CieIdIdentityProviderConfig)this.getConfig()).getSingleSignOnServiceUrl();
            String nameIDPolicyFormat = ((CieIdIdentityProviderConfig)this.getConfig()).getNameIDPolicyFormat();
            if (nameIDPolicyFormat == null) {
                nameIDPolicyFormat = JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get();
            }
            String protocolBinding = JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get();
            String assertionConsumerServiceUrl = request.getRedirectUri();
            if (((CieIdIdentityProviderConfig)this.getConfig()).isPostBindingResponse()) {
                protocolBinding = JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get();
            }
            SAML2RequestedAuthnContextBuilder requestedAuthnContext = new SAML2RequestedAuthnContextBuilder().setComparison(((CieIdIdentityProviderConfig)this.getConfig()).getAuthnContextComparisonType());
            for (String authnContextClassRef : this.getAuthnContextClassRefUris()) {
                requestedAuthnContext.addAuthnContextClassRef(authnContextClassRef);
            }
            for (String authnContextDeclRef : this.getAuthnContextDeclRefUris()) {
                requestedAuthnContext.addAuthnContextDeclRef(authnContextDeclRef);
            }
            Integer attributeConsumingServiceIndex = ((CieIdIdentityProviderConfig)this.getConfig()).getAttributeConsumingServiceIndex();
            String loginHint = ((CieIdIdentityProviderConfig)this.getConfig()).isLoginHint() ? request.getAuthenticationSession().getClientNote("login_hint") : null;
            Boolean allowCreate = null;
            if (((CieIdIdentityProviderConfig)this.getConfig()).getConfig().get("allowCreate") == null || ((CieIdIdentityProviderConfig)this.getConfig()).isAllowCreate()) {
                allowCreate = Boolean.TRUE;
            }
            SAML2AuthnRequestBuilder authnRequestBuilder = new SAML2AuthnRequestBuilder().assertionConsumerUrl(assertionConsumerServiceUrl).destination(destinationUrl).issuer(SAML2NameIDBuilder.value((String)issuerURL).setNameQualifier(issuerURL).setFormat(JBossSAMLURIConstants.NAMEID_FORMAT_ENTITY.get()).build()).forceAuthn(((CieIdIdentityProviderConfig)this.getConfig()).isForceAuthn()).protocolBinding(protocolBinding).nameIdPolicy(SAML2NameIDPolicyBuilder.format((String)nameIDPolicyFormat).setAllowCreate(allowCreate)).attributeConsumingServiceIndex(attributeConsumingServiceIndex).requestedAuthnContext(requestedAuthnContext).subject(loginHint);
            JaxrsSAML2BindingBuilder binding = (JaxrsSAML2BindingBuilder)new JaxrsSAML2BindingBuilder(this.session).relayState(request.getState().getEncoded());
            boolean postBinding = ((CieIdIdentityProviderConfig)this.getConfig()).isPostBindingAuthnRequest();
            if (((CieIdIdentityProviderConfig)this.getConfig()).isWantAuthnRequestsSigned()) {
                KeyManager.ActiveRsaKey keys = this.session.keys().getActiveRsaKey(realm);
                String keyName = ((CieIdIdentityProviderConfig)this.getConfig()).getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
                ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signatureAlgorithm(this.getSignatureAlgorithm())).signDocument();
                if (!postBinding && ((CieIdIdentityProviderConfig)this.getConfig()).isAddExtensionsElementWithKeyInfo()) {
                    authnRequestBuilder.addExtension((SamlProtocolExtensionsAwareBuilder.NodeGenerator)new KeycloakKeySamlExtensionGenerator(keyName));
                }
            }
            AuthnRequestType authnRequest = authnRequestBuilder.createAuthnRequest();
            Iterator it = SamlSessionUtils.getSamlAuthenticationPreprocessorIterator((KeycloakSession)this.session);
            while (it.hasNext()) {
                authnRequest = ((SamlAuthenticationPreprocessor)it.next()).beforeSendingLoginRequest(authnRequest, request.getAuthenticationSession());
            }
            if (authnRequest.getDestination() != null) {
                destinationUrl = authnRequest.getDestination().toString();
            }
            request.getAuthenticationSession().setClientNote("SAML_REQUEST_ID_BROKER", authnRequest.getID());
            if (postBinding) {
                return binding.postBinding(authnRequestBuilder.toDocument()).request(destinationUrl);
            }
            return binding.redirectBinding(authnRequestBuilder.toDocument()).request(destinationUrl);
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not create authentication request.", (Throwable)e);
        }
    }

    private String getEntityId(UriInfo uriInfo, RealmModel realm) {
        String configEntityId = ((CieIdIdentityProviderConfig)this.getConfig()).getEntityId();
        if (configEntityId == null || configEntityId.isEmpty()) {
            return UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("realms").path(realm.getName()).build(new Object[0]).toString();
        }
        return configEntityId;
    }

    private List<String> getAuthnContextClassRefUris() {
        String authnContextClassRefs = ((CieIdIdentityProviderConfig)this.getConfig()).getAuthnContextClassRefs();
        if (authnContextClassRefs == null || authnContextClassRefs.isEmpty()) {
            return new LinkedList<String>();
        }
        try {
            return Arrays.asList((String[])JsonSerialization.readValue((String)authnContextClassRefs, String[].class));
        }
        catch (Exception e) {
            logger.warn((Object)("Could not json-deserialize AuthContextClassRefs config entry: " + authnContextClassRefs), (Throwable)e);
            return new LinkedList<String>();
        }
    }

    private List<String> getAuthnContextDeclRefUris() {
        String authnContextDeclRefs = ((CieIdIdentityProviderConfig)this.getConfig()).getAuthnContextDeclRefs();
        if (authnContextDeclRefs == null || authnContextDeclRefs.isEmpty()) {
            return new LinkedList<String>();
        }
        try {
            return Arrays.asList((String[])JsonSerialization.readValue((String)authnContextDeclRefs, String[].class));
        }
        catch (Exception e) {
            logger.warn((Object)("Could not json-deserialize AuthContextDeclRefs config entry: " + authnContextDeclRefs), (Throwable)e);
            return new LinkedList<String>();
        }
    }

    public void authenticationFinished(AuthenticationSessionModel authSession, BrokeredIdentityContext context) {
        AuthnStatementType authn;
        ResponseType responseType = (ResponseType)context.getContextData().get("SAML_LOGIN_RESPONSE");
        AssertionType assertion = (AssertionType)context.getContextData().get("SAML_ASSERTION");
        SubjectType subject = assertion.getSubject();
        SubjectType.STSubType subType = subject.getSubType();
        if (subType != null) {
            NameIDType subjectNameID = (NameIDType)subType.getBaseID();
            authSession.setUserSessionNote("SAML_FEDERATED_SUBJECT_NAME_ID", subjectNameID.serializeAsString());
        }
        if ((authn = (AuthnStatementType)context.getContextData().get("SAML_AUTHN_STATEMENT")) != null && authn.getSessionIndex() != null) {
            authSession.setUserSessionNote("SAML_FEDERATED_SESSION_INDEX", authn.getSessionIndex());
        }
    }

    public Response retrieveToken(KeycloakSession session, FederatedIdentityModel identity) {
        return Response.ok((Object)identity.getToken()).build();
    }

    public void backchannelLogout(KeycloakSession session, UserSessionModel userSession, UriInfo uriInfo, RealmModel realm) {
        String singleLogoutServiceUrl = ((CieIdIdentityProviderConfig)this.getConfig()).getSingleLogoutServiceUrl();
        if (singleLogoutServiceUrl == null || singleLogoutServiceUrl.trim().equals("") || !((CieIdIdentityProviderConfig)this.getConfig()).isBackchannelSupported()) {
            return;
        }
        JaxrsSAML2BindingBuilder binding = this.buildLogoutBinding(session, userSession, realm);
        try {
            int status;
            boolean success;
            LogoutRequestType logoutRequest = this.buildLogoutRequest(userSession, uriInfo, realm, singleLogoutServiceUrl, new SamlProtocolExtensionsAwareBuilder.NodeGenerator[0]);
            if (logoutRequest.getDestination() != null) {
                singleLogoutServiceUrl = logoutRequest.getDestination().toString();
            }
            boolean bl = success = (status = SimpleHttp.doPost((String)singleLogoutServiceUrl, (KeycloakSession)session).param("SAMLRequest", binding.postBinding(SAML2Request.convert((RequestAbstractType)logoutRequest)).encoded()).param("RelayState", userSession.getId()).asStatus()) >= 200 && status < 400;
            if (!success) {
                logger.warn((Object)("Failed saml backchannel broker logout to: " + singleLogoutServiceUrl));
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed saml backchannel broker logout to: " + singleLogoutServiceUrl), (Throwable)e);
        }
    }

    public Response keycloakInitiatedBrowserLogout(KeycloakSession session, UserSessionModel userSession, UriInfo uriInfo, RealmModel realm) {
        String singleLogoutServiceUrl = ((CieIdIdentityProviderConfig)this.getConfig()).getSingleLogoutServiceUrl();
        if (singleLogoutServiceUrl == null || singleLogoutServiceUrl.trim().equals("")) {
            return null;
        }
        if (((CieIdIdentityProviderConfig)this.getConfig()).isBackchannelSupported()) {
            this.backchannelLogout(session, userSession, uriInfo, realm);
            return null;
        }
        try {
            LogoutRequestType logoutRequest = this.buildLogoutRequest(userSession, uriInfo, realm, singleLogoutServiceUrl, new SamlProtocolExtensionsAwareBuilder.NodeGenerator[0]);
            if (logoutRequest.getDestination() != null) {
                singleLogoutServiceUrl = logoutRequest.getDestination().toString();
            }
            JaxrsSAML2BindingBuilder binding = this.buildLogoutBinding(session, userSession, realm);
            if (((CieIdIdentityProviderConfig)this.getConfig()).isPostBindingLogout()) {
                return binding.postBinding(SAML2Request.convert((RequestAbstractType)logoutRequest)).request(singleLogoutServiceUrl);
            }
            return binding.redirectBinding(SAML2Request.convert((RequestAbstractType)logoutRequest)).request(singleLogoutServiceUrl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected LogoutRequestType buildLogoutRequest(UserSessionModel userSession, UriInfo uriInfo, RealmModel realm, String singleLogoutServiceUrl, SamlProtocolExtensionsAwareBuilder.NodeGenerator ... extensions) throws ConfigurationException {
        String entityId = this.getEntityId(uriInfo, realm);
        SAML2LogoutRequestBuilder logoutBuilder = new SAML2LogoutRequestBuilder().assertionExpiration(realm.getAccessCodeLifespan()).issuer(SAML2NameIDBuilder.value((String)entityId).setNameQualifier(entityId).setFormat(JBossSAMLURIConstants.NAMEID_FORMAT_ENTITY.get()).build()).sessionIndex(userSession.getNote("SAML_FEDERATED_SESSION_INDEX")).nameId(NameIDType.deserializeFromString((String)userSession.getNote("SAML_FEDERATED_SUBJECT_NAME_ID"))).destination(singleLogoutServiceUrl);
        LogoutRequestType logoutRequest = logoutBuilder.createLogoutRequest();
        for (SamlProtocolExtensionsAwareBuilder.NodeGenerator extension : extensions) {
            logoutBuilder.addExtension(extension);
        }
        Iterator it = SamlSessionUtils.getSamlAuthenticationPreprocessorIterator((KeycloakSession)this.session);
        while (it.hasNext()) {
            logoutRequest = ((SamlAuthenticationPreprocessor)it.next()).beforeSendingLogoutRequest(logoutRequest, userSession, null);
        }
        return logoutRequest;
    }

    private JaxrsSAML2BindingBuilder buildLogoutBinding(KeycloakSession session, UserSessionModel userSession, RealmModel realm) {
        JaxrsSAML2BindingBuilder binding = (JaxrsSAML2BindingBuilder)new JaxrsSAML2BindingBuilder(session).relayState(userSession.getId());
        if (((CieIdIdentityProviderConfig)this.getConfig()).isWantAuthnRequestsSigned()) {
            KeyManager.ActiveRsaKey keys = session.keys().getActiveRsaKey(realm);
            String keyName = ((CieIdIdentityProviderConfig)this.getConfig()).getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
            ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signatureAlgorithm(this.getSignatureAlgorithm())).signDocument();
        }
        return binding;
    }

    public Response export(UriInfo uriInfo, RealmModel realm, String format) {
        try {
            URI authnBinding = JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri();
            if (((CieIdIdentityProviderConfig)this.getConfig()).isPostBindingAuthnRequest()) {
                authnBinding = JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.getUri();
            }
            URI endpoint = uriInfo.getBaseUriBuilder().path("realms").path(realm.getName()).path("broker").path(((CieIdIdentityProviderConfig)this.getConfig()).getAlias()).path("endpoint").build(new Object[0]);
            boolean wantAuthnRequestsSigned = ((CieIdIdentityProviderConfig)this.getConfig()).isWantAuthnRequestsSigned();
            boolean wantAssertionsSigned = ((CieIdIdentityProviderConfig)this.getConfig()).isWantAssertionsSigned();
            boolean wantAssertionsEncrypted = ((CieIdIdentityProviderConfig)this.getConfig()).isWantAssertionsEncrypted();
            String entityId = this.getEntityId(uriInfo, realm);
            String nameIDPolicyFormat = ((CieIdIdentityProviderConfig)this.getConfig()).getNameIDPolicyFormat();
            LinkedList signingKeys = new LinkedList();
            LinkedList encryptionKeys = new LinkedList();
            this.session.keys().getKeysStream(realm, KeyUse.SIG, "RS256").filter(Objects::nonNull).filter(key -> key.getCertificate() != null).sorted(SamlService::compareKeys).forEach(key -> {
                try {
                    Element element = SPMetadataDescriptor.buildKeyInfoElement((String)key.getKid(), (String)PemUtils.encodeCertificate((Certificate)key.getCertificate()));
                    signingKeys.add(SPMetadataDescriptor.buildKeyDescriptorType((Element)element, (KeyTypes)KeyTypes.SIGNING, (String)"RS256"));
                    if (key.getStatus() == KeyStatus.ACTIVE) {
                        encryptionKeys.add(SPMetadataDescriptor.buildKeyDescriptorType((Element)element, (KeyTypes)KeyTypes.ENCRYPTION, (String)"RS256"));
                    }
                }
                catch (ParserConfigurationException e) {
                    logger.warn((Object)"Failed to export SAML SP Metadata!", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
            StringWriter sw = new StringWriter();
            XMLStreamWriter writer = StaxUtil.getXMLStreamWriter((Writer)sw);
            SAMLMetadataWriter metadataWriter = new SAMLMetadataWriter(writer);
            EntityDescriptorType entityDescriptor = SPMetadataDescriptor.buildSPDescriptor((URI)authnBinding, (URI)authnBinding, (URI)endpoint, (URI)endpoint, (boolean)wantAuthnRequestsSigned, (boolean)wantAssertionsSigned, (boolean)wantAssertionsEncrypted, (String)entityId, (String)nameIDPolicyFormat, signingKeys, encryptionKeys);
            ArrayList metadataAttrProviders = new ArrayList();
            realm.getIdentityProviderMappersByAliasStream(((CieIdIdentityProviderConfig)this.getConfig()).getAlias()).forEach(mapper -> {
                IdentityProviderMapper target = (IdentityProviderMapper)this.session.getKeycloakSessionFactory().getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                if (target instanceof SamlMetadataDescriptorUpdater) {
                    metadataAttrProviders.add(new AbstractMap.SimpleEntry<IdentityProviderMapperModel, SamlMetadataDescriptorUpdater>((IdentityProviderMapperModel)mapper, (SamlMetadataDescriptorUpdater)target));
                }
            });
            if (!metadataAttrProviders.isEmpty()) {
                int attributeConsumingServiceIndex = ((CieIdIdentityProviderConfig)this.getConfig()).getAttributeConsumingServiceIndex() != null ? ((CieIdIdentityProviderConfig)this.getConfig()).getAttributeConsumingServiceIndex() : 1;
                String attributeConsumingServiceName = ((CieIdIdentityProviderConfig)this.getConfig()).getAttributeConsumingServiceName();
                if (attributeConsumingServiceName == null) {
                    attributeConsumingServiceName = realm.getDisplayName() != null ? realm.getDisplayName() : realm.getName();
                }
                AttributeConsumingServiceType attributeConsumingService = new AttributeConsumingServiceType(attributeConsumingServiceIndex);
                attributeConsumingService.setIsDefault(Boolean.valueOf(true));
                String currentLocale = realm.getDefaultLocale() == null ? "en" : realm.getDefaultLocale();
                LocalizedNameType attributeConsumingServiceNameElement = new LocalizedNameType(currentLocale);
                attributeConsumingServiceNameElement.setValue(attributeConsumingServiceName);
                attributeConsumingService.addServiceName(attributeConsumingServiceNameElement);
                for (EntityDescriptorType.EDTChoiceType choiceType : entityDescriptor.getChoiceType()) {
                    List descriptors = choiceType.getDescriptors();
                    for (EntityDescriptorType.EDTDescriptorChoiceType descriptor : descriptors) {
                        descriptor.getSpDescriptor().addAttributeConsumerService(attributeConsumingService);
                    }
                }
                metadataAttrProviders.forEach(mapper -> {
                    SamlMetadataDescriptorUpdater metadataAttrProvider = (SamlMetadataDescriptorUpdater)mapper.getValue();
                    metadataAttrProvider.updateMetadata((IdentityProviderMapperModel)mapper.getKey(), entityDescriptor);
                });
            }
            metadataWriter.writeEntityDescriptor(entityDescriptor);
            String descriptor = sw.toString();
            if (((CieIdIdentityProviderConfig)this.getConfig()).isSignSpMetadata()) {
                KeyManager.ActiveRsaKey activeKey = this.session.keys().getActiveRsaKey(realm);
                String keyName = ((CieIdIdentityProviderConfig)this.getConfig()).getXmlSigKeyInfoKeyNameTransformer().getKeyName(activeKey.getKid(), activeKey.getCertificate());
                KeyPair keyPair = new KeyPair(activeKey.getPublicKey(), activeKey.getPrivateKey());
                Document metadataDocument = DocumentUtil.getDocument((String)descriptor);
                SAML2Signature signatureHelper = new SAML2Signature();
                signatureHelper.setSignatureMethod(this.getSignatureAlgorithm().getXmlSignatureMethod());
                signatureHelper.setDigestMethod(this.getSignatureAlgorithm().getXmlSignatureDigestMethod());
                Node nextSibling = metadataDocument.getDocumentElement().getFirstChild();
                signatureHelper.setNextSibling(nextSibling);
                signatureHelper.signSAMLDocument(metadataDocument, keyName, keyPair, "http://www.w3.org/2001/10/xml-exc-c14n#");
                descriptor = DocumentUtil.getDocumentAsString((Document)metadataDocument);
            }
            return Response.ok((Object)descriptor, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to export SAML SP Metadata!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        SignatureAlgorithm algorithm;
        String alg = ((CieIdIdentityProviderConfig)this.getConfig()).getSignatureAlgorithm();
        if (alg != null && (algorithm = SignatureAlgorithm.valueOf((String)alg)) != null) {
            return algorithm;
        }
        return SignatureAlgorithm.RSA_SHA256;
    }

    public IdentityProviderDataMarshaller getMarshaller() {
        return new SAMLDataMarshaller();
    }
}

