/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.cie.metadata;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamWriter;
import net.optionfactory.keycloak.cie.CieIdIdentityProvider;
import net.optionfactory.keycloak.cie.CieIdIdentityProviderConfig;
import net.optionfactory.keycloak.cie.CieIdIdentityProviderFactory;
import org.jboss.logging.Logger;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.common.util.PemUtils;
import org.keycloak.crypto.KeyStatus;
import org.keycloak.crypto.KeyUse;
import org.keycloak.dom.saml.v2.metadata.AttributeConsumingServiceType;
import org.keycloak.dom.saml.v2.metadata.ContactType;
import org.keycloak.dom.saml.v2.metadata.ContactTypeType;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.ExtensionsType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.LocalizedNameType;
import org.keycloak.dom.saml.v2.metadata.LocalizedURIType;
import org.keycloak.dom.saml.v2.metadata.OrganizationType;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.protocol.saml.mappers.SamlMetadataDescriptorUpdater;
import org.keycloak.saml.SPMetadataDescriptor;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.saml.processing.api.saml.v2.sig.SAML2Signature;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLMetadataWriter;
import org.keycloak.services.resource.RealmResourceProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CieIdSpMetadataResourceProvider
implements RealmResourceProvider {
    protected static final Logger logger = Logger.getLogger(CieIdSpMetadataResourceProvider.class);
    public static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String CIEID_METADATA_EXTENSIONS_NS = "https://www.cartaidentita.interno.gov.it/saml-extensions";
    private KeycloakSession session;

    public CieIdSpMetadataResourceProvider(KeycloakSession session) {
        this.session = session;
    }

    public Object getResource() {
        return this;
    }

    @GET
    @Produces(value={"text/xml; charset=utf-8"})
    public Response get() {
        try {
            RealmModel realm = this.session.getContext().getRealm();
            List lstCieIdIdentityProviders = realm.getIdentityProvidersStream().filter(t -> t.getProviderId().equals("cieid") && t.isEnabled()).sorted((o1, o2) -> o1.getAlias().compareTo(o2.getAlias())).collect(Collectors.toList());
            if (lstCieIdIdentityProviders.size() == 0) {
                throw new Exception("No CIE ID providers found!");
            }
            CieIdIdentityProviderFactory providerFactory = new CieIdIdentityProviderFactory();
            CieIdIdentityProvider firstCieIdProvider = providerFactory.create(this.session, (IdentityProviderModel)lstCieIdIdentityProviders.get(0));
            KeycloakUriInfo uriInfo = this.session.getContext().getUri();
            URI authnBinding = JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri();
            if (((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).isPostBindingAuthnRequest()) {
                authnBinding = JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.getUri();
            }
            URI endpoint = uriInfo.getBaseUriBuilder().path("realms").path(realm.getName()).path("broker").path(((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getAlias()).path("endpoint").build(new Object[0]);
            boolean wantAuthnRequestsSigned = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).isWantAuthnRequestsSigned();
            boolean wantAssertionsSigned = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).isWantAssertionsSigned();
            boolean wantAssertionsEncrypted = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).isWantAssertionsEncrypted();
            String configEntityId = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getEntityId();
            String entityId = this.getEntityId(configEntityId, (UriInfo)uriInfo, realm);
            String nameIDPolicyFormat = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getNameIDPolicyFormat();
            int attributeConsumingServiceIndex = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getAttributeConsumingServiceIndex() != null ? ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getAttributeConsumingServiceIndex() : 1;
            String attributeConsumingServiceName = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getAttributeConsumingServiceName();
            String[] attributeConsumingServiceNames = attributeConsumingServiceName != null ? attributeConsumingServiceName.split(",") : null;
            LinkedList signingKeys = new LinkedList();
            LinkedList encryptionKeys = new LinkedList();
            this.session.keys().getKeysStream(realm, KeyUse.SIG, "RS256").filter(Objects::nonNull).filter(key -> key.getCertificate() != null).sorted(SamlService::compareKeys).forEach(key -> {
                try {
                    Element element = SPMetadataDescriptor.buildKeyInfoElement((String)key.getKid(), (String)PemUtils.encodeCertificate((Certificate)key.getCertificate()));
                    signingKeys.add(element);
                    if (key.getStatus() == KeyStatus.ACTIVE) {
                        encryptionKeys.add(element);
                    }
                }
                catch (ParserConfigurationException e) {
                    logger.warn((Object)"Failed to export SAML SP Metadata!", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
            StringWriter sw = new StringWriter();
            XMLStreamWriter writer = StaxUtil.getXMLStreamWriter((Writer)sw);
            SAMLMetadataWriter metadataWriter = new SAMLMetadataWriter(writer);
            EntityDescriptorType entityDescriptor = SPMetadataDescriptor.buildSPdescriptor((URI)authnBinding, (URI)authnBinding, (URI)endpoint, (URI)endpoint, (boolean)wantAuthnRequestsSigned, (boolean)wantAssertionsSigned, (boolean)wantAssertionsEncrypted, (String)entityId, (String)nameIDPolicyFormat, signingKeys, encryptionKeys);
            AttributeConsumingServiceType attributeConsumingService = new AttributeConsumingServiceType(attributeConsumingServiceIndex);
            attributeConsumingService.setIsDefault(Boolean.valueOf(true));
            if (attributeConsumingServiceNames != null && attributeConsumingServiceNames.length > 0) {
                for (String attributeConsumingServiceNameStr : attributeConsumingServiceNames) {
                    String currentLocale = realm.getDefaultLocale() == null ? "en" : realm.getDefaultLocale();
                    String[] parsedName = attributeConsumingServiceNameStr.split("\\|", 2);
                    String serviceNameLocale = parsedName.length >= 2 ? parsedName[0] : currentLocale;
                    LocalizedNameType attributeConsumingServiceNameElement = new LocalizedNameType(serviceNameLocale);
                    attributeConsumingServiceNameElement.setValue((String)(parsedName.length >= 2 ? parsedName[1] : attributeConsumingServiceNameStr));
                    attributeConsumingService.addServiceName(attributeConsumingServiceNameElement);
                }
            }
            for (EntityDescriptorType.EDTChoiceType choiceType : entityDescriptor.getChoiceType()) {
                List descriptors = choiceType.getDescriptors();
                if (descriptors == null) continue;
                for (EntityDescriptorType.EDTDescriptorChoiceType descriptor : descriptors) {
                    if (descriptor.getSpDescriptor() == null) continue;
                    descriptor.getSpDescriptor().addAttributeConsumerService(attributeConsumingService);
                }
            }
            realm.getIdentityProviderMappersByAliasStream(((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getAlias()).forEach(mapper -> {
                IdentityProviderMapper target = (IdentityProviderMapper)this.session.getKeycloakSessionFactory().getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                if (target instanceof SamlMetadataDescriptorUpdater) {
                    SamlMetadataDescriptorUpdater metadataAttrProvider = (SamlMetadataDescriptorUpdater)target;
                    metadataAttrProvider.updateMetadata(mapper, entityDescriptor);
                }
            });
            String strOrganizationNames = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getOrganizationNames();
            String[] organizationNames = strOrganizationNames != null ? strOrganizationNames.split(",") : null;
            String strOrganizationDisplayNames = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getOrganizationDisplayNames();
            String[] organizationDisplayNames = strOrganizationDisplayNames != null ? strOrganizationDisplayNames.split(",") : null;
            String strOrganizationUrls = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getOrganizationUrls();
            String[] organizationUrls = strOrganizationUrls != null ? strOrganizationUrls.split(",") : null;
            boolean isSpPrivate = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).isSpPrivate();
            String ipaCode = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getIpaCode();
            String ipaCategory = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getIpaCategory();
            String administrativeContactCompany = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getAdministrativeContactCompany();
            String administrativeContactVatNumber = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getAdministrativeContactVatNumber();
            String administrativeContactFiscalCode = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getAdministrativeContactFiscalCode();
            String administrativeContactEmail = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getAdministrativeContactEmail();
            String administrativeContactPhone = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getAdministrativeContactPhone();
            String strAdministrativeContactNace2Codes = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getAdministrativeContactNace2Codes();
            String[] administrativeContactNace2Codes = strAdministrativeContactNace2Codes != null ? strAdministrativeContactNace2Codes.split(",") : null;
            String administrativeContactMunicipality = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getAdministrativeContactMunicipality();
            String administrativeContactProvince = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getAdministrativeContactProvince();
            String administrativeContactCountry = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getAdministrativeContactCountry();
            String technicalContactCompany = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getTechnicalContactCompany();
            String technicalContactVatNumber = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getTechnicalContactVatNumber();
            String technicalContactFiscalCode = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getTechnicalContactFiscalCode();
            String technicalContactEmail = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getTechnicalContactEmail();
            String technicalContactPhone = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getTechnicalContactPhone();
            String strTechnicalContactNace2Codes = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getTechnicalContactNace2Codes();
            String[] technicalContactNace2Codes = strTechnicalContactNace2Codes != null ? strTechnicalContactNace2Codes.split(",") : null;
            String technicalContactMunicipality = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getTechnicalContactMunicipality();
            String technicalContactProvince = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getTechnicalContactProvince();
            String technicalContactCountry = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getTechnicalContactCountry();
            CieIdSpMetadataResourceProvider.customizeEntityDescriptor(entityDescriptor, organizationNames, organizationDisplayNames, organizationUrls, isSpPrivate, ipaCode, ipaCategory, administrativeContactCompany, administrativeContactVatNumber, administrativeContactFiscalCode, administrativeContactEmail, administrativeContactPhone, administrativeContactNace2Codes, administrativeContactMunicipality, administrativeContactProvince, administrativeContactCountry, technicalContactCompany, technicalContactVatNumber, technicalContactFiscalCode, technicalContactEmail, technicalContactPhone, technicalContactNace2Codes, technicalContactMunicipality, technicalContactProvince, technicalContactCountry);
            List<URI> assertionEndpoints = lstCieIdIdentityProviders.stream().map(arg_0 -> CieIdSpMetadataResourceProvider.lambda$get$5((UriInfo)uriInfo, realm, arg_0)).collect(Collectors.toList());
            List<URI> logoutEndpoints = lstCieIdIdentityProviders.stream().map(arg_0 -> CieIdSpMetadataResourceProvider.lambda$get$6((UriInfo)uriInfo, realm, arg_0)).collect(Collectors.toList());
            for (EntityDescriptorType.EDTChoiceType choiceType : entityDescriptor.getChoiceType()) {
                List descriptors = choiceType.getDescriptors();
                if (descriptors == null) continue;
                for (EntityDescriptorType.EDTDescriptorChoiceType descriptor : descriptors) {
                    SPSSODescriptorType spDescriptor = descriptor.getSpDescriptor();
                    if (spDescriptor == null) continue;
                    CieIdSpMetadataResourceProvider.customizeSpDescriptor(spDescriptor, authnBinding, authnBinding, assertionEndpoints, logoutEndpoints);
                }
            }
            metadataWriter.writeEntityDescriptor(entityDescriptor);
            String descriptor = sw.toString();
            if (((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).isSignSpMetadata()) {
                KeyManager.ActiveRsaKey activeKey = this.session.keys().getActiveRsaKey(realm);
                String keyName = ((CieIdIdentityProviderConfig)firstCieIdProvider.getConfig()).getXmlSigKeyInfoKeyNameTransformer().getKeyName(activeKey.getKid(), activeKey.getCertificate());
                KeyPair keyPair = new KeyPair(activeKey.getPublicKey(), activeKey.getPrivateKey());
                Document metadataDocument = DocumentUtil.getDocument((String)descriptor);
                SAML2Signature signatureHelper = new SAML2Signature();
                signatureHelper.setSignatureMethod(firstCieIdProvider.getSignatureAlgorithm().getXmlSignatureMethod());
                signatureHelper.setDigestMethod(firstCieIdProvider.getSignatureAlgorithm().getXmlSignatureDigestMethod());
                Node nextSibling = metadataDocument.getDocumentElement().getFirstChild();
                signatureHelper.setNextSibling(nextSibling);
                signatureHelper.signSAMLDocument(metadataDocument, keyName, keyPair, "http://www.w3.org/2001/10/xml-exc-c14n#");
                descriptor = DocumentUtil.getDocumentAsString((Document)metadataDocument);
            }
            return Response.ok((Object)descriptor, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to export SAML SP Metadata!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String getEntityId(String configEntityId, UriInfo uriInfo, RealmModel realm) {
        if (configEntityId == null || configEntityId.isEmpty()) {
            return UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("realms").path(realm.getName()).build(new Object[0]).toString();
        }
        return configEntityId;
    }

    private static void customizeEntityDescriptor(EntityDescriptorType entityDescriptor, String[] organizationNames, String[] organizationDisplayNames, String[] organizationUrls, boolean isSpPrivate, String ipaCode, String ipaCategory, String administrativeContactCompany, String administrativeContactVatNumber, String administrativeContactFiscalCode, String administrativeContactEmail, String administrativeContactPhone, String[] administrativeContactNace2Codes, String administrativeContactMunicipality, String administrativeContactProvince, String administrativeContactCountry, String technicalContactCompany, String technicalContactVatNumber, String technicalContactFiscalCode, String technicalContactEmail, String technicalContactPhone, String[] technicalContactNace2Codes, String technicalContactMunicipality, String technicalContactProvince, String technicalContactCountry) throws ConfigurationException {
        if (organizationNames != null && organizationNames.length > 0 || organizationDisplayNames != null && organizationDisplayNames.length > 0 || organizationUrls != null && organizationUrls.length > 0) {
            Element naceCodeElement;
            OrganizationType organizationType = new OrganizationType();
            if (organizationNames != null) {
                for (String organizationNameStr : organizationNames) {
                    String[] parsedName = organizationNameStr.split("\\|", 2);
                    if (parsedName.length < 2) continue;
                    LocalizedNameType organizationName = new LocalizedNameType(parsedName[0].trim());
                    organizationName.setValue(parsedName[1].trim());
                    organizationType.addOrganizationName(organizationName);
                }
            }
            if (organizationDisplayNames != null) {
                for (String organizationDisplayNameStr : organizationDisplayNames) {
                    String[] parsedDisplayName = organizationDisplayNameStr.split("\\|", 2);
                    if (parsedDisplayName.length < 2) continue;
                    LocalizedNameType organizationDisplayName = new LocalizedNameType(parsedDisplayName[0].trim());
                    organizationDisplayName.setValue(parsedDisplayName[1].trim());
                    organizationType.addOrganizationDisplayName(organizationDisplayName);
                }
            }
            if (organizationUrls != null) {
                for (String organizationUrlStr : organizationUrls) {
                    String[] parsedUrl = organizationUrlStr.split("\\|", 2);
                    if (parsedUrl.length < 2) continue;
                    LocalizedURIType organizationUrl = new LocalizedURIType(parsedUrl[0].trim());
                    try {
                        organizationUrl.setValue(new URI(parsedUrl[1].trim()));
                    }
                    catch (URISyntaxException e) {
                        logger.error((Object)"Error creating URI for Organization URL");
                        continue;
                    }
                    organizationType.addOrganizationURL(organizationUrl);
                }
            }
            if (!(StringUtil.isNullOrEmpty((String)administrativeContactCompany) && StringUtil.isNullOrEmpty((String)administrativeContactEmail) && StringUtil.isNullOrEmpty((String)administrativeContactPhone))) {
                Element spTypeElement;
                ContactType administrativeContactPerson = new ContactType(ContactTypeType.ADMINISTRATIVE);
                if (!StringUtil.isNullOrEmpty((String)administrativeContactCompany)) {
                    administrativeContactPerson.setCompany(administrativeContactCompany);
                }
                if (!StringUtil.isNullOrEmpty((String)administrativeContactEmail)) {
                    administrativeContactPerson.addEmailAddress(administrativeContactEmail);
                }
                if (!StringUtil.isNullOrEmpty((String)administrativeContactPhone)) {
                    administrativeContactPerson.addTelephone(administrativeContactPhone);
                }
                if (administrativeContactPerson.getExtensions() == null) {
                    administrativeContactPerson.setExtensions(new ExtensionsType());
                }
                Document doc = DocumentUtil.createDocument();
                if (!isSpPrivate) {
                    spTypeElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:Public");
                    spTypeElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                    administrativeContactPerson.getExtensions().addExtension((Object)spTypeElement);
                    if (!StringUtil.isNullOrEmpty((String)ipaCode)) {
                        Element ipaCodeElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:IPACode");
                        ipaCodeElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                        ipaCodeElement.setTextContent(ipaCode);
                        administrativeContactPerson.getExtensions().addExtension((Object)ipaCodeElement);
                    }
                    if (!StringUtil.isNullOrEmpty((String)ipaCategory)) {
                        Element ipaCategoryElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:IPACategory");
                        ipaCategoryElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                        ipaCategoryElement.setTextContent(ipaCategory);
                        administrativeContactPerson.getExtensions().addExtension((Object)ipaCategoryElement);
                    }
                } else {
                    spTypeElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:Private");
                    spTypeElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                    administrativeContactPerson.getExtensions().addExtension((Object)spTypeElement);
                }
                if (!StringUtil.isNullOrEmpty((String)administrativeContactVatNumber)) {
                    Element vatNumberElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:VATNumber");
                    vatNumberElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                    vatNumberElement.setTextContent(administrativeContactVatNumber);
                    administrativeContactPerson.getExtensions().addExtension((Object)vatNumberElement);
                }
                if (!StringUtil.isNullOrEmpty((String)administrativeContactFiscalCode)) {
                    String[] fiscalCodeElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:FiscalCode");
                    fiscalCodeElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                    fiscalCodeElement.setTextContent(administrativeContactFiscalCode);
                    administrativeContactPerson.getExtensions().addExtension((Object)fiscalCodeElement);
                }
                if (administrativeContactNace2Codes != null && administrativeContactNace2Codes.length > 0) {
                    for (String naceCode : administrativeContactNace2Codes) {
                        naceCodeElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:NACE2Code");
                        naceCodeElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                        naceCodeElement.setTextContent(naceCode);
                        administrativeContactPerson.getExtensions().addExtension((Object)naceCodeElement);
                    }
                }
                if (!StringUtil.isNullOrEmpty((String)administrativeContactMunicipality)) {
                    Element municipalityElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:Municipality");
                    municipalityElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                    municipalityElement.setTextContent(administrativeContactMunicipality);
                    administrativeContactPerson.getExtensions().addExtension((Object)municipalityElement);
                }
                if (!StringUtil.isNullOrEmpty((String)administrativeContactProvince)) {
                    Element provinceElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:Province");
                    provinceElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                    provinceElement.setTextContent(administrativeContactProvince);
                    administrativeContactPerson.getExtensions().addExtension((Object)provinceElement);
                }
                if (!StringUtil.isNullOrEmpty((String)administrativeContactCountry)) {
                    Element countryElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:Country");
                    countryElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                    countryElement.setTextContent(administrativeContactCountry);
                    administrativeContactPerson.getExtensions().addExtension((Object)countryElement);
                }
                entityDescriptor.addContactPerson(administrativeContactPerson);
            }
            if (!(StringUtil.isNullOrEmpty((String)technicalContactCompany) && StringUtil.isNullOrEmpty((String)technicalContactEmail) && StringUtil.isNullOrEmpty((String)technicalContactPhone))) {
                ContactType technicalContactPerson = new ContactType(ContactTypeType.TECHNICAL);
                if (!StringUtil.isNullOrEmpty((String)technicalContactCompany)) {
                    technicalContactPerson.setCompany(technicalContactCompany);
                }
                if (!StringUtil.isNullOrEmpty((String)technicalContactEmail)) {
                    technicalContactPerson.addEmailAddress(technicalContactEmail);
                }
                if (!StringUtil.isNullOrEmpty((String)technicalContactPhone)) {
                    technicalContactPerson.addTelephone(technicalContactPhone);
                }
                if (technicalContactPerson.getExtensions() == null) {
                    technicalContactPerson.setExtensions(new ExtensionsType());
                }
                Document doc = DocumentUtil.createDocument();
                if (!StringUtil.isNullOrEmpty((String)technicalContactVatNumber)) {
                    Element vatNumberElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:VATNumber");
                    vatNumberElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                    vatNumberElement.setTextContent(technicalContactVatNumber);
                    technicalContactPerson.getExtensions().addExtension((Object)vatNumberElement);
                }
                if (!StringUtil.isNullOrEmpty((String)technicalContactFiscalCode)) {
                    Element fiscalCodeElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:FiscalCode");
                    fiscalCodeElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                    fiscalCodeElement.setTextContent(technicalContactFiscalCode);
                    technicalContactPerson.getExtensions().addExtension((Object)fiscalCodeElement);
                }
                if (technicalContactNace2Codes != null && technicalContactNace2Codes.length > 0) {
                    for (String naceCode : technicalContactNace2Codes) {
                        naceCodeElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:NACE2Code");
                        naceCodeElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                        naceCodeElement.setTextContent(naceCode);
                        technicalContactPerson.getExtensions().addExtension((Object)naceCodeElement);
                    }
                }
                if (!StringUtil.isNullOrEmpty((String)technicalContactMunicipality)) {
                    Element municipalityElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:Municipality");
                    municipalityElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                    municipalityElement.setTextContent(technicalContactMunicipality);
                    technicalContactPerson.getExtensions().addExtension((Object)municipalityElement);
                }
                if (!StringUtil.isNullOrEmpty((String)technicalContactProvince)) {
                    Element provinceElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:Province");
                    provinceElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                    provinceElement.setTextContent(technicalContactProvince);
                    technicalContactPerson.getExtensions().addExtension((Object)provinceElement);
                }
                if (!StringUtil.isNullOrEmpty((String)technicalContactCountry)) {
                    Element countryElement = doc.createElementNS(CIEID_METADATA_EXTENSIONS_NS, "cie:Country");
                    countryElement.setAttributeNS(XMLNS_NS, "xmlns:cie", CIEID_METADATA_EXTENSIONS_NS);
                    countryElement.setTextContent(technicalContactCountry);
                    technicalContactPerson.getExtensions().addExtension((Object)countryElement);
                }
                entityDescriptor.addContactPerson(technicalContactPerson);
            }
            entityDescriptor.setOrganization(organizationType);
        }
    }

    private static void customizeSpDescriptor(SPSSODescriptorType spDescriptor, URI loginBinding, URI logoutBinding, List<URI> assertionEndpoints, List<URI> logoutEndpoints) {
        List lstSingleLogoutService = spDescriptor.getSingleLogoutService();
        for (int i = lstSingleLogoutService.size() - 1; i >= 0; --i) {
            spDescriptor.removeSingleLogoutService((EndpointType)lstSingleLogoutService.get(i));
        }
        for (URI logoutEndpoint : logoutEndpoints) {
            spDescriptor.addSingleLogoutService(new EndpointType(logoutBinding, logoutEndpoint));
        }
        List lstAssertionConsumerService = spDescriptor.getAssertionConsumerService();
        for (int i = lstAssertionConsumerService.size() - 1; i >= 0; --i) {
            spDescriptor.removeAssertionConsumerService((IndexedEndpointType)lstAssertionConsumerService.get(i));
        }
        int assertionEndpointIndex = 0;
        for (URI assertionEndpoint : assertionEndpoints) {
            IndexedEndpointType assertionConsumerEndpoint = new IndexedEndpointType(loginBinding, assertionEndpoint);
            if (assertionEndpointIndex == 0) {
                assertionConsumerEndpoint.setIsDefault(Boolean.valueOf(true));
            }
            assertionConsumerEndpoint.setIndex(assertionEndpointIndex);
            spDescriptor.addAssertionConsumerService(assertionConsumerEndpoint);
            ++assertionEndpointIndex;
        }
    }

    public void close() {
    }

    private static /* synthetic */ URI lambda$get$6(UriInfo uriInfo, RealmModel realm, IdentityProviderModel t) {
        return uriInfo.getBaseUriBuilder().path("realms").path(realm.getName()).path("broker").path(t.getAlias()).path("endpoint").build(new Object[0]);
    }

    private static /* synthetic */ URI lambda$get$5(UriInfo uriInfo, RealmModel realm, IdentityProviderModel t) {
        return uriInfo.getBaseUriBuilder().path("realms").path(realm.getName()).path("broker").path(t.getAlias()).path("endpoint").build(new Object[0]);
    }
}

