/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.cie;

import java.io.IOException;
import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.namespace.QName;
import net.optionfactory.keycloak.cie.CieIdIdentityProvider;
import net.optionfactory.keycloak.cie.CieIdIdentityProviderConfig;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.dom.saml.common.CommonConditionsType;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationDataType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.saml.JaxrsSAML2BindingBuilder;
import org.keycloak.protocol.saml.SamlPrincipalType;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.protocol.saml.SamlSessionUtils;
import org.keycloak.protocol.saml.preprocessor.SamlAuthenticationPreprocessor;
import org.keycloak.rotation.HardcodedKeyLocator;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.SAML2LogoutResponseBuilder;
import org.keycloak.saml.SAMLRequestParser;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.constants.X500SAMLProfileConstants;
import org.keycloak.saml.processing.core.saml.v2.util.AssertionUtil;
import org.keycloak.saml.processing.core.util.KeycloakKeySamlExtensionGenerator;
import org.keycloak.saml.processing.core.util.XMLSignatureUtil;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.keycloak.saml.validators.ConditionsValidator;
import org.keycloak.saml.validators.DestinationValidator;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CieIdSAMLEndpoint {
    protected static final Logger logger = Logger.getLogger(CieIdSAMLEndpoint.class);
    public static final String SAML_FEDERATED_SESSION_INDEX = "SAML_FEDERATED_SESSION_INDEX";
    public static final String SAML_FEDERATED_SUBJECT_NAMEID = "SAML_FEDERATED_SUBJECT_NAME_ID";
    public static final String SAML_LOGIN_RESPONSE = "SAML_LOGIN_RESPONSE";
    public static final String SAML_ASSERTION = "SAML_ASSERTION";
    public static final String SAML_AUTHN_STATEMENT = "SAML_AUTHN_STATEMENT";
    protected RealmModel realm;
    protected EventBuilder event;
    protected CieIdIdentityProviderConfig config;
    protected IdentityProvider.AuthenticationCallback callback;
    protected CieIdIdentityProvider provider;
    private final DestinationValidator destinationValidator;
    @Context
    private KeycloakSession session;
    @Context
    private ClientConnection clientConnection;
    @Context
    private HttpHeaders headers;

    public CieIdSAMLEndpoint(RealmModel realm, CieIdIdentityProvider provider, CieIdIdentityProviderConfig config, IdentityProvider.AuthenticationCallback callback, DestinationValidator destinationValidator) {
        this.realm = realm;
        this.config = config;
        this.callback = callback;
        this.provider = provider;
        this.destinationValidator = destinationValidator;
    }

    @GET
    @NoCache
    @Path(value="descriptor")
    public Response getSPDescriptor() {
        return this.provider.export((UriInfo)this.session.getContext().getUri(), this.realm, null);
    }

    @GET
    public Response redirectBinding(@QueryParam(value="SAMLRequest") String samlRequest, @QueryParam(value="SAMLResponse") String samlResponse, @QueryParam(value="RelayState") String relayState) {
        return new RedirectBinding().execute(samlRequest, samlResponse, relayState, null);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postBinding(@FormParam(value="SAMLRequest") String samlRequest, @FormParam(value="SAMLResponse") String samlResponse, @FormParam(value="RelayState") String relayState) {
        return new PostBinding().execute(samlRequest, samlResponse, relayState, null);
    }

    @Path(value="clients/{client_id}")
    @GET
    public Response redirectBinding(@QueryParam(value="SAMLRequest") String samlRequest, @QueryParam(value="SAMLResponse") String samlResponse, @QueryParam(value="RelayState") String relayState, @PathParam(value="client_id") String clientId) {
        return new RedirectBinding().execute(samlRequest, samlResponse, relayState, clientId);
    }

    @Path(value="clients/{client_id}")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postBinding(@FormParam(value="SAMLRequest") String samlRequest, @FormParam(value="SAMLResponse") String samlResponse, @FormParam(value="RelayState") String relayState, @PathParam(value="client_id") String clientId) {
        return new PostBinding().execute(samlRequest, samlResponse, relayState, clientId);
    }

    private String getX500Attribute(AssertionType assertion, X500SAMLProfileConstants attribute) {
        return this.getFirstMatchingAttribute(assertion, arg_0 -> ((X500SAMLProfileConstants)attribute).correspondsTo(arg_0));
    }

    private String getAttributeByName(AssertionType assertion, String name) {
        return this.getFirstMatchingAttribute(assertion, attribute -> Objects.equals(attribute.getName(), name));
    }

    private String getAttributeByFriendlyName(AssertionType assertion, String friendlyName) {
        return this.getFirstMatchingAttribute(assertion, attribute -> Objects.equals(attribute.getFriendlyName(), friendlyName));
    }

    private String getPrincipal(AssertionType assertion) {
        SamlPrincipalType principalType = this.config.getPrincipalType();
        if (principalType == null || principalType.equals((Object)SamlPrincipalType.SUBJECT)) {
            NameIDType subjectNameID = this.getSubjectNameID(assertion);
            return subjectNameID != null ? subjectNameID.getValue() : null;
        }
        if (principalType.equals((Object)SamlPrincipalType.ATTRIBUTE)) {
            return this.getAttributeByName(assertion, this.config.getPrincipalAttribute());
        }
        return this.getAttributeByFriendlyName(assertion, this.config.getPrincipalAttribute());
    }

    private String getFirstMatchingAttribute(AssertionType assertion, Predicate<AttributeType> predicate) {
        return assertion.getAttributeStatements().stream().map(AttributeStatementType::getAttributes).flatMap(Collection::stream).map(AttributeStatementType.ASTChoiceType::getAttribute).filter(predicate).map(AttributeType::getAttributeValue).flatMap(Collection::stream).findFirst().map(Object::toString).orElse(null);
    }

    private String expectedPrincipalType() {
        SamlPrincipalType principalType = this.config.getPrincipalType();
        switch (principalType) {
            case SUBJECT: {
                return principalType.name();
            }
            case ATTRIBUTE: 
            case FRIENDLY_ATTRIBUTE: {
                return String.format("%s(%s)", principalType.name(), this.config.getPrincipalAttribute());
            }
        }
        return null;
    }

    private NameIDType getSubjectNameID(AssertionType assertion) {
        SubjectType subject = assertion.getSubject();
        SubjectType.STSubType subType = subject.getSubType();
        return subType != null ? (NameIDType)subType.getBaseID() : null;
    }

    private boolean validateInResponseToAttribute(ResponseType responseType, String expectedRequestId) {
        SubjectConfirmationDataType subjectConfirmationDataElement;
        SubjectConfirmationType subjectConfirmationElement;
        if (expectedRequestId == null || expectedRequestId.isEmpty()) {
            return true;
        }
        if (responseType.getInResponseTo() == null) {
            logger.error((Object)"Response Validation Error: InResponseTo attribute was expected but not present in received response");
            return false;
        }
        String responseInResponseToValue = responseType.getInResponseTo();
        if (responseInResponseToValue.isEmpty()) {
            logger.error((Object)"Response Validation Error: InResponseTo attribute was expected but it is empty in received response");
            return false;
        }
        if (!responseInResponseToValue.equals(expectedRequestId)) {
            logger.error((Object)"Response Validation Error: received InResponseTo attribute does not match the expected request ID");
            return false;
        }
        if (responseType.getAssertions().isEmpty()) {
            return true;
        }
        SubjectType subjectElement = ((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getAssertion().getSubject();
        if (subjectElement != null && subjectElement.getConfirmation() != null && !subjectElement.getConfirmation().isEmpty() && (subjectConfirmationElement = (SubjectConfirmationType)subjectElement.getConfirmation().get(0)) != null && (subjectConfirmationDataElement = subjectConfirmationElement.getSubjectConfirmationData()) != null && subjectConfirmationDataElement.getInResponseTo() != null) {
            String subjectConfirmationDataInResponseToValue = subjectConfirmationDataElement.getInResponseTo();
            if (subjectConfirmationDataInResponseToValue.isEmpty()) {
                logger.error((Object)"Response Validation Error: SubjectConfirmationData InResponseTo attribute was expected but it is empty in received response");
                return false;
            }
            if (!subjectConfirmationDataInResponseToValue.equals(expectedRequestId)) {
                logger.error((Object)"Response Validation Error: received SubjectConfirmationData InResponseTo attribute does not match the expected request ID");
                return false;
            }
        }
        return true;
    }

    private String verifyCieIdResponse(Element documentElement, Element assertionElement, String expectedRequestId) {
        if (!documentElement.hasAttribute("InResponseTo")) {
            return "CieIdSamlCheck_nr17";
        }
        String responseInResponseToValue = documentElement.getAttribute("InResponseTo");
        if (responseInResponseToValue.isEmpty()) {
            return "CieIdSamlCheck_nr16";
        }
        if (!responseInResponseToValue.equals(expectedRequestId)) {
            return "CieIdSamlCheck_nr18";
        }
        return null;
    }

    private boolean hasNamedChild(Element element) {
        NodeList childNodes = element.getChildNodes();
        if (childNodes == null) {
            return false;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1 || node.getNodeName() == null) continue;
            return true;
        }
        return false;
    }

    protected class RedirectBinding
    extends Binding {
        protected RedirectBinding() {
        }

        @Override
        protected boolean containsUnencryptedSignature(SAMLDocumentHolder documentHolder) {
            MultivaluedMap encodedParams = CieIdSAMLEndpoint.this.session.getContext().getUri().getQueryParameters(false);
            String algorithm = (String)encodedParams.getFirst((Object)"SigAlg");
            String signature = (String)encodedParams.getFirst((Object)"Signature");
            return algorithm != null && signature != null;
        }

        @Override
        protected void verifySignature(String key, SAMLDocumentHolder documentHolder) throws VerificationException {
            KeyLocator locator = this.getIDPKeyLocator();
            SamlProtocolUtils.verifyRedirectSignature((SAMLDocumentHolder)documentHolder, (KeyLocator)locator, (UriInfo)CieIdSAMLEndpoint.this.session.getContext().getUri(), (String)key);
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestRedirectBinding((String)samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            return SAMLRequestParser.parseResponseRedirectBinding((String)response);
        }

        @Override
        protected String getBindingType() {
            return "get";
        }
    }

    protected class PostBinding
    extends Binding {
        protected PostBinding() {
        }

        @Override
        protected boolean containsUnencryptedSignature(SAMLDocumentHolder documentHolder) {
            NodeList nl = documentHolder.getSamlDocument().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            return nl != null && nl.getLength() > 0;
        }

        @Override
        protected void verifySignature(String key, SAMLDocumentHolder documentHolder) throws VerificationException {
            ResponseType responseType;
            List assertions;
            if (!this.containsUnencryptedSignature(documentHolder) && documentHolder.getSamlObject() instanceof ResponseType && !(assertions = (responseType = (ResponseType)documentHolder.getSamlObject()).getAssertions()).isEmpty()) {
                return;
            }
            SamlProtocolUtils.verifyDocumentSignature((Document)documentHolder.getSamlDocument(), (KeyLocator)this.getIDPKeyLocator());
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestPostBinding((String)samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            byte[] samlBytes = PostBindingUtil.base64Decode((String)response);
            return SAMLRequestParser.parseResponseDocument((byte[])samlBytes);
        }

        @Override
        protected String getBindingType() {
            return "post";
        }
    }

    protected abstract class Binding {
        protected Binding() {
        }

        private boolean checkSsl() {
            if (CieIdSAMLEndpoint.this.session.getContext().getUri().getBaseUri().getScheme().equals("https")) {
                return true;
            }
            return !CieIdSAMLEndpoint.this.realm.getSslRequired().isRequired(CieIdSAMLEndpoint.this.clientConnection);
        }

        protected Response basicChecks(String samlRequest, String samlResponse) {
            if (!this.checkSsl()) {
                CieIdSAMLEndpoint.this.event.event(EventType.LOGIN);
                CieIdSAMLEndpoint.this.event.error("ssl_required");
                return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"httpsRequiredMessage", (Object[])new Object[0]);
            }
            if (!CieIdSAMLEndpoint.this.realm.isEnabled()) {
                CieIdSAMLEndpoint.this.event.event(EventType.LOGIN_ERROR);
                CieIdSAMLEndpoint.this.event.error("realm_disabled");
                return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"realmNotEnabledMessage", (Object[])new Object[0]);
            }
            if (samlRequest == null && samlResponse == null) {
                CieIdSAMLEndpoint.this.event.event(EventType.LOGIN);
                CieIdSAMLEndpoint.this.event.error("invalid_request");
                return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            return null;
        }

        protected abstract String getBindingType();

        protected abstract boolean containsUnencryptedSignature(SAMLDocumentHolder var1);

        protected abstract void verifySignature(String var1, SAMLDocumentHolder var2) throws VerificationException;

        protected abstract SAMLDocumentHolder extractRequestDocument(String var1);

        protected abstract SAMLDocumentHolder extractResponseDocument(String var1);

        protected boolean isDestinationRequired() {
            return true;
        }

        protected KeyLocator getIDPKeyLocator() {
            LinkedList<PublicKey> keys = new LinkedList<PublicKey>();
            for (String signingCertificate : CieIdSAMLEndpoint.this.config.getSigningCertificates()) {
                X509Certificate cert = null;
                try {
                    cert = XMLSignatureUtil.getX509CertificateFromKeyInfoString((String)signingCertificate.replaceAll("\\s", ""));
                    cert.checkValidity();
                    keys.add(cert.getPublicKey());
                }
                catch (CertificateException e) {
                    logger.warnf("Ignoring invalid certificate: %s", (Object)cert);
                }
                catch (ProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            return new HardcodedKeyLocator(keys);
        }

        public Response execute(String samlRequest, String samlResponse, String relayState, String clientId) {
            CieIdSAMLEndpoint.this.event = new EventBuilder(CieIdSAMLEndpoint.this.realm, CieIdSAMLEndpoint.this.session, CieIdSAMLEndpoint.this.clientConnection);
            Response response = this.basicChecks(samlRequest, samlResponse);
            if (response != null) {
                return response;
            }
            if (samlRequest != null) {
                return this.handleSamlRequest(samlRequest, relayState);
            }
            return this.handleSamlResponse(samlResponse, relayState, clientId);
        }

        protected Response handleSamlRequest(String samlRequest, String relayState) {
            SAMLDocumentHolder holder = this.extractRequestDocument(samlRequest);
            RequestAbstractType requestAbstractType = (RequestAbstractType)holder.getSamlObject();
            if (this.isDestinationRequired() && requestAbstractType.getDestination() == null && this.containsUnencryptedSignature(holder)) {
                CieIdSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                CieIdSAMLEndpoint.this.event.detail("reason", "missing_required_destination");
                CieIdSAMLEndpoint.this.event.error("invalid_request");
                return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            if (!CieIdSAMLEndpoint.this.destinationValidator.validate(this.getExpectedDestination(CieIdSAMLEndpoint.this.config.getAlias(), null), requestAbstractType.getDestination())) {
                CieIdSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                CieIdSAMLEndpoint.this.event.detail("reason", "invalid_destination");
                CieIdSAMLEndpoint.this.event.error("invalid_saml_response");
                return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            if (CieIdSAMLEndpoint.this.config.isValidateSignature()) {
                try {
                    this.verifySignature("SAMLRequest", holder);
                }
                catch (VerificationException e) {
                    logger.error((Object)"validation failed", (Throwable)e);
                    CieIdSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    CieIdSAMLEndpoint.this.event.error("invalid_signature");
                    return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequesterMessage", (Object[])new Object[0]);
                }
            }
            if (requestAbstractType instanceof LogoutRequestType) {
                logger.debug((Object)"** logout request");
                CieIdSAMLEndpoint.this.event.event(EventType.LOGOUT);
                LogoutRequestType logout = (LogoutRequestType)requestAbstractType;
                return this.logoutRequest(logout, relayState);
            }
            CieIdSAMLEndpoint.this.event.event(EventType.LOGIN);
            CieIdSAMLEndpoint.this.event.error("invalid_token");
            return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequestMessage", (Object[])new Object[0]);
        }

        protected Response logoutRequest(LogoutRequestType request, String relayState) {
            String brokerUserId = CieIdSAMLEndpoint.this.config.getAlias() + "." + request.getNameID().getValue();
            if (request.getSessionIndex() == null || request.getSessionIndex().isEmpty()) {
                AtomicReference<LogoutRequestType> ref = new AtomicReference<LogoutRequestType>(request);
                CieIdSAMLEndpoint.this.session.sessions().getUserSessionByBrokerUserIdStream(CieIdSAMLEndpoint.this.realm, brokerUserId).filter(userSession -> userSession.getState() != UserSessionModel.State.LOGGING_OUT && userSession.getState() != UserSessionModel.State.LOGGED_OUT).collect(Collectors.toList()).forEach(this.processLogout(ref));
                request = (LogoutRequestType)ref.get();
            } else {
                for (String sessionIndex : request.getSessionIndex()) {
                    String brokerSessionId = CieIdSAMLEndpoint.this.config.getAlias() + "." + sessionIndex;
                    UserSessionModel userSession2 = CieIdSAMLEndpoint.this.session.sessions().getUserSessionByBrokerSessionId(CieIdSAMLEndpoint.this.realm, brokerSessionId);
                    if (userSession2 == null || userSession2.getState() == UserSessionModel.State.LOGGING_OUT || userSession2.getState() == UserSessionModel.State.LOGGED_OUT) continue;
                    Iterator it = SamlSessionUtils.getSamlAuthenticationPreprocessorIterator((KeycloakSession)CieIdSAMLEndpoint.this.session);
                    while (it.hasNext()) {
                        request = ((SamlAuthenticationPreprocessor)it.next()).beforeProcessingLogoutRequest(request, userSession2, null);
                    }
                    try {
                        AuthenticationManager.backchannelLogout((KeycloakSession)CieIdSAMLEndpoint.this.session, (RealmModel)CieIdSAMLEndpoint.this.realm, (UserSessionModel)userSession2, (UriInfo)CieIdSAMLEndpoint.this.session.getContext().getUri(), (ClientConnection)CieIdSAMLEndpoint.this.clientConnection, (HttpHeaders)CieIdSAMLEndpoint.this.headers, (boolean)false);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"failed to do backchannel logout for userSession", (Throwable)e);
                    }
                }
            }
            String issuerURL = this.getEntityId((UriInfo)CieIdSAMLEndpoint.this.session.getContext().getUri(), CieIdSAMLEndpoint.this.realm);
            SAML2LogoutResponseBuilder builder = new SAML2LogoutResponseBuilder();
            builder.logoutRequestID(request.getID());
            builder.destination(CieIdSAMLEndpoint.this.config.getSingleLogoutServiceUrl());
            builder.issuer(issuerURL);
            JaxrsSAML2BindingBuilder binding = (JaxrsSAML2BindingBuilder)new JaxrsSAML2BindingBuilder(CieIdSAMLEndpoint.this.session).relayState(relayState);
            boolean postBinding = CieIdSAMLEndpoint.this.config.isPostBindingLogout();
            if (CieIdSAMLEndpoint.this.config.isWantAuthnRequestsSigned()) {
                KeyManager.ActiveRsaKey keys = CieIdSAMLEndpoint.this.session.keys().getActiveRsaKey(CieIdSAMLEndpoint.this.realm);
                String keyName = CieIdSAMLEndpoint.this.config.getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
                ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signatureAlgorithm(CieIdSAMLEndpoint.this.provider.getSignatureAlgorithm())).signDocument();
                if (!postBinding && CieIdSAMLEndpoint.this.config.isAddExtensionsElementWithKeyInfo()) {
                    builder.addExtension((SamlProtocolExtensionsAwareBuilder.NodeGenerator)new KeycloakKeySamlExtensionGenerator(keyName));
                }
            }
            try {
                if (postBinding) {
                    return binding.postBinding(builder.buildDocument()).response(CieIdSAMLEndpoint.this.config.getSingleLogoutServiceUrl());
                }
                return binding.redirectBinding(builder.buildDocument()).response(CieIdSAMLEndpoint.this.config.getSingleLogoutServiceUrl());
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
            catch (ProcessingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private Consumer<UserSessionModel> processLogout(AtomicReference<LogoutRequestType> ref) {
            return userSession -> {
                Iterator it = SamlSessionUtils.getSamlAuthenticationPreprocessorIterator((KeycloakSession)CieIdSAMLEndpoint.this.session);
                while (it.hasNext()) {
                    ref.set(((SamlAuthenticationPreprocessor)it.next()).beforeProcessingLogoutRequest((LogoutRequestType)ref.get(), userSession, null));
                }
                try {
                    AuthenticationManager.backchannelLogout((KeycloakSession)CieIdSAMLEndpoint.this.session, (RealmModel)CieIdSAMLEndpoint.this.realm, (UserSessionModel)userSession, (UriInfo)CieIdSAMLEndpoint.this.session.getContext().getUri(), (ClientConnection)CieIdSAMLEndpoint.this.clientConnection, (HttpHeaders)CieIdSAMLEndpoint.this.headers, (boolean)false);
                }
                catch (Exception e) {
                    logger.warn((Object)"failed to do backchannel logout for userSession", (Throwable)e);
                }
            };
        }

        private String getEntityId(UriInfo uriInfo, RealmModel realm) {
            String configEntityId = CieIdSAMLEndpoint.this.config.getEntityId();
            if (configEntityId == null || configEntityId.isEmpty()) {
                return UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("realms").path(realm.getName()).build(new Object[0]).toString();
            }
            return configEntityId;
        }

        protected Response handleLoginResponse(String samlResponse, SAMLDocumentHolder holder, ResponseType responseType, String relayState, String clientId) {
            try {
                String email;
                boolean hasNoSignatureWhenRequired;
                AuthenticationSessionModel authSession = clientId != null && !clientId.trim().isEmpty() ? this.samlIdpInitiatedSSO(clientId) : CieIdSAMLEndpoint.this.callback.getAndVerifyAuthenticationSession(relayState);
                CieIdSAMLEndpoint.this.session.getContext().setAuthenticationSession(authSession);
                KeyManager.ActiveRsaKey keys = CieIdSAMLEndpoint.this.session.keys().getActiveRsaKey(CieIdSAMLEndpoint.this.realm);
                if (!this.isSuccessfulSamlResponse(responseType)) {
                    boolean isCieIdFault;
                    boolean bl = isCieIdFault = responseType.getStatus() != null && responseType.getStatus().getStatusMessage() != null && responseType.getStatus().getStatusMessage().startsWith("ErrorCode nr");
                    if (isCieIdFault) {
                        return CieIdSAMLEndpoint.this.callback.error("CieIdFault_" + responseType.getStatus().getStatusMessage().replace(' ', '_'));
                    }
                    String statusMessage = responseType.getStatus() == null || responseType.getStatus().getStatusMessage() == null ? "identityProviderUnexpectedErrorMessage" : responseType.getStatus().getStatusMessage();
                    return CieIdSAMLEndpoint.this.callback.error(statusMessage);
                }
                if (responseType.getAssertions() == null || responseType.getAssertions().isEmpty()) {
                    return CieIdSAMLEndpoint.this.callback.error("identityProviderUnexpectedErrorMessage");
                }
                boolean assertionIsEncrypted = AssertionUtil.isAssertionEncrypted((ResponseType)responseType);
                if (CieIdSAMLEndpoint.this.config.isWantAssertionsEncrypted() && !assertionIsEncrypted) {
                    logger.error((Object)"The assertion is not encrypted, which is required.");
                    CieIdSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    CieIdSAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, (AuthenticationSessionModel)authSession, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequesterMessage", (Object[])new Object[0]);
                }
                Element assertionElement = assertionIsEncrypted ? AssertionUtil.decryptAssertion((SAMLDocumentHolder)holder, (ResponseType)responseType, (PrivateKey)keys.getPrivateKey()) : DocumentUtil.getElement((Document)holder.getSamlDocument(), (QName)new QName(JBossSAMLConstants.ASSERTION.get()));
                String cieIdExpectedRequestId = authSession.getClientNote("SAML_REQUEST_ID_BROKER");
                String cieIdResponseValidationError = CieIdSAMLEndpoint.this.verifyCieIdResponse(holder.getSamlDocument().getDocumentElement(), assertionElement, cieIdExpectedRequestId);
                if (cieIdResponseValidationError != null) {
                    logger.error((Object)("CIE ID Response Validation Error: " + cieIdResponseValidationError));
                    CieIdSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    CieIdSAMLEndpoint.this.event.error("invalid_saml_response");
                    return CieIdSAMLEndpoint.this.callback.error(cieIdResponseValidationError);
                }
                String expectedRequestId = authSession.getClientNote("SAML_REQUEST_ID_BROKER");
                boolean inResponseToValidationSuccess = CieIdSAMLEndpoint.this.validateInResponseToAttribute(responseType, expectedRequestId);
                if (!inResponseToValidationSuccess) {
                    CieIdSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    CieIdSAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, (AuthenticationSessionModel)authSession, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequesterMessage", (Object[])new Object[0]);
                }
                boolean signed = AssertionUtil.isSignedElement((Element)assertionElement);
                boolean assertionSignatureNotExistsWhenRequired = CieIdSAMLEndpoint.this.config.isWantAssertionsSigned() && !signed;
                boolean signatureNotValid = signed && CieIdSAMLEndpoint.this.config.isValidateSignature() && !AssertionUtil.isSignatureValid((Element)assertionElement, (KeyLocator)this.getIDPKeyLocator());
                boolean bl = hasNoSignatureWhenRequired = !signed && CieIdSAMLEndpoint.this.config.isValidateSignature() && !this.containsUnencryptedSignature(holder);
                if (assertionSignatureNotExistsWhenRequired || signatureNotValid || hasNoSignatureWhenRequired) {
                    logger.error((Object)"validation failed");
                    CieIdSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    CieIdSAMLEndpoint.this.event.error("invalid_signature");
                    return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, (AuthenticationSessionModel)authSession, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequesterMessage", (Object[])new Object[0]);
                }
                if (AssertionUtil.isIdEncrypted((ResponseType)responseType)) {
                    AssertionUtil.decryptId((ResponseType)responseType, (PrivateKey)keys.getPrivateKey());
                }
                AssertionType assertion = ((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getAssertion();
                NameIDType subjectNameID = CieIdSAMLEndpoint.this.getSubjectNameID(assertion);
                String principal = CieIdSAMLEndpoint.this.getPrincipal(assertion);
                if (principal == null) {
                    logger.errorf("no principal in assertion; expected: %s", (Object)CieIdSAMLEndpoint.this.expectedPrincipalType());
                    CieIdSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    CieIdSAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, (AuthenticationSessionModel)authSession, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequesterMessage", (Object[])new Object[0]);
                }
                BrokeredIdentityContext identity = new BrokeredIdentityContext(principal);
                identity.getContextData().put(CieIdSAMLEndpoint.SAML_LOGIN_RESPONSE, responseType);
                identity.getContextData().put(CieIdSAMLEndpoint.SAML_ASSERTION, assertion);
                identity.setAuthenticationSession(authSession);
                identity.setUsername(principal);
                if (subjectNameID != null && subjectNameID.getFormat() != null && subjectNameID.getFormat().toString().equals(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get())) {
                    identity.setEmail(subjectNameID.getValue());
                }
                if (CieIdSAMLEndpoint.this.config.isStoreToken()) {
                    identity.setToken(samlResponse);
                }
                ConditionsValidator.Builder cvb = new ConditionsValidator.Builder(assertion.getID(), (CommonConditionsType)assertion.getConditions(), CieIdSAMLEndpoint.this.destinationValidator).clockSkewInMillis(1000 * CieIdSAMLEndpoint.this.config.getAllowedClockSkew());
                try {
                    String issuerURL = this.getEntityId((UriInfo)CieIdSAMLEndpoint.this.session.getContext().getUri(), CieIdSAMLEndpoint.this.realm);
                    cvb.addAllowedAudience(new URI[]{URI.create(issuerURL)});
                    if (responseType.getDestination() != null) {
                        cvb.addAllowedAudience(new URI[]{URI.create(responseType.getDestination())});
                    }
                }
                catch (IllegalArgumentException issuerURL) {
                    // empty catch block
                }
                if (!cvb.build().isValid()) {
                    logger.error((Object)"Assertion expired.");
                    CieIdSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    CieIdSAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, (AuthenticationSessionModel)authSession, (Response.Status)Response.Status.BAD_REQUEST, (String)"expiredCodeMessage", (Object[])new Object[0]);
                }
                AuthnStatementType authn = null;
                for (Object statement : assertion.getStatements()) {
                    if (!(statement instanceof AuthnStatementType)) continue;
                    authn = (AuthnStatementType)statement;
                    identity.getContextData().put(CieIdSAMLEndpoint.SAML_AUTHN_STATEMENT, authn);
                    break;
                }
                if (assertion.getAttributeStatements() != null && (email = CieIdSAMLEndpoint.this.getX500Attribute(assertion, X500SAMLProfileConstants.EMAIL)) != null) {
                    identity.setEmail(email);
                }
                String brokerUserId = CieIdSAMLEndpoint.this.config.getAlias() + "." + principal;
                identity.setBrokerUserId(brokerUserId);
                identity.setIdpConfig((IdentityProviderModel)CieIdSAMLEndpoint.this.config);
                identity.setIdp((IdentityProvider)CieIdSAMLEndpoint.this.provider);
                if (authn != null && authn.getSessionIndex() != null) {
                    identity.setBrokerSessionId(CieIdSAMLEndpoint.this.config.getAlias() + "." + authn.getSessionIndex());
                }
                return CieIdSAMLEndpoint.this.callback.authenticated(identity);
            }
            catch (WebApplicationException e) {
                return e.getResponse();
            }
            catch (Exception e) {
                throw new IdentityBrokerException("Could not process response from SAML identity provider.", (Throwable)e);
            }
        }

        private AuthenticationSessionModel samlIdpInitiatedSSO(String clientUrlName) {
            CieIdSAMLEndpoint.this.event.event(EventType.LOGIN);
            CacheControlUtil.noBackButtonCacheControlHeader();
            Optional oClient = CieIdSAMLEndpoint.this.session.clients().searchClientsByAttributes(CieIdSAMLEndpoint.this.realm, Collections.singletonMap("saml_idp_initiated_sso_url_name", clientUrlName), Integer.valueOf(0), Integer.valueOf(1)).findFirst();
            if (!oClient.isPresent()) {
                CieIdSAMLEndpoint.this.event.error("client_not_found");
                Response response = ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"clientNotFoundMessage", (Object[])new Object[0]);
                throw new WebApplicationException(response);
            }
            LoginProtocolFactory factory = (LoginProtocolFactory)CieIdSAMLEndpoint.this.session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, "saml");
            SamlService samlService = (SamlService)factory.createProtocolEndpoint(CieIdSAMLEndpoint.this.realm, CieIdSAMLEndpoint.this.event);
            ResteasyProviderFactory.getInstance().injectProperties((Object)samlService);
            AuthenticationSessionModel authSession = samlService.getOrCreateLoginSessionForIdpInitiatedSso(CieIdSAMLEndpoint.this.session, CieIdSAMLEndpoint.this.realm, (ClientModel)oClient.get(), null);
            if (authSession == null) {
                CieIdSAMLEndpoint.this.event.error("invalid_redirect_uri");
                Response response = ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRedirectUriMessage", (Object[])new Object[0]);
                throw new WebApplicationException(response);
            }
            return authSession;
        }

        private boolean isSuccessfulSamlResponse(ResponseType responseType) {
            return responseType != null && responseType.getStatus() != null && responseType.getStatus().getStatusCode() != null && responseType.getStatus().getStatusCode().getValue() != null && Objects.equals(responseType.getStatus().getStatusCode().getValue().toString(), JBossSAMLURIConstants.STATUS_SUCCESS.get());
        }

        public Response handleSamlResponse(String samlResponse, String relayState, String clientId) {
            SAMLDocumentHolder holder = this.extractResponseDocument(samlResponse);
            if (holder == null) {
                CieIdSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                CieIdSAMLEndpoint.this.event.detail("reason", "invalid_saml_document");
                CieIdSAMLEndpoint.this.event.error("invalid_saml_response");
                return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidFederatedIdentityActionMessage", (Object[])new Object[0]);
            }
            StatusResponseType statusResponse = (StatusResponseType)holder.getSamlObject();
            if (this.isDestinationRequired() && statusResponse.getDestination() == null && this.containsUnencryptedSignature(holder)) {
                CieIdSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                CieIdSAMLEndpoint.this.event.detail("reason", "missing_required_destination");
                CieIdSAMLEndpoint.this.event.error("invalid_logout_response");
                return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            if (!CieIdSAMLEndpoint.this.destinationValidator.validate(this.getExpectedDestination(CieIdSAMLEndpoint.this.config.getAlias(), clientId), statusResponse.getDestination())) {
                CieIdSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                CieIdSAMLEndpoint.this.event.detail("reason", "invalid_destination");
                CieIdSAMLEndpoint.this.event.error("invalid_saml_response");
                return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            if (CieIdSAMLEndpoint.this.config.isValidateSignature()) {
                try {
                    this.verifySignature("SAMLResponse", holder);
                }
                catch (VerificationException e) {
                    logger.error((Object)"validation failed", (Throwable)e);
                    CieIdSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    CieIdSAMLEndpoint.this.event.error("invalid_signature");
                    return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidFederatedIdentityActionMessage", (Object[])new Object[0]);
                }
            }
            if (statusResponse instanceof ResponseType) {
                return this.handleLoginResponse(samlResponse, holder, (ResponseType)statusResponse, relayState, clientId);
            }
            return this.handleLogoutResponse(holder, statusResponse, relayState);
        }

        protected Response handleLogoutResponse(SAMLDocumentHolder holder, StatusResponseType responseType, String relayState) {
            if (relayState == null) {
                logger.error((Object)"no valid user session");
                CieIdSAMLEndpoint.this.event.event(EventType.LOGOUT);
                CieIdSAMLEndpoint.this.event.error("user_session_not_found");
                return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"identityProviderUnexpectedErrorMessage", (Object[])new Object[0]);
            }
            UserSessionModel userSession = CieIdSAMLEndpoint.this.session.sessions().getUserSession(CieIdSAMLEndpoint.this.realm, relayState);
            if (userSession == null) {
                logger.error((Object)"no valid user session");
                CieIdSAMLEndpoint.this.event.event(EventType.LOGOUT);
                CieIdSAMLEndpoint.this.event.error("user_session_not_found");
                return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"identityProviderUnexpectedErrorMessage", (Object[])new Object[0]);
            }
            if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
                logger.error((Object)"usersession in different state");
                CieIdSAMLEndpoint.this.event.event(EventType.LOGOUT);
                CieIdSAMLEndpoint.this.event.error("user_session_not_found");
                return ErrorPage.error((KeycloakSession)CieIdSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"sessionNotActiveMessage", (Object[])new Object[0]);
            }
            return AuthenticationManager.finishBrowserLogout((KeycloakSession)CieIdSAMLEndpoint.this.session, (RealmModel)CieIdSAMLEndpoint.this.realm, (UserSessionModel)userSession, (UriInfo)CieIdSAMLEndpoint.this.session.getContext().getUri(), (ClientConnection)CieIdSAMLEndpoint.this.clientConnection, (HttpHeaders)CieIdSAMLEndpoint.this.headers);
        }

        private String getExpectedDestination(String providerAlias, String clientId) {
            if (clientId != null) {
                return CieIdSAMLEndpoint.this.session.getContext().getUri().getAbsolutePath().toString();
            }
            return Urls.identityProviderAuthnResponse((URI)CieIdSAMLEndpoint.this.session.getContext().getUri().getBaseUri(), (String)providerAlias, (String)CieIdSAMLEndpoint.this.realm.getName()).toString();
        }
    }
}

