/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.authenticators.sms;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.optionfactory.keycloak.authenticators.sms.PlaceboSmsClient;
import net.optionfactory.keycloak.authenticators.sms.SmsClient;
import net.optionfactory.keycloak.authenticators.sms.SnsSmsClient;
import net.optionfactory.keycloak.providers.Conf;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.Spi;

public class SmsClientSpi
implements Spi {
    public boolean isInternal() {
        return true;
    }

    public String getName() {
        return "opfa-sms-client";
    }

    public Class<? extends Provider> getProviderClass() {
        return SmsClient.class;
    }

    public Class<? extends ProviderFactory> getProviderFactoryClass() {
        return Factory.class;
    }

    public static class Factory
    implements ProviderFactory<SmsClient> {
        private final Logger logger = Logger.getLogger(Factory.class);
        private final AtomicReference<CloseableHttpClient> httpClientRef = new AtomicReference();
        private final AtomicReference<SmsClient> clientRef = new AtomicReference();

        public void init(Config.Scope scope) {
            Conf config = new Conf(this.getId(), scope);
            String type = config.anyOf("type", new String[]{"placebo", "sns"});
            if ("placebo".equals(type)) {
                this.logger.infof("configured a PlaceboSmsClient", new Object[0]);
                this.clientRef.set(new PlaceboSmsClient());
                return;
            }
            String clientId = config.string("clientId");
            String clientSecret = config.string("clientSecret");
            String region = config.string("region", "eu-west-1");
            String senderIdOrNull = config.string("senderId", null);
            this.logger.infof("SnsSmsClient configured: clientId:%s, clientSecret:%s, region:%s, senderId:%s", new Object[]{clientId, "***hidden***", region, senderIdOrNull});
            try {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (chain, authType) -> true).build();
                NoopHostnameVerifier hostnameVerifier = new NoopHostnameVerifier();
                SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
                CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(3000).build()).setDefaultSocketConfig(SocketConfig.custom().setSoKeepAlive(true).build()).build();
                this.httpClientRef.set(httpClient);
                this.clientRef.set(new SnsSmsClient(httpClient, clientId, clientSecret, region, senderIdOrNull));
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public void postInit(KeycloakSessionFactory factory) {
        }

        public SmsClient create(KeycloakSession session) {
            return this.clientRef.get();
        }

        public void close() {
            CloseableHttpClient maybeHttpClient = this.httpClientRef.get();
            if (maybeHttpClient == null) {
                return;
            }
            try {
                maybeHttpClient.close();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        public String getId() {
            return "opfa-sms-client";
        }
    }
}

