/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.authenticators;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.jboss.logging.Logger;

public class HttpClients {
    private static final Logger LOGGER = Logger.getLogger(HttpClients.class);

    public static CloseableHttpClient create(String name, Optional<KeyMaterial> keyMaterial, HostnameOptions hostnameOptions) {
        SSLContextBuilder sslcb = new SSLContextBuilder();
        try {
            sslcb.loadTrustMaterial(null, (chain, authType) -> true);
            keyMaterial.ifPresent(km -> {
                try {
                    sslcb.loadKeyMaterial(km.keystore, (char[])km.keyPassword.map(pwd -> pwd.toCharArray()).orElse(null));
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
                    throw new IllegalStateException(ex);
                }
            });
            SSLContext sslc = sslcb.build();
            NoopHostnameVerifier hostnameVerifier = hostnameOptions == HostnameOptions.VERIFY ? null : new NoopHostnameVerifier();
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslc, (HostnameVerifier)hostnameVerifier);
            AtomicLong counter = new AtomicLong(0L);
            return HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(3000).build()).setDefaultSocketConfig(SocketConfig.custom().setSoKeepAlive(true).build()).addInterceptorLast((hr, hc) -> {
                if (hc.getAttribute("log") == null) {
                    return;
                }
                long rid = counter.incrementAndGet();
                hc.setAttribute("rid", (Object)rid);
                String uri = hr.getRequestLine().getUri();
                String method = hr.getRequestLine().getMethod();
                LOGGER.infof("[c:%s][rid:%s] %s request on %s", new Object[]{name, rid, method, uri});
            }).addInterceptorFirst((hr, hc) -> {
                if (hc.getAttribute("log") == null) {
                    return;
                }
                long rid = (Long)hc.getAttribute("rid");
                int status = hr.getStatusLine().getStatusCode();
                LOGGER.infof("[c:%s][rid:%s] response status: %s", (Object)name, (Object)rid, (Object)status);
            }).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static enum HostnameOptions {
        VERIFY,
        TRUST;

    }

    public static class KeyMaterial {
        public KeyStore keystore;
        public Optional<String> keyPassword;

        public static KeyMaterial fromJksFile(String path, Optional<String> keystorePassword, Optional<String> keyPassword) {
            try {
                KeyStore keystore = KeyStore.getInstance("JKS");
                try (FileInputStream is = new FileInputStream(path);){
                    keystore.load(is, keystorePassword.map(pwd -> pwd.toCharArray()).orElse(null));
                }
                KeyMaterial km = new KeyMaterial();
                km.keystore = keystore;
                km.keyPassword = keyPassword;
                return km;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

