/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.authenticators;

import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.sessions.AuthenticationSessionModel;

public class ConditionalClientIdAuthenticator
implements ConditionalAuthenticator {
    public static ConditionalClientIdAuthenticator SINGLETON = new ConditionalClientIdAuthenticator();

    public boolean matchCondition(AuthenticationFlowContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        String clientIdOrNull = authSession.getClient() == null ? null : authSession.getClient().getClientId();
        Map authConfig = context.getAuthenticatorConfig().getConfig();
        String expectedClientId = (String)authConfig.get("clientId");
        boolean match = expectedClientId.equals(clientIdOrNull);
        boolean negate = Boolean.parseBoolean((String)authConfig.get("negate"));
        return negate ? !match : match;
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return false;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }

    public static class Factory
    implements ConditionalAuthenticatorFactory {
        public void init(Config.Scope config) {
        }

        public void postInit(KeycloakSessionFactory factory) {
        }

        public void close() {
        }

        public String getId() {
            return "conditional-client-id";
        }

        public String getDisplayType() {
            return "Condition - Client id";
        }

        public boolean isConfigurable() {
            return true;
        }

        public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
            return new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};
        }

        public boolean isUserSetupAllowed() {
            return false;
        }

        public String getHelpText() {
            return "Flow is executed only if client has the given id.";
        }

        public List<ProviderConfigProperty> getConfigProperties() {
            ProviderConfigProperty clientIdProp = new ProviderConfigProperty();
            clientIdProp.setType("String");
            clientIdProp.setName("clientId");
            clientIdProp.setLabel("Client id");
            clientIdProp.setHelpText("Client Id to match");
            ProviderConfigProperty negateProp = new ProviderConfigProperty();
            negateProp.setType("boolean");
            negateProp.setName("negate");
            negateProp.setLabel("Negate output");
            negateProp.setHelpText("Apply a NOT to the check result.");
            return List.of(clientIdProp, negateProp);
        }

        public ConditionalAuthenticator getSingleton() {
            return SINGLETON;
        }
    }
}

