/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.auth;

import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.sessions.AuthenticationSessionModel;

public class ConditionalAuthNoteAuthenticator
implements ConditionalAuthenticator {
    public static ConditionalAuthNoteAuthenticator SINGLETON = new ConditionalAuthNoteAuthenticator();

    public boolean matchCondition(AuthenticationFlowContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        Map authConfig = context.getAuthenticatorConfig().getConfig();
        String authNoteKey = (String)authConfig.get("key");
        String expectedAuthNoteValue = (String)authConfig.get("value");
        boolean match = expectedAuthNoteValue.equals(authSession.getAuthNote(authNoteKey));
        boolean negate = Boolean.parseBoolean((String)authConfig.get("negate"));
        return negate ? !match : match;
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return false;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }

    public class Factory
    implements ConditionalAuthenticatorFactory {
        public void init(Config.Scope config) {
        }

        public void postInit(KeycloakSessionFactory factory) {
        }

        public void close() {
        }

        public String getId() {
            return "conditional-auth-note";
        }

        public String getDisplayType() {
            return "Condition - Authentication note";
        }

        public boolean isConfigurable() {
            return true;
        }

        public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
            return new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};
        }

        public boolean isUserSetupAllowed() {
            return false;
        }

        public String getHelpText() {
            return "Flow is executed only if session has the given auth note.";
        }

        public List<ProviderConfigProperty> getConfigProperties() {
            ProviderConfigProperty authNoteKeyProp = new ProviderConfigProperty();
            authNoteKeyProp.setType("String");
            authNoteKeyProp.setName("key");
            authNoteKeyProp.setLabel("Key");
            authNoteKeyProp.setHelpText("Auth note key");
            ProviderConfigProperty authNoteValueProp = new ProviderConfigProperty();
            authNoteValueProp.setType("String");
            authNoteValueProp.setName("value");
            authNoteValueProp.setLabel("Expected value");
            authNoteValueProp.setHelpText("Auth note value");
            ProviderConfigProperty negateProp = new ProviderConfigProperty();
            negateProp.setType("boolean");
            negateProp.setName("negate");
            negateProp.setLabel("Negate output");
            negateProp.setHelpText("Apply a NOT to the check result.");
            return List.of(authNoteKeyProp, authNoteValueProp, negateProp);
        }

        public ConditionalAuthenticator getSingleton() {
            return SINGLETON;
        }
    }
}

