/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.sg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.openhft.sg.CompilationContext;
import net.openhft.sg.Compiler;
import net.openhft.sg.ExtensionChains;
import net.openhft.sg.FieldAccessChains;
import net.openhft.sg.StageGraphCompilationException;
import net.openhft.sg.Staged;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;

public class CompilationNode {
    final Factory f;
    final CompilationContext cxt;
    final CompilationNode parent;
    List<CtClass<?>> classesToMerge = new ArrayList();
    private List<CompilationNode> innerNodes = new ArrayList<CompilationNode>();
    boolean eraseTypeParameters = false;
    CtField<?> parentAccessField;
    private List<CtField<?>> rootAccessPath;
    private CtClass<?> mergedClass;

    public static CompilationNode root(Factory f) {
        return new CompilationNode(f);
    }

    private CompilationNode(Factory f) {
        this.f = f;
        this.cxt = new CompilationContext();
        this.parent = null;
    }

    private CompilationNode(CompilationNode parent) {
        this.f = parent.f;
        this.cxt = parent.cxt;
        this.parent = parent;
        parent.innerNodes.add(this);
    }

    public CompilationNode createChild() {
        return new CompilationNode(this);
    }

    public CompilationNode eraseTypeParameters() {
        this.eraseTypeParameters = true;
        return this;
    }

    public CompilationNode addClassToMerge(Class<?> classToMerge) {
        if (classToMerge.getAnnotation(Staged.class) == null) {
            throw StageGraphCompilationException.sgce("All compiled classes should be annotated Staged: " + classToMerge);
        }
        CtClass ctClass = this.f.Class().get(classToMerge);
        this.classesToMerge.add(ctClass);
        this.cxt.bind(ctClass, this);
        Compiler.stagedClassExtensionChain(ctClass).forEach(c -> this.cxt.bindAnyStagedClassToNode((CtClass<?>)c, this));
        return this;
    }

    public CompilationNode addClassToMerge(CtClass<?> classToMerge) {
        if (classToMerge.getAnnotation(Staged.class) == null) {
            throw StageGraphCompilationException.sgce("All compiled classes should be annotated Staged: " + classToMerge);
        }
        this.classesToMerge.add(classToMerge);
        this.cxt.bind(classToMerge, this);
        Compiler.stagedClassExtensionChain(classToMerge).forEach(c -> this.cxt.bindAnyStagedClassToNode((CtClass<?>)c, this));
        return this;
    }

    void computeRootAccessPath() {
        if (this.parent == null) {
            this.rootAccessPath = Collections.emptyList();
        } else {
            if (this.parentAccessField == null) {
                throw StageGraphCompilationException.sgce("Parent compilation node is not referenced: " + this.classesToMerge);
            }
            this.rootAccessPath = new ArrayList(this.parent.rootAccessPath);
            this.rootAccessPath.add(this.parentAccessField);
        }
        this.innerNodes.forEach(CompilationNode::computeRootAccessPath);
    }

    List<CtField<?>> accessPath(CompilationNode target) {
        int equalUntil;
        int maxLen = Math.min(this.rootAccessPath.size(), target.rootAccessPath.size());
        for (equalUntil = 0; equalUntil < maxLen && this.rootAccessPath.get(equalUntil) == target.rootAccessPath.get(equalUntil); ++equalUntil) {
        }
        return target.rootAccessPath.subList(equalUntil, target.rootAccessPath.size());
    }

    CtExpression<?> access(CompilationNode target) {
        List<CtField<?>> accessPath = this.accessPath(target);
        CompilationNode thisNodeToAccess = this;
        while (!target.rootAccessPath.subList(0, Math.min(thisNodeToAccess.rootAccessPath.size(), target.rootAccessPath.size())).equals(thisNodeToAccess.rootAccessPath)) {
            thisNodeToAccess = thisNodeToAccess.parent;
        }
        CtFieldAccess access = FieldAccessChains.chainToAccess(accessPath);
        CtClass<?> classToMerge = thisNodeToAccess.classesToMerge.get(0);
        CtThisAccess thisAccess = this.f.Code().createThisAccess(classToMerge.getReference());
        if (access != null) {
            CtFieldAccess innerMostAccess = access;
            while (innerMostAccess.getTarget() != null) {
                innerMostAccess = (CtFieldAccess)innerMostAccess.getTarget();
            }
            innerMostAccess.setTarget((CtExpression)thisAccess);
            return access;
        }
        return thisAccess;
    }

    CtClass<?> getMergedClass() {
        if (this.mergedClass != null) {
            return this.mergedClass;
        }
        if (this.classesToMerge.size() == 1) {
            this.mergedClass = this.classesToMerge.get(0);
            this.finalProcessMergedClass();
            return this.mergedClass;
        }
        String name = this.classesToMerge.stream().map(CtNamedElement::getSimpleName).collect(Collectors.joining("_"));
        this.mergedClass = this.f.Class().create(this.classesToMerge.get(0).getPackage(), name);
        this.mergedClass.setModifiers(EnumSet.of(ModifierKind.PUBLIC));
        this.classesToMerge.forEach(ctClass -> {
            ctClass.getFormalTypeParameters().stream().filter(p -> !this.mergedClass.getFormalTypeParameters().contains(p)).forEach(arg_0 -> this.mergedClass.addFormalTypeParameter(arg_0));
            ctClass.getSuperInterfaces().forEach(arg_0 -> this.mergedClass.addSuperInterface(arg_0));
            ctClass.getAnonymousExecutables().forEach(ae -> ExtensionChains.add(this.mergedClass, ae, arg_0 -> this.mergedClass.addAnonymousExecutable(arg_0)));
            ctClass.getNestedTypes().forEach(t -> ExtensionChains.add(this.mergedClass, t, arg_0 -> this.mergedClass.addNestedType(arg_0)));
            ctClass.getFields().forEach(f -> ExtensionChains.add(this.mergedClass, f, arg_0 -> this.mergedClass.addField(arg_0)));
            ctClass.getConstructors().forEach(c -> ExtensionChains.add(this.mergedClass, c, arg_0 -> this.mergedClass.addConstructor(arg_0)));
            ctClass.getMethods().forEach(m -> ExtensionChains.add(this.mergedClass, m, arg_0 -> this.mergedClass.addMethod(arg_0)));
        });
        this.finalProcessMergedClass();
        return this.mergedClass;
    }

    private void finalProcessMergedClass() {
        if (this.eraseTypeParameters) {
            this.mergedClass.setFormalTypeParameters(Collections.emptyList());
        }
        if (!this.mergedClass.getModifiers().isEmpty()) {
            this.mergedClass.setModifiers(EnumSet.copyOf(this.mergedClass.getModifiers()));
            this.mergedClass.removeModifier(ModifierKind.ABSTRACT);
        }
    }

    void mergeChildNodes() {
        CtClass<?> mergedClass = this.getMergedClass();
        for (CompilationNode child : this.innerNodes) {
            CtClass<?> childMergedClass = child.getMergedClass();
            ExtensionChains.add(mergedClass, childMergedClass, arg_0 -> mergedClass.addNestedType(arg_0));
            CtCodeSnippetExpression constructor = this.f.Core().createCodeSnippetExpression();
            constructor.setValue("new " + childMergedClass.getSimpleName() + "()");
            child.parentAccessField.setDefaultExpression((CtExpression)constructor);
            child.parentAccessField.setType(childMergedClass.getReference());
            child.parentAccessField.addModifier(ModifierKind.FINAL);
            child.mergeChildNodes();
        }
    }
}

