/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.sg;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.openhft.sg.MethodNode;
import net.openhft.sg.StageGraphCompilationException;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtActualTypeContainer;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.Filter;

public final class ExtensionChains {
    private ExtensionChains() {
    }

    public static void mergeStagedChain(List<CtClass<?>> chain) {
        ExtensionChains.mergeStagedChainInner(chain);
    }

    private static <T> void mergeStagedChainInner(List<CtClass<T>> chain) {
        if (chain.size() == 1) {
            return;
        }
        Collections.reverse(chain);
        CtClass toMerge = chain.get(0);
        for (int i = 1; i < chain.size(); ++i) {
            CtClass mergeInto = chain.get(i);
            ExtensionChains.replaceInstantiatedTypeParams(toMerge, mergeInto);
            toMerge.getAnnotations().stream().forEach(a -> {
                if (mergeInto.getAnnotation(a.getActualAnnotation().getClass()) == null) {
                    ExtensionChains.add(mergeInto, a, arg_0 -> ((CtClass)mergeInto).addAnnotation(arg_0));
                }
            });
            toMerge.getSuperInterfaces().forEach(arg_0 -> mergeInto.addSuperInterface(arg_0));
            toMerge.getAnonymousExecutables().forEach(b -> ExtensionChains.add(mergeInto, b, arg_0 -> ((CtClass)mergeInto).addAnonymousExecutable(arg_0)));
            toMerge.getNestedTypes().forEach(nt -> ExtensionChains.add(mergeInto, nt, arg_0 -> ((CtClass)mergeInto).addNestedType(arg_0)));
            toMerge.getFields().forEach(f -> ExtensionChains.add(mergeInto, f, arg_0 -> ((CtClass)mergeInto).addField(arg_0)));
            for (CtMethod methodToMerge : toMerge.getMethods()) {
                ExtensionChains.processMethod(mergeInto, toMerge, methodToMerge);
            }
            CtClass finalToMerge = toMerge;
            mergeInto.getConstructors().forEach(c -> ExtensionChains.processConstructor(c, finalToMerge));
            mergeInto.setSuperclass(toMerge.getSuperclass());
            toMerge = mergeInto;
        }
    }

    private static <T> void replaceInstantiatedTypeParams(CtClass<T> toMerge, CtClass<T> mergeInto) {
        List typeArgs = mergeInto.getSuperclass().getActualTypeArguments();
        typeArgs.stream().filter(ta -> !(ta instanceof CtTypeParameterReference)).forEach(ta -> {
            int instantiatedParamIndex = typeArgs.indexOf(ta);
            final CtTypeReference instantiatedTypeParam = (CtTypeReference)toMerge.getFormalTypeParameters().get(instantiatedParamIndex);
            toMerge.accept((CtVisitor)new CtScanner((CtTypeReference)ta){
                final /* synthetic */ CtTypeReference val$ta;
                {
                    this.val$ta = ctTypeReference2;
                }

                public void scan(CtElement element) {
                    CtTypedElement typed;
                    CtTypeReference type;
                    CtActualTypeContainer ref;
                    if (element instanceof CtActualTypeContainer) {
                        ref = (CtActualTypeContainer)element;
                        ArrayList typeArgs = new ArrayList(ref.getActualTypeArguments());
                        this.replaceInList(element.getFactory(), typeArgs);
                        ref.setActualTypeArguments(typeArgs);
                    }
                    if (element instanceof CtTypeParameterReference) {
                        ref = (CtTypeParameterReference)element;
                        ArrayList bounds = new ArrayList(ref.getBounds());
                        this.replaceInList(element.getFactory(), bounds);
                        ref.setBounds(bounds);
                    }
                    if (element instanceof CtTypedElement && (type = (typed = (CtTypedElement)element).getType()) != null && instantiatedTypeParam.getSimpleName().equals(type.getSimpleName())) {
                        typed.setType((CtTypeReference)element.getFactory().Core().clone((CtElement)this.val$ta));
                    }
                    if (element instanceof CtExpression) {
                        ArrayList typeCasts = new ArrayList(((CtExpression)element).getTypeCasts());
                        this.replaceInList(element.getFactory(), typeCasts);
                        ((CtExpression)element).setTypeCasts(typeCasts);
                    }
                    super.scan(element);
                }

                private void replaceInList(Factory f, List<CtTypeReference<?>> types) {
                    for (int i = 0; i < types.size(); ++i) {
                        CtTypeReference<?> arg = types.get(i);
                        if (!instantiatedTypeParam.getSimpleName().equals(arg.getSimpleName())) continue;
                        types.set(i, (CtTypeReference<?>)f.Core().clone((CtElement)this.val$ta));
                    }
                }
            });
        });
    }

    private static <T> void processConstructor(final CtConstructor<T> c, CtClass<T> toMerge) {
        CtStatement firstStmt = (CtStatement)c.getBody().getStatements().get(0);
        if (firstStmt instanceof CtInvocation) {
            final CtInvocation superConstructorCall = (CtInvocation)firstStmt;
            if (!(superConstructorCall.getExecutable().getDeclaration() instanceof CtConstructor)) {
                return;
            }
            final CtConstructor superConstructor = (CtConstructor)superConstructorCall.getExecutable().getDeclaration();
            if (superConstructor.getDeclaringType() == toMerge) {
                CtBlock superConstructorBody = (CtBlock)c.getFactory().Core().clone((CtElement)superConstructor.getBody());
                superConstructorBody.accept((CtVisitor)new CtScanner(){

                    public <T> void visitCtParameterReference(CtParameterReference<T> ref) {
                        int parameterOrder = superConstructor.getParameters().indexOf(ref.getDeclaration());
                        ref.setDeclaringExecutable(c.getReference());
                        CtExpression arg = (CtExpression)superConstructorCall.getArguments().get(parameterOrder);
                        if (!(arg instanceof CtVariableAccess)) {
                            throw StageGraphCompilationException.sgce("super() should be directly called in " + c);
                        }
                        CtVariable param = ((CtVariableAccess)arg).getVariable().getDeclaration();
                        if (!(param instanceof CtParameter)) {
                            throw StageGraphCompilationException.sgce("super() should be directly called in " + c);
                        }
                        ref.setSimpleName(param.getSimpleName());
                        super.visitCtParameterReference(ref);
                    }
                });
                c.getBody().removeStatement(firstStmt);
                List superConstructorBodyStatements = superConstructorBody.getStatements();
                for (int i = superConstructorBodyStatements.size() - 1; i >= 0; --i) {
                    c.getBody().insertBegin((CtStatement)superConstructorBodyStatements.get(i));
                }
            }
        }
    }

    private static <T> void processMethod(CtClass<?> mergeInto, CtClass<?> toMerge, CtMethod<T> methodToMerge) {
        if (methodToMerge.hasModifier(ModifierKind.STATIC)) {
            ExtensionChains.add(mergeInto, methodToMerge, arg_0 -> mergeInto.addMethod(arg_0));
            return;
        }
        Optional<CtMethod> overridingMethod = mergeInto.getMethods().stream().filter(m -> MethodNode.overrides(m, methodToMerge)).findFirst();
        if (overridingMethod.isPresent()) {
            boolean shouldRemoveAnn;
            CtMethod overriding = overridingMethod.get();
            boolean bl = shouldRemoveAnn = methodToMerge.getAnnotation(Override.class) == null;
            if (!methodToMerge.hasModifier(ModifierKind.ABSTRACT) && !overriding.hasModifier(ModifierKind.ABSTRACT)) {
                ExtensionChains.processOverridden(mergeInto, toMerge, methodToMerge);
            }
            if (shouldRemoveAnn) {
                ExtensionChains.removeAnnotation(overriding, Override.class);
            }
        } else if (!methodToMerge.hasModifier(ModifierKind.ABSTRACT)) {
            ExtensionChains.add(mergeInto, methodToMerge, arg_0 -> mergeInto.addMethod(arg_0));
        }
    }

    private static <T> void processOverridden(CtClass<?> mergeInto, CtClass<?> toMerge, final CtMethod<T> methodToMerge) {
        List superInvocations = mergeInto.getElements(new Filter<CtInvocation<T>>(){

            public boolean matches(CtInvocation<T> invocation) {
                if (!(invocation.getTarget() instanceof CtSuperAccess)) {
                    return false;
                }
                CtExecutable m = invocation.getExecutable().getDeclaration();
                return m != null && MethodNode.overrides((CtMethod)m, methodToMerge);
            }
        });
        methodToMerge.setSimpleName(ExtensionChains.classPrefixedName(toMerge, methodToMerge));
        methodToMerge.setVisibility(ModifierKind.PRIVATE);
        ExtensionChains.removeAnnotation(methodToMerge, Override.class);
        for (CtInvocation superInvocation : superInvocations) {
            superInvocation.setTarget(null);
            superInvocation.setExecutable(methodToMerge.getReference());
        }
        ExtensionChains.add(mergeInto, methodToMerge, arg_0 -> mergeInto.addMethod(arg_0));
    }

    static <M extends CtElement> void add(CtClass<?> mergeInto, M member, Consumer<M> add) {
        add.accept(member);
        member.setParent(mergeInto);
    }

    static <A extends Annotation> void removeAnnotation(CtMethod<?> method, Class<A> annClass) {
        CtAnnotation toRemove = null;
        for (CtAnnotation ctAnnotation : method.getAnnotations()) {
            if (!annClass.isAssignableFrom(ctAnnotation.getActualAnnotation().getClass())) continue;
            toRemove = ctAnnotation;
            break;
        }
        if (toRemove != null) {
            method.removeAnnotation(toRemove);
        }
    }

    static String classPrefixedName(CtClass<?> ctClass, CtMethod<?> method) {
        return "_" + ctClass.getSimpleName() + "_" + method.getSimpleName();
    }
}

