/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.sg;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.openhft.sg.AccessType;
import net.openhft.sg.CompilationContext;
import net.openhft.sg.CompilationNode;
import net.openhft.sg.DependencyNode;
import net.openhft.sg.ExtensionChains;
import net.openhft.sg.LinedSourcePosition;
import net.openhft.sg.MethodNode;
import net.openhft.sg.Stage;
import net.openhft.sg.StageGraphCompilationException;
import net.openhft.sg.StageModel;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.Filter;

public class Compiler {
    private final CompilationContext cxt;
    private final CompilationNode root;
    private String mergedClassName;
    private String mergedClassPackage;

    public Compiler(CompilationNode root) {
        assert (root.parent == null);
        this.cxt = root.cxt;
        this.root = root;
    }

    public Compiler setMergedClassName(String mergedClassName) {
        this.mergedClassName = mergedClassName;
        return this;
    }

    public Compiler setMergedClassPackage(String mergedClassPackage) {
        this.mergedClassPackage = mergedClassPackage;
        return this;
    }

    public CtClass<?> compile() {
        this.computeAccessPaths();
        this.createNodes();
        this.checkFieldsAssignedOnlyWithinNodes();
        this.linkDependencyNodes();
        this.checkNoCyclicNodeDeps();
        this.printNodeStats();
        this.guardFieldsAccess();
        this.guardStageMethodCalls();
        this.declareAndPrepareEverything();
        this.cxt.allClasses().forEach(CtElement::updateAllParentsBelow);
        this.replaceStageRefAccesses();
        this.cxt.allClasses().forEach(CtElement::updateAllParentsBelow);
        this.removeExtraFields();
        this.generateGlobalClose();
        this.cxt.allClasses().map(Compiler::stagedClassExtensionChain).forEach(ExtensionChains::mergeStagedChain);
        if (this.mergedClassName != null) {
            this.root.getMergedClass().setSimpleName(this.mergedClassName);
        }
        if (this.mergedClassPackage != null) {
            this.root.getMergedClass().setParent((CtElement)this.root.f.Package().get(this.mergedClassName));
        }
        this.cxt.allClasses().forEach(CtElement::updateAllParentsBelow);
        List<CtClass> mergedClasses = this.cxt.allCompilationNodes().map(CompilationNode::getMergedClass).collect(Collectors.toList());
        mergedClasses.forEach(CtElement::updateAllParentsBelow);
        this.root.mergeChildNodes();
        this.root.getMergedClass().updateAllParentsBelow();
        this.sortMembers();
        this.updateFieldTypes();
        this.sortFinals();
        this.generateFinalAccessors();
        this.removeAllStageAnnotations((CtElement)this.root.getMergedClass());
        this.updateTypes((CtElement)this.root.getMergedClass());
        this.root.getMergedClass().updateAllParentsBelow();
        return this.root.getMergedClass();
    }

    public void computeAccessPaths() {
        this.cxt.allClasses().forEach(ctC -> Compiler.stagedClassExtensionChain(ctC).forEach(baseClass -> baseClass.getFields().forEach(field -> {
            if (field.getAnnotation(StageRef.class) != null) {
                CtTypeReference fieldClass = field.getType();
                List candidates = this.cxt.allClasses().filter(c -> fieldClass.isAssignableFrom(c.getReference())).collect(Collectors.toList());
                if (candidates.size() != 1) {
                    throw StageGraphCompilationException.sgce("Can assign " + candidates.stream().map(CtType::getSimpleName).collect(Collectors.toList()) + " to field " + field + " in " + baseClass.getSimpleName());
                }
                this.cxt.bindReferenced((CtField<?>)field, (CtClass<?>)((CtClass)candidates.get(0)));
                CompilationNode referencingNode = this.cxt.getCompilationNode((CtClass<?>)ctC);
                CompilationNode referencedNode = this.cxt.getCompilationNode((CtClass)candidates.get(0));
                if (referencedNode.parent == referencingNode && referencedNode.parentAccessField == null) {
                    referencedNode.parentAccessField = field;
                }
            }
        })));
        this.root.computeRootAccessPath();
    }

    private void createNodes() {
        this.cxt.allClasses().forEach(ctClass -> {
            for (CtClass<?> baseType : Compiler.stagedClassExtensionChain(ctClass)) {
                baseType.getFields().stream().filter(field -> !field.hasModifier(ModifierKind.STATIC) && !field.hasModifier(ModifierKind.FINAL) && field.getAnnotation(StageRef.class) == null && this.cxt.getStageModel((CtField<?>)field) == null).forEach(field -> new StageModel(this.cxt, (CtField<?>)field, (CtClass<?>)ctClass));
            }
        });
        this.cxt.allClasses().forEach(ctClass -> {
            for (CtClass<?> baseType : Compiler.stagedClassExtensionChain(ctClass)) {
                baseType.getMethods().stream().filter(m -> !m.hasModifier(ModifierKind.STATIC) && !m.hasModifier(ModifierKind.ABSTRACT)).filter(m -> this.cxt.getStageModelByClose((CtMethod<?>)m) == null).filter(m -> this.cxt.getStageModelByInitStage((CtMethod<?>)m) == null).filter(m -> this.cxt.getStageModelByStageInit((CtMethod<?>)m) == null).filter(m -> this.cxt.getStageModelByStageMethod((CtMethod<?>)m) == null).forEach(m -> {
                    if (this.cxt.getMethodNode((CtMethod<?>)m) == null) {
                        new MethodNode(this.cxt, (CtMethod<?>)m, (CtClass<?>)ctClass);
                    }
                });
            }
        });
    }

    private void checkFieldsAssignedOnlyWithinNodes() {
        this.forEachBaseClass(baseType -> baseType.getElements(fieldAccess -> {
            CtField field = fieldAccess.getVariable().getDeclaration();
            if (field == null) {
                return false;
            }
            StageModel model = this.cxt.getStageModel(field);
            if (model == null) {
                return false;
            }
            CtElement accessParent = fieldAccess.getParent();
            if (!(accessParent instanceof CtAssignment) || ((CtAssignment)accessParent).getAssigned() != fieldAccess) {
                return false;
            }
            CtElement p = accessParent;
            while (p != null) {
                CtMethod m;
                if (p instanceof CtMethod && (this.cxt.getStageModelByInitStage(m = (CtMethod)p) == model || this.cxt.getStageModelByClose(m) == model || this.cxt.getStageModelByStageMethod(m) == model)) {
                    return false;
                }
                p = p.isParentInitialized() ? p.getParent() : null;
            }
            throw StageGraphCompilationException.sgce(field + " shouldn't be assigned outside its stage's init() or close()");
        }));
    }

    private void linkDependencyNodes() {
        this.cxt.allNodes().forEach(node -> node.traverseBlocksForBuildingDeps(e -> {
            if (e instanceof CtInvocation) {
                CtExecutable executable;
                CtInvocation invocation = (CtInvocation)e;
                CtExpression invocationTarget = invocation.getTarget();
                if (!this.checkAccessedViaStageRefs(invocationTarget)) {
                    return;
                }
                CtExecutableReference executableRef = invocation.getExecutable();
                if (executableRef.getDeclaringType() != null && (executable = executableRef.getDeclaration()) instanceof CtMethod) {
                    CtMethod method = (CtMethod)executable;
                    MethodNode methodNode = this.cxt.getMethodNode(method);
                    if (methodNode == null) {
                        methodNode = this.referencedCompilationNode((DependencyNode)node, invocationTarget).interfaceMethodToNode.get(method);
                    }
                    if (methodNode != null && methodNode != node) {
                        node.addDependencyOrCheckSameAccess(methodNode, invocationTarget);
                        return;
                    }
                    StageModel stage = this.cxt.getStageModelByStageMethod(method);
                    if (stage != null && stage != node) {
                        node.addDependencyOrCheckSameAccess(stage, invocationTarget);
                    }
                }
            } else if (e instanceof CtFieldAccess) {
                StageModel stage;
                CtFieldAccess fieldAccess = (CtFieldAccess)e;
                if (!this.checkAccessedViaStageRefs(fieldAccess.getTarget())) {
                    return;
                }
                CtField field = fieldAccess.getVariable().getDeclaration();
                if (field != null && (stage = this.cxt.getStageModel(field)) != null && stage != node) {
                    node.addDependencyOrCheckSameAccess(stage, fieldAccess.getTarget());
                }
            }
        }));
    }

    private CompilationNode referencedCompilationNode(DependencyNode node, CtExpression<?> invocationTarget) {
        CompilationNode referencedNode;
        if (invocationTarget == null || invocationTarget instanceof CtThisAccess) {
            CtClass<?> ctClass = this.cxt.getAnyStagedClassByDependencyNode(node);
            referencedNode = this.cxt.getCompilationNode(ctClass);
        } else {
            CtField field = ((CtFieldAccess)invocationTarget).getVariable().getDeclaration();
            referencedNode = this.cxt.getCompilationNode(this.cxt.getReferencedClass(field));
        }
        return referencedNode;
    }

    private boolean checkAccessedViaStageRefs(CtExpression<?> target) {
        CtFieldAccess fieldAccess;
        CtField field;
        if (target == null || target instanceof CtThisAccess) {
            return true;
        }
        if (target instanceof CtFieldAccess && (field = (fieldAccess = (CtFieldAccess)target).getVariable().getDeclaration()) != null && field.getAnnotation(StageRef.class) != null) {
            return this.checkAccessedViaStageRefs(fieldAccess.getTarget());
        }
        return false;
    }

    private void checkNoCyclicNodeDeps() {
        HashMap visited = new HashMap();
        this.cxt.allNodes().filter(n -> n.getDependencies().isEmpty()).forEach(n -> this.recursiveCheckNoCyclicNodeDeps(visited, (List<DependencyNode>)new ArrayList<DependencyNode>(), (DependencyNode)n));
        if (this.cxt.allNodes().findAny().isPresent() && visited.isEmpty()) {
            throw StageGraphCompilationException.sgce("There are some nodes, but all have dependencies -- there are cycles");
        }
    }

    private void recursiveCheckNoCyclicNodeDeps(Map<DependencyNode, Visited> visited, List<DependencyNode> chain, DependencyNode node) {
        if (visited.get(node) == Visited.IN_PROCESS) {
            throw StageGraphCompilationException.sgce(node.name + " is a part of stage dependency cycle: " + chain);
        }
        if (visited.get(node) == Visited.END) {
            return;
        }
        visited.put(node, Visited.IN_PROCESS);
        node.getDependants().forEach(dep -> this.recursiveCheckNoCyclicNodeDeps(visited, Compiler.append(chain, node), (DependencyNode)dep));
        visited.put(node, Visited.END);
    }

    private static List<DependencyNode> append(List<DependencyNode> chain, DependencyNode node) {
        ArrayList<DependencyNode> copy = new ArrayList<DependencyNode>(chain);
        copy.add(node);
        return copy;
    }

    private void guardFieldsAccess() {
        this.cxt.allNodes().forEach(node -> {
            List fieldAccesses = node.filterBlocksForBuildingDeps(fa -> true);
            fieldAccesses.forEach(fa -> {
                StageModel stage;
                CtField field = fa.getVariable().getDeclaration();
                if (field != null && (stage = this.cxt.getStageModel(field)) != null && stage != node) {
                    CtExpression target = fa.getTarget();
                    CtTargetedExpression access = stage.fieldAccess(target, field);
                    if (target != null) {
                        target.setParent(access);
                    }
                    fa.replace(access);
                }
            });
        });
    }

    private void guardStageMethodCalls() {
        this.cxt.allNodes().forEach(node -> {
            List invocations = node.filterBlocksForBuildingDeps(inv -> true);
            invocations.forEach(invocation -> {
                if (invocation.getExecutable().getDeclaringType() == null) {
                    return;
                }
                CtExecutable declaration = invocation.getExecutable().getDeclaration();
                if (declaration == null || !(declaration instanceof CtMethod)) {
                    return;
                }
                CtMethod method = (CtMethod)declaration;
                StageModel stage = this.cxt.getStageModelByStageMethod(method);
                if (stage != null && stage != node) {
                    CtTargetedExpression guardedInvocation = stage.guardedStageMethodCall(invocation, method);
                    CtExpression target = invocation.getTarget();
                    guardedInvocation.setTarget(target);
                    if (target != null) {
                        target.setParent(guardedInvocation);
                    }
                    invocation.replace(guardedInvocation);
                }
            });
        });
    }

    private void replaceStageRefAccesses() {
        List<Pair> stageRefAccesses = this.cxt.allClasses().flatMap(ctC -> Compiler.stagedClassExtensionChain(ctC).stream().map(bc -> new Pair<CtClass, CtClass>((CtClass)ctC, (CtClass)bc))).flatMap(p -> {
            CtClass ctC = (CtClass)p.a;
            CtClass baseC = (CtClass)p.b;
            return baseC.getElements(fieldAccess -> {
                CtField field = fieldAccess.getVariable().getDeclaration();
                return field != null && field.getAnnotation(StageRef.class) != null && (fieldAccess instanceof CtFieldRead || fieldAccess instanceof CtFieldWrite);
            }).stream().map(fa -> new Pair<CtClass, CtFieldAccess>(ctC, (CtFieldAccess)fa));
        }).collect(Collectors.toList());
        stageRefAccesses.forEach(p -> {
            CtClass classWhereAccessFound = (CtClass)p.a;
            CtFieldAccess stageRefAccess = (CtFieldAccess)p.b;
            CtField field = stageRefAccess.getVariable().getDeclaration();
            assert (field != null);
            CompilationNode referencingNode = this.cxt.getCompilationNode(classWhereAccessFound);
            CompilationNode referencedNode = this.cxt.getCompilationNode(this.cxt.getReferencedClass(field));
            CtExpression<?> access = referencingNode.access(referencedNode, stageRefAccess instanceof CtFieldRead ? AccessType.Read : AccessType.Write);
            assert (access != null);
            stageRefAccess.replace(access);
        });
    }

    private void removeExtraFields() {
        this.forEachBaseClass(baseC -> {
            List<CtField> fieldsToRemove = baseC.getFields().stream().filter(f -> f.getAnnotation(StageRef.class) != null).filter(f -> {
                CompilationNode referencedNode = this.cxt.getCompilationNode(this.cxt.getReferencedClass((CtField<?>)f));
                return referencedNode.parentAccessField != f;
            }).collect(Collectors.toList());
            fieldsToRemove.forEach(arg_0 -> ((CtClass)baseC).removeField(arg_0));
        });
    }

    private void sortMembers() {
        List sortedList = this.topologicallySorted(this.cxt.allNodes().collect(Collectors.toList()));
        for (int i = 0; i < sortedList.size(); ++i) {
            this.cxt.setNodeOrder((DependencyNode)sortedList.get(i), i + 1);
        }
        this.root.getMergedClass().getElements(m -> {
            m.setPosition((SourcePosition)new LinedSourcePosition(m.getPosition(), this.cxt.getOrder((CtTypeMember)m)));
            return false;
        });
    }

    private <T extends DependencyNode> List<T> topologicallySorted(Collection<T> nodes) {
        HashSet visited = new HashSet();
        ArrayDeque sorted = new ArrayDeque();
        nodes.stream().filter(n -> n.getDependencies().isEmpty()).forEach(n -> n.visit(visited, sorted));
        sorted.retainAll(nodes);
        return new ArrayList(sorted);
    }

    private void sortFinals() {
        List<CtField> finalFields = this.cxt.allCompilationNodes().flatMap(n -> n.getMergedClass().getElements(field -> field.hasModifier(ModifierKind.FINAL)).stream()).collect(Collectors.toList());
        Map dependencies = CompilationContext.namedHashedMap();
        Map dependants = CompilationContext.namedHashedMap();
        finalFields.forEach(f -> {
            dependencies.put(f, new ArrayList());
            dependants.put(f, new ArrayList());
        });
        finalFields.forEach(f -> {
            CtElement executable;
            CtExpression defaultExpression = f.getDefaultExpression();
            if (defaultExpression == null) {
                return;
            }
            HashSet<CtElement> scannedExecutables = new HashSet<CtElement>();
            ArrayDeque executablesToScan = new ArrayDeque();
            Filter addDependencies = e -> {
                CtExecutable executable;
                if (e instanceof CtFieldAccess) {
                    CtFieldAccess access = (CtFieldAccess)e;
                    CtField field = access.getVariable().getDeclaration();
                    List fieldDependants = (List)dependants.get(field);
                    if (fieldDependants != null) {
                        fieldDependants.add(f);
                        ((List)dependencies.get(f)).add(field);
                    }
                } else if (e instanceof CtAbstractInvocation && (executable = ((CtAbstractInvocation)e).getExecutable().getDeclaration()) != null && !scannedExecutables.contains(executable) && executable.getParent() != null && this.cxt.getCompilationNode((CtClass)executable.getParent()) != null) {
                    executablesToScan.add(executable);
                }
                return false;
            };
            defaultExpression.getElements(addDependencies);
            CtType fieldClass = f.getType().getDeclaration();
            if (fieldClass instanceof CtClass && this.cxt.getCompilationNode((CtClass)fieldClass) != null) {
                fieldClass.getFields().forEach(field -> field.getElements(addDependencies));
            }
            while ((executable = (CtElement)executablesToScan.poll()) != null) {
                scannedExecutables.add(executable);
                executable.getElements(addDependencies);
            }
        });
        HashSet visited = new HashSet();
        ArrayDeque sorted = new ArrayDeque();
        dependencies.entrySet().stream().filter(e -> ((List)e.getValue()).isEmpty()).forEach(e -> this.visitField((CtField)e.getKey(), visited, sorted, dependants));
        ArrayList sortedList = new ArrayList(sorted);
        int order = 0;
        for (CtField field : sortedList) {
            CtType declaringType;
            CtExpression fieldInit = field.getDefaultExpression();
            if (fieldInit != null && !field.hasModifier(ModifierKind.STATIC) && (declaringType = field.getDeclaringType()) instanceof CtClass) {
                CtClass declaringClass = (CtClass)declaringType;
                if (declaringClass.getConstructors().isEmpty()) {
                    Factory factory = declaringClass.getFactory();
                    CtConstructor ctr2 = factory.Constructor().create(declaringClass, EnumSet.of(ModifierKind.PUBLIC), Collections.emptyList(), Collections.emptySet());
                    ctr2.setBody(factory.Core().createBlock());
                } else if (declaringClass.getConstructors().size() == 1) {
                    ((CtConstructor)declaringClass.getConstructors().iterator().next()).setImplicit(false);
                }
                declaringClass.getConstructors().forEach(ctr -> {
                    CtAssignment assignment = this.root.f.Code().createVariableAssignment((CtVariableReference)field.getReference(), false, (CtExpression)this.root.f.Core().clone((CtElement)fieldInit));
                    ctr.getBody().addStatement((CtStatement)assignment);
                });
                field.setDefaultExpression(null);
            }
            if (((List)dependencies.get(field)).isEmpty()) {
                order = 0;
            }
            field.setPosition((SourcePosition)new LinedSourcePosition(field.getPosition(), order));
            ++order;
        }
    }

    private void generateFinalAccessors() {
        List finalFields = this.root.getMergedClass().getElements(field -> field.hasModifier(ModifierKind.FINAL));
        finalFields.forEach(f -> {
            CtType declaringType = f.getDeclaringType();
            if (declaringType.getMethodsByName(f.getSimpleName()).isEmpty()) {
                Factory factory = f.getFactory();
                CtMethod access = factory.Method().create(declaringType, EnumSet.of(ModifierKind.PUBLIC), f.getType(), f.getSimpleName(), Collections.emptyList(), Collections.emptySet());
                access.setParent((CtElement)declaringType);
                access.setBody(factory.Core().createBlock());
                CtReturn fReturn = factory.Core().createReturn();
                fReturn.setReturnedExpression((CtExpression)factory.Code().createVariableRead((CtVariableReference)f.getReference(), false));
                access.getBody().addStatement((CtStatement)fReturn);
                access.setPosition((SourcePosition)new LinedSourcePosition(((LinedSourcePosition)f.getPosition()).delegate, ((LinedSourcePosition)f.getPosition()).line));
            }
        });
    }

    private void visitField(CtField<?> f, Set<CtField<?>> visited, Deque<CtField<?>> sorted, Map<CtField<?>, List<CtField<?>>> dependants) {
        if (visited.contains(f)) {
            return;
        }
        visited.add(f);
        dependants.get(f).forEach(df -> this.visitField((CtField<?>)df, visited, sorted, dependants));
        sorted.addFirst(f);
    }

    private void declareAndPrepareEverything() {
        this.cxt.allNodes().forEach(DependencyNode::declareAndPrepareAllMethods);
    }

    void forEachBaseClass(Consumer<? super CtClass<?>> action) {
        this.cxt.allClasses().forEach(ctClass -> Compiler.stagedClassExtensionChain(ctClass).forEach(action));
    }

    static List<CtClass<?>> stagedClassExtensionChain(CtClass<?> leaf) {
        ArrayList chain = new ArrayList();
        CtClass type = leaf;
        while (type != null && type.getAnnotation(Staged.class) != null) {
            chain.add(type);
            CtTypeReference superClass = type.getSuperclass();
            if (superClass == null) break;
            type = (CtClass)superClass.getDeclaration();
        }
        return chain;
    }

    void removeAllStageAnnotations(CtElement element) {
        element.getElements(e -> {
            List<CtAnnotation> stagedAnnotations = e.getAnnotations().stream().filter(a -> {
                TypeFactory tf;
                CtTypeReference annType = a.getAnnotationType();
                return annType.equals((tf = a.getFactory().Type()).createReference(Stage.class)) || annType.equals(tf.createReference(Staged.class)) || annType.equals(tf.createReference(StageRef.class));
            }).collect(Collectors.toList());
            if (!stagedAnnotations.isEmpty()) {
                stagedAnnotations.forEach(arg_0 -> ((CtElement)e).removeAnnotation(arg_0));
            }
            return false;
        });
    }

    void updateFieldTypes() {
        this.root.getMergedClass().accept((CtVisitor)new CtScanner(){

            public <T> void visitCtFieldReference(CtFieldReference<T> ref) {
                CompilationNode node;
                CtType ctType;
                CtTypeReference declarationType = ref.getDeclaringType();
                if (declarationType != null && (ctType = declarationType.getDeclaration()) instanceof CtClass && (node = Compiler.this.cxt.getNodeByAnyStagedClass((CtClass)ctType)) != null) {
                    ref.setDeclaringType(node.getMergedClass().getReference());
                }
                super.visitCtFieldReference(ref);
            }
        });
    }

    void updateTypes(CtElement element) {
        element.accept((CtVisitor)new CtScanner(){

            public <T> void visitCtTypeReference(CtTypeReference<T> ref) {
                CompilationNode node;
                CtType ctType = ref.getDeclaration();
                if (ctType instanceof CtClass && (node = Compiler.this.cxt.getNodeByAnyStagedClass((CtClass)ctType)) != null) {
                    CtType declaringType;
                    CtClass<?> mergedClass = node.getMergedClass();
                    CtPackage mergedPackage = mergedClass.getPackage();
                    if (mergedPackage != null) {
                        ref.setPackage(mergedPackage.getReference());
                    }
                    if ((declaringType = mergedClass.getDeclaringType()) != null) {
                        CtTypeReference declaringTypeRef = declaringType.getReference();
                        declaringTypeRef.setActualTypeArguments(declaringType.getFormalTypeParameters());
                        ref.setDeclaringType(declaringTypeRef);
                    }
                    ref.setSimpleName(mergedClass.getSimpleName());
                    if (node.eraseTypeParameters) {
                        ref.setActualTypeArguments(Collections.emptyList());
                    } else if (!ref.getActualTypeArguments().isEmpty()) {
                        ref.setActualTypeArguments(mergedClass.getFormalTypeParameters());
                    }
                    return;
                }
                super.visitCtTypeReference(ref);
            }
        });
    }

    void generateGlobalClose() {
        Factory f = this.root.f;
        CtBlock closeBody = f.Core().createBlock();
        List<StageModel> stageModels = this.topologicallySorted(this.cxt.allStageModels().collect(Collectors.toList()));
        Collections.reverse(stageModels);
        stageModels.forEach(stage -> {
            CompilationNode refNode = this.cxt.getCompilationNode(stage.declaringType);
            CtExpression<?> access = this.root.access(refNode, AccessType.Read);
            closeBody.addStatement((CtStatement)f.Code().createInvocation(access, stage.getDoCloseMethod().getReference(), new CtExpression[0]));
        });
        CtClass<?> rootClass = this.root.classesToMerge.get(0);
        rootClass.addSuperInterface(f.Type().createReference(AutoCloseable.class));
        f.Method().create(rootClass, EnumSet.of(ModifierKind.PUBLIC), f.Type().VOID_PRIMITIVE, "close", Collections.emptyList(), Collections.emptySet(), closeBody);
    }

    private void printNodeStats() {
        System.out.println("stage model count: " + this.cxt.allStageModels().count());
        System.out.println("total node count: " + this.cxt.allNodes().count());
        long totalDependencyCount = this.cxt.allNodes().mapToInt(n -> n.getDependencies().size()).count();
        System.out.println("total node dep count: " + totalDependencyCount);
    }

    private static class Pair<A, B> {
        final A a;
        final B b;

        Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }

    static enum Visited {
        IN_PROCESS,
        END;

    }
}

