/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.sg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.sg.CompilationContext;
import net.openhft.sg.Compiler;
import net.openhft.sg.DependencyNode;
import net.openhft.sg.SpoonUtils;
import net.openhft.sg.Stage;
import net.openhft.sg.StageGraphCompilationException;
import net.openhft.sg.StringUtils;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.Filter;

public class StageModel
extends DependencyNode {
    private final Map<CtField<?>, CtMethod<?>> fields = new LinkedHashMap();
    private final Set<CtField<?>> fieldsToGenerateAccessMethods = new HashSet();
    private CtMethod<Boolean> stageInitMethod;
    private CtField<?> initField;
    private boolean manyFieldsInitialized = false;
    private List<CtMethod<Void>> initStageMethods = new ArrayList<CtMethod<Void>>();
    private CtMethod<Void> noArgInitStageMethod;
    private Map<CtMethod<?>, CtMethod<?>> stageMethods = new LinkedHashMap();
    private boolean closeMethodGenerated = false;
    private CtMethod<Void> closeMethod;
    private List<CtStatement> closeMethodStatements;
    private CtMethod<Void> doCloseMethod;

    public StageModel(CompilationContext cxt, CtField<?> oneField, CtClass<?> declaringType) {
        super(cxt, StageModel.stageName(oneField), declaringType);
        boolean fieldsFound = false;
        for (CtClass<?> baseType : Compiler.stagedClassExtensionChain(declaringType)) {
            for (CtMethod method : baseType.getMethods()) {
                String methodName = method.getSimpleName();
                if (methodName.equals(this.stageInitMethodName()) && this.stageInitMethod == null) {
                    if (!method.getType().equals(this.f().Type().BOOLEAN_PRIMITIVE)) {
                        throw StageGraphCompilationException.sgce(methodName + "() return type should be boolean");
                    }
                    if (!method.getParameters().isEmpty()) {
                        throw StageGraphCompilationException.sgce(methodName + "() shouldn't have parameters");
                    }
                    this.stageInitMethod = method;
                    cxt.bindStageInit(this.stageInitMethod, this);
                    continue;
                }
                if (!method.hasModifier(ModifierKind.ABSTRACT) && (methodName.equals(this.initStageMethodPrefix()) || methodName.startsWith(this.initStageMethodPrefix() + "_"))) {
                    if (this.initStageMethods.stream().anyMatch(m -> SpoonUtils.clashes(method, m))) {
                        throw StageGraphCompilationException.sgce(methodName + "() methods clash");
                    }
                    CtMethod voidMethod = method;
                    this.initStageMethods.add((CtMethod<Void>)voidMethod);
                    cxt.bindInitStage((CtMethod<Void>)voidMethod, this);
                    continue;
                }
                if (methodName.equals(this.closeMethodName()) && this.closeMethod == null) {
                    if (!method.getType().equals(this.f().Type().VOID_PRIMITIVE)) {
                        throw StageGraphCompilationException.sgce(methodName + "() should be void");
                    }
                    if (!method.getParameters().isEmpty()) {
                        throw StageGraphCompilationException.sgce(methodName + "() shouldn't have parameters");
                    }
                    this.closeMethod = method;
                    cxt.bindClose(this.closeMethod, this);
                    continue;
                }
                if (method.getAnnotation(Stage.class) == null || !StageModel.getStageName((CtElement)method).equals(this.name)) continue;
                this.stageMethods.put(method, null);
                cxt.bindStageMethod(method, this);
            }
            boolean fieldsFoundInThisClass = false;
            for (CtField field : baseType.getFields()) {
                if (!StringUtils.capitalize(field.getSimpleName()).equals(this.name) && (field.getAnnotation(Stage.class) == null || !StageModel.getStageName((CtElement)field).equals(this.name))) continue;
                if (fieldsFound) {
                    throw StageGraphCompilationException.sgce(this.name + " fields cannot span several class declarations");
                }
                fieldsFoundInThisClass = true;
                this.fields.put(field, null);
                if (field.getDefaultExpression() != null) {
                    if (this.initField != null || this.manyFieldsInitialized) {
                        if (this.stageInitMethod == null || this.stageInitMethod.hasModifier(ModifierKind.ABSTRACT)) {
                            throw StageGraphCompilationException.sgce("At most one " + this.name + " stage field could be initialized");
                        }
                        this.initField = null;
                        this.manyFieldsInitialized = true;
                    } else {
                        this.initField = field;
                    }
                }
                cxt.bind(field, this);
                for (CtMethod method : baseType.getMethods()) {
                    if (!method.getSimpleName().equals(field.getSimpleName()) || !method.hasModifier(ModifierKind.ABSTRACT)) continue;
                    this.fields.put(field, method);
                    this.fieldsToGenerateAccessMethods.add(field);
                }
                baseType.getSuperInterfaces().stream().flatMap(i -> {
                    if (i.getDeclaration() != null) {
                        return i.getDeclaration().getAllMethods().stream();
                    }
                    return Stream.empty();
                }).forEach(m -> {
                    if (m.getSimpleName().equals(field.getSimpleName())) {
                        this.fieldsToGenerateAccessMethods.add(field);
                    }
                });
            }
            fieldsFound = fieldsFoundInThisClass;
        }
        this.noArgInitStageMethod = this.initStageMethods.stream().filter(m -> m.getParameters().isEmpty()).findAny().orElse(null);
        if (this.initField != null && this.stageInitMethod != null && !this.stageInitMethod.hasModifier(ModifierKind.ABSTRACT) || this.initField == null && this.stageInitMethod == null) {
            throw StageGraphCompilationException.sgce(this.stageInitMethodName() + "() should be declared OR one field initialized");
        }
        if (this.initField == null && this.closeMethod == null) {
            throw StageGraphCompilationException.sgce("If no field initialized, " + this.closeMethodName() + "() should be declared");
        }
    }

    private static String stageName(CtField<?> field) {
        if (field.getAnnotation(Stage.class) != null) {
            return StageModel.getStageName(field);
        }
        return StringUtils.capitalize(field.getSimpleName());
    }

    private static String getStageName(CtElement element) {
        return (String)element.getAnnotation(element.getFactory().Type().createReference(Stage.class)).getElementValue("value");
    }

    public CtMethod<Boolean> getStageInitMethod() {
        if (this.stageInitMethod != null && !this.stageInitMethod.hasModifier(ModifierKind.ABSTRACT)) {
            return this.stageInitMethod;
        }
        assert (this.initField != null);
        if (this.stageInitMethod == null) {
            this.stageInitMethod = this.createSimpleMethod(this.f().Type().BOOLEAN_PRIMITIVE, this.stageInitMethodName());
            this.cxt.bindStageInit(this.stageInitMethod, this);
        } else {
            this.stageInitMethod.setBody(this.f().Core().createBlock());
            this.stageInitMethod.removeModifier(ModifierKind.ABSTRACT);
        }
        CtExpression unInitExpression = this.initField.getDefaultExpression();
        CtTypeReference initFieldType = this.initField.getType();
        if ((unInitExpression.toString().equals("-1") || unInitExpression.toString().equalsIgnoreCase("-1L")) && (initFieldType.equals(this.f().Type().INTEGER_PRIMITIVE) || initFieldType == this.f().Type().LONG_PRIMITIVE)) {
            CtReturn ret = this.f().Core().createReturn();
            ret.setReturnedExpression((CtExpression)this.f().Code().createBinaryOperator((CtExpression)this.f().Code().createVariableRead((CtVariableReference)this.initField.getReference(), false), (CtExpression)this.f().Code().createLiteral((Object)0), BinaryOperatorKind.GE));
            this.stageInitMethod.getBody().addStatement((CtStatement)ret);
            return this.stageInitMethod;
        }
        CtReturn ret = this.f().Core().createReturn();
        ret.setReturnedExpression((CtExpression)this.f().Code().createBinaryOperator((CtExpression)this.f().Code().createVariableRead((CtVariableReference)this.initField.getReference(), false), (CtExpression)this.f().Core().clone((Object)unInitExpression), BinaryOperatorKind.NE));
        this.stageInitMethod.getBody().addStatement((CtStatement)ret);
        return this.stageInitMethod;
    }

    private String stageInitMethodName() {
        return StringUtils.lowercase(this.name) + "Init";
    }

    private String closeMethodName() {
        return "close" + this.name;
    }

    private String initStageMethodPrefix() {
        return "init" + this.name;
    }

    @Override
    public Optional<CtMethod<Void>> getCloseMethod() {
        if (this.closeMethod != null && !this.closeMethod.hasModifier(ModifierKind.ABSTRACT)) {
            this.initCloseMethodStatements();
            return Optional.of(this.closeMethod);
        }
        assert (this.initField != null);
        this.closeMethodGenerated = true;
        if (this.closeMethod == null) {
            this.closeMethod = this.createSimpleMethod(this.f().Type().VOID_PRIMITIVE, this.closeMethodName());
            this.cxt.bindClose(this.closeMethod, this);
        } else {
            this.closeMethod.setBody(this.f().Core().createBlock());
            this.closeMethod.removeModifier(ModifierKind.ABSTRACT);
        }
        this.closeMethod.getBody().addStatement(SpoonUtils.reassignDefault(this.initField));
        this.initCloseMethodStatements();
        return Optional.of(this.closeMethod);
    }

    private void initCloseMethodStatements() {
        if (this.closeMethodStatements != null) {
            return;
        }
        this.closeMethodStatements = ((CtBlock)this.f().Core().clone((Object)this.closeMethod.getBody())).getStatements();
    }

    public CtMethod<Void> getDoCloseMethod() {
        if (this.doCloseMethod != null) {
            return this.doCloseMethod;
        }
        this.getCloseMethod();
        this.doCloseMethod = this.createSimpleMethod(this.f().Type().VOID_PRIMITIVE, "doClose" + this.name);
        for (CtStatement statement : this.closeMethodStatements) {
            this.doCloseMethod.getBody().addStatement(statement);
        }
        return this.doCloseMethod;
    }

    public <T> CtTargetedExpression<T, CtExpression<?>> fieldAccess(CtExpression<?> target, CtField<T> field) {
        if (!this.fields.containsKey(field)) {
            throw new StageGraphCompilationException(field + " doesn't belong to " + this);
        }
        return this.f().Code().createInvocation(target, this.fieldAccess(field).getReference(), new CtExpression[0]);
    }

    private <T> CtMethod<T> fieldAccess(CtField<T> field) {
        Map<CtField<?>, CtMethod<?>> fields = this.fields;
        return fields.compute(field, (f, proxy) -> {
            if (proxy == null) {
                proxy = this.createSimpleMethod(f.getType(), f.getSimpleName());
            } else if (proxy.hasModifier(ModifierKind.ABSTRACT)) {
                proxy.setBody(this.f().Core().createBlock());
                proxy.removeModifier(ModifierKind.ABSTRACT);
            } else {
                return proxy;
            }
            this.addGuardingPrologue((CtMethod)proxy);
            CtReturn ret = this.f().Core().createReturn();
            ret.setReturnedExpression((CtExpression)this.f().Code().createVariableRead((CtVariableReference)f.getReference(), false));
            proxy.getBody().addStatement((CtStatement)ret);
            this.cxt.bindAccessMethod((CtMethod<?>)proxy, this);
            return proxy;
        });
    }

    private <T> void addGuardingPrologue(CtMethod<T> proxy) {
        if (this.noArgInitStageMethod != null) {
            CtIf ctIf = this.createNotInitIf();
            ctIf.setThenStatement((CtStatement)this.f().Code().createInvocation(this.thisAccess(), this.noArgInitStageMethod.getReference(), new CtExpression[0]));
            proxy.getBody().addStatement((CtStatement)ctIf);
        } else {
            CtAssert ctAssert = this.f().Core().createAssert();
            ctAssert.setAssertExpression(this.createStageInitInvocation());
            ctAssert.setExpression((CtExpression)this.f().Code().createLiteral((Object)(this.name + " should be init")));
            proxy.getBody().addStatement((CtStatement)ctAssert);
        }
    }

    public <T> CtTargetedExpression<T, CtExpression<?>> guardedStageMethodCall(CtInvocation<T> invocation, CtMethod<T> stageMethod) {
        if (!this.stageMethods.containsKey(stageMethod)) {
            throw new StageGraphCompilationException(stageMethod + " doesn't belong to " + this);
        }
        Map<CtMethod<?>, CtMethod<?>> stageMethods = this.stageMethods;
        return this.f().Code().createInvocation(null, stageMethods.computeIfAbsent(stageMethod, m -> {
            CtMethod guarded = this.createSimpleMethod(m.getType(), m.getSimpleName() + "Guarded");
            this.addGuardingPrologue(guarded);
            guarded.setParameters(new ArrayList(m.getParameters()));
            List arguments = m.getParameters().stream().map(p -> p.getReference()).map(pr -> this.f().Code().createVariableRead((CtVariableReference)pr, false)).collect(Collectors.toList());
            CtInvocation innerInvocation = this.f().Code().createInvocation(null, m.getReference(), arguments);
            if (m.getType().equals(this.f().Type().VOID_PRIMITIVE)) {
                guarded.getBody().addStatement((CtStatement)innerInvocation);
            } else {
                CtReturn ctReturn = this.f().Core().createReturn();
                ctReturn.setReturnedExpression((CtExpression)innerInvocation);
                guarded.getBody().addStatement((CtStatement)ctReturn);
            }
            return guarded;
        }).getReference(), invocation.getArguments());
    }

    private CtThisAccess<?> thisAccess() {
        return this.f().Code().createThisAccess(this.declaringType.getReference());
    }

    private CtIf createNotInitIf() {
        CtIf ctIf = this.f().Core().createIf();
        CtUnaryOperator negInit = this.f().Core().createUnaryOperator();
        negInit.setKind(UnaryOperatorKind.NOT);
        negInit.setOperand(this.createStageInitInvocation());
        ctIf.setCondition((CtExpression)negInit);
        return ctIf;
    }

    private CtInvocation<Boolean> createStageInitInvocation() {
        return this.f().Code().createInvocation(this.thisAccess(), this.getStageInitMethod().getReference(), new CtExpression[0]);
    }

    @Override
    protected void doDeclareAndPrepareAllMethods() {
        this.getStageInitMethod();
        this.initStageMethods.forEach(initStageMethod -> {
            CtBlock initStageMethodBody = initStageMethod.getBody();
            this.getCloseDependantsMethod().ifPresent(m -> {
                CtInvocation stageInit = this.f().Code().createInvocation(this.thisAccess(), this.getStageInitMethod().getReference(), new CtExpression[0]);
                CtLocalVariable wasStageInit = this.f().Code().createLocalVariable(this.f().Type().BOOLEAN_PRIMITIVE, "was" + this.name + "Init", (CtExpression)stageInit);
                initStageMethodBody.insertBegin((CtStatement)wasStageInit);
                CtVariableRead wasStageInitRead = this.f().Core().createVariableRead();
                wasStageInitRead.setVariable((CtVariableReference)wasStageInit.getReference());
                CtIf ifInit = this.f().Core().createIf();
                ifInit.setCondition((CtExpression)wasStageInitRead);
                CtInvocation closeDependants = this.f().Code().createInvocation(this.thisAccess(), m.getReference(), new CtExpression[0]);
                ifInit.setThenStatement((CtStatement)closeDependants);
                initStageMethodBody.insertEnd((CtStatement)ifInit);
            });
        });
        CtMethod<Void> closeMethod = this.getCloseMethod().get();
        CtBlock closeMethodBody = closeMethod.getBody();
        this.getCloseDependantsMethod().ifPresent(m -> closeMethodBody.insertBegin((CtStatement)this.f().Code().createInvocation(this.thisAccess(), m.getReference(), new CtExpression[0])));
        CtIf ctIf = this.createNotInitIf();
        ctIf.setThenStatement((CtStatement)this.f().Core().createReturn());
        if (!this.closeMethodGenerated || this.getCloseDependantsMethod().isPresent()) {
            closeMethodBody.insertBegin((CtStatement)ctIf);
        }
        if (!this.closeMethodGenerated) {
            this.getDoCloseMethod().getBody().insertBegin((CtStatement)this.f().Core().clone((Object)ctIf));
        }
        this.fieldsToGenerateAccessMethods.forEach(this::fieldAccess);
    }

    @Override
    public <E extends CtElement> List<E> filterBlocksForBuildingDeps(Filter<E> filter) {
        Stream<Object> depsBuildingMethods = Stream.concat(this.initStageMethods.stream(), this.stageMethods.keySet().stream());
        depsBuildingMethods = Stream.concat(depsBuildingMethods, Stream.of(this.getCloseMethod().get()));
        return depsBuildingMethods.flatMap(initMethod -> initMethod.getElements(filter).stream()).collect(Collectors.toList());
    }
}

