/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.sg;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.sg.CompilationContext;
import net.openhft.sg.CompilationNode;
import net.openhft.sg.Compiler;
import net.openhft.sg.DependencyNode;
import net.openhft.sg.StringUtils;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.visitor.Filter;

public class MethodNode
extends DependencyNode {
    private List<CtMethod<?>> methods = new ArrayList();

    public MethodNode(CompilationContext cxt, CtMethod<?> method, CtClass<?> declaringType) {
        super(cxt, StringUtils.capitalize(declaringType.getSimpleName()) + StringUtils.capitalize(method.getSimpleName()), declaringType);
        Compiler.stagedClassExtensionChain(declaringType).forEach(baseType -> baseType.getMethods().stream().filter(m -> MethodNode.overrides(method, m)).findAny().ifPresent(m -> {
            this.methods.add((CtMethod<?>)m);
            cxt.bind((CtMethod<?>)m, this);
        }));
        CompilationNode declaringNode = cxt.getCompilationNode(declaringType);
        declaringType.getSuperInterfaces().stream().flatMap(i -> Stream.concat(Stream.of(i), i.getSuperInterfaces().stream())).forEach(superInterface -> {
            CtType superInterfaceDeclaration = superInterface.getDeclaration();
            if (superInterfaceDeclaration != null) {
                superInterfaceDeclaration.getMethods().stream().filter(m -> MethodNode.overrides(method, m)).forEach(m -> declaringNode.bind((CtMethod<?>)m, this));
            }
        });
    }

    static boolean overrides(CtMethod<?> m1, CtMethod<?> m2) {
        if (!m2.getSimpleName().equals(m1.getSimpleName())) {
            return false;
        }
        return m2.getParameters().equals(m1.getParameters());
    }

    @Override
    public Optional<CtMethod<Void>> getCloseMethod() {
        return this.getCloseDependantsMethod();
    }

    @Override
    protected void doDeclareAndPrepareAllMethods() {
        this.getCloseMethod();
    }

    @Override
    public <E extends CtElement> List<E> filterBlocksForBuildingDeps(Filter<E> filter) {
        return this.methods.stream().flatMap(m -> m.getElements(filter).stream()).collect(Collectors.toList());
    }
}

