/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.sg;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.openhft.sg.AccessType;
import net.openhft.sg.CompilationContext;
import net.openhft.sg.CompilationNode;
import net.openhft.sg.FieldAccessChains;
import net.openhft.sg.StageGraphCompilationException;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;

public abstract class DependencyNode {
    protected final CompilationContext cxt;
    private final Map<DependencyNode, List<CtField<?>>> dependenciesVia = new HashMap();
    private final Map<DependencyNode, List<CtField<?>>> dependantsVia = new HashMap();
    private CtMethod<Void> closeDependantsMethod;
    protected final String name;
    protected final CtClass<?> declaringType;
    private boolean declaredAndPrepared = false;

    public DependencyNode(CompilationContext cxt, String name, CtClass<?> declaringType) {
        this.cxt = cxt;
        this.name = name;
        this.declaringType = declaringType;
        cxt.bindDependencyNodeToAnyStagedClass(this, declaringType);
    }

    public void addDependencyOrCheckSameAccess(DependencyNode dependency, CtExpression<?> target) {
        assert (dependency != this);
        List<Object> via = target != null && !(target instanceof CtThisAccess) ? FieldAccessChains.accessToChain((CtFieldAccess)target) : Collections.emptyList();
        List alreadyVia = dependency.dependantsVia.putIfAbsent(this, via);
        if (alreadyVia == null) {
            this.dependenciesVia.put(dependency, via);
        } else if (!via.equals(alreadyVia)) {
            throw StageGraphCompilationException.sgce(dependency + " should be accessed from " + this + " via the same field access path " + alreadyVia + ", attempted to access via " + via);
        }
    }

    public Collection<DependencyNode> getDependencies() {
        return Collections.unmodifiableCollection(this.dependenciesVia.keySet());
    }

    public Collection<DependencyNode> getDependants() {
        return Collections.unmodifiableCollection(this.dependantsVia.keySet());
    }

    public boolean dependsOn(DependencyNode dependency) {
        boolean dependsDirectly = this.dependenciesVia.containsKey(dependency);
        if (dependsDirectly) {
            return true;
        }
        for (DependencyNode reqDependency : dependency.dependantsVia.keySet()) {
            if (!this.dependsOn(reqDependency)) continue;
            return true;
        }
        return false;
    }

    public final void declareAndPrepareAllMethods() {
        assert (!this.declaredAndPrepared);
        this.doDeclareAndPrepareAllMethods();
        this.declaredAndPrepared = true;
    }

    @Deprecated
    protected abstract void doDeclareAndPrepareAllMethods();

    public abstract Optional<CtMethod<Void>> getCloseMethod();

    public abstract <E extends CtElement> List<E> filterBlocksForBuildingDeps(Filter<E> var1);

    public final <E extends CtElement> void traverseBlocksForBuildingDeps(Consumer<E> action) {
        this.filterBlocksForBuildingDeps(DependencyNode.consumerToFilter(action));
    }

    private static <E extends CtElement> Filter<E> consumerToFilter(Consumer<E> action) {
        return e -> {
            action.accept(e);
            return false;
        };
    }

    protected Optional<CtMethod<Void>> getCloseDependantsMethod() {
        if (this.closeDependantsMethod != null) {
            return Optional.of(this.closeDependantsMethod);
        }
        if (this.dependantsVia.isEmpty()) {
            return Optional.empty();
        }
        if (!this.dependantsVia.keySet().stream().map(DependencyNode::getCloseMethod).anyMatch(Optional::isPresent)) {
            return Optional.empty();
        }
        this.closeDependantsMethod = this.createSimpleMethod(this.f().Type().VOID_PRIMITIVE, "close" + this.name + "Dependants");
        this.cxt.bindCloseDependants(this.closeDependantsMethod, this);
        for (DependencyNode dependant : this.topologicallySortedDependants()) {
            Optional<CtMethod<Void>> dependantCloseMethod = dependant.getCloseMethod();
            if (!dependantCloseMethod.isPresent()) continue;
            CompilationNode dependantNode = this.cxt.getCompilationNode(dependant.declaringType);
            CompilationNode thisNode = this.cxt.getCompilationNode(this.declaringType);
            CtExpression<?> dependantAccess = thisNode.access(dependantNode, AccessType.Read);
            this.closeDependantsMethod.getBody().addStatement((CtStatement)this.f().Code().createInvocation(dependantAccess, dependantCloseMethod.get().getReference(), new CtExpression[0]));
        }
        return Optional.of(this.closeDependantsMethod);
    }

    private List<DependencyNode> topologicallySortedDependants() {
        HashSet<DependencyNode> visited = new HashSet<DependencyNode>();
        ArrayDeque<DependencyNode> sorted = new ArrayDeque<DependencyNode>();
        this.visit(visited, sorted);
        sorted.retainAll(this.dependantsVia.keySet());
        return new ArrayList<DependencyNode>(sorted);
    }

    void visit(Set<DependencyNode> visited, Deque<DependencyNode> sorted) {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        this.getDependants().forEach(d -> d.visit(visited, sorted));
        sorted.addFirst(this);
    }

    protected <T> CtMethod<T> createSimpleMethod(CtTypeReference<T> returnType, String name) {
        CtMethod method = this.f().Method().create(this.declaringType, EnumSet.of(ModifierKind.PUBLIC), returnType, name, Collections.emptyList(), Collections.emptySet());
        method.setParent(this.declaringType);
        CtBlock body = this.f().Core().createBlock();
        method.setBody(body);
        body.setParent((CtElement)method);
        return method;
    }

    protected Factory f() {
        return this.declaringType.getFactory();
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

