/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.sg;

import com.sun.source.util.Trees;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;
import net.openhft.sg.CompilationNode;
import net.openhft.sg.Compiler;
import net.openhft.sg.Context;
import spoon.Launcher;
import spoon.compiler.Environment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;

public class ContextProcessor
extends AbstractProcessor {
    private Trees trees;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.trees = Trees.instance(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(Context.class.getName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> contextClasses = roundEnv.getElementsAnnotatedWith(Context.class);
        String[] classPathStrings = this.getClassPathStrings();
        contextClasses.forEach(cxtC -> {
            Launcher spoon = new Launcher();
            spoon.getEnvironment().setComplianceLevel(8);
            spoon.getEnvironment().setNoClasspath(true);
            spoon.getEnvironment().setSourceClasspath(classPathStrings);
            AnnotationMirror am = ContextProcessor.getAnnotationMirror(cxtC, Context.class);
            Stream.concat(Stream.of(this.trees.getPath((Element)cxtC)), Stream.concat(ContextProcessor.getAnnotationValue(am, "topLevel").stream(), ContextProcessor.getAnnotationValue(am, "nested").stream()).map(typeMirror -> this.trees.getPath(this.asTypeElement((TypeMirror)typeMirror)))).map(p -> {
                String path = Paths.get(p.getCompilationUnit().getSourceFile().toUri()).toAbsolutePath().toString();
                String[] parts = path.split("java");
                assert (parts.length >= 2);
                return Arrays.asList(parts).subList(0, parts.length - 1).stream().collect(Collectors.joining("java", "", "java"));
            }).distinct().forEach(arg_0 -> ((Launcher)spoon).addInputResource(arg_0));
            spoon.buildModel();
            Factory factory = spoon.getFactory();
            factory.getEnvironment().setAutoImports(true);
            try {
                String mergedClassName = "Compiled" + cxtC.getSimpleName();
                PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf((Element)cxtC);
                JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(pkg.getQualifiedName() + "." + mergedClassName, (Element)cxtC);
                if (Files.exists(Paths.get(sourceFile.toUri()), new LinkOption[0])) {
                    return;
                }
                CompilationNode root = CompilationNode.root(factory);
                root.addClassToMerge(factory.Class().get(cxtC.getQualifiedName().toString()));
                AnnotationMirror cxtAnn = ContextProcessor.getAnnotationMirror(cxtC, Context.class);
                for (TypeMirror topLevelClassMirror : ContextProcessor.getAnnotationValue(cxtAnn, "topLevel")) {
                    CtClass topLevelClass = factory.Class().get(this.asTypeElement(topLevelClassMirror).getQualifiedName().toString());
                    root.addClassToMerge(topLevelClass);
                }
                for (TypeMirror nestedClassMirror : ContextProcessor.getAnnotationValue(cxtAnn, "nested")) {
                    CtClass nestedClass = factory.Class().get(this.asTypeElement(nestedClassMirror).getQualifiedName().toString());
                    root.createChild().addClassToMerge(nestedClass).eraseTypeParameters();
                }
                Compiler compiler = new Compiler(root);
                compiler.setMergedClassName(mergedClassName);
                CtClass<?> resultClass = compiler.compile();
                MyPrinter printer = new MyPrinter(factory.getEnvironment());
                Collection imports = printer.computeImports((CtType)resultClass);
                printer.writeHeader(Collections.singletonList(resultClass), imports);
                printer.scan((CtElement)resultClass);
                try (Writer writer = sourceFile.openWriter();){
                    writer.write(printer.getResult());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return false;
    }

    private String[] getClassPathStrings() {
        ClassLoader cl = this.getClass().getClassLoader();
        URL[] currentClassPath = ((URLClassLoader)cl).getURLs();
        return (String[])Arrays.stream(currentClassPath).map(url -> {
            try {
                return Paths.get(url.toURI()).toAbsolutePath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).distinct().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toString).toArray(String[]::new);
    }

    private static AnnotationMirror getAnnotationMirror(TypeElement typeElement, Class<?> clazz) {
        String clazzName = clazz.getName();
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(clazzName)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static List<TypeMirror> getAnnotationValue(AnnotationMirror annotationMirror, String key) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(key)) continue;
            return ((List)entry.getValue().getValue()).stream().map(av -> (TypeMirror)av.getValue()).collect(Collectors.toList());
        }
        throw new AssertionError();
    }

    private TypeElement asTypeElement(TypeMirror typeMirror) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        return (TypeElement)typeUtils.asElement(typeMirror);
    }

    class MyPrinter
    extends DefaultJavaPrettyPrinter {
        Deque<CtClass<?>> currentThis;

        public MyPrinter(Environment env) {
            super(env);
            this.currentThis = new ArrayDeque();
        }

        public <T> void visitCtClass(CtClass<T> ctClass) {
            this.currentThis.push(ctClass);
            super.visitCtClass(ctClass);
            this.currentThis.pop();
        }

        public <T> void visitCtThisAccess(CtThisAccess<T> thisAccess) {
            this.enterCtExpression((CtExpression)thisAccess);
            if (thisAccess.getTarget() != null && thisAccess.isImplicit()) {
                throw new RuntimeException("inconsistent this definition");
            }
            if (thisAccess.getType().getDeclaration() != this.currentThis.peek()) {
                this.visitCtTypeReferenceWithoutGenerics(thisAccess.getType());
                this.write(".");
            }
            if (!thisAccess.isImplicit()) {
                this.write("this");
            }
            this.exitCtExpression((CtExpression)thisAccess);
        }
    }
}

