/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.sg;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.openhft.sg.CompilationNode;
import net.openhft.sg.DependencyNode;
import net.openhft.sg.MethodNode;
import net.openhft.sg.StageModel;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtTypeMember;

public class CompilationContext {
    static Hash.Strategy identityHashedEquivalence = new Hash.Strategy(){

        public boolean equals(Object a, Object b) {
            return a == b;
        }

        public int hashCode(Object o) {
            return o.hashCode();
        }
    };
    static Hash.Strategy<CtNamedElement> namedEquivalence = new Hash.Strategy<CtNamedElement>(){

        public int hashCode(CtNamedElement element) {
            String name = element.getSimpleName();
            if (name == null) {
                System.out.println(element);
            }
            return name.hashCode();
        }

        public boolean equals(CtNamedElement a, CtNamedElement b) {
            return a == b;
        }
    };
    private Map<CtField<?>, StageModel> fieldToStage = CompilationContext.namedHashedMap();
    private Map<CtMethod<?>, MethodNode> methodToNode = CompilationContext.namedHashedMap();
    private Map<CtMethod<Void>, StageModel> closeMethodToStage = CompilationContext.namedHashedMap();
    private Map<CtMethod<Void>, StageModel> initMethodToStage = CompilationContext.namedHashedMap();
    private Map<CtMethod<?>, StageModel> stageMethodsToStage = CompilationContext.namedHashedMap();
    private Map<CtMethod<Boolean>, StageModel> stageInitMethodToStage = CompilationContext.namedHashedMap();
    private Map<CtField<?>, CtClass<?>> stageReferencedClass = CompilationContext.namedHashedMap();
    private Map<CtClass<?>, CompilationNode> classToCompilationNode = CompilationContext.namedHashedMap();
    private Map<CtMethod<Void>, DependencyNode> closeDependantsToNode = CompilationContext.namedHashedMap();
    private Map<CtMethod<?>, StageModel> accessMethodToStage = CompilationContext.namedHashedMap();
    private Map<DependencyNode, Integer> nodeToOrder = new Object2ObjectOpenCustomHashMap(CompilationContext.identityHashedEquivalence());
    private Map<DependencyNode, CtClass<?>> dependencyNodeToAnyStagedClass = new Object2ObjectOpenCustomHashMap(CompilationContext.identityHashedEquivalence());
    private Map<CtClass<?>, CompilationNode> anyStagedClassToNode = CompilationContext.namedHashedMap();

    static <T> Hash.Strategy<T> identityHashedEquivalence() {
        return identityHashedEquivalence;
    }

    static <K extends CtNamedElement, V> Map<K, V> namedHashedMap() {
        return new Object2ObjectOpenCustomHashMap(namedEquivalence);
    }

    public void bind(CtMethod<?> method, MethodNode node) {
        if (this.methodToNode.putIfAbsent(method, node) != null) {
            throw new AssertionError();
        }
    }

    public MethodNode getMethodNode(CtMethod<?> method) {
        return this.methodToNode.get(method);
    }

    public void bind(CtField<?> field, StageModel node) {
        if (this.fieldToStage.putIfAbsent(field, node) != null) {
            throw new AssertionError();
        }
    }

    public StageModel getStageModel(CtField<?> field) {
        return this.fieldToStage.get(field);
    }

    public void bindClose(CtMethod<Void> closeMethod, StageModel node) {
        if (this.closeMethodToStage.putIfAbsent(closeMethod, node) != null) {
            throw new AssertionError();
        }
    }

    public StageModel getStageModelByClose(CtMethod<?> closeMethod) {
        return this.closeMethodToStage.get(closeMethod);
    }

    public void bindInitStage(CtMethod<Void> initMethod, StageModel node) {
        if (this.initMethodToStage.putIfAbsent(initMethod, node) != null) {
            throw new AssertionError((Object)(initMethod + " is already bind to stage " + this.initMethodToStage.get(initMethod) + ", trying to bind to " + node));
        }
    }

    public StageModel getStageModelByInitStage(CtMethod<?> initMethod) {
        return this.initMethodToStage.get(initMethod);
    }

    public void bindStageInit(CtMethod<Boolean> stageInitMethod, StageModel node) {
        if (this.stageInitMethodToStage.putIfAbsent(stageInitMethod, node) != null) {
            throw new AssertionError();
        }
    }

    public StageModel getStageModelByStageInit(CtMethod<?> stageInitMethod) {
        return this.stageInitMethodToStage.get(stageInitMethod);
    }

    public void bindStageMethod(CtMethod<?> stageMethod, StageModel stage) {
        if (this.stageMethodsToStage.putIfAbsent(stageMethod, stage) != null) {
            throw new AssertionError();
        }
    }

    public StageModel getStageModelByStageMethod(CtMethod<?> stageMethod) {
        return this.stageMethodsToStage.get(stageMethod);
    }

    public Stream<StageModel> allStageModels() {
        return this.fieldToStage.values().stream().distinct();
    }

    public Stream<DependencyNode> allNodes() {
        return Stream.concat(this.fieldToStage.values().stream(), this.methodToNode.values().stream()).distinct();
    }

    public void bind(CtClass<?> ctClass, CompilationNode compilationNode) {
        if (this.classToCompilationNode.putIfAbsent(ctClass, compilationNode) != null) {
            throw new AssertionError();
        }
    }

    public CompilationNode getCompilationNode(CtClass<?> ctClass) {
        return this.classToCompilationNode.get(ctClass);
    }

    public Stream<CtClass<?>> allClasses() {
        return this.classToCompilationNode.keySet().stream();
    }

    public Stream<CompilationNode> allCompilationNodes() {
        return this.classToCompilationNode.values().stream().distinct();
    }

    public void bindReferenced(CtField<?> stageRef, CtClass<?> referencedClass) {
        if (this.stageReferencedClass.putIfAbsent(stageRef, referencedClass) != null) {
            throw new AssertionError();
        }
    }

    public CtClass<?> getReferencedClass(CtField<?> stageRef) {
        return this.stageReferencedClass.get(stageRef);
    }

    public void bindCloseDependants(CtMethod<Void> closeDependants, DependencyNode node) {
        if (this.closeDependantsToNode.putIfAbsent(closeDependants, node) != null) {
            throw new AssertionError();
        }
    }

    public void bindAccessMethod(CtMethod<?> accessMethod, StageModel node) {
        if (this.accessMethodToStage.putIfAbsent(accessMethod, node) != null) {
            throw new AssertionError();
        }
    }

    public void setNodeOrder(DependencyNode node, int order) {
        if (this.nodeToOrder.putIfAbsent(node, order) != null) {
            throw new AssertionError();
        }
    }

    public int getOrder(CtTypeMember member) {
        if (member instanceof CtField) {
            return this.getOrder((CtField)member);
        }
        if (member instanceof CtMethod) {
            return this.getOrder((CtMethod)member);
        }
        return 0;
    }

    public int getOrder(CtField<?> field) {
        StageModel stageModel = this.getStageModel(field);
        if (stageModel != null) {
            return this.nodeToOrder.get(stageModel) * 10;
        }
        return 0;
    }

    public int getOrder(CtMethod<?> method) {
        DependencyNode d = this.getMethodNode(method);
        if (d != null) {
            return this.nodeToOrder.get(d) * 10;
        }
        d = this.getStageModelByStageInit(method);
        if (d != null) {
            return this.nodeToOrder.get(d) * 10 + 1;
        }
        d = this.getStageModelByInitStage(method);
        if (d != null) {
            return this.nodeToOrder.get(d) * 10 + 2;
        }
        d = this.accessMethodToStage.get(method);
        if (d != null) {
            return this.nodeToOrder.get(d) * 10 + 3;
        }
        d = this.getStageModelByClose(method);
        if (d != null) {
            return this.nodeToOrder.get(d) * 10 + 4;
        }
        d = this.closeDependantsToNode.get(method);
        if (d != null) {
            return this.nodeToOrder.get(d) * 10 + 5;
        }
        return 0;
    }

    public void bindAnyStagedClassToNode(CtClass<?> ctClass, CompilationNode node) {
        if (this.anyStagedClassToNode.putIfAbsent(ctClass, node) != null) {
            throw new AssertionError();
        }
    }

    public CompilationNode getNodeByAnyStagedClass(CtClass<?> ctClass) {
        return this.anyStagedClassToNode.get(ctClass);
    }

    public void bindDependencyNodeToAnyStagedClass(DependencyNode node, CtClass<?> ctClass) {
        if (this.dependencyNodeToAnyStagedClass.put(node, ctClass) != null) {
            throw new AssertionError();
        }
    }

    public CtClass<?> getAnyStagedClassByDependencyNode(DependencyNode node) {
        return this.dependencyNodeToAnyStagedClass.get(node);
    }
}

