/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.sg;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.sg.CompilationContext;
import net.openhft.sg.Compiler;
import net.openhft.sg.DependencyNode;
import net.openhft.sg.SpoonUtils;
import net.openhft.sg.Stage;
import net.openhft.sg.StageGraphCompilationException;
import net.openhft.sg.StringUtils;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.Filter;

public class StageModel
extends DependencyNode {
    private final Map<CtField<?>, CtMethod<?>> fields = new LinkedHashMap();
    private CtMethod<Boolean> stageInitMethod;
    private CtField<?> initField;
    private List<CtMethod<Void>> initStageMethods = new ArrayList<CtMethod<Void>>();
    private CtMethod<Void> noArgInitStageMethod;
    private Map<CtMethod<?>, CtMethod<?>> stageMethods = new LinkedHashMap();
    private CtMethod<Void> closeMethod;

    public StageModel(CompilationContext cxt, CtField<?> oneField, CtClass<?> declaringType) {
        super(cxt, StageModel.stageName(oneField), declaringType);
        boolean fieldsFound = false;
        for (CtClass<?> baseType : Compiler.stagedClassExtensionChain(declaringType)) {
            for (CtMethod method : baseType.getMethods()) {
                String methodName = method.getSimpleName();
                if (methodName.equals(this.stageInitMethodName()) && this.stageInitMethod == null) {
                    if (!method.getType().equals(this.f().Type().BOOLEAN_PRIMITIVE)) {
                        throw StageGraphCompilationException.sgce(methodName + "() return type should be boolean");
                    }
                    if (!method.getParameters().isEmpty()) {
                        throw StageGraphCompilationException.sgce(methodName + "() shouldn't have parameters");
                    }
                    this.stageInitMethod = method;
                    cxt.bindStageInit(this.stageInitMethod, this);
                    continue;
                }
                if (!method.hasModifier(ModifierKind.ABSTRACT) && methodName.startsWith(this.initStageMethodPrefix())) {
                    if (this.initStageMethods.stream().anyMatch(m -> SpoonUtils.clashes(method, m))) {
                        throw StageGraphCompilationException.sgce(methodName + "() methods clash");
                    }
                    CtMethod voidMethod = method;
                    this.initStageMethods.add((CtMethod<Void>)voidMethod);
                    cxt.bindInitStage((CtMethod<Void>)voidMethod, this);
                    continue;
                }
                if (methodName.equals(this.closeMethodName()) && this.closeMethod == null) {
                    if (!method.getType().equals(this.f().Type().VOID_PRIMITIVE)) {
                        throw StageGraphCompilationException.sgce(methodName + "() should be void");
                    }
                    if (!method.getParameters().isEmpty()) {
                        throw StageGraphCompilationException.sgce(methodName + "() shouldn't have parameters");
                    }
                    this.closeMethod = method;
                    cxt.bindClose(this.closeMethod, this);
                    continue;
                }
                if (method.getAnnotation(Stage.class) == null || !StageModel.getStageName((CtElement)method).equals(this.name)) continue;
                this.stageMethods.put(method, null);
                cxt.bindStageMethod(method, this);
            }
            boolean fieldsFoundInThisClass = false;
            for (CtField field : baseType.getFields()) {
                if (!StringUtils.capitalize(field.getSimpleName()).equals(this.name) && (field.getAnnotation(Stage.class) == null || !StageModel.getStageName((CtElement)field).equals(this.name))) continue;
                if (fieldsFound) {
                    throw StageGraphCompilationException.sgce(this.name + " fields cannot span several class declarations");
                }
                fieldsFoundInThisClass = true;
                this.fields.put(field, null);
                if (field.getDefaultExpression() != null && (this.stageInitMethod == null || this.stageInitMethod.hasModifier(ModifierKind.ABSTRACT))) {
                    if (this.initField != null) {
                        throw StageGraphCompilationException.sgce("At most one " + this.name + " stage field could be initialized");
                    }
                    this.initField = field;
                }
                cxt.bind(field, this);
            }
            fieldsFound = fieldsFoundInThisClass;
        }
        this.noArgInitStageMethod = this.initStageMethods.stream().filter(m -> m.getParameters().isEmpty()).findAny().orElse(null);
        if (this.initField != null && this.stageInitMethod != null && !this.stageInitMethod.hasModifier(ModifierKind.ABSTRACT) || this.initField == null && this.stageInitMethod == null) {
            throw StageGraphCompilationException.sgce(this.stageInitMethodName() + "() should be declared OR one field initialized");
        }
        if (this.initField == null && this.closeMethod == null) {
            throw StageGraphCompilationException.sgce("If no field initialized, " + this.closeMethodName() + "() should be declared");
        }
    }

    private static String stageName(CtField<?> field) {
        if (field.getAnnotation(Stage.class) != null) {
            return StageModel.getStageName(field);
        }
        return StringUtils.capitalize(field.getSimpleName());
    }

    private static String getStageName(CtElement element) {
        return (String)element.getAnnotation(element.getFactory().Type().createReference(Stage.class)).getElementValue("value");
    }

    public CtMethod<Boolean> getStageInitMethod() {
        if (this.stageInitMethod != null && !this.stageInitMethod.hasModifier(ModifierKind.ABSTRACT)) {
            return this.stageInitMethod;
        }
        assert (this.initField != null);
        if (this.stageInitMethod == null) {
            this.stageInitMethod = this.createSimpleMethod(this.f().Type().BOOLEAN_PRIMITIVE, this.stageInitMethodName());
            this.cxt.bindStageInit(this.stageInitMethod, this);
        } else {
            this.stageInitMethod.setBody(this.f().Core().createBlock());
            this.stageInitMethod.removeModifier(ModifierKind.ABSTRACT);
        }
        CtExpression unInitExpression = this.initField.getDefaultExpression();
        CtTypeReference initFieldType = this.initField.getType();
        if ((unInitExpression.toString().equals("-1") || unInitExpression.toString().equalsIgnoreCase("-1L")) && (initFieldType.equals(this.f().Type().INTEGER_PRIMITIVE) || initFieldType == this.f().Type().LONG_PRIMITIVE)) {
            CtReturn ret = this.f().Core().createReturn();
            ret.setReturnedExpression((CtExpression)this.f().Code().createBinaryOperator((CtExpression)this.f().Code().createVariableRead((CtVariableReference)this.initField.getReference(), false), (CtExpression)this.f().Code().createLiteral((Object)0), BinaryOperatorKind.GE));
            this.stageInitMethod.getBody().addStatement((CtStatement)ret);
            return this.stageInitMethod;
        }
        CtReturn ret = this.f().Core().createReturn();
        ret.setReturnedExpression((CtExpression)this.f().Code().createBinaryOperator((CtExpression)this.f().Code().createVariableRead((CtVariableReference)this.initField.getReference(), false), (CtExpression)this.f().Core().clone((Object)unInitExpression), BinaryOperatorKind.NE));
        this.stageInitMethod.getBody().addStatement((CtStatement)ret);
        return this.stageInitMethod;
    }

    private String stageInitMethodName() {
        return StringUtils.lowercase(this.name) + "Init";
    }

    private String closeMethodName() {
        return "close" + this.name;
    }

    private String initStageMethodPrefix() {
        return "init" + this.name;
    }

    @Override
    public Optional<CtMethod<Void>> getCloseMethod() {
        if (this.closeMethod != null && !this.closeMethod.hasModifier(ModifierKind.ABSTRACT)) {
            return Optional.of(this.closeMethod);
        }
        assert (this.initField != null);
        if (this.closeMethod == null) {
            this.closeMethod = this.createSimpleMethod(this.f().Type().VOID_PRIMITIVE, this.closeMethodName());
            this.cxt.bindClose(this.closeMethod, this);
        } else {
            this.closeMethod.setBody(this.f().Core().createBlock());
            this.closeMethod.removeModifier(ModifierKind.ABSTRACT);
        }
        this.closeMethod.getBody().addStatement(SpoonUtils.reassignDefault(this.initField));
        return Optional.of(this.closeMethod);
    }

    public <T> CtTargetedExpression<T, CtExpression<?>> fieldAccess(CtExpression<?> target, CtField<T> field) {
        if (!this.fields.containsKey(field)) {
            throw new StageGraphCompilationException(field + " doesn't belong to " + this);
        }
        Map<CtField<?>, CtMethod<?>> fields = this.fields;
        return this.f().Code().createInvocation(target, fields.computeIfAbsent(field, f -> {
            CtMethod proxy = this.createSimpleMethod(f.getType(), f.getSimpleName());
            this.addGuardingPrologue(proxy);
            CtReturn ret = this.f().Core().createReturn();
            ret.setReturnedExpression((CtExpression)this.f().Code().createVariableRead((CtVariableReference)f.getReference(), false));
            proxy.getBody().addStatement((CtStatement)ret);
            this.cxt.bindAccessMethod(proxy, this);
            return proxy;
        }).getReference(), new CtExpression[0]);
    }

    private <T> void addGuardingPrologue(CtMethod<T> proxy) {
        if (this.noArgInitStageMethod != null) {
            CtIf ctIf = this.createNotInitIf();
            ctIf.setThenStatement((CtStatement)this.f().Code().createInvocation(this.thisAccess(), this.noArgInitStageMethod.getReference(), new CtExpression[0]));
            proxy.getBody().addStatement((CtStatement)ctIf);
        } else {
            CtAssert ctAssert = this.f().Core().createAssert();
            ctAssert.setAssertExpression(this.createStageInitInvocation());
            ctAssert.setExpression((CtExpression)this.f().Code().createLiteral((Object)(this.name + " should be init")));
            proxy.getBody().addStatement((CtStatement)ctAssert);
        }
    }

    public <T> CtTargetedExpression<T, CtExpression<?>> guardedStageMethodCall(CtInvocation<T> invocation, CtMethod<T> stageMethod) {
        if (!this.stageMethods.containsKey(stageMethod)) {
            throw new StageGraphCompilationException(stageMethod + " doesn't belong to " + this);
        }
        Map<CtMethod<?>, CtMethod<?>> stageMethods = this.stageMethods;
        return this.f().Code().createInvocation(null, stageMethods.computeIfAbsent(stageMethod, m -> {
            CtMethod guarded = this.createSimpleMethod(m.getType(), m.getSimpleName() + "Guarded");
            this.addGuardingPrologue(guarded);
            guarded.setParameters(new ArrayList(m.getParameters()));
            List arguments = m.getParameters().stream().map(p -> p.getReference()).map(pr -> this.f().Code().createVariableRead((CtVariableReference)pr, false)).collect(Collectors.toList());
            CtInvocation innerInvocation = this.f().Code().createInvocation(null, m.getReference(), arguments);
            if (m.getType().equals(this.f().Type().VOID_PRIMITIVE)) {
                guarded.getBody().addStatement((CtStatement)innerInvocation);
            } else {
                CtReturn ctReturn = this.f().Core().createReturn();
                ctReturn.setReturnedExpression((CtExpression)innerInvocation);
                guarded.getBody().addStatement((CtStatement)ctReturn);
            }
            return guarded;
        }).getReference(), invocation.getArguments());
    }

    private CtThisAccess<?> thisAccess() {
        return this.f().Code().createThisAccess(this.declaringType.getReference());
    }

    private CtIf createNotInitIf() {
        CtIf ctIf = this.f().Core().createIf();
        CtUnaryOperator negInit = this.f().Core().createUnaryOperator();
        negInit.setKind(UnaryOperatorKind.NOT);
        negInit.setOperand(this.createStageInitInvocation());
        ctIf.setCondition((CtExpression)negInit);
        return ctIf;
    }

    private CtInvocation<Boolean> createStageInitInvocation() {
        return this.f().Code().createInvocation(this.thisAccess(), this.getStageInitMethod().getReference(), new CtExpression[0]);
    }

    @Override
    protected void doDeclareAndPrepareAllMethods() {
        this.getStageInitMethod();
        this.initStageMethods.forEach(initStageMethod -> {
            CtBlock initStageMethodBody = initStageMethod.getBody();
            this.insertCloseDependantsCall(arg_0 -> ((CtBlock)initStageMethodBody).insertEnd(arg_0));
        });
        CtMethod<Void> closeMethod = this.getCloseMethod().get();
        CtBlock closeMethodBody = closeMethod.getBody();
        this.insertCloseDependantsCall(arg_0 -> ((CtBlock)closeMethodBody).insertBegin(arg_0));
        CtIf ctIf = this.createNotInitIf();
        ctIf.setThenStatement((CtStatement)this.f().Core().createReturn());
        closeMethodBody.insertBegin((CtStatement)ctIf);
    }

    private void insertCloseDependantsCall(Consumer<CtInvocation<?>> insert) {
        Optional<CtMethod<Void>> closeDependantsMethod = this.getCloseDependantsMethod();
        closeDependantsMethod.ifPresent(m -> insert.accept(this.f().Code().createInvocation(this.thisAccess(), m.getReference(), new CtExpression[0])));
    }

    @Override
    public <E extends CtElement> List<E> filterBlocksForBuildingDeps(Filter<E> filter) {
        Stream depsBuildingMethods = Stream.concat(this.initStageMethods.stream(), this.stageMethods.keySet().stream());
        return depsBuildingMethods.flatMap(initMethod -> initMethod.getElements(filter).stream()).collect(Collectors.toList());
    }
}

