/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.saxophone.json;

import net.openhft.chronicle.bytes.Bytes;

final class Unescaper {
    private static char hexToDigit(Bytes hex, long pos) {
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            int c = hex.readUnsignedByte(pos + (long)i);
            if (c >= 65) {
                c = (c & 0xFFFFFFDF) - 7;
            }
            assert (((c -= 48) & 0xF0) == 0);
            val = val << 4 | c;
        }
        return (char)val;
    }

    static void decode(StringBuilder buf, Bytes str) {
        long len = str.readLimit();
        long pos = str.readPosition();
        int beg = 0;
        long end = pos;
        while (end < len) {
            if (str.readUnsignedByte(end) == 92) {
                char codePoint;
                buf.append((CharSequence)str, beg, (int)(end - pos));
                switch (str.readUnsignedByte(++end)) {
                    case 114: {
                        codePoint = '\r';
                        break;
                    }
                    case 110: {
                        codePoint = '\n';
                        break;
                    }
                    case 92: {
                        codePoint = '\\';
                        break;
                    }
                    case 47: {
                        codePoint = '/';
                        break;
                    }
                    case 34: {
                        codePoint = '\"';
                        break;
                    }
                    case 102: {
                        codePoint = '\f';
                        break;
                    }
                    case 98: {
                        codePoint = '\b';
                        break;
                    }
                    case 116: {
                        codePoint = '\t';
                        break;
                    }
                    case 117: {
                        codePoint = Unescaper.hexToDigit(str, ++end);
                        end += 3L;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"this should never happen");
                    }
                }
                buf.append(codePoint);
                beg = (int)(++end - pos);
                continue;
            }
            ++end;
        }
        buf.append((CharSequence)str, beg, (int)(end - pos));
    }

    private Unescaper() {
    }
}

