/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.saxophone.json;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.openhft.saxophone.json.JsonParser;
import net.openhft.saxophone.json.JsonParserOption;
import net.openhft.saxophone.json.JsonParserTopLevelStrategy;
import net.openhft.saxophone.json.handler.ArrayEndHandler;
import net.openhft.saxophone.json.handler.ArrayStartHandler;
import net.openhft.saxophone.json.handler.BooleanHandler;
import net.openhft.saxophone.json.handler.FloatingHandler;
import net.openhft.saxophone.json.handler.IntegerHandler;
import net.openhft.saxophone.json.handler.JsonHandlerBase;
import net.openhft.saxophone.json.handler.NullHandler;
import net.openhft.saxophone.json.handler.NumberHandler;
import net.openhft.saxophone.json.handler.ObjectEndHandler;
import net.openhft.saxophone.json.handler.ObjectKeyHandler;
import net.openhft.saxophone.json.handler.ObjectStartHandler;
import net.openhft.saxophone.json.handler.ResetHook;
import net.openhft.saxophone.json.handler.StringValueHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonParserBuilder {
    @NotNull
    private EnumSet<JsonParserOption> options = EnumSet.noneOf(JsonParserOption.class);
    @NotNull
    private JsonParserTopLevelStrategy topLevelStrategy = JsonParserTopLevelStrategy.ALLOW_JUST_A_SINGLE_OBJECT;
    private boolean eachTokenMustBeHandled = true;
    @Nullable
    private ObjectStartHandler objectStartHandler = null;
    @Nullable
    private ObjectEndHandler objectEndHandler = null;
    @Nullable
    private ArrayStartHandler arrayStartHandler = null;
    @Nullable
    private ArrayEndHandler arrayEndHandler = null;
    @Nullable
    private BooleanHandler booleanHandler = null;
    @Nullable
    private NullHandler nullHandler = null;
    @Nullable
    private StringValueHandler stringValueHandler = null;
    @Nullable
    private ObjectKeyHandler objectKeyHandler = null;
    @Nullable
    private NumberHandler numberHandler = null;
    @Nullable
    private IntegerHandler integerHandler = null;
    @Nullable
    private FloatingHandler floatingHandler = null;
    @Nullable
    private ResetHook resetHook = null;

    JsonParserBuilder() {
    }

    public JsonParser build() {
        this.checkAnyTokenHandlerNonNull();
        return new JsonParser(this.options, this.topLevelStrategy, this.eachTokenMustBeHandled, this.objectStartHandler, this.objectEndHandler, this.arrayStartHandler, this.arrayEndHandler, this.booleanHandler, this.nullHandler, this.stringValueHandler, this.objectKeyHandler, this.numberHandler, this.integerHandler, this.floatingHandler, this.resetHook);
    }

    private void checkAnyTokenHandlerNonNull() {
        if (this.objectStartHandler != null) {
            return;
        }
        if (this.objectEndHandler != null) {
            return;
        }
        if (this.arrayStartHandler != null) {
            return;
        }
        if (this.arrayEndHandler != null) {
            return;
        }
        if (this.booleanHandler != null) {
            return;
        }
        if (this.nullHandler != null) {
            return;
        }
        if (this.stringValueHandler != null) {
            return;
        }
        if (this.objectKeyHandler != null) {
            return;
        }
        if (this.numberHandler != null) {
            return;
        }
        if (this.integerHandler != null) {
            return;
        }
        if (this.floatingHandler != null) {
            return;
        }
        throw new IllegalStateException("Parser should have at least one JSON token handler");
    }

    public Set<JsonParserOption> options() {
        return Collections.unmodifiableSet(this.options);
    }

    public JsonParserBuilder options(Collection<JsonParserOption> options) {
        this.options = EnumSet.copyOf(options);
        return this;
    }

    public JsonParserBuilder options(JsonParserOption first, JsonParserOption ... rest) {
        this.options = EnumSet.of(first, rest);
        return this;
    }

    public JsonParserBuilder clearOptions() {
        this.options = EnumSet.noneOf(JsonParserOption.class);
        return this;
    }

    @NotNull
    public JsonParserTopLevelStrategy topLevelStrategy() {
        return this.topLevelStrategy;
    }

    public JsonParserBuilder topLevelStrategy(@NotNull JsonParserTopLevelStrategy topLevelStrategy) {
        this.topLevelStrategy = topLevelStrategy;
        return this;
    }

    public boolean eachTokenMustBeHandled() {
        return this.eachTokenMustBeHandled;
    }

    public JsonParserBuilder eachTokenMustBeHandled(boolean eachTokenMustBeHandled) {
        this.eachTokenMustBeHandled = eachTokenMustBeHandled;
        return this;
    }

    public JsonParserBuilder applyAdapter(JsonHandlerBase a) {
        boolean applied = false;
        if (a instanceof ObjectStartHandler) {
            this.objectStartHandler((ObjectStartHandler)a);
            applied = true;
        }
        if (a instanceof ObjectEndHandler) {
            this.objectEndHandler((ObjectEndHandler)a);
            applied = true;
        }
        if (a instanceof ArrayStartHandler) {
            this.arrayStartHandler((ArrayStartHandler)a);
            applied = true;
        }
        if (a instanceof ArrayEndHandler) {
            this.arrayEndHandler((ArrayEndHandler)a);
            applied = true;
        }
        if (a instanceof BooleanHandler) {
            this.booleanHandler((BooleanHandler)a);
            applied = true;
        }
        if (a instanceof NullHandler) {
            this.nullHandler((NullHandler)a);
            applied = true;
        }
        if (a instanceof StringValueHandler) {
            this.stringValueHandler((StringValueHandler)a);
            applied = true;
        }
        if (a instanceof ObjectKeyHandler) {
            this.objectKeyHandler((ObjectKeyHandler)a);
            applied = true;
        }
        if (a instanceof NumberHandler) {
            this.numberHandler((NumberHandler)a);
            applied = true;
        }
        if (a instanceof IntegerHandler) {
            this.integerHandler((IntegerHandler)a);
            applied = true;
        }
        if (a instanceof FloatingHandler) {
            this.floatingHandler((FloatingHandler)a);
            applied = true;
        }
        if (a instanceof ResetHook) {
            this.resetHook((ResetHook)a);
            applied = true;
        }
        if (!applied) {
            throw new IllegalArgumentException(a + " isn't an instance of any handler interface");
        }
        return this;
    }

    @Nullable
    public ObjectStartHandler objectStartHandler() {
        return this.objectStartHandler;
    }

    public JsonParserBuilder objectStartHandler(@Nullable ObjectStartHandler objectStartHandler) {
        this.objectStartHandler = objectStartHandler;
        return this;
    }

    @Nullable
    public ObjectEndHandler objectEndHandler() {
        return this.objectEndHandler;
    }

    public JsonParserBuilder objectEndHandler(@Nullable ObjectEndHandler objectEndHandler) {
        this.objectEndHandler = objectEndHandler;
        return this;
    }

    @Nullable
    public ArrayStartHandler arrayStartHandler() {
        return this.arrayStartHandler;
    }

    public JsonParserBuilder arrayStartHandler(@Nullable ArrayStartHandler arrayStartHandler) {
        this.arrayStartHandler = arrayStartHandler;
        return this;
    }

    @Nullable
    public ArrayEndHandler arrayEndHandler() {
        return this.arrayEndHandler;
    }

    public JsonParserBuilder arrayEndHandler(@Nullable ArrayEndHandler arrayEndHandler) {
        this.arrayEndHandler = arrayEndHandler;
        return this;
    }

    @Nullable
    public BooleanHandler booleanHandler() {
        return this.booleanHandler;
    }

    public JsonParserBuilder booleanHandler(@Nullable BooleanHandler booleanHandler) {
        this.booleanHandler = booleanHandler;
        return this;
    }

    @Nullable
    public NullHandler nullHandler() {
        return this.nullHandler;
    }

    public JsonParserBuilder nullHandler(@Nullable NullHandler nullHandler) {
        this.nullHandler = nullHandler;
        return this;
    }

    @Nullable
    public StringValueHandler stringValueHandler() {
        return this.stringValueHandler;
    }

    public JsonParserBuilder stringValueHandler(@Nullable StringValueHandler stringValueHandler) {
        this.stringValueHandler = stringValueHandler;
        return this;
    }

    @Nullable
    public ObjectKeyHandler objectKeyHandler() {
        return this.objectKeyHandler;
    }

    public JsonParserBuilder objectKeyHandler(@Nullable ObjectKeyHandler objectKeyHandler) {
        this.objectKeyHandler = objectKeyHandler;
        return this;
    }

    @Nullable
    public NumberHandler numberHandler() {
        return this.numberHandler;
    }

    public JsonParserBuilder numberHandler(@Nullable NumberHandler numberHandler) {
        this.checkNoConflict(this.integerHandler, "integer", numberHandler, "number");
        this.checkNoConflict(this.floatingHandler, "floating", numberHandler, "number");
        this.numberHandler = numberHandler;
        return this;
    }

    @Nullable
    public IntegerHandler integerHandler() {
        return this.integerHandler;
    }

    public JsonParserBuilder integerHandler(@Nullable IntegerHandler integerHandler) {
        this.checkNoConflict(integerHandler, "integer", this.numberHandler, "number");
        this.integerHandler = integerHandler;
        return this;
    }

    @Nullable
    public FloatingHandler floatingHandler() {
        return this.floatingHandler;
    }

    public JsonParserBuilder floatingHandler(@Nullable FloatingHandler floatingHandler) {
        this.checkNoConflict(floatingHandler, "floating", this.numberHandler, "number");
        this.floatingHandler = floatingHandler;
        return this;
    }

    private void checkNoConflict(Object h1, String name1, Object h2, String name2) {
        if (h1 != null && h2 != null) {
            throw new IllegalStateException("Parser cannot have " + name1 + " and " + name2 + " handlers simultaneously");
        }
    }

    @Nullable
    public ResetHook resetHook() {
        return this.resetHook;
    }

    public JsonParserBuilder resetHook(@Nullable ResetHook resetHook) {
        this.resetHook = resetHook;
        return this;
    }
}

