/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.saxophone.json;

import java.io.IOException;
import java.util.EnumSet;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.saxophone.ParseException;
import net.openhft.saxophone.json.JsonParserBuilder;
import net.openhft.saxophone.json.JsonParserOption;
import net.openhft.saxophone.json.JsonParserTopLevelStrategy;
import net.openhft.saxophone.json.Lexer;
import net.openhft.saxophone.json.ParserState;
import net.openhft.saxophone.json.TokenType;
import net.openhft.saxophone.json.Unescaper;
import net.openhft.saxophone.json.handler.ArrayEndHandler;
import net.openhft.saxophone.json.handler.ArrayStartHandler;
import net.openhft.saxophone.json.handler.BooleanHandler;
import net.openhft.saxophone.json.handler.FloatingHandler;
import net.openhft.saxophone.json.handler.IntegerHandler;
import net.openhft.saxophone.json.handler.NullHandler;
import net.openhft.saxophone.json.handler.NumberHandler;
import net.openhft.saxophone.json.handler.ObjectEndHandler;
import net.openhft.saxophone.json.handler.ObjectKeyHandler;
import net.openhft.saxophone.json.handler.ObjectStartHandler;
import net.openhft.saxophone.json.handler.ResetHook;
import net.openhft.saxophone.json.handler.StringValueHandler;
import org.jetbrains.annotations.Nullable;

public final class JsonParser {
    private final Lexer lexer;
    String parseError;
    private final StringBuilder decodeBuf = new StringBuilder();
    private final ParserState.Stack stateStack;
    private final EnumSet<JsonParserOption> flags;
    private final JsonParserTopLevelStrategy topLevelStrategy;
    private final boolean eachTokenMustBeHandled;
    private Bytes finishSpace;
    @Nullable
    private final ObjectStartHandler objectStartHandler;
    @Nullable
    private final ObjectEndHandler objectEndHandler;
    @Nullable
    private final ArrayStartHandler arrayStartHandler;
    @Nullable
    private final ArrayEndHandler arrayEndHandler;
    @Nullable
    private final BooleanHandler booleanHandler;
    @Nullable
    private final NullHandler nullHandler;
    @Nullable
    private final StringValueHandler stringValueHandler;
    @Nullable
    private final ObjectKeyHandler objectKeyHandler;
    @Nullable
    private final NumberHandler numberHandler;
    @Nullable
    private final IntegerHandler integerHandler;
    @Nullable
    private final FloatingHandler floatingHandler;
    @Nullable
    private final ResetHook resetHook;
    private final OnString onString = new OnString();
    private final OnEscapedString onEscapedString = new OnEscapedString();
    private final OnKey onKey = new OnKey();
    private final OnEscapedKey onEscapedKey = new OnEscapedKey();
    private final OnNumber onNumber = new OnNumber();
    private final OnFloating onFloating = new OnFloating();

    public static JsonParserBuilder builder() {
        return new JsonParserBuilder();
    }

    private boolean applyKey(CharSequence key) throws IOException {
        assert (this.objectKeyHandler != null);
        return this.objectKeyHandler.onObjectKey(key);
    }

    JsonParser(EnumSet<JsonParserOption> flags, JsonParserTopLevelStrategy topLevelStrategy, boolean eachTokenMustBeHandled, @Nullable ObjectStartHandler objectStartHandler, @Nullable ObjectEndHandler objectEndHandler, @Nullable ArrayStartHandler arrayStartHandler, @Nullable ArrayEndHandler arrayEndHandler, @Nullable BooleanHandler booleanHandler, @Nullable NullHandler nullHandler, @Nullable StringValueHandler stringValueHandler, @Nullable ObjectKeyHandler objectKeyHandler, @Nullable NumberHandler numberHandler, @Nullable IntegerHandler integerHandler, @Nullable FloatingHandler floatingHandler, @Nullable ResetHook resetHook) {
        this.flags = flags;
        this.topLevelStrategy = topLevelStrategy;
        this.eachTokenMustBeHandled = eachTokenMustBeHandled;
        this.objectStartHandler = objectStartHandler;
        this.objectEndHandler = objectEndHandler;
        this.arrayStartHandler = arrayStartHandler;
        this.arrayEndHandler = arrayEndHandler;
        this.booleanHandler = booleanHandler;
        this.nullHandler = nullHandler;
        this.stringValueHandler = stringValueHandler;
        this.objectKeyHandler = objectKeyHandler;
        this.numberHandler = numberHandler;
        this.integerHandler = integerHandler;
        this.floatingHandler = floatingHandler;
        this.resetHook = resetHook;
        this.lexer = new Lexer(flags.contains((Object)JsonParserOption.ALLOW_COMMENTS), !flags.contains((Object)JsonParserOption.DONT_VALIDATE_STRINGS));
        this.stateStack = new ParserState.Stack();
        this.reset();
    }

    public void reset() {
        this.lexer.reset();
        this.stateStack.clear();
        this.stateStack.push((byte)0);
        this.parseError = null;
        if (this.resetHook != null) {
            this.resetHook.onReset();
        }
    }

    private long parseInteger(Bytes s, long off, long len) {
        long lim = off + len;
        boolean neg = false;
        int cutLim = 7;
        byte first = s.readByte(off);
        long ret = first - 48;
        if (ret < 0L) {
            assert (first == 45);
            neg = true;
            ++cutLim;
            ret = s.readByte(++off) - 48;
        } else {
            if (ret == 0L) {
                assert (len == 1L);
                return 0L;
            }
            assert (ret > 0L && ret <= 9L);
        }
        ++off;
        ret = -ret;
        long cutoff = -922337203685477580L;
        while (off < lim) {
            int c = s.readByte(off++) - 48;
            assert (0 <= c && c <= 9);
            if (ret < cutoff || ret == cutoff && c > cutLim) {
                throw new NumberFormatException();
            }
            ret = 10L * ret - (long)c;
        }
        return !neg ? -ret : ret;
    }

    public boolean finish() {
        if (!this.parse(this.finishSpace())) {
            return false;
        }
        switch (this.stateStack.current()) {
            case 2: 
            case 3: 
            case 13: 
            case 14: {
                throw new AssertionError((Object)"exception should be thrown directly from parse()");
            }
            case 1: 
            case 12: {
                return true;
            }
        }
        return this.flags.contains((Object)JsonParserOption.ALLOW_PARTIAL_VALUES) || this.parseError("premature EOF");
    }

    private Bytes finishSpace() {
        if (this.finishSpace == null) {
            this.finishSpace = Bytes.from((String)" ");
        }
        this.finishSpace.readPosition(0L);
        return this.finishSpace;
    }

    /*
     * Unable to fully structure code
     */
    public boolean parse(Bytes jsonText) {
        startOffset = jsonText.readPosition();
        block81: while (true) {
            switch (this.stateStack.current()) {
                case 1: {
                    if (this.topLevelStrategy == JsonParserTopLevelStrategy.ALLOW_MULTIPLE_VALUES) {
                        this.stateStack.set((byte)12);
                        continue block81;
                    }
                    if (this.topLevelStrategy != JsonParserTopLevelStrategy.ALLOW_TRAILING_GARBAGE && jsonText.readRemaining() > 0L) {
                        tok = this.lexer.lex(jsonText);
                        if (tok == TokenType.EOF) continue block81;
                        return this.parseError("trailing garbage");
                    }
                    return true;
                }
                case 2: 
                case 3: {
                    throw new IllegalStateException("parse exception occurred: " + this.parseError);
                }
                case 13: {
                    throw new IllegalStateException("client cancelled parse via handler");
                }
                case 14: {
                    throw new IllegalStateException("handler threw an exception");
                }
                case 0: 
                case 6: 
                case 9: 
                case 11: 
                case 12: {
                    stateToPush = 0;
                    tok = this.lexer.lex(jsonText);
                    switch (1.$SwitchMap$net$openhft$saxophone$json$TokenType[tok.ordinal()]) {
                        case 1: {
                            return true;
                        }
                        case 2: {
                            this.lexicalError();
                        }
                        case 3: {
                            if (this.stringValueHandler != null) {
                                try {
                                    if (!this.onString.on()) {
                                        this.stateStack.set((byte)13);
                                        return false;
                                    }
                                    break;
                                }
                                catch (Exception e) {
                                    return this.handlerError(e);
                                }
                            }
                            this.checkTokenCouldBePassed(tok);
                            break;
                        }
                        case 4: {
                            if (this.stringValueHandler != null) {
                                try {
                                    if (!this.onEscapedString.on()) {
                                        this.stateStack.set((byte)13);
                                        return false;
                                    }
                                    break;
                                }
                                catch (Exception e) {
                                    return this.handlerError(e);
                                }
                            }
                            this.checkTokenCouldBePassed(TokenType.STRING);
                            break;
                        }
                        case 5: {
                            if (this.booleanHandler != null) {
                                value = this.lexer.outBuf.readUnsignedByte(this.lexer.outPos) == 116;
                                try {
                                    if (!this.booleanHandler.onBoolean(value)) {
                                        this.stateStack.set((byte)13);
                                        return false;
                                    }
                                    break;
                                }
                                catch (Exception e) {
                                    return this.handlerError(e);
                                }
                            }
                            this.checkTokenCouldBePassed(tok);
                            break;
                        }
                        case 6: {
                            if (this.nullHandler != null) {
                                try {
                                    if (!this.nullHandler.onNull()) {
                                        this.stateStack.set((byte)13);
                                        return false;
                                    }
                                    break;
                                }
                                catch (Exception e) {
                                    return this.handlerError(e);
                                }
                            }
                            this.checkTokenCouldBePassed(tok);
                            break;
                        }
                        case 7: {
                            if (this.objectStartHandler == null) ** GOTO lbl82
                            try {
                                if (!this.objectStartHandler.onObjectStart()) {
                                    this.stateStack.set((byte)13);
                                    return false;
                                }
                                ** GOTO lbl83
                            }
                            catch (Exception e) {
                                return this.handlerError(e);
                            }
lbl82:
                            // 1 sources

                            this.checkTokenCouldBePassed(tok);
lbl83:
                            // 2 sources

                            stateToPush = 4;
                            break;
                        }
                        case 8: {
                            if (this.arrayStartHandler == null) ** GOTO lbl94
                            try {
                                if (!this.arrayStartHandler.onArrayStart()) {
                                    this.stateStack.set((byte)13);
                                    return false;
                                }
                                ** GOTO lbl95
                            }
                            catch (Exception e) {
                                return this.handlerError(e);
                            }
lbl94:
                            // 1 sources

                            this.checkTokenCouldBePassed(tok);
lbl95:
                            // 2 sources

                            stateToPush = 9;
                            break;
                        }
                        case 9: {
                            if (this.numberHandler != null) {
                                try {
                                    if (!this.onNumber.on()) {
                                        this.stateStack.set((byte)13);
                                        return false;
                                    }
                                    break;
                                }
                                catch (Exception e) {
                                    return this.handlerError(e);
                                }
                            }
                            if (this.integerHandler != null) {
                                try {
                                    i = this.parseInteger(this.lexer.outBuf, this.lexer.outPos, this.lexer.outLen);
                                    if (!this.integerHandler.onInteger(i)) {
                                        this.stateStack.set((byte)13);
                                        return false;
                                    }
                                    break;
                                }
                                catch (NumberFormatException e) {
                                    this.tryRestoreErrorEffect(jsonText, startOffset);
                                    return this.parseError("integer overflow", e);
                                }
                                catch (Exception e) {
                                    return this.handlerError(e);
                                }
                            }
                            this.checkTokenCouldBePassed(tok);
                            break;
                        }
                        case 10: {
                            if (this.numberHandler != null) {
                                try {
                                    if (!this.onNumber.on()) {
                                        this.stateStack.set((byte)13);
                                        return false;
                                    }
                                    break;
                                }
                                catch (Exception e) {
                                    return this.handlerError(e);
                                }
                            }
                            if (this.floatingHandler != null) {
                                try {
                                    if (!this.onFloating.on()) {
                                        this.stateStack.set((byte)13);
                                        return false;
                                    }
                                    break;
                                }
                                catch (NumberFormatException e) {
                                    this.tryRestoreErrorEffect(jsonText, startOffset);
                                    return this.parseError("numeric (floating point) overflow", e);
                                }
                                catch (Exception e) {
                                    return this.handlerError(e);
                                }
                            }
                            this.checkTokenCouldBePassed(tok);
                            break;
                        }
                        case 11: {
                            if (this.stateStack.current() != 9) ** GOTO lbl155
                            if (this.arrayEndHandler == null) ** GOTO lbl152
                            try {
                                if (!this.arrayEndHandler.onArrayEnd()) {
                                    this.stateStack.set((byte)13);
                                    return false;
                                }
                                ** GOTO lbl153
                            }
                            catch (Exception e) {
                                return this.handlerError(e);
                            }
lbl152:
                            // 1 sources

                            this.checkTokenCouldBePassed(tok);
lbl153:
                            // 2 sources

                            this.stateStack.pop();
                            continue block81;
                        }
lbl155:
                        // 2 sources

                        case 12: 
                        case 13: 
                        case 14: {
                            return this.parseError("unallowed token at this point in JSON text");
                        }
                        default: {
                            return this.parseError("invalid token, internal error");
                        }
                    }
                    s = this.stateStack.current();
                    if (s == 0 || s == 12) {
                        this.stateStack.set((byte)1);
                    } else if (s == 6) {
                        this.stateStack.set((byte)7);
                    } else {
                        this.stateStack.set((byte)10);
                    }
                    if (stateToPush == 0) continue block81;
                    this.stateStack.push(stateToPush);
                    continue block81;
                }
                case 4: 
                case 8: {
                    tok = this.lexer.lex(jsonText);
                    onKey = this.onKey;
                    switch (1.$SwitchMap$net$openhft$saxophone$json$TokenType[tok.ordinal()]) {
                        case 1: {
                            return true;
                        }
                        case 2: {
                            this.lexicalError();
                        }
                        case 4: {
                            onKey = this.onEscapedKey;
                        }
                        case 3: {
                            if (this.objectKeyHandler == null) ** GOTO lbl190
                            try {
                                if (!onKey.on()) {
                                    this.stateStack.set((byte)13);
                                    return false;
                                }
                                ** GOTO lbl191
                            }
                            catch (Exception e) {
                                return this.handlerError(e);
                            }
lbl190:
                            // 1 sources

                            this.checkTokenCouldBePassed(TokenType.STRING);
lbl191:
                            // 2 sources

                            this.stateStack.set((byte)5);
                            continue block81;
                        }
                        case 14: {
                            if (this.stateStack.current() != 4) break;
                            if (this.objectEndHandler == null) ** GOTO lbl203
                            try {
                                if (!this.objectEndHandler.onObjectEnd()) {
                                    this.stateStack.set((byte)13);
                                    return false;
                                }
                                ** GOTO lbl204
                            }
                            catch (Exception e) {
                                return this.handlerError(e);
                            }
lbl203:
                            // 1 sources

                            this.checkTokenCouldBePassed(tok);
lbl204:
                            // 2 sources

                            this.stateStack.pop();
                            continue block81;
                        }
                    }
                    return this.parseError("invalid object key (must be a string)");
                }
                case 5: {
                    tok = this.lexer.lex(jsonText);
                    switch (1.$SwitchMap$net$openhft$saxophone$json$TokenType[tok.ordinal()]) {
                        case 12: {
                            this.stateStack.set((byte)6);
                            continue block81;
                        }
                        case 1: {
                            return true;
                        }
                        case 2: {
                            this.lexicalError();
                        }
                    }
                    return this.parseError("object key and value must be separated by a colon (':')");
                }
                case 7: {
                    tok = this.lexer.lex(jsonText);
                    switch (1.$SwitchMap$net$openhft$saxophone$json$TokenType[tok.ordinal()]) {
                        case 14: {
                            if (this.objectEndHandler == null) ** GOTO lbl231
                            try {
                                if (!this.objectEndHandler.onObjectEnd()) {
                                    this.stateStack.set((byte)13);
                                    return false;
                                }
                                ** GOTO lbl232
                            }
                            catch (Exception e) {
                                return this.handlerError(e);
                            }
lbl231:
                            // 1 sources

                            this.checkTokenCouldBePassed(tok);
lbl232:
                            // 2 sources

                            this.stateStack.pop();
                            continue block81;
                        }
                        case 13: {
                            this.stateStack.set((byte)8);
                            continue block81;
                        }
                        case 1: {
                            return true;
                        }
                        case 2: {
                            this.lexicalError();
                        }
                    }
                    this.tryRestoreErrorEffect(jsonText, startOffset);
                    return this.parseError("after key and value, inside map, I expect ',' or '}'");
                }
                case 10: {
                    tok = this.lexer.lex(jsonText);
                    switch (1.$SwitchMap$net$openhft$saxophone$json$TokenType[tok.ordinal()]) {
                        case 11: {
                            if (this.arrayEndHandler == null) ** GOTO lbl256
                            try {
                                if (!this.arrayEndHandler.onArrayEnd()) {
                                    this.stateStack.set((byte)13);
                                    return false;
                                }
                                ** GOTO lbl257
                            }
                            catch (Exception e) {
                                return this.handlerError(e);
                            }
lbl256:
                            // 1 sources

                            this.checkTokenCouldBePassed(tok);
lbl257:
                            // 2 sources

                            this.stateStack.pop();
                            continue block81;
                        }
                        case 13: {
                            this.stateStack.set((byte)11);
                            continue block81;
                        }
                        case 1: {
                            return true;
                        }
                        case 2: {
                            return this.lexicalError();
                        }
                    }
                    return this.parseError("after array element, I expect ',' or ']'");
                }
            }
        }
    }

    private boolean handlerError(Exception e) {
        this.stateStack.set((byte)14);
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new ParseException("Exception in the handler", e);
    }

    private boolean parseError(String message) {
        this.stateStack.set((byte)2);
        this.parseError = message;
        throw new ParseException(this.parseError);
    }

    private boolean parseError(String message, Throwable cause) {
        this.stateStack.set((byte)2);
        this.parseError = message;
        throw new ParseException(this.parseError, cause);
    }

    private boolean lexicalError() {
        this.stateStack.set((byte)3);
        this.parseError = "lexical error: " + (Object)((Object)this.lexer.error);
        throw new ParseException(this.parseError);
    }

    private void checkTokenCouldBePassed(TokenType token) {
        if (this.eachTokenMustBeHandled) {
            this.stateStack.set((byte)2);
            this.parseError = (Object)((Object)token) + " occurred in the input JSON, but corresponding handler is not assigned";
            throw new IllegalStateException(this.parseError);
        }
    }

    private void tryRestoreErrorEffect(Bytes jsonText, long startOffset) {
        long pos = jsonText.readPosition();
        if (pos - startOffset >= this.lexer.outLen) {
            jsonText.readPosition(pos - this.lexer.outLen);
        } else {
            jsonText.readPosition(startOffset);
        }
    }

    private class OnFloating
    extends OnString {
        private OnFloating() {
        }

        @Override
        boolean apply(CharSequence number) throws IOException {
            assert (JsonParser.this.floatingHandler != null);
            return JsonParser.this.floatingHandler.onFloating(Double.parseDouble(number.toString()));
        }
    }

    private class OnNumber
    extends OnString {
        private OnNumber() {
        }

        @Override
        boolean apply(CharSequence number) {
            assert (JsonParser.this.numberHandler != null);
            return JsonParser.this.numberHandler.onNumber(number);
        }
    }

    private class OnEscapedKey
    extends OnEscapedString {
        private OnEscapedKey() {
        }

        @Override
        boolean apply(CharSequence key) throws IOException {
            return JsonParser.this.applyKey(key);
        }
    }

    private class OnKey
    extends OnString {
        private OnKey() {
        }

        @Override
        boolean apply(CharSequence key) throws IOException {
            return JsonParser.this.applyKey(key);
        }
    }

    private class OnEscapedString
    extends OnString {
        private OnEscapedString() {
        }

        @Override
        CharSequence value(Bytes buf) {
            JsonParser.this.decodeBuf.setLength(0);
            Unescaper.decode(JsonParser.this.decodeBuf, buf);
            return JsonParser.this.decodeBuf;
        }
    }

    private class OnString {
        private OnString() {
        }

        boolean on() throws IOException {
            Bytes buf = ((JsonParser)JsonParser.this).lexer.outBuf;
            long bufPos = ((JsonParser)JsonParser.this).lexer.outPos;
            long bufLen = ((JsonParser)JsonParser.this).lexer.outLen;
            boolean borrowBuf = buf.readPosition() != bufPos || buf.readRemaining() != bufLen;
            long pos = 0L;
            long lim = 0L;
            if (borrowBuf) {
                pos = buf.readPosition();
                lim = buf.readLimit();
                buf.readLimit(bufPos + bufLen);
                buf.readPosition(bufPos);
            }
            boolean go = this.apply(this.value(buf));
            if (borrowBuf) {
                buf.readLimit(lim);
                buf.readPosition(pos);
            }
            return go;
        }

        CharSequence value(Bytes buf) {
            return buf;
        }

        boolean apply(CharSequence value) throws IOException {
            assert (JsonParser.this.stringValueHandler != null);
            return JsonParser.this.stringValueHandler.onStringValue(value);
        }
    }
}

