/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.saxophone.json;

import java.util.Arrays;

final class ParserState {
    static final byte START = 0;
    static final byte PARSE_COMPLETE = 1;
    static final byte PARSE_ERROR = 2;
    static final byte LEXICAL_ERROR = 3;
    static final byte MAP_START = 4;
    static final byte MAP_SEP = 5;
    static final byte MAP_NEED_VAL = 6;
    static final byte MAP_GOT_VAL = 7;
    static final byte MAP_NEED_KEY = 8;
    static final byte ARRAY_START = 9;
    static final byte ARRAY_GOT_VAL = 10;
    static final byte ARRAY_NEED_VAL = 11;
    static final byte GOT_VALUE = 12;
    static final byte HANDLER_CANCEL = 13;
    static final byte HANDLER_EXCEPTION = 14;

    private ParserState() {
    }

    static final class Stack {
        private static final int INC = 128;
        private byte[] stack = new byte[128];
        private int size = 0;

        Stack() {
        }

        byte current() {
            return this.stack[this.size - 1];
        }

        void push(byte state) {
            assert (0 <= state && state <= 14);
            if (this.size == this.stack.length) {
                this.stack = Arrays.copyOf(this.stack, this.size + 128);
            }
            this.stack[this.size++] = state;
        }

        void pop() {
            --this.size;
        }

        void set(byte state) {
            assert (0 <= state && state <= 14);
            this.stack[this.size - 1] = state;
        }

        void clear() {
            this.size = 0;
        }
    }
}

