/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.saxophone.json;

import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.saxophone.json.Buf;
import net.openhft.saxophone.json.LexError;
import net.openhft.saxophone.json.TokenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Lexer {
    private static final Logger LOG = LoggerFactory.getLogger(Lexer.class);
    private static final byte VEC = 1;
    private static final byte IJC = 2;
    private static final byte VHC = 4;
    private static final byte NFP = 8;
    private static final byte NUC = 16;
    private static final byte[] CHAR_LOOKUP_TABLE = new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 4, 5, 4, 4, 4, 5, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final char[] RUE_CHARS = new char[]{'r', 'u', 'e'};
    private static final char[] ALSE_CHARS = new char[]{'a', 'l', 's', 'e'};
    private static final char[] ULL_CHARS = new char[]{'u', 'l', 'l'};
    LexError error;
    private final Buf buf = new Buf();
    private boolean bufInUse;
    private final boolean allowComments;
    private final boolean validateUTF8;
    Bytes outBuf;
    long outPos;
    long outLen;

    Lexer(boolean allowComments, boolean validateUTF8) {
        this.allowComments = allowComments;
        this.validateUTF8 = validateUTF8;
    }

    void reset() {
        this.bufInUse = false;
        this.buf.reset();
        this.error = null;
        this.outBuf = null;
        this.outLen = 0L;
        this.outPos = 0L;
    }

    private int readChar(Bytes txt) {
        if (this.bufInUse && this.buf.remaining() > 0L) {
            return this.buf.readUnsignedByte();
        }
        return txt.readUnsignedByte();
    }

    private void unreadChar(Bytes txt) {
        long pos = txt.position();
        if (pos > 0L) {
            txt.position(pos - 1L);
        } else {
            this.buf.position(this.buf.position() - 1L);
        }
    }

    private TokenType lexUtf8Char(Bytes jsonText, int curChar) {
        if (curChar <= 127) {
            return TokenType.STRING;
        }
        if (curChar >> 5 == 6) {
            if (jsonText.remaining() == 0L) {
                return TokenType.EOF;
            }
            curChar = this.readChar(jsonText);
            if (curChar >> 6 == 2) {
                return TokenType.STRING;
            }
        } else if (curChar >> 4 == 14) {
            if (jsonText.remaining() == 0L) {
                return TokenType.EOF;
            }
            curChar = this.readChar(jsonText);
            if (curChar >> 6 == 2) {
                if (jsonText.remaining() == 0L) {
                    return TokenType.EOF;
                }
                curChar = this.readChar(jsonText);
                if (curChar >> 6 == 2) {
                    return TokenType.STRING;
                }
            }
        } else if (curChar >> 3 == 30) {
            if (jsonText.remaining() == 0L) {
                return TokenType.EOF;
            }
            curChar = this.readChar(jsonText);
            if (curChar >> 6 == 2) {
                if (jsonText.remaining() == 0L) {
                    return TokenType.EOF;
                }
                curChar = this.readChar(jsonText);
                if (curChar >> 6 == 2) {
                    if (jsonText.remaining() == 0L) {
                        return TokenType.EOF;
                    }
                    curChar = this.readChar(jsonText);
                    if (curChar >> 6 == 2) {
                        return TokenType.STRING;
                    }
                }
            }
        }
        return TokenType.ERROR;
    }

    private void stringScan(Bytes bytes) {
        long pos;
        int mask = 0xA | (this.validateUTF8 ? 16 : 0);
        long limit = bytes.limit();
        for (pos = bytes.position(); pos < limit && (CHAR_LOOKUP_TABLE[bytes.readUnsignedByte(pos)] & mask) == 0; ++pos) {
        }
        bytes.position(pos);
    }

    private TokenType lexString(Bytes jsonText) {
        boolean hasEscapes;
        TokenType tok;
        block15: {
            tok = TokenType.ERROR;
            hasEscapes = false;
            block0: while (true) {
                if (this.bufInUse && this.buf.remaining() > 0L) {
                    this.stringScan((Bytes)this.buf);
                } else if (jsonText.remaining() > 0L) {
                    this.stringScan(jsonText);
                }
                if (jsonText.remaining() == 0L) {
                    tok = TokenType.EOF;
                    break block15;
                }
                int curChar = this.readChar(jsonText);
                if (curChar == 34) {
                    tok = TokenType.STRING;
                    break block15;
                }
                if (curChar == 92) {
                    hasEscapes = true;
                    if (jsonText.remaining() == 0L) {
                        tok = TokenType.EOF;
                        break block15;
                    }
                    curChar = this.readChar(jsonText);
                    if (curChar == 117) {
                        int i = 0;
                        while (true) {
                            if (i >= 4) continue block0;
                            if (jsonText.remaining() == 0L) {
                                tok = TokenType.EOF;
                                break block15;
                            }
                            curChar = this.readChar(jsonText);
                            if ((CHAR_LOOKUP_TABLE[curChar] & 4) == 0) {
                                this.unreadChar(jsonText);
                                this.error = LexError.STRING_INVALID_HEX_CHAR;
                                break block15;
                            }
                            ++i;
                        }
                    }
                    if ((CHAR_LOOKUP_TABLE[curChar] & 1) != 0) continue;
                    this.unreadChar(jsonText);
                    this.error = LexError.STRING_INVALID_ESCAPED_CHAR;
                    break block15;
                }
                if ((CHAR_LOOKUP_TABLE[curChar] & 2) != 0) {
                    this.unreadChar(jsonText);
                    this.error = LexError.STRING_INVALID_JSON_CHAR;
                    break block15;
                }
                if (!this.validateUTF8) continue;
                TokenType t = this.lexUtf8Char(jsonText, curChar);
                if (t == TokenType.EOF) {
                    tok = TokenType.EOF;
                    break block15;
                }
                if (t == TokenType.ERROR) break;
            }
            this.error = LexError.STRING_INVALID_UTF8;
        }
        if (hasEscapes && tok == TokenType.STRING) {
            tok = TokenType.STRING_WITH_ESCAPES;
        }
        return tok;
    }

    private TokenType lexNumber(Bytes jsonText) {
        TokenType tok = TokenType.INTEGER;
        if (jsonText.remaining() == 0L) {
            return TokenType.EOF;
        }
        int c = this.readChar(jsonText);
        if (c == 45) {
            if (jsonText.remaining() == 0L) {
                return TokenType.EOF;
            }
            c = this.readChar(jsonText);
        }
        if (c == 48) {
            if (jsonText.remaining() == 0L) {
                return TokenType.EOF;
            }
            c = this.readChar(jsonText);
        } else if (c >= 49 && c <= 57) {
            do {
                if (jsonText.remaining() != 0L) continue;
                return TokenType.EOF;
            } while ((c = this.readChar(jsonText)) >= 48 && c <= 57);
        } else {
            this.unreadChar(jsonText);
            this.error = LexError.MISSING_INTEGER_AFTER_MINUS;
            return TokenType.ERROR;
        }
        if (c == 46) {
            boolean readSome = false;
            if (jsonText.remaining() == 0L) {
                return TokenType.EOF;
            }
            c = this.readChar(jsonText);
            while (c >= 48 && c <= 57) {
                readSome = true;
                if (jsonText.remaining() == 0L) {
                    return TokenType.EOF;
                }
                c = this.readChar(jsonText);
            }
            if (!readSome) {
                this.unreadChar(jsonText);
                this.error = LexError.MISSING_INTEGER_AFTER_DECIMAL;
                return TokenType.ERROR;
            }
            tok = TokenType.DOUBLE;
        }
        if (c == 101 || c == 69) {
            if (jsonText.remaining() == 0L) {
                return TokenType.EOF;
            }
            c = this.readChar(jsonText);
            if (c == 43 || c == 45) {
                if (jsonText.remaining() == 0L) {
                    return TokenType.EOF;
                }
                c = this.readChar(jsonText);
            }
            if (c >= 48 && c <= 57) {
                do {
                    if (jsonText.remaining() != 0L) continue;
                    return TokenType.EOF;
                } while ((c = this.readChar(jsonText)) >= 48 && c <= 57);
            } else {
                this.unreadChar(jsonText);
                this.error = LexError.MISSING_INTEGER_AFTER_EXPONENT;
                return TokenType.ERROR;
            }
            tok = TokenType.DOUBLE;
        }
        this.unreadChar(jsonText);
        return tok;
    }

    private TokenType lexComment(Bytes jsonText) {
        TokenType tok = TokenType.COMMENT;
        if (jsonText.remaining() == 0L) {
            return TokenType.EOF;
        }
        int c = this.readChar(jsonText);
        if (c == 47) {
            do {
                if (jsonText.remaining() != 0L) continue;
                return TokenType.EOF;
            } while ((c = this.readChar(jsonText)) != 10);
        } else if (c == 42) {
            while (true) {
                if (jsonText.remaining() == 0L) {
                    return TokenType.EOF;
                }
                c = this.readChar(jsonText);
                if (c != 42) continue;
                if (jsonText.remaining() == 0L) {
                    return TokenType.EOF;
                }
                c = this.readChar(jsonText);
                if (c != 47) {
                    this.unreadChar(jsonText);
                    continue;
                }
                break;
            }
        } else {
            this.error = LexError.INVALID_CHAR;
            tok = TokenType.ERROR;
        }
        return tok;
    }

    TokenType lex(Bytes jsonText) {
        TokenType tok;
        long startOffset = jsonText.position();
        this.outBuf = null;
        this.outPos = 0L;
        this.outLen = 0L;
        block15: while (true) {
            if (jsonText.remaining() == 0L) {
                tok = TokenType.EOF;
                break;
            }
            int c = this.readChar(jsonText);
            switch (c) {
                case 123: {
                    tok = TokenType.LEFT_BRACKET;
                    break block15;
                }
                case 125: {
                    tok = TokenType.RIGHT_BRACKET;
                    break block15;
                }
                case 91: {
                    tok = TokenType.LEFT_BRACE;
                    break block15;
                }
                case 93: {
                    tok = TokenType.RIGHT_BRACE;
                    break block15;
                }
                case 44: {
                    tok = TokenType.COMMA;
                    break block15;
                }
                case 58: {
                    tok = TokenType.COLON;
                    break block15;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    ++startOffset;
                    continue block15;
                }
                case 116: {
                    for (char want : RUE_CHARS) {
                        if (jsonText.remaining() == 0L) {
                            tok = TokenType.EOF;
                            break block15;
                        }
                        c = this.readChar(jsonText);
                        if (c == want) continue;
                        this.unreadChar(jsonText);
                        this.error = LexError.INVALID_STRING;
                        tok = TokenType.ERROR;
                        break block15;
                    }
                    tok = TokenType.BOOL;
                    break block15;
                }
                case 102: {
                    for (char want : ALSE_CHARS) {
                        if (jsonText.remaining() == 0L) {
                            tok = TokenType.EOF;
                            break block15;
                        }
                        c = this.readChar(jsonText);
                        if (c == want) continue;
                        this.unreadChar(jsonText);
                        this.error = LexError.INVALID_STRING;
                        tok = TokenType.ERROR;
                        break block15;
                    }
                    tok = TokenType.BOOL;
                    break block15;
                }
                case 110: {
                    for (char want : ULL_CHARS) {
                        if (jsonText.remaining() == 0L) {
                            tok = TokenType.EOF;
                            break block15;
                        }
                        c = this.readChar(jsonText);
                        if (c == want) continue;
                        this.unreadChar(jsonText);
                        this.error = LexError.INVALID_STRING;
                        tok = TokenType.ERROR;
                        break block15;
                    }
                    tok = TokenType.NULL;
                    break block15;
                }
                case 34: {
                    tok = this.lexString(jsonText);
                    break block15;
                }
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.unreadChar(jsonText);
                    tok = this.lexNumber(jsonText);
                    break block15;
                }
                case 47: {
                    if (!this.allowComments) {
                        this.unreadChar(jsonText);
                        this.error = LexError.UNALLOWED_COMMENT;
                        tok = TokenType.ERROR;
                        break block15;
                    }
                    tok = this.lexComment(jsonText);
                    if (tok != TokenType.COMMENT) break block15;
                    this.buf.reset();
                    this.bufInUse = false;
                    startOffset = jsonText.position();
                    continue block15;
                }
                default: {
                    this.error = LexError.INVALID_CHAR;
                    tok = TokenType.ERROR;
                    break block15;
                }
            }
            break;
        }
        if (tok == TokenType.EOF || this.bufInUse) {
            if (!this.bufInUse) {
                this.buf.reset();
                this.bufInUse = true;
            }
            this.buf.append((RandomDataInput)jsonText, startOffset, jsonText.position() - startOffset);
            this.buf.position(0L);
            if (tok != TokenType.EOF) {
                this.outBuf = this.buf;
                this.outPos = 0L;
                this.outLen = this.buf.limit();
                this.bufInUse = false;
            }
        } else if (tok != TokenType.ERROR) {
            this.outBuf = jsonText;
            this.outPos = startOffset;
            this.outLen = jsonText.position() - startOffset;
        }
        if (tok == TokenType.STRING || tok == TokenType.STRING_WITH_ESCAPES) {
            assert (this.outLen >= 2L);
            ++this.outPos;
            this.outLen -= 2L;
        }
        if (LOG.isDebugEnabled()) {
            if (tok == TokenType.ERROR) {
                LOG.debug("lexical error: " + (Object)((Object)this.error));
            } else if (tok == TokenType.EOF) {
                LOG.debug("EOF hit");
            } else {
                LOG.debug("lexed %s: '" + (Object)((Object)tok) + this.outBuf.bytes(this.outPos, this.outLen) + "'");
            }
        }
        return tok;
    }
}

