/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.nio.BufferUnderflowException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.util.UTF8StringInterner;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BinaryIntReference;
import net.openhft.chronicle.wire.BinaryLongArrayReference;
import net.openhft.chronicle.wire.BinaryLongReference;
import net.openhft.chronicle.wire.BinaryWireCode;
import net.openhft.chronicle.wire.InternalWireIn;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.util.BooleanConsumer;
import net.openhft.chronicle.wire.util.ByteConsumer;
import net.openhft.chronicle.wire.util.FloatConsumer;
import net.openhft.chronicle.wire.util.ShortConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryWire
implements Wire,
InternalWireIn {
    private static final int ANY_CODE_MATCH = -1;
    private static final int END_OF_BYTES = -1;
    private static final UTF8StringInterner UTF8_INTERNER = new UTF8StringInterner(128);
    private final Bytes<?> bytes;
    private final ValueOut fixedValueOut = new FixedBinaryValueOut();
    @NotNull
    private final ValueOut valueOut;
    private final BinaryValueIn valueIn = new BinaryValueIn();
    private final boolean numericFields;
    private final boolean fieldLess;
    private boolean ready;

    public BinaryWire(Bytes bytes) {
        this(bytes, false, false, false);
    }

    public BinaryWire(Bytes bytes, boolean fixed, boolean numericFields, boolean fieldLess) {
        this.numericFields = numericFields;
        this.fieldLess = fieldLess;
        this.bytes = bytes;
        this.valueOut = fixed ? this.fixedValueOut : new BinaryValueOut();
    }

    public static int toIntU30(long l, @NotNull String error) {
        if (l < 0L || l > 0x3FFFFFFFL) {
            throw new IllegalStateException(String.format(error, l));
        }
        return (int)l;
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void setReady(boolean ready) {
        this.ready = ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(@NotNull WireOut wire) {
        block18: while (this.bytes.readRemaining() > 0L) {
            int peekCode = this.peekCode();
            block1 : switch (peekCode >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.bytes.readSkip(1L);
                    wire.writeValue().uint8(peekCode);
                    break;
                }
                case 8: {
                    switch (peekCode) {
                        case 143: {
                            this.bytes.readSkip(1L);
                            break block1;
                        }
                        case 142: {
                            this.bytes.readSkip(1L);
                            this.bytes.readSkip(this.bytes.readUnsignedInt());
                            break block1;
                        }
                        case 130: {
                            this.bytes.readSkip(1L);
                            int len = this.bytes.readInt();
                            long lim = this.bytes.readLimit();
                            try {
                                this.bytes.readLimit(this.bytes.readPosition() + (long)len);
                                if (this.isFieldNext()) {
                                    wire.writeValue().marshallable(w -> this.copyTo(w));
                                    continue block18;
                                }
                                wire.writeValue().sequence(v -> this.copyTo(v.wireOut()));
                                continue block18;
                            }
                            finally {
                                this.bytes.readLimit(lim);
                                continue block18;
                            }
                        }
                        case 138: {
                            this.bytes.readSkip(1L);
                            wire.writeValue().bytes((BytesStore)this.bytes);
                            break block1;
                        }
                    }
                    throw new UnsupportedOperationException("peekCode=" + BinaryWireCode.stringForCode(peekCode));
                }
                case 9: {
                    this.bytes.readSkip(1L);
                    Double d = this.readFloat0(peekCode);
                    wire.writeValue().object(d);
                    break;
                }
                case 10: {
                    this.bytes.readSkip(1L);
                    Number l = this.readInt0object(peekCode);
                    wire.writeValue().object(l);
                    break;
                }
                case 11: {
                    this.copySpecial(wire, peekCode);
                    break;
                }
                case 12: 
                case 13: {
                    StringBuilder fsb = this.readField(peekCode, -1, Wires.acquireStringBuilder());
                    wire.write(() -> fsb);
                    break;
                }
                case 14: 
                case 15: {
                    this.bytes.readSkip(1L);
                    StringBuilder sb = this.readText(peekCode, Wires.acquireStringBuilder());
                    wire.writeValue().text(sb);
                }
            }
        }
    }

    private boolean isFieldNext() {
        int peekCode = this.peekCode();
        return peekCode == 183 || peekCode >= 192 && peekCode <= 223;
    }

    @Override
    @NotNull
    public ValueIn read() {
        this.readField(Wires.acquireStringBuilder(), -1);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        long position = this.bytes.readPosition();
        StringBuilder sb = this.readField(Wires.acquireStringBuilder(), key.code());
        if (this.fieldLess || sb != null && (sb.length() == 0 || StringUtils.isEqual((CharSequence)sb, (CharSequence)key.name()))) {
            return this.valueIn;
        }
        return this.unorderedField(key, position, sb);
    }

    @NotNull
    private ValueIn unorderedField(@NotNull WireKey key, long position, @Nullable StringBuilder sb) {
        this.bytes.readPosition(position);
        if (sb == null) {
            sb = Wires.acquireStringBuilder();
        }
        this.readEventName(sb);
        throw new UnsupportedOperationException("Unordered fields not supported yet, Expected=" + key.name() + " was: '" + sb + "'");
    }

    @Override
    @NotNull
    public ValueIn readEventName(@NotNull StringBuilder name) {
        this.readField(name, -1);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.readField(name, -1);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    public boolean hasMore() {
        this.consumeSpecial();
        return this.bytes.readRemaining() > 0L;
    }

    @Nullable
    private StringBuilder readField(@NotNull StringBuilder name, int codeMatch) {
        this.consumeSpecial();
        int peekCode = this.peekCode();
        return this.readField(peekCode, codeMatch, name);
    }

    void consumeSpecial() {
        this.consumeSpecial(false);
    }

    void consumeSpecial(boolean consumeType) {
        block6: while (true) {
            int code = this.peekCode();
            switch (code) {
                case 143: {
                    this.bytes.readSkip(1L);
                    continue block6;
                }
                case 142: {
                    this.bytes.readSkip(1L);
                    this.bytes.readSkip(this.bytes.readUnsignedInt());
                    continue block6;
                }
                case 182: {
                    if (!consumeType) {
                        return;
                    }
                }
                case 190: 
                case 191: {
                    this.bytes.readSkip(1L);
                    StringBuilder sb = Wires.acquireStringBuilder();
                    this.bytes.readUTF\u0394((Appendable)sb);
                    continue block6;
                }
            }
            break;
        }
    }

    private int peekCode() {
        if (this.bytes.readRemaining() < 1L) {
            return -1;
        }
        long pos = this.bytes.readPosition();
        return this.bytes.readUnsignedByte(pos);
    }

    private StringBuilder readField(int peekCode, int codeMatch, @NotNull StringBuilder sb) {
        sb.setLength(0);
        switch (peekCode >> 4) {
            case -1: {
                break;
            }
            case 11: {
                return this.readSpecialField(peekCode, codeMatch, sb);
            }
            case 12: 
            case 13: {
                this.bytes.readSkip(1L);
                if (this.bytes.bytesStore() instanceof NativeBytesStore) {
                    BytesUtil.parse8bit_SB1(this.bytes, (StringBuilder)sb, (int)(peekCode & 0x1F));
                } else {
                    BytesUtil.parse8bit(this.bytes, (Appendable)sb, (int)(peekCode & 0x1F));
                }
                return sb;
            }
        }
        if (this.fieldLess) {
            return sb;
        }
        return null;
    }

    @Nullable
    private StringBuilder readSpecialField(int peekCode, int codeMatch, @NotNull StringBuilder sb) {
        if (peekCode == 186) {
            this.bytes.readSkip(1L);
            long fieldId = this.bytes.readStopBit();
            if (codeMatch >= 0 && fieldId != (long)codeMatch) {
                throw new UnsupportedOperationException("Field was: " + fieldId + " expected " + codeMatch);
            }
            if (codeMatch < 0) {
                sb.append(fieldId);
            }
            return sb;
        }
        if (peekCode == 183 || peekCode == 185) {
            this.bytes.readSkip(1L);
            this.bytes.readUTF\u0394((Appendable)sb);
            return sb;
        }
        return null;
    }

    @NotNull
    private <ACS extends Appendable & CharSequence> ACS getStringBuilder(int code, @NotNull ACS sb) {
        BytesUtil.setLength(sb, (int)0);
        BytesUtil.parseUTF(this.bytes, sb, (int)(code & 0x1F));
        return sb;
    }

    private void copySpecial(@NotNull WireOut wire, int peekCode) {
        switch (peekCode) {
            case 190: {
                this.bytes.readSkip(1L);
                StringBuilder sb = Wires.acquireStringBuilder();
                this.bytes.readUTF\u0394((Appendable)sb);
                wire.writeComment(sb);
                break;
            }
            case 191: {
                this.bytes.readSkip(1L);
                StringBuilder sb = Wires.acquireStringBuilder();
                this.bytes.readUTF\u0394((Appendable)sb);
                break;
            }
            case 178: 
            case 180: 
            case 181: {
                throw new UnsupportedOperationException();
            }
            case 182: {
                this.bytes.readSkip(1L);
                StringBuilder sb = Wires.acquireStringBuilder();
                this.bytes.readUTF\u0394((Appendable)sb);
                wire.writeValue().type(sb);
                break;
            }
            case 188: {
                this.bytes.readSkip(1L);
                StringBuilder sb = Wires.acquireStringBuilder();
                this.bytes.readUTF\u0394((Appendable)sb);
                wire.writeValue().typeLiteral(sb);
                break;
            }
            case 183: 
            case 185: {
                StringBuilder fsb = this.readField(peekCode, -1, Wires.acquireStringBuilder());
                wire.write(() -> fsb);
                break;
            }
            case 184: {
                this.bytes.readSkip(1L);
                StringBuilder sb1 = Wires.acquireStringBuilder();
                this.bytes.readUTF\u0394((Appendable)sb1);
                wire.writeValue().text(sb1);
                break;
            }
            case 186: {
                this.bytes.readSkip(1L);
                final long code2 = this.bytes.readStopBit();
                wire.write(new WireKey(){

                    @Override
                    @Nullable
                    public String name() {
                        return null;
                    }

                    @Override
                    public int code() {
                        return (int)code2;
                    }
                });
                break;
            }
            case 187: {
                this.bytes.readSkip(1L);
                wire.writeValue().bool(null);
                break;
            }
            case 176: {
                this.bytes.readSkip(1L);
                wire.writeValue().bool(false);
                break;
            }
            case 177: {
                this.bytes.readSkip(1L);
                wire.writeValue().bool(true);
                break;
            }
            default: {
                throw new UnsupportedOperationException(BinaryWireCode.stringForCode(peekCode));
            }
        }
    }

    private long readInt(int code) {
        if (code < 128) {
            return code;
        }
        switch (code >> 4) {
            case 11: {
                switch (code) {
                    case 176: {
                        return 0L;
                    }
                    case 177: {
                        return 1L;
                    }
                }
                break;
            }
            case 9: {
                double d = this.readFloat0(code);
                return (long)d;
            }
            case 10: {
                return this.readInt0(code);
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private double readFloat0(int code) {
        if (code < 128 && code >= 0) {
            return code;
        }
        switch (code) {
            case 144: {
                return this.bytes.readFloat();
            }
            case 145: {
                return this.bytes.readDouble();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private Number readFloat0object(int code) {
        if (code < 128 && code >= 0) {
            return code;
        }
        switch (code) {
            case 144: {
                return Float.valueOf(this.bytes.readFloat());
            }
            case 145: {
                return this.bytes.readDouble();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private long readInt0(int code) {
        if (this.isSmallInt(code)) {
            return code;
        }
        switch (code) {
            case 164: {
                return this.bytes.readByte();
            }
            case 161: {
                return this.bytes.readUnsignedByte();
            }
            case 165: {
                return this.bytes.readShort();
            }
            case 162: {
                return this.bytes.readUnsignedShort();
            }
            case 166: {
                return this.bytes.readInt();
            }
            case 163: {
                return this.bytes.readUnsignedInt();
            }
            case 167: {
                return this.bytes.readLong();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private Number readInt0object(int code) {
        if (this.isSmallInt(code)) {
            return code;
        }
        switch (code) {
            case 164: {
                return this.bytes.readByte();
            }
            case 161: {
                return this.bytes.readUnsignedByte();
            }
            case 165: {
                return this.bytes.readShort();
            }
            case 162: {
                return this.bytes.readUnsignedShort();
            }
            case 166: {
                return this.bytes.readInt();
            }
            case 163: {
                return this.bytes.readUnsignedInt();
            }
            case 167: {
                return this.bytes.readLong();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private boolean isSmallInt(int code) {
        return (code & 0x80) == 0;
    }

    private double readFloat(int code) {
        if (code < 128) {
            return code;
        }
        switch (code >> 4) {
            case 9: {
                return this.readFloat0(code);
            }
            case 10: {
                return this.readInt0(code);
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    @Override
    @NotNull
    public ValueOut write() {
        if (!this.fieldLess) {
            this.writeField("");
        }
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut writeEventName(@NotNull WireKey key) {
        this.writeCode(185).writeUTF\u0394(key.name());
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        if (!this.fieldLess) {
            if (this.numericFields) {
                this.writeField(key.code());
            } else {
                this.writeField(key.name());
            }
        }
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut writeValue() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public Wire writeComment(CharSequence s) {
        this.writeCode(190);
        this.bytes.writeUTF\u0394(s);
        return this;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        if (paddingToAdd < 0) {
            throw new IllegalStateException("Cannot add " + paddingToAdd + " bytes of padding");
        }
        if (paddingToAdd >= 5) {
            this.writeCode(142).writeUnsignedInt((long)(paddingToAdd - 5)).writeSkip((long)(paddingToAdd - 5));
        } else {
            for (int i = 0; i < paddingToAdd; ++i) {
                this.writeCode(143);
            }
        }
        return this;
    }

    private void writeField(@NotNull CharSequence name) {
        int len = name.length();
        if (len < 32) {
            if (len > 0 && Character.isDigit(name.charAt(0))) {
                try {
                    this.writeField(Integer.parseInt(name.toString()));
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ((Bytes)this.bytes.writeByte((byte)(192 + len))).write(name);
        } else {
            this.writeCode(183).write8bit(name);
        }
    }

    private void writeField(int code) {
        this.writeCode(186);
        this.bytes.writeStopBit((long)code);
    }

    private Bytes writeCode(int code) {
        return (Bytes)this.bytes.writeByte((byte)code);
    }

    @Nullable
    <ACS extends Appendable & CharSequence> ACS readText(int code, @NotNull ACS sb) {
        if (code <= 127) {
            BytesUtil.append(sb, (long)code);
            return sb;
        }
        switch (code >> 4) {
            case 8: {
                switch (code) {
                    case 130: {
                        if (!(sb instanceof StringBuilder)) {
                            throw new AssertionError();
                        }
                        this.bytes.readSkip(-1L);
                        this.valueIn.bytesStore((StringBuilder)sb);
                        return sb;
                    }
                }
            }
            case 11: {
                switch (code) {
                    case 187: {
                        BytesUtil.append(sb, (String)"null");
                        return sb;
                    }
                    case 177: {
                        BytesUtil.append(sb, (String)"true");
                        return sb;
                    }
                    case 176: {
                        BytesUtil.append(sb, (String)"false");
                        return sb;
                    }
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 184: 
                    case 188: {
                        if (this.bytes.readUTF\u0394(sb)) {
                            return sb;
                        }
                        return null;
                    }
                }
                return null;
            }
            case 9: {
                BytesUtil.append(sb, (double)this.readFloat(code));
                return sb;
            }
            case 10: {
                BytesUtil.append(sb, (long)this.readInt(code));
                return sb;
            }
            case 14: 
            case 15: {
                return this.getStringBuilder(code, sb);
            }
        }
        throw new UnsupportedOperationException("code=0x" + String.format("%02X ", code).trim());
    }

    private int readCode() {
        if (this.bytes.readRemaining() < 1L) {
            return -1;
        }
        return this.bytes.readUnsignedByte();
    }

    @NotNull
    public String toString() {
        return this.bytes.toDebugString();
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return new BinaryLongReference();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return new BinaryIntReference();
    }

    @Override
    @NotNull
    public BinaryLongArrayReference newLongArrayReference() {
        return new BinaryLongArrayReference();
    }

    class BinaryValueIn
    implements ValueIn {
        BinaryValueIn() {
        }

        @Override
        @NotNull
        public WireIn bool(@NotNull BooleanConsumer flag) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 187: {
                    flag.accept(null);
                    break;
                }
                case 176: {
                    flag.accept(false);
                    break;
                }
                case 177: {
                    flag.accept(true);
                    break;
                }
                default: {
                    return this.cantRead(code);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn text(@NotNull Consumer<String> s) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 187: {
                    s.accept(null);
                    break;
                }
                case 184: {
                    s.accept(BinaryWire.this.bytes.readUTF\u0394());
                    break;
                }
                default: {
                    if (code >= 224 && code <= 255) {
                        StringBuilder sb = Wires.acquireStringBuilder();
                        BytesUtil.parseUTF((StreamingDataInput)BinaryWire.this.bytes, (Appendable)sb, (int)(code & 0x1F));
                        s.accept(Wires.INTERNER.intern((CharSequence)sb));
                        break;
                    }
                    this.cantRead(code);
                }
            }
            return BinaryWire.this;
        }

        private boolean isText(int code) {
            return code == 184 || code >= 224 && code <= 255;
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder sb) {
            boolean wasNull;
            int code = BinaryWire.this.readCode();
            boolean bl = wasNull = code == 187;
            if (wasNull) {
                sb.setLength(0);
                return null;
            }
            StringBuilder text = BinaryWire.this.readText(code, sb);
            if (text == null) {
                this.cantRead(code);
            }
            return sb;
        }

        @Override
        @Nullable
        public Bytes textTo(@NotNull Bytes bytes) {
            boolean wasNull;
            int code = BinaryWire.this.readCode();
            boolean bl = wasNull = code == 187;
            if (wasNull) {
                bytes.readPosition(0L);
                return null;
            }
            Bytes text = BinaryWire.this.readText(code, bytes);
            if (text == null) {
                this.cantRead(code);
            }
            return bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public String text() {
            boolean wasNull;
            int code = BinaryWire.this.readCode();
            boolean bl = wasNull = code == 187;
            if (wasNull) {
                return null;
            }
            if (code == 184) {
                long len0 = BytesUtil.readStopBit((StreamingDataInput)BinaryWire.this.bytes);
                if (len0 == -1L) {
                    return null;
                }
                int len = Maths.toUInt31((long)len0);
                long limit = BinaryWire.this.bytes.readLimit();
                try {
                    BinaryWire.this.bytes.readLimit(BinaryWire.this.bytes.readPosition() + (long)len);
                    String string = UTF8_INTERNER.intern(BinaryWire.this.bytes);
                    return string;
                }
                finally {
                    BinaryWire.this.bytes.readPosition(BinaryWire.this.bytes.readLimit());
                    BinaryWire.this.bytes.readLimit(limit);
                }
            }
            StringBuilder text = BinaryWire.this.readText(code, Wires.acquireStringBuilder());
            if (text == null) {
                this.cantRead(code);
            }
            return Wires.INTERNER.intern((CharSequence)text);
        }

        @Override
        @NotNull
        public WireIn int8(@NotNull ByteConsumer i) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.bytes.readUnsignedByte();
            if (this.isText(code)) {
                i.accept(Byte.valueOf(this.text()));
            } else {
                i.accept((byte)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @NotNull
        public WireIn bytes(@NotNull Bytes toBytes) {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            toBytes.clear();
            BinaryWire.this.bytes.readWithLength(length - 1L, b -> toBytes.write((BytesStore)b));
            return this.wireIn();
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore compareBytes, @NotNull BooleanConsumer consumer) {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            if (compareBytes.readRemaining() == --length) {
                consumer.accept(BinaryWire.this.bytes.equalBytes(compareBytes, length));
            } else {
                consumer.accept(false);
            }
            BinaryWire.this.bytes.readSkip(length);
            return this.wireIn();
        }

        @Override
        @NotNull
        public BytesStore bytesStore() {
            long length = this.readLength() - 1L;
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            NativeBytesStore toBytes = NativeBytesStore.nativeStore((long)length);
            toBytes.write(0L, (RandomDataInput)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            BinaryWire.this.bytes.readSkip(length);
            return toBytes;
        }

        public void bytesStore(@NotNull StringBuilder sb) {
            sb.setLength(0);
            long length = this.readLength() - 1L;
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            for (long i = 0L; i < length; ++i) {
                sb.append((char)BinaryWire.this.bytes.readUnsignedByte());
            }
        }

        public void bytesStore(@NotNull Bytes toBytes) {
            toBytes.clear();
            long length = this.readLength() - 1L;
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            toBytes.write(0L, (RandomDataInput)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            toBytes.readLimit(length);
            BinaryWire.this.bytes.readSkip(length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadMarshallable bytesConsumer) {
            long length = this.readLength() - 1L;
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            if (length > BinaryWire.this.bytes.readRemaining()) {
                throw new BufferUnderflowException();
            }
            long limit0 = BinaryWire.this.bytes.readLimit();
            long limit = BinaryWire.this.bytes.readPosition() + length;
            try {
                BinaryWire.this.bytes.readLimit(limit);
                bytesConsumer.readMarshallable(this.wireIn());
            }
            finally {
                BinaryWire.this.bytes.readLimit(limit0);
                BinaryWire.this.bytes.readPosition(limit);
            }
            return this.wireIn();
        }

        @Override
        @NotNull
        public byte[] bytes() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return BinaryWire.this;
        }

        @Override
        public long readLength() {
            int code = BinaryWire.this.peekCode();
            switch (code) {
                case 130: {
                    BinaryWire.this.bytes.readSkip(1L);
                    return BinaryWire.this.bytes.readUnsignedInt();
                }
            }
            return -1L;
        }

        @Override
        @NotNull
        public WireIn uint8(@NotNull ShortConsumer i) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                i.accept(Short.valueOf(this.text()));
            } else {
                i.accept((short)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn int16(@NotNull ShortConsumer i) {
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                i.accept(Short.valueOf(this.text()));
            } else {
                i.accept((short)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn uint16(@NotNull IntConsumer i) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                i.accept(Integer.valueOf(this.text()));
            } else {
                i.accept((int)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn int32(@NotNull IntConsumer i) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                i.accept(Integer.valueOf(this.text()));
            } else {
                i.accept((int)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn uint32(@NotNull LongConsumer i) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                i.accept(Long.valueOf(this.text()));
            } else {
                i.accept(BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(@NotNull LongConsumer i) {
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                i.accept(Long.valueOf(this.text()));
            } else {
                i.accept(BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn float32(@NotNull FloatConsumer v) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                v.accept(Float.valueOf(this.text()).floatValue());
            } else {
                v.accept((float)BinaryWire.this.readFloat(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn float64(@NotNull DoubleConsumer v) {
            int code = BinaryWire.this.readCode();
            v.accept(BinaryWire.this.readFloat(code));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn time(@NotNull Consumer<LocalTime> localTime) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 178) {
                localTime.accept(this.readLocalTime());
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        private LocalTime readLocalTime() {
            StringBuilder sb = Wires.acquireStringBuilder();
            BinaryWire.this.bytes.readUTF\u0394((Appendable)sb);
            return LocalTime.parse(sb);
        }

        @Override
        @NotNull
        public WireIn zonedDateTime(@NotNull Consumer<ZonedDateTime> zonedDateTime) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 181) {
                StringBuilder sb = Wires.acquireStringBuilder();
                BinaryWire.this.bytes.readUTF\u0394((Appendable)sb);
                zonedDateTime.accept(ZonedDateTime.parse(sb));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn date(@NotNull Consumer<LocalDate> localDate) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 180) {
                StringBuilder sb = Wires.acquireStringBuilder();
                BinaryWire.this.bytes.readUTF\u0394((Appendable)sb);
                localDate.accept(LocalDate.parse(sb));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        public boolean hasNext() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public boolean hasNextSequenceItem() {
            return BinaryWire.this.bytes.readRemaining() > 0L;
        }

        @Override
        @NotNull
        public WireIn uuid(@NotNull Consumer<UUID> uuid) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 160) {
                uuid.accept(new UUID(BinaryWire.this.bytes.readLong(), BinaryWire.this.bytes.readLong()));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn int64array(@Nullable LongArrayValues values, @NotNull Consumer<LongArrayValues> setter) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 141) {
                if (!(values instanceof BinaryLongArrayReference)) {
                    values = new BinaryLongArrayReference();
                    setter.accept(values);
                }
                Byteable b = (Byteable)values;
                long length = BinaryLongArrayReference.peakLength((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition());
                b.bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
                BinaryWire.this.bytes.readSkip(length);
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(LongValue value) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code != 167) {
                this.cantRead(code);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            BinaryWire.this.bytes.readSkip(length);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(LongValue value, @NotNull Consumer<LongValue> setter) {
            if (!(value instanceof BinaryLongReference)) {
                value = new BinaryLongReference();
                setter.accept(value);
            }
            return this.int64(value);
        }

        @Override
        @NotNull
        public WireIn int32(IntValue value, @NotNull Consumer<IntValue> setter) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code != 166) {
                this.cantRead(code);
            }
            if (!(value instanceof Byteable) || ((Byteable)value).maxSize() != 4L) {
                value = new BinaryIntReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            BinaryWire.this.bytes.readSkip(length);
            return BinaryWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn sequence(@NotNull Consumer<ValueIn> reader) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code != 130) {
                this.cantRead(code);
            }
            int length = BinaryWire.this.bytes.readInt();
            long limit = BinaryWire.this.bytes.readLimit();
            long limit2 = BinaryWire.this.bytes.readPosition() + (long)length;
            BinaryWire.this.bytes.readLimit(limit2);
            try {
                reader.accept(this);
            }
            finally {
                BinaryWire.this.bytes.readLimit(limit);
                BinaryWire.this.bytes.readPosition(limit2);
            }
            return BinaryWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            BinaryWire.this.consumeSpecial();
            long length = this.readLength();
            if (length >= 0L) {
                long limit = BinaryWire.this.bytes.readLimit();
                long limit2 = BinaryWire.this.bytes.readPosition() + length;
                BinaryWire.this.bytes.readLimit(limit2);
                try {
                    T t = marshallableReader.apply(BinaryWire.this);
                    return t;
                }
                finally {
                    BinaryWire.this.bytes.readLimit(limit);
                    BinaryWire.this.bytes.readPosition(limit2);
                }
            }
            return marshallableReader.apply(BinaryWire.this);
        }

        @Override
        @Nullable
        public <T extends ReadMarshallable> T typedMarshallable() {
            StringBuilder sb = Wires.acquireStringBuilder();
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 182: {
                    BinaryWire.this.bytes.readUTF\u0394((Appendable)sb);
                    Class clazz = ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb);
                    if (!Marshallable.class.isAssignableFrom(clazz)) {
                        throw new IllegalStateException("its not possible to Marshallable and object that is not of type Marshallable, type=" + sb);
                    }
                    ReadMarshallable m = (ReadMarshallable)OS.memory().allocateInstance(clazz);
                    this.marshallable(m);
                    return (T)((ReadMarshallable)ReadResolvable.readResolve((Object)m));
                }
                case 187: {
                    return null;
                }
            }
            this.cantRead(code);
            return null;
        }

        @Override
        @NotNull
        public ValueIn type(@NotNull StringBuilder s) {
            int code = BinaryWire.this.readCode();
            if (code == 182) {
                BinaryWire.this.bytes.readUTF\u0394((Appendable)s);
            } else if (code == 187) {
                s.setLength(0);
                s.append("!null");
            } else {
                this.cantRead(code);
            }
            return this;
        }

        @Override
        @NotNull
        public WireIn typeLiteralAsText(@NotNull Consumer<CharSequence> classNameConsumer) {
            int code = BinaryWire.this.readCode();
            if (code == 188) {
                StringBuilder sb = Wires.acquireStringBuilder();
                BinaryWire.this.bytes.readUTF\u0394((Appendable)sb);
                classNameConsumer.accept(sb);
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn marshallable(@NotNull ReadMarshallable object) {
            BinaryWire.this.consumeSpecial(true);
            long length = this.readLength();
            if (length >= 0L) {
                long limit = BinaryWire.this.bytes.readLimit();
                long limit2 = BinaryWire.this.bytes.readPosition() + length;
                BinaryWire.this.bytes.readLimit(limit2);
                try {
                    object.readMarshallable(BinaryWire.this);
                }
                finally {
                    BinaryWire.this.bytes.readLimit(limit);
                    BinaryWire.this.bytes.readPosition(limit2);
                }
            } else {
                object.readMarshallable(BinaryWire.this);
            }
            return BinaryWire.this;
        }

        @Override
        public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public <K, V> Map<K, V> map(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException("todo");
        }

        private long readTextAsLong() {
            BinaryWire.this.bytes.readSkip(-1L);
            String text = this.text();
            if (text == null) {
                throw new NullPointerException();
            }
            try {
                return Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                return Math.round(Double.parseDouble(text));
            }
        }

        private double readTextAsDouble() {
            BinaryWire.this.bytes.readSkip(-1L);
            String text = this.text();
            if (text == null || text.length() == 0) {
                return Double.NaN;
            }
            return Double.parseDouble(text);
        }

        @Override
        public boolean bool() {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                return Boolean.valueOf(this.text());
            }
            switch (code) {
                case 177: {
                    return true;
                }
                case 176: {
                    return false;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public byte int8() {
            long value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > 127L || value < -128L) {
                throw new IllegalStateException();
            }
            return (byte)value;
        }

        @Override
        public short int16() {
            long value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > 32767L || value < -32768L) {
                throw new IllegalStateException();
            }
            return (short)value;
        }

        @Override
        public int uint16() {
            long value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > 0x100000000L || value < 0L) {
                throw new IllegalStateException();
            }
            return (int)value;
        }

        @Override
        public int int32() {
            long value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                throw new IllegalStateException();
            }
            return (int)value;
        }

        @Override
        public long int64() {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code >> 4 == 9) {
                return (long)BinaryWire.this.readFloat0(code);
            }
            return this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
        }

        @Override
        public double float64() {
            int code = BinaryWire.this.readCode();
            if (code >> 4 == 9) {
                return BinaryWire.this.readFloat0(code);
            }
            return this.isText(code) ? this.readTextAsDouble() : (double)BinaryWire.this.readInt0(code);
        }

        @Override
        public float float32() {
            double value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            double d = value = this.isText(code) ? this.readTextAsDouble() : BinaryWire.this.readFloat0(code);
            if (Double.isFinite(value) && (value > 3.4028234663852886E38 || value < (double)1.4E-45f)) {
                throw new IllegalStateException("Cannot convert " + value + " to float");
            }
            return (float)value;
        }

        @NotNull
        private WireIn cantRead(int code) {
            throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
        }

        @Override
        @Nullable
        public <E> E object(@Nullable E using, @NotNull Class<E> clazz) {
            return (E)ObjectUtils.convertTo(clazz, (Object)this.object0(using, clazz));
        }

        @Override
        @Nullable
        public <E> WireIn object(@NotNull Class<E> clazz, @NotNull Consumer<E> e) {
            e.accept(ObjectUtils.convertTo(clazz, (Object)this.object0(null, clazz)));
            return BinaryWire.this;
        }

        @Nullable
        Object object0(@Nullable Object using, @NotNull Class clazz) {
            if (ReadMarshallable.class.isAssignableFrom(clazz)) {
                Object v = using == null ? OS.memory().allocateInstance(clazz) : using;
                this.marshallable((ReadMarshallable)v);
                return ReadResolvable.readResolve((Object)v);
            }
            if (CharSequence.class.isAssignableFrom(clazz)) {
                if (StringBuilder.class.isAssignableFrom(clazz)) {
                    StringBuilder builder = using == null ? Wires.acquireStringBuilder() : (StringBuilder)using;
                    this.textTo(builder);
                    return builder;
                }
                return this.text();
            }
            if (Map.class.isAssignableFrom(clazz)) {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                this.map(result);
                return result;
            }
            if (byte[].class.isAssignableFrom(clazz)) {
                return this.bytes();
            }
            return this.object(using);
        }

        @Nullable
        private Object object(@Nullable Object using) {
            int code = BinaryWire.this.peekCode();
            if ((code & 0x80) == 0) {
                BinaryWire.this.bytes.readSkip(1L);
                return code;
            }
            switch (code >> 4) {
                case 8: {
                    switch (code) {
                        case 130: {
                            if (using instanceof StringBuilder) {
                                this.bytesStore((StringBuilder)using);
                                return using;
                            }
                            if (using instanceof Bytes) {
                                this.bytesStore((Bytes)using);
                                return using;
                            }
                            return this.bytesStore();
                        }
                    }
                    break;
                }
                case 11: {
                    switch (code) {
                        case 176: {
                            BinaryWire.this.bytes.readSkip(1L);
                            return Boolean.FALSE;
                        }
                        case 177: {
                            BinaryWire.this.bytes.readSkip(1L);
                            return Boolean.TRUE;
                        }
                        case 187: {
                            BinaryWire.this.bytes.readSkip(1L);
                            return null;
                        }
                        case 184: {
                            return this.text();
                        }
                        case 182: {
                            BinaryWire.this.readCode();
                            StringBuilder sb = Wires.acquireStringBuilder();
                            BinaryWire.this.bytes.readUTF\u0394((Appendable)sb);
                            Class clazz2 = ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb);
                            return this.object(null, clazz2);
                        }
                    }
                    break;
                }
                case 9: {
                    return BinaryWire.this.readFloat0object(code);
                }
                case 10: {
                    return BinaryWire.this.readInt0object(code);
                }
            }
            return this.text();
        }
    }

    class BinaryValueOut
    extends FixedBinaryValueOut {
        BinaryValueOut() {
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            this.writeNumber(i8);
            return BinaryWire.this;
        }

        void writeNumber(long l) {
            if (l >= 0L && l <= 127L) {
                BinaryWire.this.bytes.writeUnsignedByte((int)l);
                return;
            }
            if (l >= 0L) {
                if (l <= 255L) {
                    super.uint8checked((short)l);
                    return;
                }
                if (l <= 65535L) {
                    super.uint16checked((int)l);
                    return;
                }
                if (l <= 0xFFFFFFFFL) {
                    super.uint32checked(l);
                    return;
                }
                if ((long)((float)l) == l) {
                    super.float32(l);
                    return;
                }
                super.int64(l);
                return;
            }
            if (l >= -128L && l <= 127L) {
                super.int8((byte)l);
                return;
            }
            if (l >= -32768L && l <= 32767L) {
                super.int16((short)l);
                return;
            }
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                super.int32((int)l);
                return;
            }
            if ((long)((float)l) == l) {
                super.float32(l);
                return;
            }
            super.int64(l);
        }

        void writeNumber(double l) {
            boolean canOnlyBeRepresentedAsFloatingPoint;
            boolean bl = canOnlyBeRepresentedAsFloatingPoint = (double)((long)l) != l;
            if (l >= 0.0 && l <= 127.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                BinaryWire.this.bytes.writeUnsignedByte((int)l);
                return;
            }
            if (l >= 0.0) {
                if (l <= 255.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                    super.uint8checked((short)l);
                    return;
                }
                if (l <= 65535.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                    super.uint16checked((int)l);
                    return;
                }
                if ((double)((float)l) == l) {
                    super.float32((float)l);
                    return;
                }
                if (l <= 4.294967295E9 && !canOnlyBeRepresentedAsFloatingPoint) {
                    super.uint32checked((int)l);
                    return;
                }
                super.float64(l);
                return;
            }
            if (l >= -128.0 && l <= 127.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                super.int8((byte)l);
                return;
            }
            if (l >= -32768.0 && l <= 32767.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                super.int16((short)l);
                return;
            }
            if ((double)((float)l) == l) {
                super.float32((float)l);
                return;
            }
            if (l >= -2.147483648E9 && l <= 2.147483647E9 && !canOnlyBeRepresentedAsFloatingPoint) {
                super.int32((int)l);
                return;
            }
            super.float64(l);
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            this.writeNumber(u8);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            this.writeNumber(i16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            this.writeNumber(u16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            this.writeNumber(i32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            this.writeNumber(u32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            this.writeNumber(i64);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            this.writeNumber(f);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            this.writeNumber(d);
            return BinaryWire.this;
        }
    }

    class FixedBinaryValueOut
    implements ValueOut {
        FixedBinaryValueOut() {
        }

        @Override
        @NotNull
        public ValueOut leaf() {
            return this;
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            BinaryWire.this.bytes.writeUnsignedByte(flag == null ? 187 : (flag != false ? 177 : 176));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            if (s == null) {
                BinaryWire.this.writeCode(187);
            } else {
                int len = s.length();
                if (len < 32) {
                    ((Bytes)BinaryWire.this.bytes.writeUnsignedByte(224 + len)).append(s);
                } else {
                    BinaryWire.this.writeCode(184).writeUTF\u0394(s);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable BytesStore s) {
            if (s == null) {
                BinaryWire.this.writeCode(187);
            } else {
                int len = s.length();
                if (len < 32) {
                    ((Bytes)BinaryWire.this.bytes.writeUnsignedByte(224 + len)).append((CharSequence)s);
                } else {
                    BinaryWire.this.writeCode(184).writeUTF\u0394((CharSequence)s);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            BinaryWire.this.writeCode(164).writeByte(i8);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(@Nullable BytesStore fromBytes) {
            long remaining = fromBytes.readRemaining();
            this.writeLength(Maths.toInt32((long)(remaining + 1L)));
            BinaryWire.this.writeCode(138);
            if (remaining > 0L) {
                BinaryWire.this.bytes.write(fromBytes);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut rawBytes(byte[] value) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public ValueOut writeLength(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("Invalid length " + length);
            }
            BinaryWire.this.writeCode(130);
            BinaryWire.this.bytes.writeUnsignedInt(length);
            return this;
        }

        @Override
        @NotNull
        public WireOut bytes(@NotNull byte[] fromBytes) {
            this.writeLength(Maths.toInt32((long)(fromBytes.length + 1)));
            BinaryWire.this.writeCode(138);
            BinaryWire.this.bytes.write(fromBytes);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            BinaryWire.this.writeCode(161).writeUnsignedByte(u8);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            BinaryWire.this.writeCode(165).writeShort(i16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            BinaryWire.this.writeCode(162).writeUnsignedShort(u16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut utf8(int codepoint) {
            BinaryWire.this.writeCode(162);
            BytesUtil.appendUTF((StreamingDataOutput)BinaryWire.this.bytes, (int)codepoint);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            return this.fixedInt32(i32);
        }

        @NotNull
        public WireOut fixedInt32(int i32) {
            BinaryWire.this.writeCode(166).writeInt(i32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            BinaryWire.this.writeCode(163).writeUnsignedInt(u32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            return this.fixedInt64(i64);
        }

        @NotNull
        private WireOut fixedInt64(long i64) {
            BinaryWire.this.writeCode(167).writeLong(i64);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity) {
            BinaryWire.this.writeCode(141);
            BinaryLongArrayReference.lazyWrite(BinaryWire.this.bytes, capacity);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity, @NotNull LongArrayValues values) {
            BinaryWire.this.writeCode(141);
            long pos = BinaryWire.this.bytes.writePosition();
            BinaryLongArrayReference.lazyWrite(BinaryWire.this.bytes, capacity);
            ((Byteable)values).bytesStore((BytesStore)BinaryWire.this.bytes, pos, BinaryWire.this.bytes.writePosition() - pos);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            BinaryWire.this.writeCode(144).writeFloat(f);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            BinaryWire.this.writeCode(145).writeDouble(d);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut time(@NotNull LocalTime localTime) {
            BinaryWire.this.writeCode(178).writeUTF\u0394((CharSequence)localTime.toString());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut zonedDateTime(@NotNull ZonedDateTime zonedDateTime) {
            BinaryWire.this.writeCode(181).writeUTF\u0394((CharSequence)zonedDateTime.toString());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut date(@NotNull LocalDate localDate) {
            BinaryWire.this.writeCode(180).writeUTF\u0394((CharSequence)localDate.toString());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public ValueOut type(CharSequence typeName) {
            BinaryWire.this.writeCode(182).writeUTF\u0394(typeName);
            return this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull CharSequence type) {
            BinaryWire.this.writeCode(188).writeUTF\u0394(type);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull Class type) {
            BinaryWire.this.writeCode(188).writeUTF\u0394((CharSequence)ClassAliasPool.CLASS_ALIASES.nameFor(type));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes> typeTranslator, @NotNull Class type) {
            BinaryWire.this.writeCode(188);
            typeTranslator.accept(type, BinaryWire.this.bytes);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uuid(@NotNull UUID uuid) {
            BinaryWire.this.writeCode(160).writeLong(uuid.getMostSignificantBits()).writeLong(uuid.getLeastSignificantBits());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value) {
            int fromEndOfCacheLine = (int)(-BinaryWire.this.bytes.readPosition() - 1L & 0x3FL);
            if (fromEndOfCacheLine < 4) {
                BinaryWire.this.addPadding(fromEndOfCacheLine - 1);
            }
            this.fixedInt32(value);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value) {
            int fromEndOfCacheLine = (int)(-BinaryWire.this.bytes.readPosition() - 1L & 0x3FL);
            if (fromEndOfCacheLine < 8) {
                BinaryWire.this.addPadding(fromEndOfCacheLine);
            }
            this.fixedInt64(value);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value, @NotNull IntValue intValue) {
            this.int32forBinding(value);
            ((BinaryIntReference)intValue).bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.writePosition() - 4L, 4L);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value, @NotNull LongValue longValue) {
            this.int64forBinding(value);
            ((BinaryLongReference)longValue).bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.writePosition() - 8L, 8L);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut sequence(@NotNull Consumer<ValueOut> writer) {
            BinaryWire.this.writeCode(130);
            long position = BinaryWire.this.bytes.writePosition();
            BinaryWire.this.bytes.writeInt(0);
            writer.accept(this);
            BinaryWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(BinaryWire.this.bytes.writePosition() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) {
            BinaryWire.this.writeCode(130);
            long position = BinaryWire.this.bytes.writePosition();
            BinaryWire.this.bytes.writeInt(0);
            object.writeMarshallable(BinaryWire.this);
            BinaryWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(BinaryWire.this.bytes.writePosition() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut map(Map map) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut wireOut() {
            return BinaryWire.this;
        }
    }
}

