/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.InternalWireIn;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextIntReference;
import net.openhft.chronicle.wire.TextLongArrayReference;
import net.openhft.chronicle.wire.TextLongReference;
import net.openhft.chronicle.wire.TextStopCharTesters;
import net.openhft.chronicle.wire.TextStopCharsTesters;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.util.BooleanConsumer;
import net.openhft.chronicle.wire.util.ByteConsumer;
import net.openhft.chronicle.wire.util.FloatConsumer;
import net.openhft.chronicle.wire.util.ShortConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

public class JSONWire
implements Wire,
InternalWireIn {
    public static final BytesStore TYPE = BytesStore.wrap((CharSequence)"!type ");
    static final String SEQ_MAP = "!seqmap";
    static final String NULL = "!null \"\"";
    static final BitSet QUOTE_CHARS = new BitSet();
    static final Logger LOG = LoggerFactory.getLogger(JSONWire.class);
    static final ThreadLocal<StopCharTester> ESCAPED_QUOTES = ThreadLocal.withInitial(() -> StopCharTesters.QUOTES.escaping());
    static final ThreadLocal<StopCharsTester> ESCAPED_END_OF_TEXT = ThreadLocal.withInitial(() -> TextStopCharsTesters.END_OF_TEXT.escaping());
    static final BytesStore COMMA = BytesStore.wrap((CharSequence)",");
    static final BytesStore NEW_LINE = BytesStore.wrap((CharSequence)"\n");
    static final BytesStore SPACE = BytesStore.wrap((CharSequence)" ");
    static final BytesStore END_FIELD = NEW_LINE;
    private final Bytes<?> bytes;
    private final TextValueOut valueOut = new TextValueOut();
    private final ValueIn valueIn = new TextValueIn();
    private final boolean use8bit;
    private boolean ready;

    public JSONWire(Bytes bytes, boolean use8bit) {
        this.bytes = bytes;
        this.use8bit = use8bit;
    }

    public JSONWire(Bytes bytes) {
        this(bytes, false);
    }

    @NotNull
    public static JSONWire from(@NotNull String text) {
        return new JSONWire(Bytes.wrapForRead((CharSequence)text));
    }

    public static String asText(@NotNull Wire wire) {
        long pos = wire.bytes().readPosition();
        JSONWire tw = new JSONWire((Bytes)NativeBytes.nativeBytes());
        wire.copyTo(tw);
        wire.bytes().readPosition(pos);
        return tw.toString();
    }

    public static <ACS extends Appendable & CharSequence> void unescape(@NotNull ACS sb) {
        int end = 0;
        int length = ((CharSequence)sb).length();
        for (int i = 0; i < length; ++i) {
            int ch = ((CharSequence)sb).charAt(i);
            if (ch == 92 && i < length - 1) {
                char ch3 = ((CharSequence)sb).charAt(++i);
                switch (ch3) {
                    case 'n': {
                        ch = 10;
                        break;
                    }
                    case 't': {
                        ch = 9;
                        break;
                    }
                    default: {
                        ch = ch3;
                    }
                }
            }
            BytesUtil.setCharAt(sb, (int)end++, (char)ch);
        }
        if (length != ((CharSequence)sb).length()) {
            throw new IllegalStateException("Length changed from " + length + " to " + ((CharSequence)sb).length() + " for " + sb);
        }
        BytesUtil.setLength(sb, (int)end);
    }

    public String toString() {
        return this.bytes.toString();
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void setReady(boolean ready) {
        this.ready = ready;
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ValueIn read() {
        this.readField(Wires.acquireStringBuilder());
        return this.valueIn;
    }

    @NotNull
    private StringBuilder readField(@NotNull StringBuilder sb) {
        this.consumeWhiteSpace();
        if (this.peekCode() == 44) {
            this.bytes.readSkip(1L);
            this.consumeWhiteSpace();
        }
        try {
            int ch = this.peekCode();
            if (ch == 34) {
                this.bytes.readSkip(1L);
                this.parseUntil(sb, this.getEscapingQuotes());
                this.consumeWhiteSpace();
                ch = this.readCode();
                if (ch != 58) {
                    throw new UnsupportedOperationException("Expected a : at " + this.bytes.toDebugString());
                }
            } else {
                if (ch < 0) {
                    sb.setLength(0);
                    return sb;
                }
                this.parseUntil(sb, this.getEscapingEndOfText());
            }
            JSONWire.unescape(sb);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        return sb;
    }

    @NotNull
    private StopCharsTester getEscapingEndOfText() {
        StopCharsTester escaping = ESCAPED_END_OF_TEXT.get();
        escaping.isStopChar(32, 32);
        return escaping;
    }

    private StopCharTester getEscapingQuotes() {
        StopCharTester sct = ESCAPED_QUOTES.get();
        sct.isStopChar(32);
        return sct;
    }

    void consumeWhiteSpace() {
        block0: while (true) {
            int codePoint;
            if ((codePoint = this.peekCode()) == 35) {
                while (true) {
                    if (this.readCode() < 32) continue block0;
                }
            }
            if (!Character.isWhitespace(codePoint) && codePoint != 44) break;
            this.bytes.readSkip(1L);
        }
    }

    int peekCode() {
        return this.bytes.peekUnsignedByte();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean peekStringIgnoreCase(@NotNull String source) {
        if (source.isEmpty()) {
            return true;
        }
        if (this.bytes.readRemaining() < 1L) {
            return false;
        }
        long pos = this.bytes.readPosition();
        try {
            for (int i = 0; i < source.length(); ++i) {
                if (Character.toLowerCase(source.charAt(i)) == Character.toLowerCase(this.bytes.readByte())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.bytes.readPosition(pos);
        }
        return true;
    }

    private int readCode() {
        if (this.bytes.readRemaining() < 1L) {
            return -1;
        }
        return this.bytes.readUnsignedByte();
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        long position = this.bytes.readPosition();
        StringBuilder sb = this.readField(Wires.acquireStringBuilder());
        if (sb.length() == 0 || StringUtils.isEqual((CharSequence)sb, (CharSequence)key.name())) {
            return this.valueIn;
        }
        this.bytes.readPosition(position);
        throw new UnsupportedOperationException("Unordered fields not supported yet. key=" + key.name() + ", was=" + sb + ", data='" + sb + "'");
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.consumeWhiteSpace();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    public boolean hasMore() {
        this.consumeWhiteSpace();
        return this.bytes.readRemaining() > 0L;
    }

    @Override
    @NotNull
    public ValueOut write() {
        return this.valueOut.write();
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        return this.valueOut.write(key);
    }

    @Override
    @NotNull
    public ValueOut writeValue() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public Wire writeComment(@NotNull CharSequence s) {
        this.valueOut.writeComment(s);
        return this;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        for (int i = 0; i < paddingToAdd; ++i) {
            this.bytes.append((this.bytes.writePosition() & 0x3FL) == 0L ? (char)'\n' : ' ');
        }
        return this;
    }

    void escaped(@NotNull CharSequence s) {
        if (!this.needsQuotes(s)) {
            this.bytes.append(s);
            return;
        }
        this.doEscape(s);
    }

    private void doEscape(@NotNull CharSequence s) {
        block4: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': 
                case '\\': {
                    ((Bytes)this.bytes.append('\\')).append(ch);
                    continue block4;
                }
                case '\n': {
                    this.bytes.append((CharSequence)"\\n");
                    continue block4;
                }
                default: {
                    this.bytes.append(ch);
                }
            }
        }
    }

    boolean needsQuotes(@NotNull CharSequence s) {
        if (s.length() == 0) {
            return true;
        }
        if (s.charAt(0) == ' ' || s.charAt(0) == '!' || s.charAt(s.length() - 1) == ' ') {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!QUOTE_CHARS.get(ch)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return new TextLongReference();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return new TextIntReference();
    }

    @Override
    @NotNull
    public LongArrayValues newLongArrayReference() {
        return new TextLongArrayReference();
    }

    public void parseWord(StringBuilder sb) {
        this.parseUntil(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
    }

    public void parseUntil(StringBuilder sb, StopCharTester testers) {
        if (this.use8bit) {
            this.bytes.parse8bit((Appendable)sb, testers);
        } else {
            this.bytes.parseUTF((Appendable)sb, testers);
        }
    }

    public void parseUntil(StringBuilder sb, StopCharsTester testers) {
        sb.setLength(0);
        if (this.use8bit) {
            BytesUtil.read8bitAndAppend(this.bytes, (StringBuilder)sb, (StopCharsTester)testers);
        } else {
            try {
                BytesUtil.readUTFAndAppend(this.bytes, (Appendable)sb, (StopCharsTester)testers);
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }
    }

    public void append(CharSequence cs) {
        if (this.use8bit) {
            this.bytes.append8bit(cs);
        } else {
            this.bytes.append(cs);
        }
    }

    public void append(CharSequence cs, int offset) {
        if (this.use8bit) {
            this.bytes.append8bit(cs, offset, cs.length());
        } else {
            this.bytes.append(cs, offset, cs.length());
        }
    }

    static {
        for (char ch : "\",\n\\#:{}[]".toCharArray()) {
            QUOTE_CHARS.set(ch);
        }
    }

    class TextValueIn
    implements ValueIn {
        TextValueIn() {
        }

        @Override
        @NotNull
        public WireIn bool(@NotNull BooleanConsumer flag) {
            JSONWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (this.textTo(sb) == null) {
                flag.accept(null);
                return JSONWire.this;
            }
            flag.accept(StringUtils.isEqual((CharSequence)sb, (CharSequence)"true"));
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn text(@NotNull Consumer<String> s) {
            StringBuilder sb = Wires.acquireStringBuilder();
            StringBuilder acs = this.textTo(sb);
            s.accept(acs == null ? null : ((Object)acs).toString());
            return JSONWire.this;
        }

        @Override
        public String text() {
            return StringUtils.toString((Object)this.textTo(Wires.acquireStringBuilder()));
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder sb) {
            return this.textTo0(sb);
        }

        @Override
        @Nullable
        public Bytes textTo(@NotNull Bytes bytes) {
            return this.textTo0(bytes);
        }

        @Nullable
        <ACS extends Appendable & CharSequence> ACS textTo0(@NotNull ACS a) {
            JSONWire.this.consumeWhiteSpace();
            int ch = JSONWire.this.peekCode();
            if (ch == 123) {
                long len = this.readLength();
                try {
                    a.append(Bytes.toString((Bytes)JSONWire.this.bytes, (long)JSONWire.this.bytes.readPosition(), (long)len));
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                JSONWire.this.bytes.readSkip(len);
                JSONWire.this.bytes.skipTo((StopCharTester)StopCharTesters.COMMA_STOP);
                return a;
            }
            if (ch == 34) {
                JSONWire.this.bytes.readSkip(1L);
                if (JSONWire.this.use8bit) {
                    JSONWire.this.bytes.parse8bit(a, JSONWire.this.getEscapingQuotes());
                } else {
                    JSONWire.this.bytes.parseUTF(a, JSONWire.this.getEscapingQuotes());
                }
                JSONWire.unescape(a);
                int code = JSONWire.this.peekCode();
                if (code == 34) {
                    JSONWire.this.readCode();
                }
            } else if (ch == 33) {
                JSONWire.this.bytes.readSkip(1L);
                ch = JSONWire.this.peekCode();
                if (ch == 33) {
                    JSONWire.this.bytes.readSkip(1L);
                    StringBuilder sb = Wires.acquireStringBuilder();
                    JSONWire.this.parseWord(sb);
                    if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"null")) {
                        this.textTo(sb);
                        return null;
                    }
                    if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"snappy")) {
                        this.textTo(sb);
                        try {
                            byte[] decodedBytes = Base64.getDecoder().decode(sb.toString().getBytes());
                            String csq = Snappy.uncompressString((byte[])decodedBytes);
                            return (ACS)Wires.acquireStringBuilder().append(csq);
                        }
                        catch (IOException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                } else {
                    StringBuilder sb = Wires.acquireStringBuilder();
                    this.textTo(sb);
                }
            } else {
                if (JSONWire.this.bytes.readRemaining() > 0L) {
                    if (a instanceof Bytes || JSONWire.this.use8bit) {
                        JSONWire.this.bytes.parse8bit(a, JSONWire.this.getEscapingEndOfText());
                    } else {
                        JSONWire.this.bytes.parseUTF(a, JSONWire.this.getEscapingEndOfText());
                    }
                } else {
                    BytesUtil.setLength(a, (int)0);
                }
                while (((CharSequence)a).length() > 0 && Character.isWhitespace(((CharSequence)a).charAt(((CharSequence)a).length() - 1))) {
                    BytesUtil.setLength(a, (int)(((CharSequence)a).length() - 1));
                }
            }
            int prev = this.rewindAndRead();
            if (prev == 58) {
                JSONWire.this.bytes.readSkip(-1L);
            }
            return a;
        }

        private int rewindAndRead() {
            return JSONWire.this.bytes.readPosition() > 0L ? JSONWire.this.bytes.readUnsignedByte(JSONWire.this.bytes.readPosition() - 1L) : -1;
        }

        @Override
        @NotNull
        public WireIn int8(@NotNull ByteConsumer i) {
            JSONWire.this.consumeWhiteSpace();
            i.accept((byte)JSONWire.this.bytes.parseLong());
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore compareBytes, BooleanConsumer consumer) {
            throw new UnsupportedOperationException("todo");
        }

        @NotNull
        public WireIn bytes(@NotNull Bytes toBytes) {
            return this.bytes((WireIn wi) -> toBytes.write(wi.bytes()));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadMarshallable bytesConsumer) {
            JSONWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (JSONWire.this.peekCode() == 33) {
                JSONWire.this.parseWord(sb);
                String str = Wires.INTERNER.intern((CharSequence)sb);
                if (str.equals("!!binary")) {
                    BytesUtil.setLength((Appendable)sb, (int)0);
                    JSONWire.this.parseWord(sb);
                    byte[] decode = Base64.getDecoder().decode(sb.toString());
                    bytesConsumer.readMarshallable(new JSONWire(Bytes.wrapForRead((byte[])decode)));
                    return JSONWire.this;
                } else {
                    if (!str.equals("!!null")) throw new IORuntimeException("Unsupported type=" + str);
                    bytesConsumer.readMarshallable(null);
                    JSONWire.this.parseWord(sb);
                }
                return JSONWire.this;
            } else {
                this.textTo(sb);
                bytesConsumer.readMarshallable(new JSONWire(Bytes.wrapForRead((byte[])sb.toString().getBytes())));
            }
            return JSONWire.this;
        }

        @Override
        @Nullable
        public byte[] bytes() {
            JSONWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (JSONWire.this.peekCode() == 33) {
                JSONWire.this.parseWord(sb);
                String str = Wires.INTERNER.intern((CharSequence)sb);
                if (str.equals("!!binary")) {
                    BytesUtil.setLength((Appendable)sb, (int)0);
                    JSONWire.this.parseWord(sb);
                    byte[] decode = Base64.getDecoder().decode(Wires.INTERNER.intern((CharSequence)sb));
                    return decode;
                }
                if (str.equals("!!null")) {
                    JSONWire.this.parseWord(sb);
                    return null;
                }
                if (str.equals("!!seqmap")) {
                    sb.append(JSONWire.this.bytes.toString());
                    return Wires.INTERNER.intern((CharSequence)sb).getBytes();
                }
                throw new IllegalStateException("unsupported type=" + str);
            }
            this.textTo(sb);
            return sb.toString().getBytes();
        }

        @Override
        @Nullable
        public byte[] snappy() {
            JSONWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (JSONWire.this.peekCode() == 33) {
                JSONWire.this.parseWord(sb);
                String str = Wires.INTERNER.intern((CharSequence)sb);
                if (str.equals("!!snappy")) {
                    BytesUtil.setLength((Appendable)sb, (int)0);
                    JSONWire.this.parseWord(sb);
                    byte[] decode = Base64.getDecoder().decode(Wires.INTERNER.intern((CharSequence)sb));
                    return decode;
                }
                throw new AssertionError((Object)"Incorrect format for snappy");
            }
            this.textTo(sb);
            return sb.toString().getBytes();
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return JSONWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long readLength() {
            JSONWire.this.consumeWhiteSpace();
            long start = JSONWire.this.bytes.readPosition();
            try {
                JSONWire.this.consumeWhiteSpace();
                int code = JSONWire.this.readCode();
                switch (code) {
                    case 123: {
                        int count = 1;
                        while (true) {
                            byte b;
                            if ((b = JSONWire.this.bytes.readByte()) == 123) {
                                ++count;
                                continue;
                            }
                            if (b != 125 || --count != 0) continue;
                            long l = JSONWire.this.bytes.readPosition() - start;
                            return l;
                        }
                    }
                    case 45: {
                        while (true) {
                            byte b;
                            if ((b = JSONWire.this.bytes.readByte()) == 10) {
                                long l = JSONWire.this.bytes.readPosition() - start + 1L;
                                return l;
                            }
                            if (JSONWire.this.bytes.readRemaining() != 0L) continue;
                            long l = JSONWire.this.bytes.readLimit() - start;
                            return l;
                        }
                    }
                }
                this.bytes();
                long l = JSONWire.this.bytes.readPosition() - start;
                return l;
            }
            finally {
                JSONWire.this.bytes.readPosition(start);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long readLengthMarshable() {
            long start = JSONWire.this.bytes.readPosition();
            try {
                JSONWire.this.consumeWhiteSpace();
                int code = JSONWire.this.readCode();
                switch (code) {
                    case 123: {
                        int count = 1;
                        while (true) {
                            byte b;
                            if ((b = JSONWire.this.bytes.readByte()) == 123) {
                                ++count;
                                continue;
                            }
                            if (b != 125 || --count != 0) continue;
                            long l = JSONWire.this.bytes.readPosition() - start;
                            return l;
                        }
                    }
                }
                this.bytes();
                long l = JSONWire.this.bytes.readPosition() - start;
                return l;
            }
            finally {
                JSONWire.this.bytes.readPosition(start);
            }
        }

        @Override
        @NotNull
        public WireIn uint8(@NotNull ShortConsumer i) {
            JSONWire.this.consumeWhiteSpace();
            i.accept((short)JSONWire.this.bytes.parseLong());
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn int16(@NotNull ShortConsumer i) {
            JSONWire.this.consumeWhiteSpace();
            i.accept((short)JSONWire.this.bytes.parseLong());
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn uint16(@NotNull IntConsumer i) {
            JSONWire.this.consumeWhiteSpace();
            i.accept((int)JSONWire.this.bytes.parseLong());
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn int32(@NotNull IntConsumer i) {
            JSONWire.this.consumeWhiteSpace();
            i.accept((int)JSONWire.this.bytes.parseLong());
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn uint32(@NotNull LongConsumer i) {
            JSONWire.this.consumeWhiteSpace();
            i.accept(JSONWire.this.bytes.parseLong());
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(@NotNull LongConsumer i) {
            JSONWire.this.consumeWhiteSpace();
            i.accept(JSONWire.this.bytes.parseLong());
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn float32(@NotNull FloatConsumer v) {
            JSONWire.this.consumeWhiteSpace();
            v.accept((float)JSONWire.this.bytes.parseDouble());
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn float64(@NotNull DoubleConsumer v) {
            JSONWire.this.consumeWhiteSpace();
            v.accept(JSONWire.this.bytes.parseDouble());
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn time(@NotNull Consumer<LocalTime> localTime) {
            JSONWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.textTo(sb);
            localTime.accept(LocalTime.parse(Wires.INTERNER.intern((CharSequence)sb)));
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn zonedDateTime(@NotNull Consumer<ZonedDateTime> zonedDateTime) {
            JSONWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.textTo(sb);
            zonedDateTime.accept(ZonedDateTime.parse(Wires.INTERNER.intern((CharSequence)sb)));
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn date(@NotNull Consumer<LocalDate> localDate) {
            JSONWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.textTo(sb);
            localDate.accept(LocalDate.parse(Wires.INTERNER.intern((CharSequence)sb)));
            return JSONWire.this;
        }

        @Override
        public boolean hasNext() {
            return JSONWire.this.bytes.readRemaining() > 0L;
        }

        @Override
        public boolean hasNextSequenceItem() {
            JSONWire.this.consumeWhiteSpace();
            int ch = JSONWire.this.peekCode();
            if (ch == 44) {
                JSONWire.this.bytes.readSkip(1L);
                return true;
            }
            return ch > 0 && ch != 93;
        }

        @Override
        @NotNull
        public WireIn uuid(@NotNull Consumer<UUID> uuid) {
            JSONWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.textTo(sb);
            uuid.accept(UUID.fromString(Wires.INTERNER.intern((CharSequence)sb)));
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn int64array(@Nullable LongArrayValues values, @NotNull Consumer<LongArrayValues> setter) {
            JSONWire.this.consumeWhiteSpace();
            if (!(values instanceof TextLongArrayReference)) {
                values = new TextLongArrayReference();
                setter.accept(values);
            }
            Byteable b = (Byteable)values;
            long length = TextLongArrayReference.peakLength((BytesStore)JSONWire.this.bytes, JSONWire.this.bytes.readPosition());
            b.bytesStore((BytesStore)JSONWire.this.bytes, JSONWire.this.bytes.readPosition(), length);
            JSONWire.this.bytes.readSkip(length);
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(@Nullable LongValue value) {
            JSONWire.this.consumeWhiteSpace();
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)JSONWire.this.bytes, JSONWire.this.bytes.readPosition(), length);
            JSONWire.this.bytes.readSkip(length);
            JSONWire.this.consumeWhiteSpace();
            if (JSONWire.this.peekCode() == 44) {
                JSONWire.this.bytes.readSkip(1L);
            }
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(LongValue value, @NotNull Consumer<LongValue> setter) {
            if (!(value instanceof TextLongReference)) {
                value = new TextLongReference();
                setter.accept(value);
            }
            return this.int64(value);
        }

        @Override
        @NotNull
        public WireIn int32(IntValue value, @NotNull Consumer<IntValue> setter) {
            if (!(value instanceof TextIntReference)) {
                value = new TextIntReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)JSONWire.this.bytes, JSONWire.this.bytes.readPosition(), length);
            JSONWire.this.bytes.readSkip(length);
            JSONWire.this.consumeWhiteSpace();
            if (JSONWire.this.peekCode() == 44) {
                JSONWire.this.bytes.readSkip(1L);
            }
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireIn sequence(@NotNull Consumer<ValueIn> reader) {
            JSONWire.this.consumeWhiteSpace();
            char code = (char)JSONWire.this.readCode();
            if (code != '[') {
                throw new IORuntimeException("Unsupported type " + code + " (" + code + ")");
            }
            JSONWire.this.consumeWhiteSpace();
            code = (char)JSONWire.this.peekCode();
            if (code == ']') {
                return JSONWire.this;
            }
            reader.accept(JSONWire.this.valueIn);
            JSONWire.this.consumeWhiteSpace();
            code = (char)JSONWire.this.peekCode();
            if (code != ']') {
                throw new IORuntimeException("Expected a ] but got " + code + " (" + code + ")");
            }
            return JSONWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            JSONWire.this.consumeWhiteSpace();
            int code = JSONWire.this.peekCode();
            if (code != 123) {
                throw new IORuntimeException("Unsupported type " + (char)code);
            }
            long len = this.readLengthMarshable() - 1L;
            long limit = JSONWire.this.bytes.readLimit();
            long position = JSONWire.this.bytes.readPosition();
            try {
                long newLimit = position - 1L + len;
                JSONWire.this.bytes.readLimit(newLimit);
                JSONWire.this.bytes.readSkip(1L);
                JSONWire.this.consumeWhiteSpace();
                T t = marshallableReader.apply(JSONWire.this);
                return t;
            }
            finally {
                JSONWire.this.bytes.readLimit(limit);
                JSONWire.this.consumeWhiteSpace();
                code = JSONWire.this.readCode();
                if (code != 125) {
                    throw new IORuntimeException("Unterminated { while reading marshallable bytes=" + Bytes.toString((Bytes)JSONWire.this.bytes));
                }
            }
        }

        @Override
        @NotNull
        public WireIn type(@NotNull StringBuilder sb) {
            JSONWire.this.consumeWhiteSpace();
            int code = JSONWire.this.peekCode();
            if (code == -1) {
                sb.append("java.lang.Void");
            } else if (code != 33) {
                sb.append("java.lang.String");
            } else {
                JSONWire.this.readCode();
                JSONWire.this.parseUntil(sb, TextStopCharTesters.END_OF_TYPE);
            }
            return JSONWire.this;
        }

        @NotNull
        String stringForCode(int code) {
            return code < 0 ? "Unexpected end of input" : "'" + (char)code + "'";
        }

        @Override
        @NotNull
        public WireIn typeLiteralAsText(@NotNull Consumer<CharSequence> classNameConsumer) {
            JSONWire.this.consumeWhiteSpace();
            int code = JSONWire.this.readCode();
            if (!JSONWire.this.peekStringIgnoreCase("type ")) {
                throw new UnsupportedOperationException(this.stringForCode(code));
            }
            JSONWire.this.bytes.readSkip((long)"type ".length());
            StringBuilder sb = Wires.acquireStringBuilder();
            JSONWire.this.parseUntil(sb, TextStopCharTesters.END_OF_TYPE);
            classNameConsumer.accept(sb);
            return JSONWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn marshallable(@NotNull ReadMarshallable object) {
            JSONWire.this.consumeWhiteSpace();
            int code = JSONWire.this.peekCode();
            if (code == 33) {
                this.type(Wires.acquireStringBuilder());
            } else if (code != 123) {
                throw new IORuntimeException("Unsupported type " + this.stringForCode(code));
            }
            long len = this.readLengthMarshable() - 1L;
            long limit = JSONWire.this.bytes.readLimit();
            long position = JSONWire.this.bytes.readPosition();
            long newLimit = position - 1L + len;
            try {
                JSONWire.this.bytes.readLimit(newLimit);
                JSONWire.this.bytes.readSkip(1L);
                JSONWire.this.consumeWhiteSpace();
                object.readMarshallable(JSONWire.this);
            }
            finally {
                JSONWire.this.bytes.readLimit(limit);
                JSONWire.this.bytes.readPosition(newLimit);
            }
            JSONWire.this.consumeWhiteSpace();
            code = JSONWire.this.readCode();
            if (code != 125) {
                throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (char)code + "', bytes=" + Bytes.toString((Bytes)JSONWire.this.bytes));
            }
            return JSONWire.this;
        }

        @Override
        @Nullable
        public <T extends ReadMarshallable> T typedMarshallable() {
            try {
                JSONWire.this.consumeWhiteSpace();
                int code = JSONWire.this.peekCode();
                if (code < 0) {
                    throw new IllegalStateException("Cannot read nothing as a Marshallable " + JSONWire.this.bytes.toDebugString());
                }
                StringBuilder sb = Wires.acquireStringBuilder();
                if (code != 33) {
                    throw new ClassCastException("Cannot convert to Marshallable. " + JSONWire.this.bytes.toDebugString());
                }
                JSONWire.this.readCode();
                JSONWire.this.parseUntil(sb, TextStopCharTesters.END_OF_TYPE);
                if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"!null")) {
                    this.text();
                    return null;
                }
                if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"!binary")) {
                    this.bytesStore();
                    return null;
                }
                Class clazz = ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb);
                if (!Marshallable.class.isAssignableFrom(clazz)) {
                    throw new ClassCastException("Cannot convert " + sb + " to Marshallable.");
                }
                ReadMarshallable m = (ReadMarshallable)OS.memory().allocateInstance(clazz);
                this.marshallable(m);
                return (T)((ReadMarshallable)ReadResolvable.readResolve((Object)m));
            }
            catch (Exception e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        @Override
        @Nullable
        public <K, V> Map<K, V> map(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap) {
            JSONWire.this.consumeWhiteSpace();
            usingMap.clear();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (JSONWire.this.peekCode() == 33) {
                JSONWire.this.parseUntil(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = Wires.INTERNER.intern((CharSequence)sb);
                if ("!!null".contentEquals(sb)) {
                    this.text();
                    return null;
                }
                if ("!!seqmap".contentEquals(sb)) {
                    JSONWire.this.consumeWhiteSpace();
                    int start = JSONWire.this.readCode();
                    if (start != 91) {
                        throw new IORuntimeException("Unsupported start of sequence : " + (char)start);
                    }
                    do {
                        this.marshallable(r -> {
                            Object k = r.read(() -> "key").object(kClazz);
                            Object v = r.read(() -> "value").object(vClass);
                            usingMap.put(k, v);
                        });
                    } while (this.hasNextSequenceItem());
                    return usingMap;
                }
                throw new IORuntimeException("Unsupported type :" + str);
            }
            return usingMap;
        }

        @Override
        public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> usingMap) {
            JSONWire.this.consumeWhiteSpace();
            usingMap.clear();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (JSONWire.this.peekCode() == 33) {
                JSONWire.this.parseUntil(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = Wires.INTERNER.intern((CharSequence)sb);
                if (JSONWire.SEQ_MAP.contentEquals(sb)) {
                    while (this.hasNext()) {
                        this.sequence(s -> s.marshallable(r -> {
                            try {
                                Object k = r.read(() -> "key").typedMarshallable();
                                Object v = r.read(() -> "value").typedMarshallable();
                                usingMap.put(k, v);
                            }
                            catch (Exception e) {
                                LOG.error("", (Throwable)e);
                            }
                        }));
                    }
                } else {
                    throw new IORuntimeException("Unsupported type " + str);
                }
            }
        }

        @Override
        public boolean bool() {
            JSONWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (this.textTo(sb) == null) {
                throw new NullPointerException("value is null");
            }
            return StringUtils.isEqual((CharSequence)sb, (CharSequence)"true");
        }

        @Override
        public byte int8() {
            long l = this.int64();
            if (l > 127L || l < -128L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Byte.MAX_VALUE/MIN_VALUE");
            }
            return (byte)l;
        }

        @Override
        public short int16() {
            long l = this.int64();
            if (l > 32767L || l < -32768L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Short.MAX_VALUE/MIN_VALUE");
            }
            return (short)l;
        }

        @Override
        public int int32() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/MIN_VALUE");
            }
            return (int)l;
        }

        @Override
        public int uint16() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < 0L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer" + ".MAX_VALUE/ZERO");
            }
            return (int)l;
        }

        @Override
        public long int64() {
            JSONWire.this.consumeWhiteSpace();
            return JSONWire.this.bytes.parseLong();
        }

        @Override
        public double float64() {
            JSONWire.this.consumeWhiteSpace();
            return JSONWire.this.bytes.parseDouble();
        }

        @Override
        public float float32() {
            double d = this.float64();
            if ((double)((float)d) != d) {
                throw new IllegalStateException("value=" + d + " can not be represented as a float");
            }
            return (float)d;
        }

        public boolean isNull() {
            JSONWire.this.consumeWhiteSpace();
            if (JSONWire.this.peekStringIgnoreCase("!!null \"\"")) {
                JSONWire.this.bytes.readSkip((long)"!!null \"\"".length());
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public <E> E object(@Nullable E using, @NotNull Class<E> clazz) {
            return (E)ObjectUtils.convertTo(clazz, (Object)this.object0(using, clazz));
        }

        @Override
        @Nullable
        public <E> WireIn object(@NotNull Class<E> clazz, @NotNull Consumer<E> e) {
            e.accept(ObjectUtils.convertTo(clazz, (Object)this.object0(null, clazz)));
            return JSONWire.this;
        }

        @Nullable
        Object object0(@Nullable Object using, @NotNull Class clazz) {
            JSONWire.this.consumeWhiteSpace();
            if (this.isNull()) {
                return null;
            }
            if (byte[].class.isAssignableFrom(clazz)) {
                return this.bytes();
            }
            if (BytesStore.class.isAssignableFrom(clazz)) {
                Bytes bytes = Bytes.wrapForRead((byte[])this.bytes());
                return bytes;
            }
            if (ReadMarshallable.class.isAssignableFrom(clazz)) {
                Object v2 = using == null ? OS.memory().allocateInstance(clazz) : using;
                JSONWire.this.valueIn.marshallable((ReadMarshallable)v2);
                return ReadResolvable.readResolve((Object)v2);
            }
            if (StringBuilder.class.isAssignableFrom(clazz)) {
                StringBuilder builder = using == null ? Wires.acquireStringBuilder() : (StringBuilder)using;
                JSONWire.this.valueIn.textTo(builder);
                return using;
            }
            if (CharSequence.class.isAssignableFrom(clazz)) {
                return JSONWire.this.valueIn.text();
            }
            if (Long.class.isAssignableFrom(clazz)) {
                return JSONWire.this.valueIn.int64();
            }
            if (Double.class.isAssignableFrom(clazz)) {
                return JSONWire.this.valueIn.float64();
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                return JSONWire.this.valueIn.int32();
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return Float.valueOf(JSONWire.this.valueIn.float32());
            }
            if (Short.class.isAssignableFrom(clazz)) {
                return JSONWire.this.valueIn.int16();
            }
            if (Character.class.isAssignableFrom(clazz)) {
                String text = JSONWire.this.valueIn.text();
                if (text == null || text.length() == 0) {
                    return null;
                }
                return Character.valueOf(text.charAt(0));
            }
            if (Byte.class.isAssignableFrom(clazz)) {
                return JSONWire.this.valueIn.int8();
            }
            if (Map.class.isAssignableFrom(clazz)) {
                HashMap<String, String> result = new HashMap<String, String>();
                JSONWire.this.valueIn.map(result);
                return result;
            }
            int code = JSONWire.this.peekCode();
            if (code == 33) {
                JSONWire.this.readCode();
                StringBuilder sb = Wires.acquireStringBuilder();
                JSONWire.this.parseUntil(sb, TextStopCharTesters.END_OF_TYPE);
                Class clazz2 = ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb);
                return this.object(null, clazz2);
            }
            if (code == 91) {
                if (clazz == Object[].class || clazz == Object.class) {
                    ArrayList list = new ArrayList();
                    this.sequence(v -> {
                        while (v.hasNextSequenceItem()) {
                            list.add(v.object(Object.class));
                        }
                    });
                    return list.toArray();
                }
                if (clazz == String[].class) {
                    ArrayList list = new ArrayList();
                    this.sequence(v -> {
                        while (v.hasNextSequenceItem()) {
                            list.add(v.text());
                        }
                    });
                    return list.toArray(new String[0]);
                }
                if (clazz == List.class) {
                    ArrayList list = new ArrayList();
                    this.sequence(v -> {
                        while (v.hasNextSequenceItem()) {
                            list.add(v.text());
                        }
                    });
                    return list;
                }
                if (clazz == Set.class) {
                    HashSet list = new HashSet();
                    this.sequence(v -> {
                        while (v.hasNextSequenceItem()) {
                            list.add(v.text());
                        }
                    });
                    return list;
                }
                throw new UnsupportedOperationException("Arrays of type " + clazz + " not supported.");
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                StringBuilder sb = Wires.acquireStringBuilder();
                JSONWire.this.parseUntil(sb, TextStopCharTesters.END_OF_TYPE);
                return Wires.INTERNER.intern((CharSequence)sb);
            }
            return JSONWire.this.valueIn.text();
        }
    }

    class TextValueOut
    implements ValueOut {
        @NotNull
        BytesStore sep = Bytes.empty();
        boolean leaf = false;

        TextValueOut() {
        }

        void prependSeparator() {
            JSONWire.this.append((CharSequence)this.sep);
            if (this.sep.endsWith('\n')) {
                this.indent();
            }
            this.sep = Bytes.empty();
        }

        @Override
        @NotNull
        public ValueOut leaf() {
            this.leaf = true;
            return this;
        }

        @Override
        @NotNull
        public WireOut wireOut() {
            return JSONWire.this;
        }

        private void indent() {
        }

        public void elementSeparator() {
            this.sep = COMMA;
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            this.prependSeparator();
            JSONWire.this.append(flag == null ? "!" + JSONWire.NULL : (flag != false ? "true" : "false"));
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            this.prependSeparator();
            if (s == null) {
                JSONWire.this.append("!!null \"\"");
            } else {
                JSONWire.this.bytes.append('\"');
                JSONWire.this.escaped(s);
                JSONWire.this.bytes.append('\"');
            }
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            this.prependSeparator();
            JSONWire.this.bytes.append((long)i8);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(@Nullable BytesStore fromBytes) {
            if (this.isText(fromBytes)) {
                return this.text(fromBytes);
            }
            int length = Maths.toInt32((long)fromBytes.readRemaining());
            byte[] byteArray = new byte[length];
            fromBytes.copyTo(byteArray);
            return this.bytes(byteArray);
        }

        @Override
        @NotNull
        public WireOut rawBytes(@NotNull byte[] value) {
            this.prependSeparator();
            JSONWire.this.bytes.write(value);
            this.elementSeparator();
            return JSONWire.this;
        }

        private boolean isText(@Nullable BytesStore fromBytes) {
            if (fromBytes == null) {
                return true;
            }
            for (long i = fromBytes.readPosition(); i < fromBytes.readLimit(); ++i) {
                int ch = fromBytes.readUnsignedByte(i);
                if ((ch >= 32 || ch == 9) && ch < 127) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public ValueOut writeLength(long remaining) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut bytes(byte[] byteArray) {
            this.prependSeparator();
            JSONWire.this.append("!!binary ");
            JSONWire.this.append(Base64.getEncoder().encodeToString(byteArray));
            JSONWire.this.append((CharSequence)END_FIELD);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        public WireOut snappy(byte[] compressedBytes) {
            this.prependSeparator();
            JSONWire.this.append("!!snappy ");
            JSONWire.this.append(Base64.getEncoder().encodeToString(compressedBytes));
            JSONWire.this.append((CharSequence)END_FIELD);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            this.prependSeparator();
            JSONWire.this.bytes.append((long)u8);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            this.prependSeparator();
            JSONWire.this.bytes.append((long)i16);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            this.prependSeparator();
            JSONWire.this.bytes.append((long)u16);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut utf8(int codepoint) {
            this.prependSeparator();
            StringBuilder sb = Wires.acquireStringBuilder();
            sb.appendCodePoint(codepoint);
            this.text(sb);
            this.sep = Bytes.empty();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            this.prependSeparator();
            JSONWire.this.bytes.append((long)i32);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            this.prependSeparator();
            JSONWire.this.bytes.append(u32);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            this.prependSeparator();
            JSONWire.this.bytes.append(i64);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity) {
            TextLongArrayReference.write(JSONWire.this.bytes, capacity);
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity, @NotNull LongArrayValues values) {
            long pos = JSONWire.this.bytes.writePosition();
            TextLongArrayReference.write(JSONWire.this.bytes, capacity);
            ((Byteable)values).bytesStore((BytesStore)JSONWire.this.bytes, pos, JSONWire.this.bytes.writePosition() - pos);
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            this.prependSeparator();
            JSONWire.this.bytes.append(f);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            this.prependSeparator();
            JSONWire.this.bytes.append(d);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut time(@NotNull LocalTime localTime) {
            this.prependSeparator();
            JSONWire.this.append(localTime.toString());
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut zonedDateTime(@NotNull ZonedDateTime zonedDateTime) {
            this.prependSeparator();
            JSONWire.this.append(zonedDateTime.toString());
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut date(@NotNull LocalDate localDate) {
            this.prependSeparator();
            JSONWire.this.append(localDate.toString());
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public ValueOut type(@NotNull CharSequence typeName) {
            this.prependSeparator();
            JSONWire.this.bytes.append('!');
            JSONWire.this.append(typeName);
            this.sep = SPACE;
            return this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes> typeTranslator, Class type) {
            this.prependSeparator();
            JSONWire.this.append((CharSequence)TYPE);
            typeTranslator.accept(type, JSONWire.this.bytes);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull CharSequence type) {
            this.prependSeparator();
            JSONWire.this.append((CharSequence)TYPE);
            this.text(type);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut uuid(@NotNull UUID uuid) {
            this.prependSeparator();
            JSONWire.this.append((CharSequence)this.sep);
            JSONWire.this.append(uuid.toString());
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value) {
            this.prependSeparator();
            TextIntReference.write(JSONWire.this.bytes, value);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value, IntValue intValue) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value) {
            this.prependSeparator();
            TextLongReference.write(JSONWire.this.bytes, value);
            this.elementSeparator();
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value, LongValue longValue) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut sequence(@NotNull Consumer<ValueOut> writer) {
            this.pushState();
            JSONWire.this.bytes.append('[');
            this.sep = NEW_LINE;
            long pos = JSONWire.this.bytes.readPosition();
            writer.accept(this);
            if (JSONWire.this.bytes.writePosition() > pos + 1L) {
                JSONWire.this.bytes.append('\n');
            }
            this.popState();
            this.indent();
            JSONWire.this.bytes.append(']');
            this.sep = END_FIELD;
            return JSONWire.this;
        }

        @Override
        public WireOut array(@NotNull Consumer<ValueOut> writer, Class arrayType) {
            if (arrayType == String[].class) {
                JSONWire.this.append("!String[] ");
            } else {
                JSONWire.this.bytes.append('!');
                JSONWire.this.append(arrayType.getName());
                JSONWire.this.bytes.append(' ');
            }
            return this.sequence(writer);
        }

        private void popState() {
            this.leaf = false;
        }

        private void pushState() {
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) {
            if (!this.leaf) {
                this.pushState();
            }
            this.prependSeparator();
            JSONWire.this.bytes.append('{');
            this.sep = this.leaf ? SPACE : END_FIELD;
            object.writeMarshallable(JSONWire.this);
            if (!this.leaf) {
                this.popState();
            } else {
                this.leaf = false;
            }
            if (this.sep.startsWith(',')) {
                JSONWire.this.append((CharSequence)this.sep, 1);
            } else {
                this.prependSeparator();
            }
            JSONWire.this.bytes.append('}');
            this.sep = COMMA;
            return JSONWire.this;
        }

        @Override
        @NotNull
        public WireOut map(@NotNull Map map) {
            this.type(JSONWire.SEQ_MAP);
            JSONWire.this.bytes.append(' ');
            JSONWire.this.bytes.append('[');
            this.pushState();
            this.sep = END_FIELD;
            map.forEach((k, v) -> {
                this.prependSeparator();
                JSONWire.this.append("{ key: ");
                this.leaf();
                this.object2(k);
                this.sep = COMMA;
                this.prependSeparator();
                JSONWire.this.append("  value: ");
                this.leaf();
                this.object2(v);
                JSONWire.this.bytes.append(' ');
                JSONWire.this.bytes.append('}');
                this.sep = COMMA;
            });
            this.popState();
            this.sep = END_FIELD;
            this.prependSeparator();
            JSONWire.this.bytes.append(']');
            this.sep = END_FIELD;
            return JSONWire.this;
        }

        private void object2(Object v) {
            if (v instanceof CharSequence) {
                this.text((CharSequence)v);
            } else if (v instanceof WriteMarshallable) {
                this.typedMarshallable((WriteMarshallable)v);
            } else if (v == null) {
                JSONWire.this.append("!!null \"\"");
            } else {
                this.text(String.valueOf(v));
            }
        }

        @Override
        @NotNull
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            this.type(JSONWire.SEQ_MAP);
            map.forEach((k, v) -> this.sequence(w -> w.marshallable(m -> m.write(() -> "key").typedMarshallable((WriteMarshallable)k).write(() -> "value").typedMarshallable((WriteMarshallable)v))));
            return JSONWire.this;
        }

        @NotNull
        public ValueOut write() {
            JSONWire.this.append((CharSequence)this.sep);
            JSONWire.this.bytes.append('\"');
            JSONWire.this.bytes.append('\"');
            JSONWire.this.bytes.append(':');
            this.sep = Bytes.empty();
            return this;
        }

        @NotNull
        public ValueOut write(@NotNull WireKey key) {
            CharSequence name = key.name();
            if (name == null) {
                name = Integer.toString(key.code());
            }
            this.prependSeparator();
            JSONWire.this.bytes.append('\"');
            JSONWire.this.escaped(name);
            JSONWire.this.bytes.append('\"');
            JSONWire.this.bytes.append(':');
            return this;
        }

        public void writeComment(@NotNull CharSequence s) {
        }
    }
}

