/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.IntTextReference;
import net.openhft.chronicle.wire.InternalWireIn;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextLongArrayReference;
import net.openhft.chronicle.wire.TextLongReference;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.util.BooleanConsumer;
import net.openhft.chronicle.wire.util.ByteConsumer;
import net.openhft.chronicle.wire.util.FloatConsumer;
import net.openhft.chronicle.wire.util.ShortConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryWire
implements Wire,
InternalWireIn {
    final Bytes<?> bytes;
    final TextValueOut valueOut = new TextValueOut();
    final ValueIn valueIn = new TextValueIn();
    boolean ready;

    public QueryWire(Bytes bytes) {
        this.bytes = bytes;
    }

    public String toString() {
        return this.bytes.toString();
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void setReady(boolean ready) {
        this.ready = ready;
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ValueIn read() {
        this.readField(Wires.acquireStringBuilder());
        return this.valueIn;
    }

    @NotNull
    private StringBuilder readField(@NotNull StringBuilder sb) {
        this.consumeWhiteSpace();
        this.bytes.parseUTF((Appendable)sb, (StopCharTester)QueryStopCharTesters.QUERY_FIELD_NAME);
        if (this.rewindAndRead() == 38) {
            this.bytes.readSkip(-1L);
        }
        return sb;
    }

    @ForceInline
    void consumeWhiteSpace() {
        int codePoint = this.peekCode();
        while (Character.isWhitespace(codePoint)) {
            this.bytes.readSkip(1L);
            codePoint = this.peekCode();
        }
    }

    @ForceInline
    int peekCode() {
        return this.bytes.peekUnsignedByte();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean peekStringIgnoreCase(@NotNull String source) {
        if (source.isEmpty()) {
            return true;
        }
        if (this.bytes.readRemaining() < 1L) {
            return false;
        }
        long pos = this.bytes.readPosition();
        try {
            for (int i = 0; i < source.length(); ++i) {
                if (Character.toLowerCase(source.charAt(i)) == Character.toLowerCase(this.bytes.readByte())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.bytes.readPosition(pos);
        }
        return true;
    }

    private int readCode() {
        if (this.bytes.readRemaining() < 1L) {
            return -1;
        }
        return this.bytes.readUnsignedByte();
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        long position = this.bytes.readPosition();
        StringBuilder sb = this.readField(Wires.acquireStringBuilder());
        if (sb.length() == 0 || StringUtils.isEqual((CharSequence)sb, (CharSequence)key.name())) {
            return this.valueIn;
        }
        this.bytes.readPosition(position);
        throw new UnsupportedOperationException("Unordered fields not supported yet. key=" + key.name() + ", was=" + sb + ", data='" + sb + "'");
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.consumeWhiteSpace();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    public boolean hasMore() {
        return this.bytes.readRemaining() > 0L;
    }

    @Override
    @NotNull
    public ValueOut write() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        return this.valueOut.write(key);
    }

    @Override
    @NotNull
    public ValueOut writeValue() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public Wire writeComment(CharSequence s) {
        return this;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        return this;
    }

    int rewindAndRead() {
        return this.bytes.readUnsignedByte(this.bytes.readPosition() - 1L);
    }

    class TextValueIn
    implements ValueIn {
        TextValueIn() {
        }

        @Override
        @NotNull
        public WireIn bool(@NotNull BooleanConsumer flag) {
            QueryWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (this.textTo(sb) == null) {
                flag.accept(null);
                return QueryWire.this;
            }
            flag.accept(StringUtils.isEqual((CharSequence)sb, (CharSequence)"true"));
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn text(@NotNull Consumer<String> s) {
            StringBuilder sb = Wires.acquireStringBuilder();
            this.textTo(sb);
            s.accept(Wires.INTERNER.intern((CharSequence)sb));
            return QueryWire.this;
        }

        @Override
        public String text() {
            return StringUtils.toString((Object)this.textTo(Wires.acquireStringBuilder()));
        }

        @Override
        @Nullable
        public <ACS extends Appendable & CharSequence> ACS textTo(@NotNull ACS a) {
            QueryWire.this.consumeWhiteSpace();
            QueryWire.this.bytes.parseUTF(a, (StopCharTester)QueryStopCharTesters.QUERY_VALUE);
            return a;
        }

        @Override
        @NotNull
        public WireIn int8(@NotNull ByteConsumer i) {
            QueryWire.this.consumeWhiteSpace();
            i.accept((byte)QueryWire.this.bytes.parseLong());
            return QueryWire.this;
        }

        @NotNull
        public WireIn bytes(@NotNull Bytes toBytes) {
            return this.bytes((WireIn wi) -> toBytes.write(wi.bytes()));
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull Consumer<WireIn> bytesConsumer) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public byte[] bytes() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return QueryWire.this;
        }

        @Override
        public long readLength() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireIn uint8(@NotNull ShortConsumer i) {
            QueryWire.this.consumeWhiteSpace();
            i.accept((short)QueryWire.this.bytes.parseLong());
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn int16(@NotNull ShortConsumer i) {
            QueryWire.this.consumeWhiteSpace();
            i.accept((short)QueryWire.this.bytes.parseLong());
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn uint16(@NotNull IntConsumer i) {
            QueryWire.this.consumeWhiteSpace();
            i.accept((int)QueryWire.this.bytes.parseLong());
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn int32(@NotNull IntConsumer i) {
            QueryWire.this.consumeWhiteSpace();
            i.accept((int)QueryWire.this.bytes.parseLong());
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn uint32(@NotNull LongConsumer i) {
            QueryWire.this.consumeWhiteSpace();
            i.accept(QueryWire.this.bytes.parseLong());
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(@NotNull LongConsumer i) {
            QueryWire.this.consumeWhiteSpace();
            i.accept(QueryWire.this.bytes.parseLong());
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn float32(@NotNull FloatConsumer v) {
            QueryWire.this.consumeWhiteSpace();
            v.accept((float)QueryWire.this.bytes.parseDouble());
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn float64(@NotNull DoubleConsumer v) {
            QueryWire.this.consumeWhiteSpace();
            v.accept(QueryWire.this.bytes.parseDouble());
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn time(@NotNull Consumer<LocalTime> localTime) {
            QueryWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.textTo(sb);
            localTime.accept(LocalTime.parse(Wires.INTERNER.intern((CharSequence)sb)));
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn zonedDateTime(@NotNull Consumer<ZonedDateTime> zonedDateTime) {
            QueryWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.textTo(sb);
            zonedDateTime.accept(ZonedDateTime.parse(Wires.INTERNER.intern((CharSequence)sb)));
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn date(@NotNull Consumer<LocalDate> localDate) {
            QueryWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.textTo(sb);
            localDate.accept(LocalDate.parse(Wires.INTERNER.intern((CharSequence)sb)));
            return QueryWire.this;
        }

        @Override
        public boolean hasNext() {
            return QueryWire.this.bytes.readRemaining() > 0L;
        }

        @Override
        public boolean hasNextSequenceItem() {
            QueryWire.this.consumeWhiteSpace();
            int ch = QueryWire.this.peekCode();
            if (ch == 44) {
                QueryWire.this.bytes.readSkip(1L);
                return true;
            }
            return ch != 93;
        }

        @Override
        @NotNull
        public WireIn uuid(@NotNull Consumer<UUID> uuid) {
            QueryWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.textTo(sb);
            uuid.accept(UUID.fromString(Wires.INTERNER.intern((CharSequence)sb)));
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn int64array(@Nullable LongArrayValues values, @NotNull Consumer<LongArrayValues> setter) {
            QueryWire.this.consumeWhiteSpace();
            if (!(values instanceof TextLongArrayReference)) {
                values = new TextLongArrayReference();
                setter.accept(values);
            }
            Byteable b = (Byteable)values;
            long length = TextLongArrayReference.peakLength(QueryWire.this.bytes, QueryWire.this.bytes.readPosition());
            b.bytesStore(QueryWire.this.bytes, QueryWire.this.bytes.readPosition(), length);
            QueryWire.this.bytes.readSkip(length);
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(LongValue value, @NotNull Consumer<LongValue> setter) {
            QueryWire.this.consumeWhiteSpace();
            if (!(value instanceof TextLongReference)) {
                value = new TextLongReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore(QueryWire.this.bytes, QueryWire.this.bytes.readPosition(), length);
            QueryWire.this.bytes.readSkip(length);
            QueryWire.this.consumeWhiteSpace();
            if (QueryWire.this.peekCode() == 44) {
                QueryWire.this.bytes.readSkip(1L);
            }
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn int32(IntValue value, @NotNull Consumer<IntValue> setter) {
            if (!(value instanceof IntTextReference)) {
                value = new IntTextReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore(QueryWire.this.bytes, QueryWire.this.bytes.readPosition(), length);
            QueryWire.this.bytes.readSkip(length);
            QueryWire.this.consumeWhiteSpace();
            if (QueryWire.this.peekCode() == 44) {
                QueryWire.this.bytes.readSkip(1L);
            }
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn sequence(@NotNull Consumer<ValueIn> reader) {
            QueryWire.this.consumeWhiteSpace();
            int code = QueryWire.this.readCode();
            if (code != 91) {
                throw new IORuntimeException("Unsupported type " + (char)code + " (" + code + ")");
            }
            reader.accept(QueryWire.this.valueIn);
            QueryWire.this.consumeWhiteSpace();
            code = QueryWire.this.peekCode();
            if (code != 93) {
                throw new IORuntimeException("Expected a ] but got " + (char)code + " (" + code + ")");
            }
            return QueryWire.this;
        }

        @Override
        @NotNull
        public <T> T applyToMarshallable(Function<WireIn, T> marshallableReader) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @Nullable
        public <T extends ReadMarshallable> T typedMarshallable() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireIn type(@NotNull StringBuilder s) {
            QueryWire.this.consumeWhiteSpace();
            QueryWire.this.bytes.parseUTF((Appendable)s, (StopCharTester)QueryStopCharTesters.QUERY_VALUE);
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn typeLiteralAsText(@NotNull Consumer<CharSequence> classNameConsumer) {
            StringBuilder sb = Wires.acquireStringBuilder();
            this.type(sb);
            classNameConsumer.accept(sb);
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireIn marshallable(@NotNull ReadMarshallable object) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public <K, V> Map<K, V> map(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public boolean bool() {
            QueryWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (this.textTo(sb) == null) {
                throw new NullPointerException("value is null");
            }
            return StringUtils.isEqual((CharSequence)sb, (CharSequence)"true");
        }

        @Override
        public byte int8() {
            long l = this.int64();
            if (l > 127L || l < -128L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Byte.MAX_VALUE/MIN_VALUE");
            }
            return (byte)l;
        }

        @Override
        public short int16() {
            long l = this.int64();
            if (l > 32767L || l < -32768L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Short.MAX_VALUE/MIN_VALUE");
            }
            return (short)l;
        }

        @Override
        public int int32() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/MIN_VALUE");
            }
            return (int)l;
        }

        @Override
        public int uint16() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < 0L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer" + ".MAX_VALUE/ZERO");
            }
            return (int)l;
        }

        @Override
        public long int64() {
            QueryWire.this.consumeWhiteSpace();
            return QueryWire.this.bytes.parseLong();
        }

        @Override
        public double float64() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public float float32() {
            throw new UnsupportedOperationException("todo");
        }

        public boolean isNull() {
            QueryWire.this.consumeWhiteSpace();
            if (QueryWire.this.peekStringIgnoreCase("!!null ")) {
                QueryWire.this.bytes.readSkip((long)"!!null ".length());
                this.textTo(Wires.acquireStringBuilder());
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public <E> E object(@Nullable E using, @NotNull Class<E> clazz) {
            QueryWire.this.consumeWhiteSpace();
            if (this.isNull()) {
                return null;
            }
            if (byte[].class.isAssignableFrom(clazz)) {
                return (E)this.bytes();
            }
            if (Marshallable.class.isAssignableFrom(clazz)) {
                Object v = using == null ? OS.memory().allocateInstance(clazz) : using;
                QueryWire.this.valueIn.marshallable((Marshallable)v);
                return v;
            }
            if (StringBuilder.class.isAssignableFrom(clazz)) {
                StringBuilder builder = using == null ? Wires.acquireStringBuilder() : (StringBuilder)using;
                QueryWire.this.valueIn.textTo(builder);
                return using;
            }
            if (CharSequence.class.isAssignableFrom(clazz)) {
                return (E)QueryWire.this.valueIn.text();
            }
            if (Long.class.isAssignableFrom(clazz)) {
                return (E)Long.valueOf(QueryWire.this.valueIn.int64());
            }
            if (Double.class.isAssignableFrom(clazz)) {
                return (E)Double.valueOf(QueryWire.this.valueIn.float64());
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                return (E)Integer.valueOf(QueryWire.this.valueIn.int32());
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return (E)Float.valueOf(QueryWire.this.valueIn.float32());
            }
            if (Short.class.isAssignableFrom(clazz)) {
                return (E)Short.valueOf(QueryWire.this.valueIn.int16());
            }
            if (Character.class.isAssignableFrom(clazz)) {
                String text = QueryWire.this.valueIn.text();
                if (text == null || text.length() == 0) {
                    return null;
                }
                return (E)Character.valueOf(text.charAt(0));
            }
            if (Byte.class.isAssignableFrom(clazz)) {
                return (E)Byte.valueOf(QueryWire.this.valueIn.int8());
            }
            if (Map.class.isAssignableFrom(clazz)) {
                HashMap<String, String> result = new HashMap<String, String>();
                QueryWire.this.valueIn.map(result);
                return (E)result;
            }
            throw new IllegalStateException("unsupported type=" + clazz);
        }
    }

    class TextValueOut
    implements ValueOut {
        @NotNull
        String sep = "";
        @Nullable
        CharSequence fieldName = null;

        TextValueOut() {
        }

        void prependSeparator() {
            QueryWire.this.bytes.append((CharSequence)this.sep);
            this.sep = "";
            if (this.fieldName != null) {
                ((Bytes)QueryWire.this.bytes.append(this.fieldName)).append((CharSequence)"=");
                this.fieldName = null;
            }
        }

        @Override
        @NotNull
        public ValueOut leaf() {
            return this;
        }

        @Override
        @NotNull
        public WireOut wireOut() {
            return QueryWire.this;
        }

        public void elementSeparator() {
            this.sep = "&";
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            if (flag != null) {
                this.prependSeparator();
                QueryWire.this.bytes.append((CharSequence)(flag != false ? "true" : "false"));
                this.elementSeparator();
            }
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            if (s != null) {
                this.prependSeparator();
                QueryWire.this.bytes.append(s);
                this.elementSeparator();
            }
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            this.prependSeparator();
            QueryWire.this.bytes.append((long)i8);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(BytesStore fromBytes) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut rawBytes(@Nullable byte[] value) {
            if (value != null) {
                this.prependSeparator();
                QueryWire.this.bytes.write(value);
                this.elementSeparator();
            }
            return QueryWire.this;
        }

        private boolean isText(@NotNull Bytes fromBytes) {
            for (long i = fromBytes.readPosition(); i < fromBytes.readLimit(); ++i) {
                int ch = fromBytes.readUnsignedByte(i);
                if ((ch >= 32 || ch == 9) && ch != 38 && ch < 127) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public ValueOut writeLength(long remaining) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut bytes(byte[] byteArray) {
            this.prependSeparator();
            QueryWire.this.bytes.append((CharSequence)Base64.getEncoder().encodeToString(byteArray));
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            this.prependSeparator();
            QueryWire.this.bytes.append((long)u8);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            this.prependSeparator();
            QueryWire.this.bytes.append((long)i16);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            this.prependSeparator();
            QueryWire.this.bytes.append((long)u16);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut utf8(int codepoint) {
            this.prependSeparator();
            StringBuilder sb = Wires.acquireStringBuilder();
            sb.appendCodePoint(codepoint);
            this.text(sb);
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            this.prependSeparator();
            QueryWire.this.bytes.append((long)i32);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            this.prependSeparator();
            QueryWire.this.bytes.append(u32);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            this.prependSeparator();
            QueryWire.this.bytes.append(i64);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity) {
            TextLongArrayReference.write(QueryWire.this.bytes, capacity);
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            this.prependSeparator();
            QueryWire.this.bytes.append(f);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            this.prependSeparator();
            QueryWire.this.bytes.append(d);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut time(@NotNull LocalTime localTime) {
            this.prependSeparator();
            QueryWire.this.bytes.append((CharSequence)localTime.toString());
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut zonedDateTime(@NotNull ZonedDateTime zonedDateTime) {
            this.prependSeparator();
            QueryWire.this.bytes.append((CharSequence)zonedDateTime.toString());
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut date(@NotNull LocalDate localDate) {
            this.prependSeparator();
            QueryWire.this.bytes.append((CharSequence)localDate.toString());
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public ValueOut type(@NotNull CharSequence typeName) {
            this.prependSeparator();
            QueryWire.this.bytes.append(typeName);
            this.sep = " ";
            return this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull CharSequence type) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes> typeTranslator, @NotNull Class type) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut uuid(@NotNull UUID uuid) {
            this.prependSeparator();
            ((Bytes)QueryWire.this.bytes.append((CharSequence)this.sep)).append((CharSequence)uuid.toString());
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value) {
            this.prependSeparator();
            IntTextReference.write(QueryWire.this.bytes, value);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value) {
            this.prependSeparator();
            TextLongReference.write(QueryWire.this.bytes, value);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut sequence(@NotNull Consumer<ValueOut> writer) {
            this.prependSeparator();
            this.pushState();
            QueryWire.this.bytes.append((CharSequence)"[");
            this.sep = ",";
            long pos = QueryWire.this.bytes.writePosition();
            writer.accept(this);
            if (pos != QueryWire.this.bytes.writePosition()) {
                QueryWire.this.bytes.append((CharSequence)",");
            }
            this.popState();
            QueryWire.this.bytes.append((CharSequence)"]");
            this.elementSeparator();
            return QueryWire.this;
        }

        private void popState() {
        }

        private void pushState() {
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) {
            this.pushState();
            this.prependSeparator();
            QueryWire.this.bytes.append((CharSequence)"{");
            this.sep = ",";
            object.writeMarshallable(QueryWire.this);
            this.popState();
            QueryWire.this.bytes.append('}');
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut map(@NotNull Map map) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public ValueOut write() {
            ((Bytes)QueryWire.this.bytes.append((CharSequence)this.sep)).append((CharSequence)"\"\": ");
            this.sep = "";
            return this;
        }

        @NotNull
        public ValueOut write(@NotNull WireKey key) {
            this.fieldName = key.name();
            return this;
        }
    }

    static enum QueryStopCharTesters implements StopCharTester
    {
        QUERY_FIELD_NAME{

            public boolean isStopChar(int ch) throws IllegalStateException {
                return ch == 38 || ch == 61 || ch < 0;
            }
        }
        ,
        QUERY_VALUE{

            public boolean isStopChar(int ch) throws IllegalStateException {
                return ch == 38 || ch < 0;
            }
        };

    }
}

