/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Type;
import java.util.HashMap;

@FunctionalInterface
public interface WireKey {
    public CharSequence name();

    default public int code() {
        return this.name().toString().hashCode();
    }

    default public Type type() {
        Object o = this.defaultValue();
        return o == null ? Void.class : o.getClass();
    }

    default public Object defaultValue() {
        return null;
    }

    public static boolean checkKeys(WireKey[] keys) {
        HashMap<Integer, WireKey> codes = new HashMap<Integer, WireKey>();
        for (WireKey key : keys) {
            WireKey pkey = codes.put(key.code(), key);
            if (pkey != null) {
                throw new AssertionError((Object)(pkey + " and " + key + " have the same code " + key.code()));
            }
        }
        return true;
    }

    default public boolean contentEquals(CharSequence c) {
        return this.toString().contentEquals(c);
    }
}

