/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshaller;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Wire;

public class MarshallableBytesMarshaller<M extends Marshallable>
implements BytesMarshaller<M> {
    private final Function<Bytes, Wire> wireFactory;
    private final Supplier<M> mSupplier;

    private MarshallableBytesMarshaller(Function<Bytes, Wire> wireFactory, Supplier<M> mSupplier) {
        this.wireFactory = wireFactory;
        this.mSupplier = mSupplier;
    }

    public static <M extends Marshallable> MarshallableBytesMarshaller<M> of(Function<Bytes, Wire> wireFactory, Supplier<M> mSupplier) {
        return new MarshallableBytesMarshaller<M>(wireFactory, mSupplier);
    }

    public void write(Bytes bytes, M m) {
        m.writeMarshallable(this.wireFactory.apply(bytes));
    }

    public M read(Bytes bytes, M m) {
        if (m == null) {
            m = (Marshallable)this.mSupplier.get();
        }
        m.readMarshallable(this.wireFactory.apply(bytes));
        return m;
    }
}

