/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.util.BooleanConsumer;
import net.openhft.chronicle.util.ByteConsumer;
import net.openhft.chronicle.util.FloatConsumer;
import net.openhft.chronicle.util.ShortConsumer;
import net.openhft.chronicle.wire.IntDirectReference;
import net.openhft.chronicle.wire.LongArrayDirectReference;
import net.openhft.chronicle.wire.LongDirectReference;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;

public class RawWire
implements Wire {
    final Bytes bytes;
    final RawValueOut writeValue = new RawValueOut();
    final RawValueIn readValue = new RawValueIn();
    String lastField = "";
    StringBuilder lastSB;

    public RawWire(Bytes bytes) {
        this.bytes = bytes;
    }

    @Override
    public void copyTo(WireOut wire) {
        if (!(wire instanceof RawWire)) {
            throw new UnsupportedOperationException("Can only copy Raw Wire format to the same format.");
        }
        wire.bytes().write(this.bytes);
    }

    public String toString() {
        return this.bytes.toString();
    }

    @Override
    public ValueOut write() {
        this.lastField = "";
        return this.writeValue;
    }

    @Override
    public ValueOut write(WireKey key) {
        this.lastField = key.name().toString();
        return this.writeValue;
    }

    @Override
    public ValueOut writeEventName(WireKey key) {
        this.lastField = "";
        this.bytes.writeUTF\u0394(key.name());
        return this.writeValue;
    }

    @Override
    public ValueOut writeValue() {
        this.lastField = "";
        return this.writeValue;
    }

    @Override
    public ValueIn read() {
        this.lastSB = null;
        return this.readValue;
    }

    @Override
    public ValueIn read(WireKey key) {
        this.lastSB = null;
        return this.readValue;
    }

    @Override
    public ValueIn read(StringBuilder name) {
        this.lastSB = name;
        return this.readValue;
    }

    @Override
    public ValueIn readEventName(StringBuilder name) {
        this.bytes.readUTF\u0394(name);
        this.lastSB = null;
        return this.readValue;
    }

    @Override
    public boolean hasNextSequenceItem() {
        return false;
    }

    @Override
    public Wire writeComment(CharSequence s) {
        return this;
    }

    @Override
    public Wire readComment(StringBuilder sb) {
        return this;
    }

    @Override
    public boolean hasMapping() {
        return false;
    }

    @Override
    public boolean hasDocument() {
        return false;
    }

    @Override
    public void flip() {
        this.bytes.flip();
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    @Override
    public Bytes bytes() {
        return this.bytes;
    }

    @Override
    public WireOut addPadding(int paddingToAdd) {
        throw new UnsupportedOperationException();
    }

    class RawValueIn
    implements ValueIn {
        RawValueIn() {
        }

        public WireIn bytes(Bytes toBytes) {
            this.wireIn().bytes().withLength(this.readLength(), arg_0 -> ((Bytes)toBytes).write(arg_0));
            return this.wireIn();
        }

        @Override
        public WireIn bytes(Consumer<byte[]> bytesConsumer) {
            long length = this.readLength();
            byte[] byteArray = new byte[Maths.toInt32((long)length)];
            RawWire.this.bytes.read(byteArray);
            bytesConsumer.accept(byteArray);
            return this.wireIn();
        }

        @Override
        public byte[] bytes() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public Wire bool(BooleanConsumer flag) {
            int b = RawWire.this.bytes.readUnsignedByte();
            if (b == WireType.NULL.code) {
                flag.accept(null);
            } else if (b == 0 || b == WireType.FALSE.code) {
                flag.accept(false);
            } else {
                flag.accept(true);
            }
            return RawWire.this;
        }

        @Override
        public Wire text(StringBuilder s) {
            RawWire.this.bytes.readUTF\u0394(s);
            return RawWire.this;
        }

        @Override
        public WireIn text(Consumer<String> s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Wire type(StringBuilder s) {
            RawWire.this.bytes.readUTF\u0394(s);
            return RawWire.this;
        }

        @Override
        public Wire int8(ByteConsumer i) {
            i.accept(RawWire.this.bytes.readByte());
            return RawWire.this;
        }

        @Override
        public WireIn wireIn() {
            return RawWire.this;
        }

        @Override
        public long readLength() {
            return RawWire.this.bytes.readStopBit();
        }

        @Override
        public Wire uint8(ShortConsumer i) {
            i.accept((short)RawWire.this.bytes.readUnsignedByte());
            return RawWire.this;
        }

        @Override
        public Wire int16(ShortConsumer i) {
            i.accept(RawWire.this.bytes.readShort());
            return RawWire.this;
        }

        @Override
        public Wire uint16(IntConsumer i) {
            i.accept(RawWire.this.bytes.readUnsignedShort());
            return RawWire.this;
        }

        @Override
        public Wire int32(IntConsumer i) {
            i.accept(RawWire.this.bytes.readInt());
            return RawWire.this;
        }

        @Override
        public Wire uint32(LongConsumer i) {
            i.accept(RawWire.this.bytes.readUnsignedInt());
            return RawWire.this;
        }

        @Override
        public Wire int64(LongConsumer i) {
            i.accept(RawWire.this.bytes.readLong());
            return RawWire.this;
        }

        @Override
        public boolean bool() {
            return RawWire.this.bytes.readBoolean();
        }

        @Override
        public byte int8() {
            return RawWire.this.bytes.readByte();
        }

        @Override
        public short int16() {
            return RawWire.this.bytes.readShort();
        }

        @Override
        public int int32() {
            return RawWire.this.bytes.readInt();
        }

        @Override
        public long int64() {
            return RawWire.this.bytes.readLong();
        }

        @Override
        public double float64() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public float float32() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public boolean isNull() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Wire float32(FloatConsumer v) {
            v.accept(RawWire.this.bytes.readFloat());
            return RawWire.this;
        }

        @Override
        public Wire float64(DoubleConsumer v) {
            v.accept(RawWire.this.bytes.readDouble());
            return RawWire.this;
        }

        @Override
        public Wire time(Consumer<LocalTime> localTime) {
            localTime.accept(LocalTime.ofNanoOfDay(RawWire.this.bytes.readLong()));
            return RawWire.this;
        }

        @Override
        public Wire zonedDateTime(Consumer<ZonedDateTime> zonedDateTime) {
            zonedDateTime.accept(ZonedDateTime.parse(RawWire.this.bytes.readUTF\u0394()));
            return RawWire.this;
        }

        @Override
        public Wire date(Consumer<LocalDate> localDate) {
            localDate.accept(LocalDate.ofEpochDay(RawWire.this.bytes.readStopBit()));
            return RawWire.this;
        }

        @Override
        public boolean hasNext() {
            return RawWire.this.bytes.remaining() > 0L;
        }

        @Override
        public WireIn expectText(CharSequence s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireIn uuid(Consumer<UUID> uuid) {
            uuid.accept(new UUID(RawWire.this.bytes.readLong(), RawWire.this.bytes.readLong()));
            return RawWire.this;
        }

        @Override
        public WireIn int64(LongValue value, Consumer<LongValue> setter) {
            if (!(value instanceof Byteable) || ((Byteable)value).maxSize() != 8L) {
                value = new LongDirectReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.position(), length);
            RawWire.this.bytes.skip(length);
            return RawWire.this;
        }

        @Override
        public WireIn int64array(LongArrayValues values, Consumer<LongArrayValues> setter) {
            if (!(values instanceof Byteable)) {
                values = new LongArrayDirectReference();
                setter.accept(values);
            }
            Byteable b = (Byteable)values;
            long length = b.maxSize();
            b.bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.position(), length);
            RawWire.this.bytes.skip(length);
            return RawWire.this;
        }

        @Override
        public WireIn int32(IntValue value, Consumer<IntValue> setter) {
            if (!(value instanceof Byteable) || ((Byteable)value).maxSize() != 8L) {
                value = new IntDirectReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.position(), length);
            RawWire.this.bytes.skip(length);
            return RawWire.this;
        }

        @Override
        public WireIn sequence(Consumer<ValueIn> reader) {
            this.text(RawWire.this.lastSB);
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WireIn marshallable(ReadMarshallable object) {
            this.text(RawWire.this.lastSB);
            long length = RawWire.this.bytes.readUnsignedInt();
            if (length >= 0L) {
                long limit = RawWire.this.bytes.readLimit();
                long limit2 = RawWire.this.bytes.position() + length;
                RawWire.this.bytes.limit(limit2);
                try {
                    object.readMarshallable(RawWire.this);
                }
                finally {
                    RawWire.this.bytes.limit(limit);
                    RawWire.this.bytes.position(limit2);
                }
            } else {
                object.readMarshallable(RawWire.this);
            }
            return RawWire.this;
        }
    }

    class RawValueOut
    implements ValueOut {
        boolean nested = false;

        RawValueOut() {
        }

        @Override
        public boolean isNested() {
            return this.nested;
        }

        @Override
        public WireOut nested(boolean nested) {
            this.nested = nested;
            return RawWire.this;
        }

        @Override
        public Wire bool(Boolean flag) {
            if (flag == null) {
                RawWire.this.bytes.writeUnsignedByte(WireType.NULL.code);
            } else {
                RawWire.this.bytes.writeUnsignedByte(flag != false ? WireType.TRUE.code : 0);
            }
            return RawWire.this;
        }

        @Override
        public Wire text(CharSequence s) {
            RawWire.this.bytes.writeUTF\u0394(s);
            return RawWire.this;
        }

        @Override
        public Wire int8(byte i8) {
            RawWire.this.bytes.writeByte(i8);
            return RawWire.this;
        }

        @Override
        public WireOut bytes(Bytes fromBytes) {
            this.writeLength(fromBytes.remaining());
            RawWire.this.bytes.write(fromBytes);
            return RawWire.this;
        }

        @Override
        public ValueOut writeLength(long length) {
            RawWire.this.bytes.writeStopBit(length);
            return this;
        }

        @Override
        public WireOut bytes(byte[] fromBytes) {
            this.writeLength(fromBytes.length);
            RawWire.this.bytes.write(fromBytes);
            return RawWire.this;
        }

        @Override
        public Wire uint8checked(int u8) {
            RawWire.this.bytes.writeUnsignedByte(u8);
            return RawWire.this;
        }

        @Override
        public Wire int16(short i16) {
            RawWire.this.bytes.writeShort(i16);
            return RawWire.this;
        }

        @Override
        public Wire uint16checked(int u16) {
            RawWire.this.bytes.writeUnsignedShort(u16);
            return RawWire.this;
        }

        @Override
        public Wire utf8(int codepoint) {
            BytesUtil.appendUTF((StreamingDataOutput)RawWire.this.bytes, (int)codepoint);
            return RawWire.this;
        }

        @Override
        public Wire int32(int i32) {
            RawWire.this.bytes.writeInt(i32);
            return RawWire.this;
        }

        @Override
        public Wire uint32checked(long u32) {
            RawWire.this.bytes.writeUnsignedInt(u32);
            return RawWire.this;
        }

        @Override
        public Wire float32(float f) {
            RawWire.this.bytes.writeFloat(f);
            return RawWire.this;
        }

        @Override
        public Wire float64(double d) {
            RawWire.this.bytes.writeDouble(d);
            return RawWire.this;
        }

        @Override
        public Wire int64(long i64) {
            RawWire.this.bytes.writeLong(i64);
            return RawWire.this;
        }

        @Override
        public WireOut int64array(long capacity) {
            LongArrayDirectReference.lazyWrite(RawWire.this.bytes, capacity);
            return RawWire.this;
        }

        @Override
        public Wire time(LocalTime localTime) {
            long t = localTime.toNanoOfDay();
            RawWire.this.bytes.writeLong(t);
            return RawWire.this;
        }

        @Override
        public Wire zonedDateTime(ZonedDateTime zonedDateTime) {
            RawWire.this.bytes.writeUTF\u0394((CharSequence)zonedDateTime.toString());
            return RawWire.this;
        }

        @Override
        public Wire date(LocalDate localDate) {
            RawWire.this.bytes.writeStopBit(localDate.toEpochDay());
            return RawWire.this;
        }

        @Override
        public Wire type(CharSequence typeName) {
            RawWire.this.bytes.writeUTF\u0394(typeName);
            return RawWire.this;
        }

        @Override
        public WireOut uuid(UUID uuid) {
            RawWire.this.bytes.writeLong(uuid.getMostSignificantBits());
            RawWire.this.bytes.writeLong(uuid.getLeastSignificantBits());
            return RawWire.this;
        }

        @Override
        public WireOut int64forBinding(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireOut int32forBinding(int value) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WireOut sequence(Consumer<ValueOut> writer) {
            this.text(RawWire.this.lastField);
            long position = RawWire.this.bytes.position();
            RawWire.this.bytes.writeInt(0);
            boolean nested = this.isNested();
            try {
                this.nested(true);
                writer.accept(this);
            }
            finally {
                this.nested(nested);
            }
            RawWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(RawWire.this.bytes.position() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return RawWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WireOut marshallable(WriteMarshallable object) {
            this.text(RawWire.this.lastField);
            long position = RawWire.this.bytes.position();
            RawWire.this.bytes.writeInt(0);
            boolean nested = this.isNested();
            try {
                this.nested(true);
                object.writeMarshallable(RawWire.this);
            }
            finally {
                this.nested(nested);
            }
            RawWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(RawWire.this.bytes.position() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return RawWire.this;
        }
    }
}

